/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.text.StringUtil;

public class BuildNumber
implements Comparable<BuildNumber> {
    private final String myProductCode;
    private final int myBaselineVersion;
    private final int myBuildNumber;
    private static final String BUILD_NUMBER = "__BUILD_NUMBER__";
    private static final int TOP_BASELINE_VERSION = 95;

    public BuildNumber(String productCode, int baselineVersion, int buildNumber) {
        this.myProductCode = productCode;
        this.myBaselineVersion = baselineVersion;
        this.myBuildNumber = buildNumber;
    }

    public String asString() {
        return this.asString(true);
    }

    public String asStringWithoutProductCode() {
        return this.asString(false);
    }

    private String asString(boolean includeProductCode) {
        StringBuilder builder = new StringBuilder();
        if (includeProductCode && !StringUtil.isEmpty(this.myProductCode)) {
            builder.append(this.myProductCode).append('-');
        }
        builder.append(this.myBaselineVersion).append('.');
        if (this.myBuildNumber != Integer.MAX_VALUE) {
            builder.append(this.myBuildNumber);
        } else {
            builder.append("SNAPSHOT");
        }
        return builder.toString();
    }

    public static BuildNumber fromString(String version) {
        int buildNumber;
        int baselineVersion;
        String productCode;
        if (version == null) {
            return null;
        }
        if (BUILD_NUMBER.equals(version)) {
            return new BuildNumber("IU", 95, Integer.MAX_VALUE);
        }
        String code = version;
        int productSeparator = code.indexOf(45);
        if (productSeparator > 0) {
            productCode = code.substring(0, productSeparator);
            code = code.substring(productSeparator + 1);
        } else {
            productCode = "";
        }
        int baselineVersionSeparator = code.indexOf(46);
        if (baselineVersionSeparator > 0) {
            try {
                baselineVersion = Integer.parseInt(code.substring(0, baselineVersionSeparator));
                code = code.substring(baselineVersionSeparator + 1);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Unparseable version number: " + version);
            }
            buildNumber = BuildNumber.parseBuildNumber(version, code);
        } else {
            buildNumber = BuildNumber.parseBuildNumber(version, code);
            if (buildNumber <= 2000) {
                return new BuildNumber(productCode, buildNumber, 0);
            }
            baselineVersion = BuildNumber.getBaseLineForHistoricBuilds(buildNumber);
        }
        return new BuildNumber(productCode, baselineVersion, buildNumber);
    }

    private static int parseBuildNumber(String version, String code) {
        if ("SNAPSHOT".equals(code) || BUILD_NUMBER.equals(code)) {
            return Integer.MAX_VALUE;
        }
        try {
            return Integer.parseInt(code);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Unparseable version number: " + version);
        }
    }

    public String toString() {
        return this.asString();
    }

    @Override
    public int compareTo(BuildNumber o) {
        if (this.myBaselineVersion == o.myBaselineVersion) {
            return this.myBuildNumber - o.myBuildNumber;
        }
        return this.myBaselineVersion - o.myBaselineVersion;
    }

    public String getProductCode() {
        return this.myProductCode;
    }

    public int getBaselineVersion() {
        return this.myBaselineVersion;
    }

    public int getBuildNumber() {
        return this.myBuildNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildNumber that = (BuildNumber)o;
        if (this.myBaselineVersion != that.myBaselineVersion) {
            return false;
        }
        if (this.myBuildNumber != that.myBuildNumber) {
            return false;
        }
        return this.myProductCode.equals(that.myProductCode);
    }

    public int hashCode() {
        int result = this.myProductCode.hashCode();
        result = 31 * result + this.myBaselineVersion;
        result = 31 * result + this.myBuildNumber;
        return result;
    }

    private static int getBaseLineForHistoricBuilds(int bn) {
        if (bn == Integer.MAX_VALUE) {
            return 95;
        }
        if (bn >= 10000) {
            return 88;
        }
        if (bn >= 9500) {
            return 85;
        }
        if (bn >= 9100) {
            return 81;
        }
        if (bn >= 8000) {
            return 80;
        }
        if (bn >= 7500) {
            return 75;
        }
        if (bn >= 7200) {
            return 72;
        }
        if (bn >= 6900) {
            return 69;
        }
        if (bn >= 6500) {
            return 65;
        }
        if (bn >= 6000) {
            return 60;
        }
        if (bn >= 5000) {
            return 55;
        }
        if (bn >= 4000) {
            return 50;
        }
        return 40;
    }

    public boolean isSnapshot() {
        return this.myBuildNumber == Integer.MAX_VALUE;
    }
}

