/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.configuration;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunJavaConfiguration;
import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.TestClassFilter;
import com.intellij.execution.junit2.configuration.ClassBrowser;
import com.intellij.execution.junit2.configuration.CommonJavaParameters;
import com.intellij.execution.junit2.configuration.ConfigurationModuleSelector;
import com.intellij.execution.junit2.configuration.JUnitConfigurationModel;
import com.intellij.execution.junit2.configuration.MethodListDlg;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.ui.AlternativeJREPanel;
import com.intellij.ide.util.PackageChooserDialog;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import gnu.trove.TIntArrayList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

public class JUnitConfigurable
extends SettingsEditor<JUnitConfiguration> {
    private JRadioButton myAllInPackageButton;
    private JRadioButton myClassButton;
    private JRadioButton myTestMethodButton;
    private JComponent myPackagePanel;
    private LabeledComponent<TextFieldWithBrowseButton> myPackage;
    private LabeledComponent<TextFieldWithBrowseButton> myClass;
    private LabeledComponent<TextFieldWithBrowseButton> myMethod;
    private JPanel myWholePanel;
    private LabeledComponent<JComboBox> myModule;
    private CommonJavaParameters myCommonJavaParameters;
    private EnvironmentVariablesComponent myEnvVariablesComponent;
    private JRadioButton myWholeProjectScope;
    private JRadioButton mySingleModuleScope;
    private JRadioButton myModuleWDScope;
    private static final ArrayList<TIntArrayList> ourEnabledFields = new ArrayList<TIntArrayList>(Arrays.asList(new TIntArrayList(new int[]{0}), new TIntArrayList(new int[]{1}), new TIntArrayList(new int[]{1, 2})));
    private final ConfigurationModuleSelector myModuleSelector;
    private final JRadioButton[] myRadioButtons = new JRadioButton[3];
    private final LabeledComponent[] myTestLocations = new LabeledComponent[3];
    private final JUnitConfigurationModel myModel;
    private final BrowseModuleValueActionListener[] myBrowsers;
    private AlternativeJREPanel myAlternativeJREPanel;

    public void applyEditorTo(JUnitConfiguration configuration) {
        this.myModel.apply(this.getModuleSelector().getModule(), configuration);
        this.applyHelpersTo(configuration);
        JUnitConfiguration.Data data = configuration.getPersistentData();
        if (this.myWholeProjectScope.isSelected()) {
            data.setScope(TestSearchScope.WHOLE_PROJECT);
        } else if (this.mySingleModuleScope.isSelected()) {
            data.setScope(TestSearchScope.SINGLE_MODULE);
        } else if (this.myModuleWDScope.isSelected()) {
            data.setScope(TestSearchScope.MODULE_WITH_DEPENDENCIES);
        }
        configuration.setAlternativeJrePath(this.myAlternativeJREPanel.getPath());
        configuration.setAlternativeJrePathEnabled(this.myAlternativeJREPanel.isPathEnabled());
        configuration.getPersistentData().setEnvs(this.myEnvVariablesComponent.getEnvs());
        configuration.getPersistentData().PASS_PARENT_ENVS = this.myEnvVariablesComponent.isPassParentEnvs();
    }

    public void resetEditorFrom(JUnitConfiguration configuration) {
        this.myModel.reset(configuration);
        this.myCommonJavaParameters.reset((RunJavaConfiguration)configuration);
        this.getModuleSelector().reset((ModuleBasedConfiguration)configuration);
        TestSearchScope scope = configuration.getPersistentData().getScope();
        if (scope == TestSearchScope.SINGLE_MODULE) {
            this.mySingleModuleScope.setSelected(true);
        } else if (scope == TestSearchScope.MODULE_WITH_DEPENDENCIES) {
            this.myModuleWDScope.setSelected(true);
        } else {
            this.myWholeProjectScope.setSelected(true);
        }
        this.myAlternativeJREPanel.init(configuration.getAlternativeJrePath(), configuration.isAlternativeJrePathEnabled());
        this.myEnvVariablesComponent.setEnvs(configuration.getPersistentData().getEnvs());
        this.myEnvVariablesComponent.setPassParentEnvs(configuration.getPersistentData().PASS_PARENT_ENVS);
    }

    private void changePanel() {
        if (this.myAllInPackageButton.isSelected()) {
            this.myPackagePanel.setVisible(true);
            this.myClass.setVisible(false);
            this.myMethod.setVisible(false);
        } else if (this.myClassButton.isSelected()) {
            this.myPackagePanel.setVisible(false);
            this.myClass.setVisible(true);
            this.myMethod.setVisible(false);
        } else {
            this.myPackagePanel.setVisible(false);
            this.myClass.setVisible(true);
            this.myMethod.setVisible(true);
        }
    }

    public JUnitConfigurable(Project project) {
        this.$$$setupUI$$$();
        this.myModel = new JUnitConfigurationModel(project);
        this.myModuleSelector = new ConfigurationModuleSelector(project, this.getModulesComponent());
        ((JComboBox)this.myModule.getComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JUnitConfigurable.this.myCommonJavaParameters.setModuleContext(JUnitConfigurable.this.myModuleSelector.getModule());
            }
        });
        this.myBrowsers = new BrowseModuleValueActionListener[]{new PackageChooserActionListener(project), new TestClassBrowser(project), new MethodBrowser(project)};
        this.myRadioButtons[0] = this.myAllInPackageButton;
        this.myRadioButtons[1] = this.myClassButton;
        this.myRadioButtons[2] = this.myTestMethodButton;
        this.myTestLocations[0] = this.myPackage;
        this.myTestLocations[1] = this.myClass;
        this.myTestLocations[2] = this.myMethod;
        this.myModel.setListener(this);
        JUnitConfigurable.addRadioButtonsListeners(this.myRadioButtons, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ButtonModel buttonModel = (ButtonModel)e.getSource();
                if (buttonModel.isSelected()) {
                    for (int i = 0; i < JUnitConfigurable.this.myRadioButtons.length; ++i) {
                        if (buttonModel != JUnitConfigurable.this.myRadioButtons[i].getModel()) continue;
                        JUnitConfigurable.this.myModel.setType(i);
                        break;
                    }
                }
                JUnitConfigurable.this.changePanel();
            }
        });
        this.myModel.setType(1);
        this.installDocuments();
        JUnitConfigurable.addRadioButtonsListeners(new JRadioButton[]{this.myWholeProjectScope, this.mySingleModuleScope, this.myModuleWDScope}, null);
        this.myWholeProjectScope.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JUnitConfigurable.this.onScopeChanged();
            }
        });
    }

    public JComboBox getModulesComponent() {
        return (JComboBox)this.myModule.getComponent();
    }

    public ConfigurationModuleSelector getModuleSelector() {
        return this.myModuleSelector;
    }

    private void installDocuments() {
        for (int i = 0; i < this.myTestLocations.length; ++i) {
            LabeledComponent<TextFieldWithBrowseButton> testLocation = this.getTestLocation(i);
            TextFieldWithBrowseButton field = (TextFieldWithBrowseButton)testLocation.getComponent();
            Document document = this.myModel.getJUnitDocument(i);
            field.getTextField().setDocument(document);
            this.myBrowsers[i].setField(field);
        }
    }

    public LabeledComponent<TextFieldWithBrowseButton> getTestLocation(int index) {
        return this.myTestLocations[index];
    }

    private static void addRadioButtonsListeners(JRadioButton[] radioButtons, ChangeListener listener) {
        ButtonGroup group = new ButtonGroup();
        for (JRadioButton radioButton : radioButtons) {
            radioButton.getModel().addChangeListener(listener);
            group.add(radioButton);
        }
        if (group.getSelection() == null) {
            group.setSelected(radioButtons[0].getModel(), true);
        }
    }

    public void onTypeChanged(int newType) {
        this.myRadioButtons[newType].setSelected(true);
        TIntArrayList enabledFields = ourEnabledFields.get(newType);
        for (int i = 0; i < this.myTestLocations.length; ++i) {
            this.getTestLocation(i).setEnabled(enabledFields.contains(i));
        }
        if (newType != 0) {
            this.myModule.setEnabled(true);
        } else {
            this.onScopeChanged();
        }
    }

    private void onScopeChanged() {
        this.myModule.setEnabled(!this.myWholeProjectScope.isSelected());
    }

    private String getClassName() {
        return ((TextFieldWithBrowseButton)this.getTestLocation(1).getComponent()).getText();
    }

    private void setPackage(PsiPackage aPackage) {
        if (aPackage == null) {
            return;
        }
        ((TextFieldWithBrowseButton)this.getTestLocation(0).getComponent()).setText(aPackage.getQualifiedName());
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myWholePanel;
        if (jPanel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/junit2/configuration/JUnitConfigurable.createEditor must not return null");
        }
        return jPanel;
    }

    public void disposeEditor() {
    }

    private void applyHelpersTo(JUnitConfiguration currentState) {
        this.myCommonJavaParameters.applyTo((RunJavaConfiguration)currentState);
        this.getModuleSelector().applyTo((ModuleBasedConfiguration)currentState);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        EnvironmentVariablesComponent environmentVariablesComponent;
        AlternativeJREPanel alternativeJREPanel;
        LabeledComponent labeledComponent;
        CommonJavaParameters commonJavaParameters;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        LabeledComponent labeledComponent2;
        LabeledComponent labeledComponent3;
        LabeledComponent labeledComponent4;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        JRadioButton jRadioButton6;
        JPanel jPanel;
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, 5, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myAllInPackageButton = jRadioButton6 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton6, ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.all.in.package.radio"));
        jRadioButton6.setActionCommand(ResourceBundle.getBundle("messages/ExecutionBundle").getString("jnit.configuration.all.tests.in.package.radio"));
        jPanel2.add((Component)jRadioButton6, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myClassButton = jRadioButton5 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton5, ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.class.radio"));
        ((Component)jRadioButton5).setEnabled(true);
        jRadioButton5.setSelected(false);
        jRadioButton5.setActionCommand(ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.test.class.radio"));
        jPanel2.add((Component)jRadioButton5, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTestMethodButton = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.method.radio"));
        jRadioButton4.setActionCommand(ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.test.method.radio"));
        jPanel2.add((Component)jRadioButton4, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.configure.junit.test.label"));
        jLabel.setIconTextGap(4);
        jLabel.setHorizontalAlignment(2);
        jLabel.setHorizontalTextPosition(2);
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, new Dimension(-1, 120), null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.test.border"), 0, 0, null, null));
        this.myClass = labeledComponent4 = new LabeledComponent();
        labeledComponent4.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.class.label"));
        labeledComponent4.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        jPanel4.add((Component)labeledComponent4, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myMethod = labeledComponent3 = new LabeledComponent();
        labeledComponent3.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.method.label"));
        labeledComponent3.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        jPanel4.add((Component)labeledComponent3, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel5 = new JPanel();
        this.myPackagePanel = jPanel5;
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPackage = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.package.label"));
        labeledComponent2.setVisible(true);
        labeledComponent2.setEnabled(true);
        labeledComponent2.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        jPanel5.add((Component)labeledComponent2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.search.for.tests.label"));
        jPanel6.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWholeProjectScope = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.in.whole.project.radio"));
        jPanel6.add((Component)jRadioButton3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySingleModuleScope = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.in.single.module.radio"));
        jPanel6.add((Component)jRadioButton2, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myModuleWDScope = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.across.module.dependencies.radio"));
        jPanel6.add((Component)jRadioButton, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(5, 0, 5, 0), -1, 10, false, false));
        jPanel.add((Component)jPanel7, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCommonJavaParameters = commonJavaParameters = new CommonJavaParameters();
        jPanel7.add((Component)commonJavaParameters, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myModule = labeledComponent = new LabeledComponent();
        labeledComponent.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.use.classpath.and.jdk.of.module.label"));
        labeledComponent.setEnabled(true);
        labeledComponent.setComponentClass("javax.swing.JComboBox");
        labeledComponent.setLabelInsets(new Insets(7, 0, 2, 0));
        jPanel7.add((Component)labeledComponent, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myAlternativeJREPanel = alternativeJREPanel = new AlternativeJREPanel();
        jPanel7.add((Component)alternativeJREPanel, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myEnvVariablesComponent = environmentVariablesComponent = new EnvironmentVariablesComponent();
        jPanel7.add((Component)environmentVariablesComponent, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MethodBrowser
    extends BrowseModuleValueActionListener {
        public MethodBrowser(Project project) {
            super(project);
        }

        protected String showDialog() {
            PsiMethod method;
            String className = JUnitConfigurable.this.getClassName();
            if (className.trim().length() == 0) {
                Messages.showMessageDialog((Component)this.getField(), (String)ExecutionBundle.message((String)"set.class.name.message", (Object[])new Object[0]), (String)ExecutionBundle.message((String)"cannot.browse.method.dialog.title", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
                return null;
            }
            PsiClass testClass = JUnitConfigurable.this.getModuleSelector().findClass(className);
            if (testClass == null) {
                Messages.showMessageDialog((Component)this.getField(), (String)ExecutionBundle.message((String)"class.does.not.exists.error.message", (Object[])new Object[]{className}), (String)ExecutionBundle.message((String)"cannot.browse.method.dialog.title", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
                return null;
            }
            MethodListDlg dlg = new MethodListDlg(testClass, (Condition<PsiMethod>)new JUnitUtil.TestMethodFilter(testClass), (JComponent)this.getField());
            dlg.show();
            if (dlg.isOK() && (method = dlg.getSelected()) != null) {
                return method.getName();
            }
            return null;
        }
    }

    private class TestClassBrowser
    extends ClassBrowser {
        public TestClassBrowser(Project project) {
            super(project, ExecutionBundle.message((String)"choose.test.class.dialog.title", (Object[])new Object[0]));
        }

        protected void onClassChoosen(PsiClass psiClass) {
            JUnitConfigurable.this.setPackage(JUnitUtil.getContainingPackage((PsiClass)psiClass));
        }

        protected PsiClass findClass(String className) {
            return JUnitConfigurable.this.getModuleSelector().findClass(className);
        }

        protected TreeClassChooser.ClassFilterWithScope getFilter() throws ClassBrowser.NoFilterException {
            TestClassFilter classFilter;
            ConfigurationModuleSelector moduleSelector = JUnitConfigurable.this.getModuleSelector();
            Module module = moduleSelector.getModule();
            if (module == null) {
                throw ClassBrowser.NoFilterException.moduleDoesntExist((ConfigurationModuleSelector)moduleSelector);
            }
            try {
                JUnitConfiguration configurationCopy = new JUnitConfiguration(ExecutionBundle.message((String)"default.junit.configuration.name", (Object[])new Object[0]), this.getProject(), JUnitConfigurationType.getInstance().getConfigurationFactories()[0]);
                JUnitConfigurable.this.applyEditorTo(configurationCopy);
                classFilter = TestClassFilter.create(configurationCopy.getTestObject().getSourceScope(), ((JavaRunConfigurationModule)configurationCopy.getConfigurationModule()).getModule());
            }
            catch (JUnitUtil.NoJUnitException e) {
                throw ClassBrowser.NoFilterException.noJUnitInModule((Module)module);
            }
            return classFilter;
        }
    }

    private static class PackageChooserActionListener
    extends BrowseModuleValueActionListener {
        public PackageChooserActionListener(Project project) {
            super(project);
        }

        protected String showDialog() {
            PackageChooserDialog dialog = new PackageChooserDialog(ExecutionBundle.message((String)"choose.package.dialog.title", (Object[])new Object[0]), this.getProject());
            dialog.show();
            PsiPackage aPackage = dialog.getSelectedPackage();
            return aPackage != null ? aPackage.getQualifiedName() : null;
        }
    }
}

