/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.TestMethod;
import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.junit2.info.TestInfo;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.LinkedHashSet;

public class TestMethods
extends TestMethod {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.junit.TestMethods");
    private final Collection<AbstractTestProxy> myFailedTests;

    public TestMethods(Project project, JUnitConfiguration configuration, RunnerSettings runnerSettings, ConfigurationPerRunnerSettings configurationSettings, Collection<AbstractTestProxy> failedTests) {
        super(project, configuration, runnerSettings, configurationSettings);
        this.myFailedTests = failedTests;
    }

    @Override
    protected void initialize() throws ExecutionException {
        this.defaultInitialize();
        JUnitConfiguration.Data data = this.myConfiguration.getPersistentData();
        RunConfigurationModule module = this.myConfiguration.getConfigurationModule();
        final Project project = module.getProject();
        this.addJUnit4Parameter(data, project);
        final ExecutionException[] exception = new ExecutionException[1];
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                try {
                    TestMethods.this.myConfiguration.configureClasspath(TestMethods.this.myJavaParameters);
                }
                catch (CantRunException e) {
                    exception[0] = e;
                }
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
        LinkedHashSet<TestInfo> methods = new LinkedHashSet<TestInfo>();
        for (AbstractTestProxy failedTest : this.myFailedTests) {
            Location location = failedTest.getLocation(project);
            if (!(location instanceof MethodLocation)) continue;
            PsiElement psiElement = location.getPsiElement();
            LOG.assertTrue(psiElement instanceof PsiMethod);
            PsiMethod method = (PsiMethod)psiElement;
            methods.add(((TestProxy)failedTest).getInfo());
        }
        this.addClassesListToJavaParameters(methods, new Function<TestInfo, String>(){

            public String fun(TestInfo testInfo) {
                if (testInfo != null) {
                    MethodLocation location = (MethodLocation)testInfo.getLocation(project);
                    LOG.assertTrue(location != null);
                    return JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)location.getContainingClass()) + "," + testInfo.getName();
                }
                return null;
            }
        }, data.getPackageName(), true, false);
    }

    @Override
    protected void addJUnit4Parameter(JUnitConfiguration.Data data, Project project) {
        for (AbstractTestProxy failedTest : this.myFailedTests) {
            Location location = failedTest.getLocation(project);
            if (!(location instanceof MethodLocation)) continue;
            if (JUnitUtil.isJUnit4TestClass((PsiClass)((MethodLocation)location).getContainingClass())) {
                this.myJavaParameters.getProgramParametersList().add("-junit4");
                return;
            }
            PsiMethod method = ((MethodLocation)location).getPsiElement();
            if (!JUnitUtil.isTestAnnotated((PsiMethod)method)) continue;
            this.myJavaParameters.getProgramParametersList().add("-junit4");
            return;
        }
    }

    @Override
    public String suggestActionName() {
        return ActionsBundle.message((String)"action.RerunFailedTests.text", (Object[])new Object[0]);
    }
}

