/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.vfs.MavenPropertiesVirtualFile;

public class MavenPropertiesVirtualFileSystem
extends DummyFileSystem
implements ApplicationComponent {
    @NonNls
    public static final String PROTOCOL = "maven-properties";
    @NonNls
    public static final String SYSTEM_PROPERTIES_FILE = "System.properties";
    @NonNls
    public static final String ENV_PROPERTIES_FILE = "Environment.properties";
    public static final String[] PROPERTIES_FILES = new String[]{"System.properties", "Environment.properties"};
    private final Map<String, VirtualFile> myFiles = new THashMap();

    public static MavenPropertiesVirtualFileSystem getInstance() {
        return (MavenPropertiesVirtualFileSystem)((Object)ApplicationManager.getApplication().getComponent(MavenPropertiesVirtualFileSystem.class));
    }

    @NotNull
    public String getComponentName() {
        String string = MavenPropertiesVirtualFileSystem.class.getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/vfs/MavenPropertiesVirtualFileSystem.getComponentName must not return null");
        }
        return string;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getProtocol() {
        if (PROTOCOL == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/vfs/MavenPropertiesVirtualFileSystem.getProtocol must not return null");
        }
        return PROTOCOL;
    }

    public synchronized VirtualFile findFileByPath(@NotNull @NonNls String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/vfs/MavenPropertiesVirtualFileSystem.findFileByPath must not be null");
        }
        VirtualFile result = this.myFiles.get(path);
        if (result != null) {
            return result;
        }
        result = this.createFile(path);
        if (result != null) {
            this.myFiles.put(path, result);
        }
        return result;
    }

    @Nullable
    private VirtualFile createFile(String path) {
        if (SYSTEM_PROPERTIES_FILE.equals(path)) {
            return new MavenPropertiesVirtualFile(path, MavenUtil.getSystemProperties(), (VirtualFileSystem)this);
        }
        if (ENV_PROPERTIES_FILE.equals(path)) {
            return new MavenPropertiesVirtualFile(path, MavenUtil.getEnvProperties(), (VirtualFileSystem)this);
        }
        return null;
    }

    public void refresh(boolean asynchronous) {
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/vfs/MavenPropertiesVirtualFileSystem.refreshAndFindFileByPath must not be null");
        }
        return this.findFileByPath(path);
    }
}

