/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.psi.PsiFile;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.SwingUtilities;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.project.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenArtifactDownloader;
import org.jetbrains.idea.maven.project.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.ProjectBundle;

public class MavenAttachSourcesProvider
implements AttachSourcesProvider {
    public Collection<AttachSourcesProvider.AttachSourcesAction> getActions(final Library library, final PsiFile psiFile) {
        Collection<MavenProject> projects = this.getMavenProjects(psiFile);
        if (projects.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.findArtifacts(projects, library).isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singleton(new AttachSourcesProvider.AttachSourcesAction(){

            public String getName() {
                return ProjectBundle.message("maven.action.download.sources", new Object[0]);
            }

            public String getBusyText() {
                return ProjectBundle.message("maven.action.download.sources.busy.text", new Object[0]);
            }

            public ActionCallback perform() {
                Collection mavenProjects = MavenAttachSourcesProvider.this.getMavenProjects(psiFile);
                if (mavenProjects.isEmpty()) {
                    return new ActionCallback.Rejected();
                }
                MavenProjectsManager manager = MavenProjectsManager.getInstance(psiFile.getProject());
                Collection artifacts = MavenAttachSourcesProvider.this.findArtifacts(mavenProjects, library);
                if (artifacts.isEmpty()) {
                    return new ActionCallback.Rejected();
                }
                AsyncResult result = new AsyncResult();
                manager.scheduleArtifactsDownloading(mavenProjects, artifacts, true, false, (AsyncResult<MavenArtifactDownloader.DownloadResult>)result);
                final ActionCallback resultWrapper = new ActionCallback();
                result.doWhenDone((AsyncResult.Handler)new AsyncResult.Handler<MavenArtifactDownloader.DownloadResult>(){

                    public void run(MavenArtifactDownloader.DownloadResult downloadResult) {
                        if (!downloadResult.unresolvedSources.isEmpty()) {
                            String message = "<html>Sources not found for:";
                            int count = 0;
                            for (MavenId each : downloadResult.unresolvedSources) {
                                if (count++ > 5) {
                                    message = message + "<br>and more...";
                                    break;
                                }
                                message = message + "<br>" + each.getDisplayString();
                            }
                            final String finalMessage = message = message + "</html>";
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Notifications.Bus.notify((Notification)new Notification("Maven", "Cannot download sources", finalMessage, NotificationType.WARNING), (Project)psiFile.getProject());
                                }
                            });
                        }
                        if (downloadResult.resolvedSources.isEmpty()) {
                            resultWrapper.setRejected();
                        } else {
                            resultWrapper.setDone();
                        }
                    }
                });
                return resultWrapper;
            }
        });
    }

    private Collection<MavenArtifact> findArtifacts(Collection<MavenProject> mavenProjects, Library library) {
        THashSet artifacts = new THashSet();
        for (MavenProject each : mavenProjects) {
            MavenArtifact artifact = MavenRootModelAdapter.findArtifact(each, library);
            if (artifact == null) continue;
            artifacts.add(artifact);
        }
        return artifacts;
    }

    private Collection<MavenProject> getMavenProjects(PsiFile psiFile) {
        Project project = psiFile.getProject();
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        for (OrderEntry each : ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(psiFile.getVirtualFile())) {
            MavenProject mavenProject = MavenProjectsManager.getInstance(project).findProject(each.getOwnerModule());
            if (mavenProject == null) continue;
            result.add(mavenProject);
        }
        return result;
    }
}

