/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Resource;
import org.apache.maven.profiles.activation.FileProfileActivator;
import org.apache.maven.profiles.activation.JdkPrefixProfileActivator;
import org.apache.maven.profiles.activation.OperatingSystemProfileActivator;
import org.apache.maven.profiles.activation.ProfileActivationException;
import org.apache.maven.profiles.activation.ProfileActivator;
import org.apache.maven.profiles.activation.SystemPropertyProfileActivator;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.JBMavenProjectHelper;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.inheritance.DefaultModelInheritanceAssembler;
import org.apache.maven.project.injection.DefaultProfileInjector;
import org.apache.maven.project.validation.ModelValidationResult;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.context.DefaultContext;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.embedder.MavenConsole;
import org.jetbrains.idea.maven.embedder.MavenConsoleHelper;
import org.jetbrains.idea.maven.embedder.MavenEmbedderFactory;
import org.jetbrains.idea.maven.embedder.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.embedder.MavenExecutionResult;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenId;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenParentDesc;
import org.jetbrains.idea.maven.project.MavenParentProjectFileProcessor;
import org.jetbrains.idea.maven.project.MavenProjectProblem;
import org.jetbrains.idea.maven.project.MavenProjectReaderProjectLocator;
import org.jetbrains.idea.maven.project.MavenProjectReaderResult;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenProjectReader {
    private static final String UNKNOWN = "Unknown";
    private static final String PROFILE_FROM_POM = "pom";
    private static final String PROFILE_FROM_PROFILES_XML = "profiles.xml";
    private static final String PROFILE_FROM_SETTINGS_XML = "settings.xml";
    private final Map<VirtualFile, RawModelReadResult> myRawModelsCache = new THashMap();
    private Pair<List<Profile>, Collection<MavenProjectProblem>> mySettingsProfilesWithProblemsCache;

    public MavenProjectReaderResult readProject(MavenGeneralSettings generalSettings, VirtualFile file, Collection<String> explicitProfiles, MavenProjectReaderProjectLocator locator) {
        Pair<RawModelReadResult, Collection<String>> readResult = this.doReadProjectModel(generalSettings, file, explicitProfiles, (Set<VirtualFile>)new THashSet(), locator);
        File basedir = this.getBaseDir(file);
        Model model = this.expandProperties(((RawModelReadResult)readResult.first).model, basedir);
        this.alignModel(model, basedir);
        MavenProject mavenProject = new MavenProject(model);
        mavenProject.setFile(new File(file.getPath()));
        JBMavenProjectHelper.setSourceRoots(mavenProject, Collections.singletonList(model.getBuild().getSourceDirectory()), Collections.singletonList(model.getBuild().getTestSourceDirectory()), Collections.singletonList(model.getBuild().getScriptSourceDirectory()));
        return new MavenProjectReaderResult(generalSettings, ((RawModelReadResult)readResult.first).problems, Collections.EMPTY_SET, generalSettings.getEffectiveLocalRepository(), mavenProject, (Collection)readResult.second);
    }

    private File getBaseDir(VirtualFile file) {
        return new File(file.getParent().getPath());
    }

    private Pair<RawModelReadResult, Collection<String>> doReadProjectModel(MavenGeneralSettings generalSettings, VirtualFile file, Collection<String> explicitProfiles, Set<VirtualFile> recursionGuard, MavenProjectReaderProjectLocator locator) {
        RawModelReadResult cachedModel = this.myRawModelsCache.get(file);
        if (cachedModel == null) {
            cachedModel = this.doReadProjectModel(file, false);
            this.myRawModelsCache.put(file, cachedModel);
        }
        Model model = cachedModel.model;
        Set<String> alwaysOnProfiles = cachedModel.alwaysOnProfiles;
        Collection<MavenProjectProblem> problems = cachedModel.problems;
        this.repairModelHeader(model);
        this.resolveInheritance(generalSettings, model, file, explicitProfiles, recursionGuard, locator, problems);
        this.addSettingsProfiles(generalSettings, model, alwaysOnProfiles, problems);
        List<String> activatedProfiles = this.applyProfiles(model, this.getBaseDir(file), explicitProfiles, alwaysOnProfiles);
        this.repairModelBody(model);
        return Pair.create((Object)cachedModel, activatedProfiles);
    }

    private RawModelReadResult doReadProjectModel(VirtualFile file, boolean headerOnly) {
        Model result = new Model();
        LinkedHashSet<MavenProjectProblem> problems = this.createProblemsList();
        THashSet alwaysOnProfiles = new THashSet();
        Element xmlProject = this.readXml(file, problems, MavenProjectProblem.ProblemType.SYNTAX);
        if (xmlProject == null || !"project".equals(xmlProject.getName())) {
            return new RawModelReadResult(result, problems, (Set)alwaysOnProfiles);
        }
        result.setModelVersion(MavenJDOMUtil.findChildValueByPath(xmlProject, "modelVersion"));
        result.setGroupId(MavenJDOMUtil.findChildValueByPath(xmlProject, "groupId"));
        result.setArtifactId(MavenJDOMUtil.findChildValueByPath(xmlProject, "artifactId"));
        result.setVersion(MavenJDOMUtil.findChildValueByPath(xmlProject, "version"));
        if (headerOnly) {
            return new RawModelReadResult(result, problems, (Set)alwaysOnProfiles);
        }
        result.setPackaging(MavenJDOMUtil.findChildValueByPath(xmlProject, "packaging"));
        result.setName(MavenJDOMUtil.findChildValueByPath(xmlProject, "name"));
        if (MavenJDOMUtil.hasChildByPath(xmlProject, "parent")) {
            Parent parent = new Parent();
            String groupId = MavenJDOMUtil.findChildValueByPath(xmlProject, "parent.groupId");
            String artifactId = MavenJDOMUtil.findChildValueByPath(xmlProject, "parent.artifactId");
            String version = MavenJDOMUtil.findChildValueByPath(xmlProject, "parent.version");
            parent.setGroupId(groupId);
            parent.setArtifactId(artifactId);
            parent.setVersion(version);
            parent.setRelativePath(MavenJDOMUtil.findChildValueByPath(xmlProject, "parent.relativePath"));
            result.setParent(parent);
        }
        result.setBuild(new Build());
        this.readModelAndBuild((ModelBase)result, (BuildBase)result.getBuild(), xmlProject);
        result.setProfiles(this.collectProfiles(file, xmlProject, problems, (Collection<String>)alwaysOnProfiles));
        return new RawModelReadResult(result, problems, (Set)alwaysOnProfiles);
    }

    private void readModelAndBuild(ModelBase mavenModelBase, BuildBase mavenBuildBase, Element xmlModel) {
        mavenModelBase.setModules(MavenJDOMUtil.findChildrenValuesByPath(xmlModel, "modules", "module"));
        this.collectProperties(MavenJDOMUtil.findChildByPath(xmlModel, "properties"), mavenModelBase);
        Element xmlBuild = MavenJDOMUtil.findChildByPath(xmlModel, "build");
        if (xmlBuild == null) {
            return;
        }
        mavenBuildBase.setFinalName(MavenJDOMUtil.findChildValueByPath(xmlBuild, "finalName"));
        mavenBuildBase.setDefaultGoal(MavenJDOMUtil.findChildValueByPath(xmlBuild, "defaultGoal"));
        mavenBuildBase.setDirectory(MavenJDOMUtil.findChildValueByPath(xmlBuild, "directory"));
        mavenBuildBase.setResources(this.collectResources(MavenJDOMUtil.findChildrenByPath(xmlBuild, "resources", "resource")));
        mavenBuildBase.setTestResources(this.collectResources(MavenJDOMUtil.findChildrenByPath(xmlBuild, "testResources", "testResource")));
        if (mavenBuildBase instanceof Build) {
            Build mavenBuild = (Build)mavenBuildBase;
            mavenBuild.setSourceDirectory(MavenJDOMUtil.findChildValueByPath(xmlBuild, "sourceDirectory"));
            mavenBuild.setTestSourceDirectory(MavenJDOMUtil.findChildValueByPath(xmlBuild, "testSourceDirectory"));
            mavenBuild.setScriptSourceDirectory(MavenJDOMUtil.findChildValueByPath(xmlBuild, "scriptSourceDirectory"));
            mavenBuild.setOutputDirectory(MavenJDOMUtil.findChildValueByPath(xmlBuild, "outputDirectory"));
            mavenBuild.setTestOutputDirectory(MavenJDOMUtil.findChildValueByPath(xmlBuild, "testOutputDirectory"));
        }
    }

    private List<Resource> collectResources(List<Element> xmlResources) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Element each : xmlResources) {
            Resource r = new Resource();
            r.setDirectory(MavenJDOMUtil.findChildValueByPath(each, "directory"));
            r.setFiltering("true".equals(MavenJDOMUtil.findChildValueByPath(each, "filtering")));
            r.setTargetPath(MavenJDOMUtil.findChildValueByPath(each, "targetPath"));
            r.setIncludes(MavenJDOMUtil.findChildrenValuesByPath(each, "includes", "include"));
            r.setExcludes(MavenJDOMUtil.findChildrenValuesByPath(each, "excludes", "exclude"));
            result.add(r);
        }
        return result;
    }

    private List<Profile> collectProfiles(VirtualFile projectFile, Element xmlProject, Collection<MavenProjectProblem> problems, Collection<String> alwaysOnProfiles) {
        ArrayList<Profile> result = new ArrayList<Profile>();
        this.collectProfiles(MavenJDOMUtil.findChildrenByPath(xmlProject, "profiles", "profile"), result, PROFILE_FROM_POM);
        VirtualFile profilesFile = MavenUtil.findProfilesXmlFile(projectFile);
        if (profilesFile != null) {
            this.collectProfilesFromSettingsXmlOrProfilesXml(profilesFile, "profilesXml", true, PROFILE_FROM_PROFILES_XML, result, alwaysOnProfiles, problems);
        }
        return result;
    }

    private void addSettingsProfiles(MavenGeneralSettings generalSettings, Model model, Collection<String> alwaysOnProfiles, Collection<MavenProjectProblem> problems) {
        if (this.mySettingsProfilesWithProblemsCache == null) {
            ArrayList<Profile> settingsProfiles = new ArrayList<Profile>();
            LinkedHashSet<MavenProjectProblem> settingsProblems = this.createProblemsList();
            for (VirtualFile each : generalSettings.getEffectiveSettingsFiles()) {
                this.collectProfilesFromSettingsXmlOrProfilesXml(each, "settings", false, PROFILE_FROM_SETTINGS_XML, settingsProfiles, alwaysOnProfiles, settingsProblems);
            }
            this.mySettingsProfilesWithProblemsCache = Pair.create(settingsProfiles, settingsProblems);
        }
        List modelProfiles = model.getProfiles();
        for (Profile each : (List)this.mySettingsProfilesWithProblemsCache.first) {
            this.addProfileIfDoesNotExist(each, modelProfiles);
        }
        problems.addAll((Collection)this.mySettingsProfilesWithProblemsCache.second);
    }

    private void collectProfilesFromSettingsXmlOrProfilesXml(VirtualFile profilesFile, String rootElementName, boolean wrapRootIfNecessary, String profilesSource, List<Profile> result, Collection<String> alwaysOnProfiles, Collection<MavenProjectProblem> problems) {
        Element rootElement = this.readXml(profilesFile, problems, MavenProjectProblem.ProblemType.SETTINGS_OR_PROFILES);
        if (rootElement == null) {
            return;
        }
        if (wrapRootIfNecessary && !rootElementName.equals(rootElement.getName())) {
            Element wrapper = new Element(rootElementName);
            wrapper.addContent(rootElement);
            rootElement = wrapper;
        }
        List<Element> xmlProfiles = MavenJDOMUtil.findChildrenByPath(rootElement, "profiles", "profile");
        this.collectProfiles(xmlProfiles, result, profilesSource);
        alwaysOnProfiles.addAll(MavenJDOMUtil.findChildrenValuesByPath(rootElement, "activeProfiles", "activeProfile"));
    }

    private void collectProfiles(List<Element> xmlProfiles, List<Profile> result, String source) {
        for (Element each : xmlProfiles) {
            String id = MavenJDOMUtil.findChildValueByPath(each, "id");
            if (StringUtil.isEmptyOrSpaces((String)id)) continue;
            Profile profile = new Profile();
            profile.setId(id);
            profile.setSource(source);
            if (!this.addProfileIfDoesNotExist(profile, result)) continue;
            Element xmlActivation = MavenJDOMUtil.findChildByPath(each, "activation");
            if (xmlActivation != null) {
                Element xmlFile;
                Activation activation = new Activation();
                activation.setActiveByDefault("true".equals(MavenJDOMUtil.findChildValueByPath(xmlActivation, "activeByDefault")));
                Element xmlOS = MavenJDOMUtil.findChildByPath(xmlActivation, "os");
                if (xmlOS != null) {
                    ActivationOS activationOS = new ActivationOS();
                    activationOS.setName(MavenJDOMUtil.findChildValueByPath(xmlOS, "name"));
                    activationOS.setFamily(MavenJDOMUtil.findChildValueByPath(xmlOS, "family"));
                    activationOS.setArch(MavenJDOMUtil.findChildValueByPath(xmlOS, "arch"));
                    activationOS.setVersion(MavenJDOMUtil.findChildValueByPath(xmlOS, "version"));
                    activation.setOs(activationOS);
                }
                activation.setJdk(MavenJDOMUtil.findChildValueByPath(xmlActivation, "jdk"));
                Element xmlProperty = MavenJDOMUtil.findChildByPath(xmlActivation, "property");
                if (xmlProperty != null) {
                    ActivationProperty activationProperty = new ActivationProperty();
                    activationProperty.setName(MavenJDOMUtil.findChildValueByPath(xmlProperty, "name"));
                    activationProperty.setValue(MavenJDOMUtil.findChildValueByPath(xmlProperty, "value"));
                    activation.setProperty(activationProperty);
                }
                if ((xmlFile = MavenJDOMUtil.findChildByPath(xmlActivation, "file")) != null) {
                    ActivationFile activationFile = new ActivationFile();
                    activationFile.setExists(MavenJDOMUtil.findChildValueByPath(xmlFile, "exists"));
                    activationFile.setMissing(MavenJDOMUtil.findChildValueByPath(xmlFile, "missing"));
                    activation.setFile(activationFile);
                }
                profile.setActivation(activation);
            }
            profile.setBuild(new BuildBase());
            this.readModelAndBuild((ModelBase)profile, profile.getBuild(), each);
        }
    }

    private boolean addProfileIfDoesNotExist(Profile profile, List<Profile> result) {
        for (Profile each : result) {
            if (!Comparing.equal((String)each.getId(), (String)profile.getId())) continue;
            return false;
        }
        result.add(profile);
        return true;
    }

    private void collectProperties(Element xmlProperties, ModelBase mavenModelBase) {
        if (xmlProperties == null) {
            return;
        }
        Properties props = mavenModelBase.getProperties();
        for (Element each : xmlProperties.getChildren()) {
            String name = each.getName();
            String value = each.getText();
            if (props.containsKey(name) || StringUtil.isEmptyOrSpaces((String)value)) continue;
            props.setProperty(name, value);
        }
    }

    private List<String> applyProfiles(Model model, File basedir, Collection<String> explicitProfiles, Collection<String> alwaysOnProfiles) {
        ArrayList<Profile> activatedPom = new ArrayList<Profile>();
        ArrayList<Profile> activatedExternal = new ArrayList<Profile>();
        ArrayList<Profile> activeByDefault = new ArrayList<Profile>();
        List rawProfiles = model.getProfiles();
        List expandedProfilesCache = null;
        for (int i = 0; i < rawProfiles.size(); ++i) {
            Profile eachRawProfile = (Profile)rawProfiles.get(i);
            boolean shouldAdd = explicitProfiles.contains(eachRawProfile.getId()) || alwaysOnProfiles.contains(eachRawProfile.getId());
            Activation activation = eachRawProfile.getActivation();
            if (activation != null) {
                if (activation.isActiveByDefault()) {
                    activeByDefault.add(eachRawProfile);
                }
                if (expandedProfilesCache == null) {
                    expandedProfilesCache = this.expandProperties(model, basedir).getProfiles();
                }
                Profile eachExpandedProfile = (Profile)expandedProfilesCache.get(i);
                for (ProfileActivator eachActivator : this.getProfileActivators()) {
                    try {
                        if (!eachActivator.canDetermineActivation(eachExpandedProfile) || !eachActivator.isActive(eachExpandedProfile)) continue;
                        shouldAdd = true;
                        break;
                    }
                    catch (ProfileActivationException e) {
                        MavenLog.LOG.warn((Throwable)e);
                    }
                }
            }
            if (!shouldAdd) continue;
            if (PROFILE_FROM_POM.equals(eachRawProfile.getSource())) {
                activatedPom.add(eachRawProfile);
                continue;
            }
            activatedExternal.add(eachRawProfile);
        }
        ArrayList<Profile> activatedProfiles = new ArrayList<Profile>(activatedPom.isEmpty() ? activeByDefault : activatedPom);
        activatedProfiles.addAll(activatedExternal);
        for (Profile each : activatedProfiles) {
            new DefaultProfileInjector().inject(each, model);
        }
        return ContainerUtil.mapNotNull(activatedProfiles, (Function)new NullableFunction<Profile, String>(){

            public String fun(Profile profile) {
                return profile.getId();
            }
        });
    }

    private ProfileActivator[] getProfileActivators() {
        SystemPropertyProfileActivator sysPropertyActivator = new SystemPropertyProfileActivator();
        DefaultContext context = new DefaultContext();
        context.put((Object)"SystemProperties", (Object)MavenEmbedderFactory.collectSystemProperties());
        try {
            sysPropertyActivator.contextualize((Context)context);
        }
        catch (ContextException e) {
            MavenLog.LOG.error((Throwable)e);
            return new ProfileActivator[0];
        }
        return new ProfileActivator[]{new FileProfileActivator(), sysPropertyActivator, new JdkPrefixProfileActivator(), new OperatingSystemProfileActivator()};
    }

    private void repairModelHeader(Model model) {
        Parent parent;
        if (StringUtil.isEmptyOrSpaces((String)model.getModelVersion())) {
            model.setModelVersion("4.0.0");
        }
        if ((parent = model.getParent()) != null) {
            if (StringUtil.isEmptyOrSpaces((String)parent.getGroupId())) {
                parent.setGroupId(UNKNOWN);
            }
            if (StringUtil.isEmptyOrSpaces((String)parent.getArtifactId())) {
                parent.setArtifactId(UNKNOWN);
            }
            if (StringUtil.isEmptyOrSpaces((String)parent.getVersion())) {
                parent.setVersion(UNKNOWN);
            }
            if (StringUtil.isEmptyOrSpaces((String)parent.getRelativePath())) {
                parent.setRelativePath("../pom.xml");
            }
        }
        if (StringUtil.isEmptyOrSpaces((String)model.getGroupId())) {
            if (parent != null) {
                model.setGroupId(parent.getGroupId());
            } else {
                model.setGroupId(UNKNOWN);
            }
        }
        if (StringUtil.isEmptyOrSpaces((String)model.getArtifactId())) {
            model.setArtifactId(UNKNOWN);
        }
        if (StringUtil.isEmptyOrSpaces((String)model.getVersion())) {
            if (parent != null) {
                model.setVersion(parent.getVersion());
            } else {
                model.setVersion(UNKNOWN);
            }
        }
        if (StringUtil.isEmptyOrSpaces((String)model.getPackaging())) {
            model.setPackaging("jar");
        }
    }

    private void repairModelBody(Model model) {
        Build build;
        if (model.getBuild() == null) {
            model.setBuild(new Build());
        }
        if (StringUtil.isEmptyOrSpaces((String)(build = model.getBuild()).getFinalName())) {
            build.setFinalName("${project.artifactId}-${project.version}");
        }
        build.setSourceDirectory(StringUtil.isEmptyOrSpaces((String)build.getSourceDirectory()) ? "src/main/java" : build.getSourceDirectory());
        build.setTestSourceDirectory(StringUtil.isEmptyOrSpaces((String)build.getTestSourceDirectory()) ? "src/test/java" : build.getTestSourceDirectory());
        build.setScriptSourceDirectory(StringUtil.isEmptyOrSpaces((String)build.getScriptSourceDirectory()) ? "src/main/scripts" : build.getScriptSourceDirectory());
        build.setResources(this.repairResources(build.getResources(), "src/main/resources"));
        build.setTestResources(this.repairResources(build.getTestResources(), "src/test/resources"));
        build.setDirectory(StringUtil.isEmptyOrSpaces((String)build.getDirectory()) ? "target" : build.getDirectory());
        build.setOutputDirectory(StringUtil.isEmptyOrSpaces((String)build.getOutputDirectory()) ? "${project.build.directory}/classes" : build.getOutputDirectory());
        build.setTestOutputDirectory(StringUtil.isEmptyOrSpaces((String)build.getTestOutputDirectory()) ? "${project.build.directory}/test-classes" : build.getTestOutputDirectory());
    }

    private List<Resource> repairResources(List<Resource> resources, String defaultDir) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        if (resources.isEmpty()) {
            result.add(this.createResource(defaultDir));
            return result;
        }
        for (Resource each : resources) {
            if (StringUtil.isEmptyOrSpaces((String)each.getDirectory())) continue;
            each.setDirectory(each.getDirectory());
            result.add(each);
        }
        return result;
    }

    private Resource createResource(String directory) {
        Resource result = new Resource();
        result.setDirectory(directory);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveInheritance(final MavenGeneralSettings generalSettings, Model model, VirtualFile file, final Collection<String> explicitProfiles, final Set<VirtualFile> recursionGuard, final MavenProjectReaderProjectLocator locator, Collection<MavenProjectProblem> problems) {
        if (recursionGuard.contains(file)) {
            problems.add(this.createProblem(file, ProjectBundle.message("maven.project.problem.recursiveInheritance", new Object[0]), MavenProjectProblem.ProblemType.PARENT));
            return;
        }
        recursionGuard.add(file);
        try {
            Pair parentModelWithProblems;
            Parent parent = model.getParent();
            final MavenParentDesc[] parentDesc = new MavenParentDesc[1];
            if (parent != null) {
                MavenId parentId = new MavenId(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
                if (parentId.equals(model.getGroupId(), model.getArtifactId(), model.getVersion())) {
                    problems.add(this.createProblem(file, ProjectBundle.message("maven.project.problem.selfInheritance", new Object[0]), MavenProjectProblem.ProblemType.PARENT));
                    return;
                }
                parentDesc[0] = new MavenParentDesc(parentId, parent.getRelativePath());
            }
            if ((parentModelWithProblems = (Pair)new MavenParentProjectFileProcessor<Pair<VirtualFile, RawModelReadResult>>(){

                @Override
                @Nullable
                protected VirtualFile findManagedFile(@NotNull MavenId id) {
                    if (id == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/project/MavenProjectReader$2.findManagedFile must not be null");
                    }
                    return locator.findProjectFile(id);
                }

                @Override
                @Nullable
                protected Pair<VirtualFile, RawModelReadResult> processRelativeParent(VirtualFile parentFile) {
                    Model parentModel = ((MavenProjectReader)MavenProjectReader.this).doReadProjectModel((VirtualFile)parentFile, (boolean)true).model;
                    MavenId parentId = parentDesc[0].getParentId();
                    if (!parentId.equals(new MavenId(parentModel))) {
                        return null;
                    }
                    return (Pair)super.processRelativeParent(parentFile);
                }

                @Override
                protected Pair<VirtualFile, RawModelReadResult> processSuperParent(VirtualFile parentFile) {
                    return null;
                }

                @Override
                protected Pair<VirtualFile, RawModelReadResult> doProcessParent(VirtualFile parentFile) {
                    RawModelReadResult result = (RawModelReadResult)((MavenProjectReader)MavenProjectReader.this).doReadProjectModel((MavenGeneralSettings)generalSettings, (VirtualFile)parentFile, (Collection)explicitProfiles, (Set)recursionGuard, (MavenProjectReaderProjectLocator)locator).first;
                    return Pair.create((Object)parentFile, (Object)result);
                }
            }.process(generalSettings, file, parentDesc[0])) == null) {
                return;
            }
            Model parentModel = ((RawModelReadResult)parentModelWithProblems.second).model;
            if (!((RawModelReadResult)parentModelWithProblems.second).problems.isEmpty()) {
                problems.add(this.createProblem((VirtualFile)parentModelWithProblems.first, ProjectBundle.message("maven.project.problem.parentHasProblems", new MavenId(parentModel)), MavenProjectProblem.ProblemType.PARENT));
            }
            new DefaultModelInheritanceAssembler().assembleModelInheritance(model, parentModel);
            List profiles = model.getProfiles();
            for (Profile each : parentModel.getProfiles()) {
                this.addProfileIfDoesNotExist(each, profiles);
            }
        }
        finally {
            recursionGuard.remove(file);
        }
    }

    private Model expandProperties(Model model, File basedir) {
        return MavenEmbedderWrapper.interpolate(model, basedir);
    }

    private void alignModel(Model model, File basedir) {
        MavenEmbedderWrapper.alignModel(model, basedir);
    }

    private MavenProjectProblem createStructureProblem(VirtualFile file, String description) {
        return this.createProblem(file, description, MavenProjectProblem.ProblemType.STRUCTURE);
    }

    private MavenProjectProblem createSyntaxProblem(VirtualFile file, MavenProjectProblem.ProblemType type) {
        return this.createProblem(file, ProjectBundle.message("maven.project.problem.syntaxError", file.getName()), type);
    }

    private MavenProjectProblem createProblem(VirtualFile file, String description, MavenProjectProblem.ProblemType type) {
        return new MavenProjectProblem(file, description, type);
    }

    private LinkedHashSet<MavenProjectProblem> createProblemsList() {
        return this.createProblemsList(Collections.<MavenProjectProblem>emptySet());
    }

    private LinkedHashSet<MavenProjectProblem> createProblemsList(Collection<MavenProjectProblem> copyThis) {
        return new LinkedHashSet<MavenProjectProblem>(copyThis);
    }

    public MavenProjectReaderResult resolveProject(MavenGeneralSettings generalSettings, MavenEmbedderWrapper embedder, VirtualFile file, Collection<String> explicitProfiles, MavenProjectReaderProjectLocator locator) throws MavenProcessCanceledException {
        MavenProject mavenProject = null;
        LinkedHashSet<MavenProjectProblem> problems = this.createProblemsList();
        Object unresolvedArtifactsIds = new THashSet();
        try {
            Pair<MavenProject, Set<MavenId>> result = this.doResolveProject(embedder, file, explicitProfiles, problems);
            mavenProject = (MavenProject)result.first;
            unresolvedArtifactsIds = (Set)result.second;
        }
        catch (MavenProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            String message = e.getMessage();
            if (e instanceof RuntimeException && e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            if (message != null) {
                problems.add(this.createStructureProblem(file, message));
            }
            MavenLog.LOG.info(e);
            MavenLog.printInTests(e);
        }
        if (mavenProject == null) {
            if (problems.isEmpty()) {
                problems.add(this.createSyntaxProblem(file, MavenProjectProblem.ProblemType.SYNTAX));
            }
            mavenProject = this.readProject((MavenGeneralSettings)generalSettings, (VirtualFile)file, explicitProfiles, (MavenProjectReaderProjectLocator)locator).nativeMavenProject;
        }
        return new MavenProjectReaderResult(generalSettings, problems, (Set<MavenId>)unresolvedArtifactsIds, embedder.getLocalRepositoryFile(), mavenProject, this.collectActivatedProfiles(mavenProject));
    }

    private Pair<MavenProject, Set<MavenId>> doResolveProject(MavenEmbedderWrapper embedder, VirtualFile file, Collection<String> profiles, Collection<MavenProjectProblem> problems) throws MavenProcessCanceledException {
        MavenExecutionResult result = embedder.resolveProject(file, profiles);
        this.validate(file, result, problems);
        return Pair.create((Object)result.getMavenProject(), result.getUnresolvedArtifactIds());
    }

    private boolean validate(VirtualFile file, MavenExecutionResult r, Collection<MavenProjectProblem> problems) {
        for (Exception each : r.getExceptions()) {
            MavenLog.LOG.info((Throwable)each);
            if (each instanceof InvalidProjectModelException) {
                ModelValidationResult modelValidationResult = ((InvalidProjectModelException)each).getValidationResult();
                if (modelValidationResult != null) {
                    for (Object eachValidationProblem : modelValidationResult.getMessages()) {
                        problems.add(this.createStructureProblem(file, (String)eachValidationProblem));
                    }
                    continue;
                }
                problems.add(this.createStructureProblem(file, each.getCause().getMessage()));
                continue;
            }
            if (each instanceof ProjectBuildingException) {
                String causeMessage = each.getCause() != null ? each.getCause().getMessage() : each.getMessage();
                problems.add(this.createStructureProblem(file, causeMessage));
                continue;
            }
            problems.add(this.createStructureProblem(file, each.getMessage()));
        }
        return problems.isEmpty();
    }

    public MavenProjectReaderResult generateSources(MavenEmbedderWrapper embedder, MavenGeneralSettings generalSettings, MavenImportingSettings importingSettings, VirtualFile file, Collection<String> profiles, MavenConsole console) throws MavenProcessCanceledException {
        try {
            LinkedHashSet<MavenProjectProblem> problems;
            MavenExecutionResult result = embedder.execute(file, profiles, Arrays.asList(importingSettings.getUpdateFoldersOnImportPhase()));
            if (result.hasExceptions()) {
                MavenConsoleHelper.printExecutionExceptions(console, result);
            }
            if (!this.validate(file, result, problems = this.createProblemsList())) {
                return null;
            }
            MavenProject project = result.getMavenProject();
            if (project == null) {
                return null;
            }
            return new MavenProjectReaderResult(generalSettings, problems, result.getUnresolvedArtifactIds(), embedder.getLocalRepositoryFile(), project, this.collectActivatedProfiles(project));
        }
        catch (MavenProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            MavenConsoleHelper.printException(console, e);
            MavenLog.LOG.warn(e);
            return null;
        }
    }

    private Collection<String> collectActivatedProfiles(MavenProject mavenProject) {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        while (mavenProject != null) {
            if (profiles != null) {
                profiles.addAll(mavenProject.getActiveProfiles());
            }
            mavenProject = mavenProject.getParent();
        }
        return MavenProjectReader.collectProfilesIds(profiles);
    }

    private static Collection<String> collectProfilesIds(List<Profile> profiles) {
        THashSet result = new THashSet();
        for (Profile each : profiles) {
            if (each.getId() == null) continue;
            result.add(each.getId());
        }
        return result;
    }

    private Element readXml(final VirtualFile file, final Collection<MavenProjectProblem> problems, final MavenProjectProblem.ProblemType type) {
        return MavenJDOMUtil.read(file, new MavenJDOMUtil.ErrorHandler(){

            @Override
            public void onReadError(IOException e) {
                MavenLog.LOG.warn("Cannot read the pom file: " + e);
                problems.add(MavenProjectReader.this.createProblem(file, e.getMessage(), type));
            }

            @Override
            public void onSyntaxError() {
                problems.add(MavenProjectReader.this.createSyntaxProblem(file, type));
            }
        });
    }

    private static class RawModelReadResult {
        public Model model;
        public Collection<MavenProjectProblem> problems;
        public Set<String> alwaysOnProfiles;

        private RawModelReadResult(Model model, Collection<MavenProjectProblem> problems, Set<String> alwaysOnProfiles) {
            this.model = model;
            this.problems = problems;
            this.alwaysOnProfiles = alwaysOnProfiles;
        }
    }
}

