/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenExtraArtifactType;
import org.jetbrains.idea.maven.importing.MavenModifiableModelsProvider;
import org.jetbrains.idea.maven.project.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.Path;
import org.jetbrains.idea.maven.utils.Url;

public class MavenRootModelAdapter {
    private static final String MAVEN_LIB_PREFIX = "Maven: ";
    private final MavenProject myMavenProject;
    private final ModifiableModuleModel myModuleModel;
    private final ModifiableRootModel myRootModel;

    public MavenRootModelAdapter(MavenProject p, Module module, MavenModifiableModelsProvider rootModelsProvider) {
        this.myMavenProject = p;
        this.myModuleModel = rootModelsProvider.getModuleModel();
        this.myRootModel = rootModelsProvider.getRootModel(module);
    }

    public void init(boolean isNewlyCreatedModule) {
        this.setupInitialValues(isNewlyCreatedModule);
        this.initContentRoots();
        this.initOrderEntries();
    }

    private void setupInitialValues(boolean newlyCreatedModule) {
        if (newlyCreatedModule || this.myRootModel.getSdk() == null) {
            this.myRootModel.inheritSdk();
        }
        if (newlyCreatedModule) {
            this.getCompilerExtension().setExcludeOutput(true);
        }
    }

    private void initContentRoots() {
        Url url = this.toUrl(this.myMavenProject.getDirectory());
        if (this.getContentRootFor(url) != null) {
            return;
        }
        this.myRootModel.addContentEntry(url.getUrl());
    }

    private ContentEntry getContentRootFor(Url url) {
        for (ContentEntry e : this.myRootModel.getContentEntries()) {
            if (!this.isEqualOrAncestor(e.getUrl(), url.getUrl())) continue;
            return e;
        }
        return null;
    }

    private void initOrderEntries() {
        for (OrderEntry e : this.myRootModel.getOrderEntries()) {
            Module m;
            if (e instanceof ModuleSourceOrderEntry || e instanceof JdkOrderEntry || e instanceof LibraryOrderEntry && !MavenRootModelAdapter.isMavenLibrary(((LibraryOrderEntry)e).getLibrary()) || e instanceof ModuleOrderEntry && (m = ((ModuleOrderEntry)e).getModule()) != null && !MavenProjectsManager.getInstance(this.myRootModel.getProject()).isMavenizedModule(m)) continue;
            this.myRootModel.removeOrderEntry(e);
        }
    }

    public ModifiableRootModel getRootModel() {
        return this.myRootModel;
    }

    public Module getModule() {
        return this.myRootModel.getModule();
    }

    public void addSourceFolder(String path, boolean testSource) {
        if (!this.exists(path)) {
            return;
        }
        Url url = this.toUrl(path);
        ContentEntry e = this.getContentRootFor(url);
        if (e == null) {
            return;
        }
        this.unregisterAll(path, false, true);
        e.addSourceFolder(url.getUrl(), testSource);
    }

    public boolean hasRegisteredSourceSubfolder(File f) {
        String url = this.toUrl(f.getPath()).getUrl();
        for (ContentEntry eachEntry : this.myRootModel.getContentEntries()) {
            for (SourceFolder eachFolder : eachEntry.getSourceFolders()) {
                if (!this.isEqualOrAncestor(url, eachFolder.getUrl())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAlreadyExcluded(File f) {
        String url = this.toUrl(f.getPath()).getUrl();
        for (ContentEntry eachEntry : this.myRootModel.getContentEntries()) {
            for (ExcludeFolder eachFolder : eachEntry.getExcludeFolders()) {
                if (!this.isEqualOrAncestor(eachFolder.getUrl(), url)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isEqualOrAncestor(String ancestor, String child) {
        return ancestor.equals(child) || StringUtil.startsWithConcatenationOf((String)child, (String)ancestor, (String)"/");
    }

    private boolean exists(String path) {
        return new File(this.toPath(path).getPath()).exists();
    }

    public void addExcludedFolder(String path) {
        this.unregisterAll(path, true, false);
        Url url = this.toUrl(path);
        ContentEntry e = this.getContentRootFor(url);
        if (e == null) {
            return;
        }
        e.addExcludeFolder(url.getUrl());
    }

    public void unregisterAll(String path, boolean under, boolean unregisterSources) {
        Url url = this.toUrl(path);
        for (ContentEntry eachEntry : this.myRootModel.getContentEntries()) {
            String child;
            String ancestor;
            if (unregisterSources) {
                for (SourceFolder sourceFolder : eachEntry.getSourceFolders()) {
                    ancestor = under ? url.getUrl() : sourceFolder.getUrl();
                    String string = child = under ? sourceFolder.getUrl() : url.getUrl();
                    if (!this.isEqualOrAncestor(ancestor, child)) continue;
                    eachEntry.removeSourceFolder(sourceFolder);
                }
            }
            for (SourceFolder sourceFolder : eachEntry.getExcludeFolders()) {
                ancestor = under ? url.getUrl() : sourceFolder.getUrl();
                String string = child = under ? sourceFolder.getUrl() : url.getUrl();
                if (!this.isEqualOrAncestor(ancestor, child)) continue;
                if (sourceFolder.isSynthetic()) {
                    this.getCompilerExtension().setExcludeOutput(false);
                    continue;
                }
                eachEntry.removeExcludeFolder((ExcludeFolder)sourceFolder);
            }
        }
    }

    public void useModuleOutput(String production, String test) {
        this.getCompilerExtension().inheritCompilerOutputPath(false);
        this.getCompilerExtension().setCompilerOutputPath(this.toUrl(production).getUrl());
        this.getCompilerExtension().setCompilerOutputPathForTests(this.toUrl(test).getUrl());
    }

    private CompilerModuleExtension getCompilerExtension() {
        return (CompilerModuleExtension)this.myRootModel.getModuleExtension(CompilerModuleExtension.class);
    }

    private Url toUrl(String path) {
        return this.toPath(path).toUrl();
    }

    private Path toPath(String path) {
        if (!FileUtil.isAbsolute((String)path)) {
            path = new File(this.myMavenProject.getDirectory(), path).getPath();
        }
        return new Path(path);
    }

    public void addModuleDependency(String moduleName, DependencyScope scope) {
        Module m = this.findModuleByName(moduleName);
        ModuleOrderEntry e = m != null ? this.myRootModel.addModuleOrderEntry(m) : this.myRootModel.addInvalidModuleEntry(moduleName);
        e.setScope(scope);
    }

    @Nullable
    private Module findModuleByName(String moduleName) {
        return this.myModuleModel.findModuleByName(moduleName);
    }

    public void addLibraryDependency(MavenArtifact artifact, DependencyScope scope, MavenModifiableModelsProvider provider, MavenProject project) {
        String libraryName = MavenRootModelAdapter.makeLibraryName(artifact);
        Library library = provider.getLibraryByName(libraryName);
        if (library == null) {
            library = provider.createLibrary(libraryName);
        }
        Library.ModifiableModel libraryModel = provider.getLibraryModel(library);
        this.updateUrl(libraryModel, OrderRootType.CLASSES, artifact, null, null, true);
        if (!"system".equals(artifact.getScope())) {
            this.updateUrl(libraryModel, OrderRootType.SOURCES, artifact, MavenExtraArtifactType.SOURCES, project, false);
            this.updateUrl(libraryModel, JavadocOrderRootType.getInstance(), artifact, MavenExtraArtifactType.DOCS, project, false);
        }
        LibraryOrderEntry e = this.myRootModel.addLibraryEntry(library);
        e.setScope(scope);
    }

    private void updateUrl(Library.ModifiableModel library, OrderRootType type, MavenArtifact artifact, MavenExtraArtifactType artifactType, MavenProject project, boolean clearAll) {
        String classifier = null;
        String extension = null;
        if (artifactType != null) {
            Pair<String, String> result = project.getClassifierAndExtension(artifact, artifactType);
            classifier = (String)result.first;
            extension = (String)result.second;
        }
        String newUrl = artifact.getUrlForExtraArtifact(classifier, extension);
        for (String url : library.getUrls(type)) {
            if (newUrl.equals(url)) {
                return;
            }
            if (!clearAll && !this.isRepositoryUrl(artifact, url, classifier, extension)) continue;
            library.removeRoot(url, type);
        }
        library.addRoot(newUrl, type);
    }

    private boolean isRepositoryUrl(MavenArtifact artifact, String url, String classifier, String extension) {
        return url.endsWith(artifact.getRelativePathForExtraArtifact(classifier, extension) + "!/");
    }

    public static boolean isChangedByUser(Library library) {
        String[] classRoots = library.getUrls(OrderRootType.CLASSES);
        if (classRoots.length != 1) {
            return true;
        }
        String classes = classRoots[0];
        if (!classes.endsWith("!/")) {
            return true;
        }
        int dotPos = classes.lastIndexOf("/", classes.length() - 2);
        if (dotPos == -1) {
            return true;
        }
        String pathToJar = classes.substring(0, dotPos);
        if (MavenRootModelAdapter.hasUserPaths(OrderRootType.SOURCES, library, pathToJar)) {
            return true;
        }
        return MavenRootModelAdapter.hasUserPaths(JavadocOrderRootType.getInstance(), library, pathToJar);
    }

    private static boolean hasUserPaths(OrderRootType rootType, Library library, String pathToJar) {
        String[] sources;
        for (String each : sources = library.getUrls(rootType)) {
            if (FileUtil.startsWith((String)each, (String)pathToJar)) continue;
            return true;
        }
        return false;
    }

    public Library findLibrary(final MavenArtifact artifact) {
        return (Library)this.myRootModel.processOrder((RootPolicy)new RootPolicy<Library>(){

            public Library visitLibraryOrderEntry(LibraryOrderEntry e, Library result) {
                String name = MavenRootModelAdapter.makeLibraryName(artifact);
                return name.equals(e.getLibraryName()) ? e.getLibrary() : result;
            }
        }, null);
    }

    private static String makeLibraryName(MavenArtifact artifact) {
        return MAVEN_LIB_PREFIX + artifact.getDisplayStringForLibraryName();
    }

    public static boolean isMavenLibrary(Library library) {
        if (library == null) {
            return false;
        }
        String name = library.getName();
        return name != null && name.startsWith(MAVEN_LIB_PREFIX);
    }

    @Nullable
    public static OrderEntry findLibraryEntry(Module m, MavenArtifact artifact) {
        String name = MavenRootModelAdapter.makeLibraryName(artifact);
        for (OrderEntry each : ModuleRootManager.getInstance((Module)m).getOrderEntries()) {
            if (!(each instanceof LibraryOrderEntry) || !name.equals(((LibraryOrderEntry)each).getLibraryName())) continue;
            return each;
        }
        return null;
    }

    @Nullable
    public static MavenArtifact findArtifact(MavenProject project, Library library) {
        String name = library.getName();
        for (MavenArtifact each : project.getDependencies()) {
            if (!MavenRootModelAdapter.makeLibraryName(each).equals(name)) continue;
            return each;
        }
        return null;
    }

    public void setLanguageLevel(LanguageLevel level) {
        try {
            ((LanguageLevelModuleExtension)this.myRootModel.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(level);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

