/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.compiler.impl.javaCompiler.javac.JavacSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.Stack;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.idea.maven.embedder.MavenConsole;
import org.jetbrains.idea.maven.importing.MavenModifiableModelsProvider;
import org.jetbrains.idea.maven.importing.MavenModuleImporter;
import org.jetbrains.idea.maven.importing.MavenModuleNameMapper;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.project.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenProjectImporter {
    private final Project myProject;
    private final MavenProjectsTree myProjectsTree;
    private final Map<VirtualFile, Module> myFileToModuleMapping;
    private volatile Map<MavenProject, MavenProjectChanges> myProjectsToImportWithChanges;
    private volatile Set<MavenProject> myAllProjects;
    private final boolean myImportModuleGroupsRequired;
    private final MavenModifiableModelsProvider myModelsProvider;
    private final MavenImportingSettings myImportingSettings;
    private final ModifiableModuleModel myModuleModel;
    private final List<Module> myCreatedModules = new ArrayList<Module>();
    private final Map<MavenProject, Module> myMavenProjectToModule = new THashMap();
    private final Map<MavenProject, String> myMavenProjectToModuleName = new THashMap();
    private final Map<MavenProject, String> myMavenProjectToModulePath = new THashMap();

    public MavenProjectImporter(Project p, MavenProjectsTree projectsTree, Map<VirtualFile, Module> fileToModuleMapping, Map<MavenProject, MavenProjectChanges> projectsToImportWithChanges, boolean importModuleGroupsRequired, MavenModifiableModelsProvider modelsProvider, MavenImportingSettings importingSettings) {
        this.myProject = p;
        this.myProjectsTree = projectsTree;
        this.myFileToModuleMapping = fileToModuleMapping;
        this.myProjectsToImportWithChanges = projectsToImportWithChanges;
        this.myImportModuleGroupsRequired = importModuleGroupsRequired;
        this.myModelsProvider = modelsProvider;
        this.myImportingSettings = importingSettings;
        this.myModuleModel = modelsProvider.getModuleModel();
    }

    public List<MavenProjectsProcessorTask> importProject() {
        boolean modulesDeleted;
        ArrayList<MavenProjectsProcessorTask> postTasks = new ArrayList<MavenProjectsProcessorTask>();
        boolean hasChanges = false;
        this.myAllProjects = new LinkedHashSet<MavenProject>(this.myProjectsTree.getProjects());
        this.myAllProjects.addAll(this.myProjectsToImportWithChanges.keySet());
        hasChanges |= this.deleteIncompatibleModules();
        this.myProjectsToImportWithChanges = this.collectProjectsToImport(this.myProjectsToImportWithChanges);
        this.mapMavenProjectsToModulesAndNames();
        boolean projectsHaveChanges = this.projectsToImportHaveChanges();
        if (projectsHaveChanges) {
            hasChanges = true;
            this.importModules(postTasks);
            this.scheduleRefreshResolvedArtifacts(postTasks);
            this.configSettings();
        }
        if (projectsHaveChanges || this.myImportModuleGroupsRequired) {
            hasChanges = true;
            this.configModuleGroups();
        }
        if (hasChanges |= (modulesDeleted = this.deleteObsoleteModules())) {
            this.removeUnusedProjectLibraries();
        }
        if (hasChanges) {
            this.myModelsProvider.commit();
        } else {
            this.myModelsProvider.dispose();
        }
        return postTasks;
    }

    private boolean projectsToImportHaveChanges() {
        for (MavenProjectChanges each : this.myProjectsToImportWithChanges.values()) {
            if (!each.hasChanges()) continue;
            return true;
        }
        return false;
    }

    private Map<MavenProject, MavenProjectChanges> collectProjectsToImport(Map<MavenProject, MavenProjectChanges> projectsToImport) {
        THashMap result = new THashMap(projectsToImport);
        result.putAll(this.collectNewlyCreatedProjects());
        Set<MavenProject> allProjectsToImport = result.keySet();
        Set<MavenProject> selectedProjectsToImport = this.selectProjectsToImport(allProjectsToImport);
        Iterator<MavenProject> it = allProjectsToImport.iterator();
        while (it.hasNext()) {
            if (selectedProjectsToImport.contains(it.next())) continue;
            it.remove();
        }
        return result;
    }

    private Map<MavenProject, MavenProjectChanges> collectNewlyCreatedProjects() {
        THashMap result = new THashMap();
        for (MavenProject each : this.myAllProjects) {
            Module module = this.myFileToModuleMapping.get(each.getFile());
            if (module != null) continue;
            result.put(each, MavenProjectChanges.ALL);
        }
        return result;
    }

    private Set<MavenProject> selectProjectsToImport(Collection<MavenProject> originalProjects) {
        THashSet result = new THashSet();
        for (MavenProject each : originalProjects) {
            if (!this.shouldCreateModuleFor(each)) continue;
            result.add(each);
        }
        return result;
    }

    private boolean shouldCreateModuleFor(MavenProject project) {
        if (this.myProjectsTree.isIgnored(project)) {
            return false;
        }
        return !project.isAggregator() || this.myImportingSettings.isCreateModulesForAggregators();
    }

    private boolean deleteIncompatibleModules() {
        final List incompatible = this.collectIncompatibleModulesWithProjects();
        if (incompatible.isEmpty()) {
            return false;
        }
        final int[] result = new int[1];
        MavenUtil.invokeAndWait(this.myProject, this.myModelsProvider.getModalityStateForQuestionDialogs(), new Runnable(){

            @Override
            public void run() {
                String message = ProjectBundle.message("maven.import.incompatible.modules", MavenProjectImporter.formatProjectsWithModules(incompatible), incompatible.size() == 1 ? "" : "s");
                String[] options = new String[]{ProjectBundle.message("maven.import.incompatible.modules.recreate", new Object[0]), ProjectBundle.message("maven.import.incompatible.modules.ignore", new Object[0])};
                result[0] = Messages.showDialog((Project)MavenProjectImporter.this.myProject, (String)message, (String)ProjectBundle.message("maven.tab.importing", new Object[0]), (String[])options, (int)0, (Icon)Messages.getQuestionIcon());
            }
        });
        if (result[0] == 0) {
            for (Pair<MavenProject, Module> pair : incompatible) {
                this.myFileToModuleMapping.remove(((MavenProject)pair.first).getFile());
                this.myModuleModel.disposeModule((Module)pair.second);
            }
            return true;
        }
        this.myProjectsTree.setIgnoredState(MavenUtil.collectFirsts(incompatible), true, this);
        return false;
    }

    private List<Pair<MavenProject, Module>> collectIncompatibleModulesWithProjects() {
        ArrayList<Pair<MavenProject, Module>> incompatible = new ArrayList<Pair<MavenProject, Module>>();
        for (MavenProject each : this.myAllProjects) {
            Module module = this.myFileToModuleMapping.get(each.getFile());
            if (module == null || !this.shouldCreateModuleFor(each) || module.getModuleType() instanceof JavaModuleType) continue;
            incompatible.add((Pair<MavenProject, Module>)Pair.create((Object)each, (Object)module));
        }
        return incompatible;
    }

    private static String formatProjectsWithModules(List<Pair<MavenProject, Module>> projectsWithModules) {
        return StringUtil.join(projectsWithModules, (Function)new Function<Pair<MavenProject, Module>, String>(){

            public String fun(Pair<MavenProject, Module> each) {
                MavenProject project = (MavenProject)each.first;
                Module module = (Module)each.second;
                return module.getModuleType().getName() + " '" + module.getName() + "' for Maven project '" + project.getMavenId().getDisplayString() + "'";
            }
        }, (String)"<br>");
    }

    private boolean deleteObsoleteModules() {
        final List<Module> obsoleteModules = this.collectObsoleteModules();
        if (obsoleteModules.isEmpty()) {
            return false;
        }
        this.setMavenizedModules(obsoleteModules, false);
        final int[] result = new int[1];
        MavenUtil.invokeAndWait(this.myProject, this.myModelsProvider.getModalityStateForQuestionDialogs(), new Runnable(){

            @Override
            public void run() {
                result[0] = Messages.showYesNoDialog((Project)MavenProjectImporter.this.myProject, (String)ProjectBundle.message("maven.import.message.delete.obsolete", MavenProjectImporter.formatModules(obsoleteModules)), (String)ProjectBundle.message("maven.tab.importing", new Object[0]), (Icon)Messages.getQuestionIcon());
            }
        });
        if (result[0] == 1) {
            return false;
        }
        for (Module each : obsoleteModules) {
            this.myModuleModel.disposeModule(each);
        }
        return true;
    }

    private List<Module> collectObsoleteModules() {
        ArrayList remainingModules = new ArrayList();
        Collections.addAll(remainingModules, this.myModuleModel.getModules());
        for (MavenProject each : this.selectProjectsToImport(this.myAllProjects)) {
            remainingModules.remove(this.myMavenProjectToModule.get(each));
        }
        ArrayList<Module> obsolete = new ArrayList<Module>();
        for (Module each : remainingModules) {
            if (!MavenProjectsManager.getInstance(this.myProject).isMavenizedModule(each)) continue;
            obsolete.add(each);
        }
        return obsolete;
    }

    private static String formatModules(Collection<Module> modules) {
        return StringUtil.join(modules, (Function)new Function<Module, String>(){

            public String fun(Module m) {
                return "'" + m.getName() + "'";
            }
        }, (String)"\n");
    }

    private void scheduleRefreshResolvedArtifacts(List<MavenProjectsProcessorTask> postTasks) {
        ArrayList<MavenArtifact> artifacts = new ArrayList<MavenArtifact>();
        for (MavenProject each : this.myProjectsToImportWithChanges.keySet()) {
            artifacts.addAll(each.getDependencies());
        }
        THashSet files = new THashSet();
        for (MavenArtifact each : artifacts) {
            if (!each.isResolved()) continue;
            files.add(each.getFile());
        }
        final Runnable r = new Runnable((Set)files){
            final /* synthetic */ Set val$files;
            {
                this.val$files = set;
            }

            @Override
            public void run() {
                LocalFileSystem.getInstance().refreshIoFiles((Iterable)this.val$files);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            r.run();
        } else {
            postTasks.add(new MavenProjectsProcessorTask(){

                @Override
                public void perform(Project project, MavenEmbeddersManager embeddersManager, MavenConsole console, MavenProgressIndicator indicator) throws MavenProcessCanceledException {
                    indicator.setText("Refreshing files...");
                    r.run();
                }
            });
        }
    }

    private void mapMavenProjectsToModulesAndNames() {
        for (MavenProject each : this.myAllProjects) {
            Module module = this.myFileToModuleMapping.get(each.getFile());
            if (module == null) continue;
            this.myMavenProjectToModule.put(each, module);
        }
        MavenModuleNameMapper.map(this.myAllProjects, this.myMavenProjectToModule, this.myMavenProjectToModuleName, this.myMavenProjectToModulePath, this.myImportingSettings.getDedicatedModuleDir());
    }

    private void configSettings() {
        MavenUtil.invokeAndWaitWriteAction(this.myProject, new Runnable(){

            @Override
            public void run() {
                String level = MavenProjectImporter.this.calcTargetLevel();
                if (level == null) {
                    return;
                }
                String options = JavacSettings.getInstance((Project)((MavenProjectImporter)MavenProjectImporter.this).myProject).ADDITIONAL_OPTIONS_STRING;
                Pattern pattern = Pattern.compile("(-target (\\S+))");
                Matcher matcher = pattern.matcher(options);
                if (matcher.find()) {
                    String currentValue = MavenProject.normalizeCompilerLevel(matcher.group(2));
                    if (currentValue == null || MavenProjectImporter.this.compareCompilerLevel(level, currentValue) < 0) {
                        StringBuffer buffer = new StringBuffer();
                        matcher.appendReplacement(buffer, "-target " + level);
                        matcher.appendTail(buffer);
                        options = buffer.toString();
                    }
                } else {
                    if (!StringUtil.isEmptyOrSpaces((String)options)) {
                        options = options + " ";
                    }
                    options = options + "-target " + level;
                }
                JavacSettings.getInstance((Project)((MavenProjectImporter)MavenProjectImporter.this).myProject).ADDITIONAL_OPTIONS_STRING = options;
            }
        });
    }

    private String calcTargetLevel() {
        String maxSource = null;
        String minTarget = null;
        for (MavenProject each : this.myAllProjects) {
            String source = each.getSourceLevel();
            String target = each.getTargetLevel();
            if (source != null && (maxSource == null || this.compareCompilerLevel(maxSource, source) < 0)) {
                maxSource = source;
            }
            if (target == null || minTarget != null && this.compareCompilerLevel(minTarget, target) <= 0) continue;
            minTarget = target;
        }
        return maxSource != null && this.compareCompilerLevel(minTarget, maxSource) < 0 ? maxSource : minTarget;
    }

    private int compareCompilerLevel(String left, String right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        return left.compareTo(right);
    }

    private void importModules(List<MavenProjectsProcessorTask> postTasks) {
        Map<MavenProject, MavenProjectChanges> projectsWithChanges = this.myProjectsToImportWithChanges;
        Set<MavenProject> projects = projectsWithChanges.keySet();
        THashSet projectsWithNewlyCreatedModules = new THashSet();
        for (MavenProject each : projects) {
            if (!this.ensureModuleCreated(each)) continue;
            projectsWithNewlyCreatedModules.add(each);
        }
        THashMap moduleImporters = new THashMap();
        for (Map.Entry<MavenProject, MavenProjectChanges> entry : projectsWithChanges.entrySet()) {
            MavenProject project = entry.getKey();
            Module module = this.myMavenProjectToModule.get(project);
            boolean isNewModule = projectsWithNewlyCreatedModules.contains(project);
            MavenModuleImporter moduleImporter = this.createModuleImporter(module, (Pair<MavenProject, MavenProjectChanges>)Pair.create((Object)project, (Object)entry.getValue()));
            moduleImporters.put(module, moduleImporter);
            moduleImporter.config(isNewModule);
        }
        for (MavenProject mavenProject : projects) {
            ((MavenModuleImporter)moduleImporters.get(this.myMavenProjectToModule.get(mavenProject))).preConfigFacets();
        }
        for (MavenProject mavenProject : projects) {
            ((MavenModuleImporter)moduleImporters.get(this.myMavenProjectToModule.get(mavenProject))).configFacets(postTasks);
        }
        this.setMavenizedModules(moduleImporters.keySet(), true);
    }

    private void setMavenizedModules(final Collection<Module> modules, final boolean mavenized) {
        MavenUtil.invokeAndWaitWriteAction(this.myProject, new Runnable(){

            @Override
            public void run() {
                MavenProjectsManager.getInstance(MavenProjectImporter.this.myProject).setMavenizedModules(modules, mavenized);
            }
        });
    }

    private boolean ensureModuleCreated(MavenProject project) {
        if (this.myMavenProjectToModule.get(project) != null) {
            return false;
        }
        String path = this.myMavenProjectToModulePath.get(project);
        this.deleteExistingImlFile(path);
        Module module = this.myModuleModel.newModule(path, StdModuleTypes.JAVA);
        this.myMavenProjectToModule.put(project, module);
        this.myCreatedModules.add(module);
        return true;
    }

    private void deleteExistingImlFile(final String path) {
        MavenUtil.invokeAndWaitWriteAction(this.myProject, new Runnable(){

            @Override
            public void run() {
                try {
                    VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
                    if (file != null) {
                        file.delete((Object)this);
                    }
                }
                catch (IOException e) {
                    MavenLog.LOG.warn("Cannot delete existing iml file: " + path, (Throwable)e);
                }
            }
        });
    }

    private MavenModuleImporter createModuleImporter(Module module, Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
        return new MavenModuleImporter(module, this.myProjectsTree, projectWithChanges, this.myMavenProjectToModuleName, this.myImportingSettings, this.myModelsProvider);
    }

    private void configModuleGroups() {
        if (!this.myImportingSettings.isCreateModuleGroups()) {
            return;
        }
        final Stack groups = new Stack();
        final boolean createTopLevelGroup = this.myProjectsTree.getRootProjects().size() > 1;
        this.myProjectsTree.visit(new MavenProjectsTree.SimpleVisitor(){
            int depth = 0;

            @Override
            public boolean shouldVisit(MavenProject project) {
                return MavenProjectImporter.this.myMavenProjectToModuleName.containsKey(project);
            }

            @Override
            public void visit(MavenProject each) {
                ++this.depth;
                String name = (String)MavenProjectImporter.this.myMavenProjectToModuleName.get(each);
                if (this.shouldCreateGroup(each)) {
                    groups.push((Object)ProjectBundle.message("module.group.name", name));
                }
                if (!MavenProjectImporter.this.shouldCreateModuleFor(each)) {
                    return;
                }
                Module module = MavenProjectImporter.this.myModuleModel.findModuleByName(name);
                if (module == null) {
                    return;
                }
                MavenProjectImporter.this.myModuleModel.setModuleGroupPath(module, groups.isEmpty() ? null : ArrayUtil.toStringArray((Collection)groups));
            }

            @Override
            public void leave(MavenProject each) {
                if (this.shouldCreateGroup(each)) {
                    groups.pop();
                }
                --this.depth;
            }

            private boolean shouldCreateGroup(MavenProject project) {
                return !MavenProjectImporter.this.myProjectsTree.getModules(project).isEmpty() && (createTopLevelGroup || this.depth > 1);
            }
        });
    }

    private boolean removeUnusedProjectLibraries() {
        THashSet allLibraries = new THashSet();
        Collections.addAll(allLibraries, this.myModelsProvider.getAllLibraries());
        THashSet usedLibraries = new THashSet();
        for (ModuleRootModel eachModel : this.collectModuleModels()) {
            for (OrderEntry eachEntry : eachModel.getOrderEntries()) {
                Library lib;
                if (!(eachEntry instanceof LibraryOrderEntry) || !MavenRootModelAdapter.isMavenLibrary(lib = ((LibraryOrderEntry)eachEntry).getLibrary())) continue;
                usedLibraries.add(lib);
            }
        }
        THashSet unusedLibraries = new THashSet((Collection)allLibraries);
        unusedLibraries.removeAll((Collection<?>)usedLibraries);
        boolean removed = false;
        for (Library each : unusedLibraries) {
            if (!MavenRootModelAdapter.isMavenLibrary(each) || MavenRootModelAdapter.isChangedByUser(each)) continue;
            this.myModelsProvider.removeLibrary(each);
            removed = true;
        }
        return removed;
    }

    private Collection<ModuleRootModel> collectModuleModels() {
        THashMap rootModels = new THashMap();
        for (MavenProject each : this.myProjectsToImportWithChanges.keySet()) {
            Module module = this.myMavenProjectToModule.get(each);
            ModifiableRootModel rootModel = this.myModelsProvider.getRootModel(module);
            rootModels.put(module, rootModel);
        }
        for (Module each : this.myModuleModel.getModules()) {
            if (rootModels.containsKey(each)) continue;
            rootModels.put(each, this.myModelsProvider.getRootModel(each));
        }
        return rootModels.values();
    }

    public List<Module> getCreatedModules() {
        return this.myCreatedModules;
    }
}

