/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.embedder.MavenConsoleImpl;
import org.jetbrains.idea.maven.execution.MavenExternalParameters;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationSettings;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenRunConfiguration
extends RunConfigurationBase
implements LocatableConfiguration,
ModuleRunProfile {
    private MavenSettings mySettings;

    protected MavenRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
        this.mySettings = new MavenSettings(project);
    }

    public RunConfiguration clone() {
        MavenRunConfiguration clone = (MavenRunConfiguration)super.clone();
        clone.mySettings = this.mySettings.clone();
        return clone;
    }

    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new MavenRunConfigurationSettings(this.getProject());
    }

    public JDOMExternalizable createRunnerSettings(ConfigurationInfoProvider provider) {
        return null;
    }

    public SettingsEditor<JDOMExternalizable> getRunnerSettingsEditor(ProgramRunner runner) {
        return null;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/execution/MavenRunConfiguration.getState must not be null");
        }
        if (env == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/execution/MavenRunConfiguration.getState must not be null");
        }
        JavaCommandLineState state = new JavaCommandLineState(env){

            protected JavaParameters createJavaParameters() throws ExecutionException {
                return MavenExternalParameters.createJavaParameters(((MavenRunConfiguration)MavenRunConfiguration.this).mySettings.myRunnerParameters, ((MavenRunConfiguration)MavenRunConfiguration.this).mySettings.myGeneralSettings, ((MavenRunConfiguration)MavenRunConfiguration.this).mySettings.myRunnerSettings);
            }

            protected OSProcessHandler startProcess() throws ExecutionException {
                OSProcessHandler result = super.startProcess();
                result.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void processTerminated(ProcessEvent event) {
                        MavenRunConfiguration.this.updateProjectsFolders();
                    }
                });
                return result;
            }
        };
        state.setConsoleBuilder(MavenConsoleImpl.createConsoleBuilder(this.getProject()));
        return state;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        String filePath = this.mySettings.myRunnerParameters.getPomFilePath();
        if (filePath == null || !new File(filePath).isFile()) {
            throw new RuntimeConfigurationError(RunnerBundle.message("maven.run.configuration.error.file.not.found", new Object[0]));
        }
    }

    private void updateProjectsFolders() {
        MavenProjectsManager.getInstance(this.getProject()).updateProjectTargetFolders();
    }

    @NotNull
    public Module[] getModules() {
        if (Module.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/execution/MavenRunConfiguration.getModules must not return null");
        }
        return Module.EMPTY_ARRAY;
    }

    public MavenGeneralSettings getGeneralSettings() {
        return this.mySettings.myGeneralSettings;
    }

    public void setGeneralSettings(MavenGeneralSettings settings) {
        this.mySettings.myGeneralSettings = settings;
    }

    public MavenRunnerSettings getRunnerSettings() {
        return this.mySettings.myRunnerSettings;
    }

    public void setRunnerSettings(MavenRunnerSettings settings) {
        this.mySettings.myRunnerSettings = settings;
    }

    public MavenRunnerParameters getRunnerParameters() {
        return this.mySettings.myRunnerParameters;
    }

    public void setRunnerParameters(MavenRunnerParameters p) {
        this.mySettings.myRunnerParameters = p;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        Element mavenSettingsElement = element.getChild("MavenSettings");
        if (mavenSettingsElement != null) {
            File workingDir;
            this.mySettings = (MavenSettings)XmlSerializer.deserialize((Element)mavenSettingsElement, MavenSettings.class);
            if (this.mySettings == null) {
                this.mySettings = new MavenSettings();
            }
            if (this.mySettings.myGeneralSettings == null) {
                this.mySettings.myGeneralSettings = new MavenGeneralSettings();
            }
            if (this.mySettings.myRunnerSettings == null) {
                this.mySettings.myRunnerSettings = new MavenRunnerSettings();
            }
            if (this.mySettings.myRunnerParameters == null) {
                this.mySettings.myRunnerParameters = new MavenRunnerParameters();
            }
            if ("pom.xml".equals((workingDir = this.mySettings.myRunnerParameters.getWorkingDirFile()).getName())) {
                this.mySettings.myRunnerParameters.setWorkingDirPath(workingDir.getParent());
            }
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        element.addContent(XmlSerializer.serialize((Object)this.mySettings));
    }

    public boolean isGeneratedName() {
        return Comparing.equal((String)this.getName(), (String)this.getGeneratedName());
    }

    public String suggestedName() {
        return this.getGeneratedName();
    }

    private String getGeneratedName() {
        return MavenRunConfigurationType.generateName(this.getProject(), this.mySettings.myRunnerParameters);
    }

    public static class MavenSettings
    implements Cloneable {
        public static final String TAG = "MavenSettings";
        public MavenGeneralSettings myGeneralSettings;
        public MavenRunnerSettings myRunnerSettings;
        public MavenRunnerParameters myRunnerParameters;

        public MavenSettings() {
        }

        public MavenSettings(Project project) {
            this(MavenProjectsManager.getInstance(project).getGeneralSettings(), MavenRunner.getInstance(project).getState(), new MavenRunnerParameters());
        }

        private MavenSettings(MavenGeneralSettings cs, MavenRunnerSettings rs, MavenRunnerParameters rp) {
            this.myGeneralSettings = cs.clone();
            this.myRunnerSettings = rs.clone();
            this.myRunnerParameters = rp.clone();
        }

        protected MavenSettings clone() {
            return new MavenSettings(this.myGeneralSettings, this.myRunnerSettings, this.myRunnerParameters);
        }
    }
}

