/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.embedder;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import gnu.trove.THashSet;
import hidden.edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.maven.Maven;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.manager.DefaultWagonManager;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.DefaultArtifactResolver;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.extension.ExtensionManager;
import org.apache.maven.model.Build;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Repository;
import org.apache.maven.monitor.event.DefaultEventDispatcher;
import org.apache.maven.monitor.event.DefaultEventMonitor;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.monitor.event.EventMonitor;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.project.DefaultProjectBuilderConfiguration;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ModelUtils;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectUtils;
import org.apache.maven.project.artifact.ProjectArtifactFactory;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.interpolation.ModelInterpolator;
import org.apache.maven.project.path.DefaultPathTranslator;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.events.TransferListener;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.embedder.CustomArtifactFactory;
import org.jetbrains.idea.maven.embedder.CustomArtifactResolver;
import org.jetbrains.idea.maven.embedder.CustomModelInterpolator;
import org.jetbrains.idea.maven.embedder.CustomWagonManager;
import org.jetbrains.idea.maven.embedder.FieldAccessor;
import org.jetbrains.idea.maven.embedder.MavenConsole;
import org.jetbrains.idea.maven.embedder.MavenEmbedderFactory;
import org.jetbrains.idea.maven.embedder.MavenExecutionOptions;
import org.jetbrains.idea.maven.embedder.MavenExecutionResult;
import org.jetbrains.idea.maven.embedder.MavenLogger;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenId;
import org.jetbrains.idea.maven.project.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenRemoteRepository;
import org.jetbrains.idea.maven.project.TransferListenerAdapter;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public class MavenEmbedderWrapper {
    private final DefaultPlexusContainer myContainer;
    private final Settings mySettings;
    private final MavenLogger myLogger;
    private final ArtifactRepository myLocalRepository;
    private volatile MavenProgressIndicator myCurrentIndicator;

    public MavenEmbedderWrapper(@NotNull DefaultPlexusContainer container, @NotNull Settings settings, @NotNull MavenLogger logger, @NotNull MavenGeneralSettings generalSettings) {
        if (container == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/embedder/MavenEmbedderWrapper.<init> must not be null");
        }
        if (settings == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/embedder/MavenEmbedderWrapper.<init> must not be null");
        }
        if (logger == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/idea/maven/embedder/MavenEmbedderWrapper.<init> must not be null");
        }
        if (generalSettings == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/jetbrains/idea/maven/embedder/MavenEmbedderWrapper.<init> must not be null");
        }
        this.myContainer = container;
        this.mySettings = settings;
        this.myLogger = logger;
        this.myLocalRepository = this.createLocalRepository(generalSettings);
        this.configureContainer();
        this.loadSettings();
    }

    private void loadSettings() {
        DefaultWagonManager wagonManager = (DefaultWagonManager)this.getComponent(WagonManager.class);
        wagonManager.setHttpUserAgent("Apache-Maven/2.2");
        Proxy proxy = this.mySettings.getActiveProxy();
        if (proxy != null && proxy.getHost() != null) {
            String pass = this.decrypt(proxy.getPassword());
            wagonManager.addProxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), proxy.getUsername(), pass, proxy.getNonProxyHosts());
        }
        Iterator i$ = this.mySettings.getServers().iterator();
        while (i$.hasNext()) {
            Server each;
            Server server = each = (Server)i$.next();
            String passWord = this.decrypt(server.getPassword());
            String passPhrase = this.decrypt(server.getPassphrase());
            wagonManager.addAuthenticationInfo(server.getId(), server.getUsername(), passWord, server.getPrivateKey(), passPhrase);
            wagonManager.addPermissionInfo(server.getId(), server.getFilePermissions(), server.getDirectoryPermissions());
            if (server.getConfiguration() == null) continue;
            wagonManager.addConfiguration(server.getId(), (Xpp3Dom)server.getConfiguration());
        }
        for (Server each : this.mySettings.getMirrors()) {
            Mirror mirror = (Mirror)each;
            wagonManager.addMirror(mirror.getId(), mirror.getMirrorOf(), mirror.getUrl());
        }
    }

    private String decrypt(String pass) {
        try {
            pass = this.getComponent(SecDispatcher.class, "maven").decrypt(pass);
        }
        catch (SecDispatcherException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
        return pass;
    }

    private ArtifactRepository createLocalRepository(MavenGeneralSettings generalSettings) {
        ArtifactRepositoryLayout layout = this.getComponent(ArtifactRepositoryLayout.class, "default");
        ArtifactRepositoryFactory factory = this.getComponent(ArtifactRepositoryFactory.class);
        String url = this.mySettings.getLocalRepository();
        if (!url.startsWith("file:")) {
            url = "file://" + url;
        }
        DefaultArtifactRepository localRepository = new DefaultArtifactRepository("local", url, layout);
        boolean snapshotPolicySet = this.mySettings.isOffline();
        if (!snapshotPolicySet && generalSettings.getSnapshotUpdatePolicy() == MavenExecutionOptions.SnapshotUpdatePolicy.ALWAYS_UPDATE) {
            factory.setGlobalUpdatePolicy("always");
        }
        factory.setGlobalChecksumPolicy("warn");
        return localRepository;
    }

    public MavenExecutionResult resolveProject(final @NotNull VirtualFile file, final @NotNull Collection<String> activeProfiles) throws MavenProcessCanceledException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/embedder/MavenEmbedderWrapper.resolveProject must not be null");
        }
        if (activeProfiles == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/embedder/MavenEmbedderWrapper.resolveProject must not be null");
        }
        return this.doExecute(new Executor<MavenExecutionResult>(){

            @Override
            public MavenExecutionResult execute() throws Exception {
                MavenExecutionRequest request = MavenEmbedderWrapper.this.createRequest(file, activeProfiles, Collections.EMPTY_LIST);
                ProjectBuilderConfiguration config = request.getProjectBuilderConfiguration();
                request.getGlobalProfileManager().loadSettingsProfiles(MavenEmbedderWrapper.this.mySettings);
                ProfileManager globalProfileManager = request.getGlobalProfileManager();
                globalProfileManager.loadSettingsProfiles(request.getSettings());
                ArrayList<Exception> exceptions = new ArrayList<Exception>();
                org.apache.maven.project.MavenProject project = null;
                try {
                    MavenProjectBuilder builder = MavenEmbedderWrapper.this.getComponent(MavenProjectBuilder.class);
                    project = builder.build(new File(file.getPath()), config);
                    builder.calculateConcreteState(project, config, false);
                    MavenEmbedderWrapper.this.findExtensions(project);
                    Artifact projectArtifact = project.getArtifact();
                    Map managedVersions = project.getManagedVersionMap();
                    ArtifactMetadataSource metadataSource = MavenEmbedderWrapper.this.getComponent(ArtifactMetadataSource.class);
                    project.setDependencyArtifacts(project.createArtifacts(MavenEmbedderWrapper.this.getComponent(ArtifactFactory.class), null, null));
                    ArtifactResolver resolver = MavenEmbedderWrapper.this.getComponent(ArtifactResolver.class);
                    ArtifactResolutionResult result = resolver.resolveTransitively(project.getDependencyArtifacts(), projectArtifact, managedVersions, MavenEmbedderWrapper.this.myLocalRepository, project.getRemoteArtifactRepositories(), metadataSource);
                    project.setArtifacts(result.getArtifacts());
                }
                catch (ProjectBuildingException e) {
                    exceptions.add((Exception)((Object)e));
                }
                catch (ArtifactResolutionException e) {
                    exceptions.add((Exception)((Object)e));
                }
                catch (ArtifactNotFoundException e) {
                    exceptions.add((Exception)((Object)e));
                }
                return new MavenExecutionResult(project, MavenEmbedderWrapper.this.retrieveUnresolvedArtifactIds(), exceptions);
            }
        });
    }

    private void findExtensions(org.apache.maven.project.MavenProject project) {
        ExtensionManager extensionManager = this.getComponent(ExtensionManager.class);
        for (Object each : project.getBuildExtensions()) {
            try {
                extensionManager.addExtension((Extension)each, project, this.myLocalRepository);
            }
            catch (PlexusContainerException e) {
            }
            catch (ArtifactResolutionException e) {
            }
            catch (ArtifactNotFoundException e) {}
        }
        extensionManager.registerWagons();
        Map handlers = this.findArtifactTypeHandlers(project);
        this.getComponent(ArtifactHandlerManager.class).addHandlers(handlers);
    }

    private Map findArtifactTypeHandlers(org.apache.maven.project.MavenProject project) {
        HashMap result = new HashMap();
        for (Object each : project.getBuildPlugins()) {
            Plugin eachPlugin = (Plugin)each;
            if (!eachPlugin.isExtensions()) continue;
            try {
                PluginManager pluginManager = this.getComponent(PluginManager.class);
                pluginManager.verifyPlugin(eachPlugin, project, this.mySettings, this.myLocalRepository);
                result.putAll(pluginManager.getPluginComponents(eachPlugin, ArtifactHandler.ROLE));
            }
            catch (Exception e) {
                MavenLog.LOG.info((Throwable)e);
                continue;
            }
            for (Object o : result.values()) {
                ArtifactHandler handler = (ArtifactHandler)o;
                if (!project.getPackaging().equals(handler.getPackaging())) continue;
                project.getArtifact().setArtifactHandler(handler);
            }
        }
        return result;
    }

    public void resolve(final @NotNull Artifact artifact, final @NotNull List<MavenRemoteRepository> remoteRepositories) throws MavenProcessCanceledException {
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/embedder/MavenEmbedderWrapper.resolve must not be null");
        }
        if (remoteRepositories == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/embedder/MavenEmbedderWrapper.resolve must not be null");
        }
        this.doExecute(new Executor<Object>(){

            @Override
            public Object execute() throws Exception {
                try {
                    MavenEmbedderWrapper.this.getComponent(ArtifactResolver.class).resolve(artifact, MavenEmbedderWrapper.this.convertRepositories(remoteRepositories), MavenEmbedderWrapper.this.myLocalRepository);
                }
                catch (Exception e) {
                    MavenLog.LOG.info((Throwable)e);
                }
                return null;
            }
        });
    }

    public Artifact resolve(final @NotNull MavenId id, final @NotNull String type, final @Nullable String classifier, final @NotNull List<MavenRemoteRepository> remoteRepositories) throws MavenProcessCanceledException {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/embedder/MavenEmbedderWrapper.resolve must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/embedder/MavenEmbedderWrapper.resolve must not be null");
        }
        if (remoteRepositories == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/jetbrains/idea/maven/embedder/MavenEmbedderWrapper.resolve must not be null");
        }
        return this.doExecute(new Executor<Artifact>(){

            @Override
            public Artifact execute() throws Exception {
                return MavenEmbedderWrapper.this.doResolve(id, type, classifier, MavenEmbedderWrapper.this.convertRepositories(remoteRepositories));
            }
        });
    }

    private Artifact doResolve(MavenId id, String type, String classifier, List<ArtifactRepository> remoteRepositories) {
        Artifact artifact = this.getComponent(ArtifactFactory.class).createArtifactWithClassifier(id.getGroupId(), id.getArtifactId(), id.getVersion(), type, classifier);
        try {
            this.getComponent(ArtifactResolver.class).resolve(artifact, remoteRepositories, this.myLocalRepository);
            return artifact;
        }
        catch (Exception e) {
            MavenLog.LOG.info((Throwable)e);
            return artifact;
        }
    }

    private List<ArtifactRepository> convertRepositories(List<MavenRemoteRepository> repositories) {
        ArrayList<ArtifactRepository> result = new ArrayList<ArtifactRepository>();
        for (MavenRemoteRepository each : repositories) {
            try {
                ArtifactRepositoryFactory factory = this.getComponent(ArtifactRepositoryFactory.class);
                result.add(ProjectUtils.buildArtifactRepository((Repository)each.toRepository(), (ArtifactRepositoryFactory)factory, (PlexusContainer)this.getContainer()));
            }
            catch (InvalidRepositoryException e) {
                MavenLog.LOG.warn((Throwable)e);
            }
        }
        return result;
    }

    public boolean resolvePlugin(final @NotNull MavenPlugin plugin, final @NotNull org.apache.maven.project.MavenProject nativeMavenProject, final boolean transitive) throws MavenProcessCanceledException {
        if (plugin == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/embedder/MavenEmbedderWrapper.resolvePlugin must not be null");
        }
        if (nativeMavenProject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/embedder/MavenEmbedderWrapper.resolvePlugin must not be null");
        }
        return this.doExecute(new Executor<Boolean>(){

            @Override
            public Boolean execute() throws Exception {
                try {
                    Plugin mavenPlugin = new Plugin();
                    mavenPlugin.setGroupId(plugin.getGroupId());
                    mavenPlugin.setArtifactId(plugin.getArtifactId());
                    mavenPlugin.setVersion(plugin.getVersion());
                    PluginDescriptor result = MavenEmbedderWrapper.this.getComponent(PluginManager.class).verifyPlugin(mavenPlugin, nativeMavenProject, MavenEmbedderWrapper.this.mySettings, MavenEmbedderWrapper.this.myLocalRepository);
                    if (!transitive) {
                        return true;
                    }
                    List repos = nativeMavenProject.getRemoteArtifactRepositories();
                    for (Artifact each : result.getIntroducedDependencyArtifacts()) {
                        MavenEmbedderWrapper.this.doResolve(new MavenId(each.getGroupId(), each.getArtifactId(), each.getVersion()), each.getType(), null, repos);
                    }
                    for (Artifact each : result.getDependencies()) {
                        MavenEmbedderWrapper.this.doResolve(new MavenId(each.getGroupId(), each.getArtifactId(), each.getVersion()), each.getType(), null, repos);
                    }
                }
                catch (Exception e) {
                    MavenLog.LOG.info((Throwable)e);
                    return false;
                }
                return true;
            }
        });
    }

    @NotNull
    public MavenExecutionResult execute(final @NotNull VirtualFile file, final @NotNull Collection<String> activeProfiles, final @NotNull List<String> goals) throws MavenProcessCanceledException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/embedder/MavenEmbedderWrapper.execute must not be null");
        }
        if (activeProfiles == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/embedder/MavenEmbedderWrapper.execute must not be null");
        }
        if (goals == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/idea/maven/embedder/MavenEmbedderWrapper.execute must not be null");
        }
        MavenExecutionResult mavenExecutionResult = this.doExecute(new Executor<MavenExecutionResult>(){

            @Override
            public MavenExecutionResult execute() throws Exception {
                MavenExecutionRequest request = MavenEmbedderWrapper.this.createRequest(file, activeProfiles, goals);
                Maven maven = MavenEmbedderWrapper.this.getComponent(Maven.class);
                Method method = maven.getClass().getDeclaredMethod("doExecute", MavenExecutionRequest.class, EventDispatcher.class);
                method.setAccessible(true);
                ReactorManager reactor = (ReactorManager)method.invoke((Object)maven, request, request.getEventDispatcher());
                return new MavenExecutionResult(reactor.getTopLevelProject(), MavenEmbedderWrapper.this.retrieveUnresolvedArtifactIds(), Collections.EMPTY_LIST);
            }
        });
        if (mavenExecutionResult == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/embedder/MavenEmbedderWrapper.execute must not return null");
        }
        return mavenExecutionResult;
    }

    private MavenExecutionRequest createRequest(VirtualFile virtualFile, Collection<String> profiles, List<String> goals) {
        Properties executionProperties = this.getExecutionProperties();
        DefaultEventDispatcher dispatcher = new DefaultEventDispatcher();
        dispatcher.addEventMonitor((EventMonitor)new DefaultEventMonitor((Logger)this.myLogger));
        DefaultMavenExecutionRequest result = new DefaultMavenExecutionRequest(this.myLocalRepository, this.mySettings, (EventDispatcher)dispatcher, goals, virtualFile.getParent().getPath(), this.createProfileManager(profiles, executionProperties), executionProperties, new Properties(), true);
        result.setPomFile(virtualFile.getPath());
        result.setRecursive(false);
        return result;
    }

    private Properties getExecutionProperties() {
        return MavenEmbedderFactory.collectSystemProperties();
    }

    private ProfileManager createProfileManager(Collection<String> activeProfiles, Properties executionProperties) {
        DefaultProfileManager profileManager = new DefaultProfileManager(this.getContainer(), executionProperties);
        profileManager.explicitlyActivate(new ArrayList<String>(activeProfiles));
        return profileManager;
    }

    private Set<MavenId> retrieveUnresolvedArtifactIds() {
        THashSet result = new THashSet();
        ((CustomWagonManager)this.getComponent(WagonManager.class)).getUnresolvedCollector().retrieveUnresolvedIds((Set<MavenId>)result);
        ((CustomArtifactResolver)this.getComponent(ArtifactResolver.class)).getUnresolvedCollector().retrieveUnresolvedIds((Set<MavenId>)result);
        return result;
    }

    public File getLocalRepositoryFile() {
        return new File(this.myLocalRepository.getBasedir());
    }

    public <T> T getComponent(Class<T> clazz) {
        try {
            return (T)this.getContainer().lookup(clazz.getName());
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T getComponent(Class<T> clazz, String roleHint) {
        try {
            return (T)this.getContainer().lookup(clazz.getName(), roleHint);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException(e);
        }
    }

    public PlexusContainer getContainer() {
        return this.myContainer;
    }

    public void release() {
        this.releaseResolverThreadExecutor();
        this.myContainer.dispose();
    }

    private void releaseResolverThreadExecutor() {
        ArtifactResolver resolver = this.getComponent(ArtifactResolver.class);
        FieldAccessor pool = new FieldAccessor(DefaultArtifactResolver.class, resolver, "resolveArtifactPool");
        ((ThreadPoolExecutor)pool.getField()).shutdown();
    }

    private <T> T doExecute(final Executor<T> executor) throws MavenProcessCanceledException {
        final Ref result = new Ref();
        final boolean[] cancelled = new boolean[1];
        final Throwable[] exception = new Throwable[1];
        Future future = ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    result.set(executor.execute());
                }
                catch (ProcessCanceledException e) {
                    cancelled[0] = true;
                }
                catch (Throwable e) {
                    exception[0] = e;
                }
            }
        });
        MavenProgressIndicator indicator = this.myCurrentIndicator;
        do {
            indicator.checkCanceled();
            try {
                future.get(50L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException ignore) {
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getCause());
            }
            catch (InterruptedException e) {
                throw new MavenProcessCanceledException();
            }
        } while (!future.isDone());
        if (cancelled[0]) {
            throw new MavenProcessCanceledException();
        }
        if (exception[0] != null) {
            throw this.getRethrowable(exception[0]);
        }
        return (T)result.get();
    }

    private RuntimeException getRethrowable(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        return new RuntimeException(throwable);
    }

    public void customizeForResolve(MavenConsole console, MavenProgressIndicator process) {
        this.doCustomize(null, false, console, process);
    }

    public void customizeForResolve(Map<MavenId, VirtualFile> projectIdToFileMap, MavenConsole console, MavenProgressIndicator process) {
        this.doCustomize(projectIdToFileMap, false, console, process);
    }

    public void customizeForStrictResolve(Map<MavenId, VirtualFile> projectIdToFileMap, MavenConsole console, MavenProgressIndicator process) {
        this.doCustomize(projectIdToFileMap, true, console, process);
    }

    private void doCustomize(Map<MavenId, VirtualFile> projectIdToFileMap, boolean strict, MavenConsole console, MavenProgressIndicator process) {
        ((CustomArtifactFactory)this.getComponent(ArtifactFactory.class)).customize();
        ((CustomArtifactFactory)this.getComponent(ProjectArtifactFactory.class)).customize();
        ((CustomArtifactResolver)this.getComponent(ArtifactResolver.class)).customize(projectIdToFileMap, strict);
        ((CustomWagonManager)this.getComponent(WagonManager.class)).customize(strict);
        this.setConsoleAndLogger(console, process);
    }

    private void setConsoleAndLogger(MavenConsole console, MavenProgressIndicator process) {
        this.myCurrentIndicator = process;
        this.myLogger.setConsole(console);
        WagonManager wagon = this.getComponent(WagonManager.class);
        wagon.setDownloadMonitor((TransferListener)(process == null ? null : new TransferListenerAdapter(process)));
    }

    public void reset() {
        this.setConsoleAndLogger(null, null);
        ((CustomArtifactFactory)this.getComponent(ArtifactFactory.class)).reset();
        ((CustomArtifactResolver)this.getComponent(ArtifactResolver.class)).reset();
        ((CustomWagonManager)this.getComponent(WagonManager.class)).reset();
    }

    public void clearCaches() {
        this.withProjectCachesDo(new Function<Map, Object>(){

            public Object fun(Map map) {
                map.clear();
                return null;
            }
        });
    }

    public void clearCachesFor(final MavenProject mavenProject) {
        this.withProjectCachesDo(new Function<Map, Object>(){

            public Object fun(Map map) {
                map.remove(mavenProject.getMavenId().getKey());
                return null;
            }
        });
    }

    public static Model interpolate(Model model, File basedir) {
        try {
            CustomModelInterpolator interpolator = new CustomModelInterpolator(new DefaultPathTranslator());
            interpolator.initialize();
            Properties context = MavenEmbedderFactory.collectSystemProperties();
            ProjectBuilderConfiguration config = new DefaultProjectBuilderConfiguration().setExecutionProperties(context);
            model = interpolator.interpolate(ModelUtils.cloneModel((Model)model), basedir, config, false);
        }
        catch (ModelInterpolationException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
        catch (InitializationException e) {
            MavenLog.LOG.error((Throwable)e);
        }
        return model;
    }

    public static void alignModel(Model model, File basedir) {
        DefaultPathTranslator pathTranslator = new DefaultPathTranslator();
        pathTranslator.alignToBaseDirectory(model, basedir);
        Build build = model.getBuild();
        build.setScriptSourceDirectory(pathTranslator.alignToBaseDirectory(build.getScriptSourceDirectory(), basedir));
    }

    private void withProjectCachesDo(Function<Map, ?> func) {
        MavenProjectBuilder builder = this.getComponent(MavenProjectBuilder.class);
        try {
            Field field = builder.getClass().getDeclaredField("rawProjectCache");
            field.setAccessible(true);
            func.fun((Object)((Map)field.get(builder)));
            field = builder.getClass().getDeclaredField("processedProjectCache");
            field.setAccessible(true);
            func.fun((Object)((Map)field.get(builder)));
        }
        catch (NoSuchFieldException e) {
            MavenLog.LOG.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            MavenLog.LOG.error((Throwable)e);
        }
    }

    private void configureContainer() {
        this.setImplementation(ArtifactFactory.class, CustomArtifactFactory.class);
        this.setImplementation(ProjectArtifactFactory.class, CustomArtifactFactory.class);
        this.setImplementation(ArtifactResolver.class, CustomArtifactResolver.class);
        this.setImplementation(WagonManager.class, CustomWagonManager.class);
        this.setImplementation(ModelInterpolator.class, CustomModelInterpolator.class);
    }

    private <T> void setImplementation(Class<T> componentClass, Class<? extends T> implementationClass) {
        ComponentDescriptor d = this.myContainer.getComponentDescriptor(componentClass.getName());
        d.setImplementation(implementationClass.getName());
    }

    private static interface Executor<T> {
        public T execute() throws Exception;
    }
}

