/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters.repositories;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xmlb.XmlSerializer;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.converters.repositories.beans.RepositoriesBean;
import org.jetbrains.idea.maven.dom.converters.repositories.beans.RepositoryBeanInfo;

public class MavenRepositoriesProvider {
    Map<String, Pair<String, String>> myRepositoriesMap = new HashMap();

    public static MavenRepositoriesProvider getInstance() {
        return (MavenRepositoriesProvider)ServiceManager.getService(MavenRepositoriesProvider.class);
    }

    public MavenRepositoriesProvider() {
        RepositoriesBean repositoriesBean = (RepositoriesBean)XmlSerializer.deserialize((URL)MavenRepositoriesProvider.class.getResource("repositories.xml"), RepositoriesBean.class);
        assert (repositoriesBean != null);
        RepositoryBeanInfo[] repositories = repositoriesBean.getRepositories();
        assert (repositories != null);
        for (RepositoryBeanInfo repository : repositories) {
            this.registerRepository(repository.getId(), repository.getName(), repository.getUrl());
        }
    }

    public void registerRepository(@NotNull String id, @NotNull String name, @NotNull String url) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/converters/repositories/MavenRepositoriesProvider.registerRepository must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/converters/repositories/MavenRepositoriesProvider.registerRepository must not be null");
        }
        if (url == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/idea/maven/dom/converters/repositories/MavenRepositoriesProvider.registerRepository must not be null");
        }
        this.myRepositoriesMap.put(id, (Pair<String, String>)Pair.create((Object)name, (Object)url));
    }

    @NotNull
    public Set<String> getRepositoryIds() {
        Set<String> set = this.myRepositoriesMap.keySet();
        if (set == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/converters/repositories/MavenRepositoriesProvider.getRepositoryIds must not return null");
        }
        return set;
    }

    @Nullable
    public String getRepositoryName(@Nullable String id) {
        Pair<String, String> pair = this.myRepositoriesMap.get(id);
        return pair != null ? (String)pair.getFirst() : null;
    }

    @Nullable
    public String getRepositoryUrl(@Nullable String id) {
        Pair<String, String> pair = this.myRepositoriesMap.get(id);
        return pair != null ? (String)pair.getSecond() : null;
    }
}

