/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.regexp.psi.RegExpBackref;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;

public class RegExpBackrefImpl
extends RegExpElementImpl
implements RegExpBackref {
    public RegExpBackrefImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    public int getIndex() {
        String s = this.getUnescapedText();
        assert (s.charAt(0) == '\\');
        return Integer.parseInt(s.substring(1));
    }

    @Override
    public void accept(RegExpElementVisitor visitor) {
        visitor.visitRegExpBackref(this);
    }

    @Override
    public RegExpGroup resolve() {
        final int index = this.getIndex();
        PsiElementProcessor.FindFilteredElement processor = new PsiElementProcessor.FindFilteredElement(new PsiElementFilter(){
            int groupCount;

            public boolean isAccepted(PsiElement element) {
                if (element instanceof RegExpGroup && ((RegExpGroup)element).isCapturing() && ++this.groupCount == index) {
                    return true;
                }
                return element == RegExpBackrefImpl.this;
            }
        });
        PsiTreeUtil.processElements((PsiElement)this.getContainingFile(), (PsiElementProcessor)processor);
        if (processor.getFoundElement() instanceof RegExpGroup) {
            return (RegExpGroup)processor.getFoundElement();
        }
        return null;
    }

    @Override
    public PsiReference getReference() {
        return new PsiReference(){

            public PsiElement getElement() {
                return RegExpBackrefImpl.this;
            }

            public TextRange getRangeInElement() {
                return TextRange.from((int)0, (int)this.getElement().getTextLength());
            }

            public String getCanonicalText() {
                return this.getElement().getText();
            }

            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                throw new IncorrectOperationException();
            }

            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                if (element == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/lang/regexp/psi/impl/RegExpBackrefImpl$2.bindToElement must not be null");
                }
                throw new IncorrectOperationException();
            }

            public boolean isReferenceTo(PsiElement element) {
                return Comparing.equal((Object)element, (Object)this.resolve());
            }

            public boolean isSoft() {
                return false;
            }

            public PsiElement resolve() {
                return RegExpBackrefImpl.this.resolve();
            }

            @NotNull
            public Object[] getVariants() {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/psi/impl/RegExpBackrefImpl$2.getVariants must not return null");
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
        };
    }
}

