/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.thumbnail.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.intellij.images.thumbnail.ThumbnailView;
import org.intellij.images.thumbnail.impl.ThumbnailViewUI;
import org.intellij.images.vfs.IfsUtil;
import org.jetbrains.annotations.NotNull;

final class ThumbnailViewImpl
implements ThumbnailView {
    private static final Icon TOOL_WINDOW_ICON = IconLoader.getIcon((String)"/org/intellij/images/icons/ThumbnailToolWindow.png");
    private final Project project;
    private final ToolWindow toolWindow;
    private boolean recursive = false;
    private VirtualFile root = null;
    private final ThumbnailViewUI myThubmnailViewUi;

    public ThumbnailViewImpl(Project project) {
        this.project = project;
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)project);
        this.myThubmnailViewUi = new ThumbnailViewUI(this);
        this.toolWindow = windowManager.registerToolWindow(TOOLWINDOW_ID, (JComponent)this.myThubmnailViewUi, ToolWindowAnchor.BOTTOM);
        this.toolWindow.setIcon(TOOL_WINDOW_ICON);
        this.setVisible(false);
    }

    private ThumbnailViewUI getUI() {
        return this.myThubmnailViewUi;
    }

    @Override
    public void setRoot(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/images/thumbnail/impl/ThumbnailViewImpl.setRoot must not be null");
        }
        this.root = root;
        this.updateUI();
    }

    @Override
    public VirtualFile getRoot() {
        return this.root;
    }

    @Override
    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
        this.updateUI();
    }

    @Override
    public void setSelected(@NotNull VirtualFile file, boolean selected) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/images/thumbnail/impl/ThumbnailViewImpl.setSelected must not be null");
        }
        if (this.isVisible()) {
            this.getUI().setSelected(file, selected);
        }
    }

    @Override
    public boolean isSelected(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/images/thumbnail/impl/ThumbnailViewImpl.isSelected must not be null");
        }
        return this.isVisible() && this.getUI().isSelected(file);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public VirtualFile[] getSelection() {
        VirtualFile[] virtualFileArray;
        if (this.isVisible()) {
            virtualFileArray = this.getUI().getSelection();
            if (virtualFileArray == null) throw new IllegalStateException("@NotNull method org/intellij/images/thumbnail/impl/ThumbnailViewImpl.getSelection must not return null");
            return virtualFileArray;
        }
        virtualFileArray = VirtualFile.EMPTY_ARRAY;
        if (VirtualFile.EMPTY_ARRAY != null) return virtualFileArray;
        throw new IllegalStateException("@NotNull method org/intellij/images/thumbnail/impl/ThumbnailViewImpl.getSelection must not return null");
    }

    @Override
    public void scrollToSelection() {
        if (this.isVisible()) {
            if (!this.toolWindow.isActive()) {
                this.toolWindow.activate((Runnable)new LazyScroller());
            } else {
                this.getUI().scrollToSelection();
            }
        }
    }

    @Override
    public boolean isVisible() {
        return this.toolWindow.isAvailable();
    }

    @Override
    public void activate() {
        if (this.isVisible() && !this.toolWindow.isActive()) {
            this.toolWindow.activate(null);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        this.toolWindow.setAvailable(visible, null);
        if (visible) {
            this.setTitle();
            this.getUI().refresh();
        } else {
            this.getUI().dispose();
        }
    }

    private void updateUI() {
        if (this.isVisible()) {
            this.setTitle();
            this.getUI().refresh();
        }
    }

    private void setTitle() {
        this.toolWindow.setTitle(this.root != null ? IfsUtil.getReferencePath(this.project, this.root) : null);
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.project;
        if (project == null) {
            throw new IllegalStateException("@NotNull method org/intellij/images/thumbnail/impl/ThumbnailViewImpl.getProject must not return null");
        }
        return project;
    }

    @Override
    public void setTransparencyChessboardVisible(boolean visible) {
        if (this.isVisible()) {
            this.getUI().setTransparencyChessboardVisible(visible);
        }
    }

    @Override
    public boolean isTransparencyChessboardVisible() {
        return this.isVisible() && this.getUI().isTransparencyChessboardVisible();
    }

    @Override
    public boolean isEnabledForActionPlace(String place) {
        return this.isVisible() && !"Images.Editor".equals(place);
    }

    public void dispose() {
        this.getUI().dispose();
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)this.project);
        windowManager.unregisterToolWindow(TOOLWINDOW_ID);
    }

    private final class LazyScroller
    implements Runnable {
        private LazyScroller() {
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ThumbnailViewImpl.this.getUI().scrollToSelection();
                }
            });
        }
    }
}

