/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlInspectionGroupNames;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttlistDecl;
import com.intellij.psi.xml.XmlConditionalSection;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementContentSpec;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlMarkupDecl;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class CheckDtdReferencesInspection
extends XmlSuppressableInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/util/CheckDtdReferencesInspection.buildVisitor must not be null");
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlElement(XmlElement element) {
                if (element instanceof XmlElementContentSpec || element instanceof XmlEntityRef) {
                    CheckDtdReferencesInspection.doCheckRefs(element, holder);
                }
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xml/util/CheckDtdReferencesInspection.buildVisitor must not return null");
        }
        return xmlElementVisitor;
    }

    private static void doCheckRefs(XmlElement element, ProblemsHolder holder) {
        for (PsiReference ref : element.getReferences()) {
            String image;
            ProgressManager.checkCanceled();
            if (!XmlHighlightVisitor.hasBadResolve(ref) || ref.getElement() instanceof XmlElementContentSpec && ((image = ref.getCanonicalText()).equals("-") || image.equals("O"))) continue;
            holder.registerProblem(ref, XmlHighlightVisitor.getErrorDescription(ref), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        }
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xml/util/CheckDtdReferencesInspection.getDefaultLevel must not return null");
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = XmlInspectionGroupNames.XML_INSPECTIONS;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xml/util/CheckDtdReferencesInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message((String)"xml.inspections.check.dtd.references", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xml/util/CheckDtdReferencesInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("CheckDtdRefs" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xml/util/CheckDtdReferencesInspection.getShortName must not return null");
        }
        return "CheckDtdRefs";
    }

    public static class AddDtdDeclarationFix
    implements LocalQuickFix {
        private final String myMessageKey;
        private final String myElementDeclarationName;
        private final PsiReference myReference;

        public AddDtdDeclarationFix(@PropertyKey(resourceBundle="messages.XmlBundle") String messageKey, @NotNull String elementDeclarationName, @NotNull PsiReference reference) {
            if (elementDeclarationName == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/util/CheckDtdReferencesInspection$AddDtdDeclarationFix.<init> must not be null");
            }
            if (reference == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/xml/util/CheckDtdReferencesInspection$AddDtdDeclarationFix.<init> must not be null");
            }
            this.myMessageKey = messageKey;
            this.myElementDeclarationName = elementDeclarationName;
            this.myReference = reference;
        }

        @NotNull
        public String getName() {
            String string = XmlBundle.message((String)this.myMessageKey, (Object[])new Object[]{this.myReference.getCanonicalText()});
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/xml/util/CheckDtdReferencesInspection$AddDtdDeclarationFix.getName must not return null");
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/xml/util/CheckDtdReferencesInspection$AddDtdDeclarationFix.getFamilyName must not return null");
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/util/CheckDtdReferencesInspection$AddDtdDeclarationFix.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/util/CheckDtdReferencesInspection$AddDtdDeclarationFix.applyFix must not be null");
            }
            PsiElement element = descriptor.getPsiElement();
            PsiFile containingFile = element.getContainingFile();
            if (!CodeInsightUtilBase.prepareFileForWrite(containingFile)) {
                return;
            }
            String prefixToInsert = "";
            String suffixToInsert = "";
            int UNDEFINED_OFFSET = -1;
            int anchorOffset = -1;
            PsiElement anchor = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{XmlElementDecl.class, XmlAttlistDecl.class, XmlEntityDecl.class, XmlConditionalSection.class});
            if (anchor != null) {
                anchorOffset = anchor.getTextRange().getStartOffset();
            }
            if (anchorOffset == -1 && containingFile.getLanguage() == XMLLanguage.INSTANCE) {
                XmlFile file = (XmlFile)containingFile;
                XmlProlog prolog = file.getDocument().getProlog();
                assert (prolog != null);
                XmlDoctype doctype = prolog.getDoctype();
                XmlMarkupDecl markupDecl = doctype != null ? doctype.getMarkupDecl() : null;
                if (doctype == null) {
                    XmlTag rootTag = file.getDocument().getRootTag();
                    prefixToInsert = "<!DOCTYPE " + (rootTag != null ? rootTag.getName() : "null");
                    suffixToInsert = ">\n";
                }
                if (markupDecl == null) {
                    prefixToInsert = prefixToInsert + " [\n";
                    suffixToInsert = "]" + suffixToInsert;
                    anchorOffset = doctype != null ? doctype.getTextRange().getEndOffset() - 1 : prolog.getTextRange().getEndOffset();
                }
            }
            if (anchorOffset == -1) {
                anchorOffset = element.getTextRange().getStartOffset();
            }
            OpenFileDescriptor openDescriptor = new OpenFileDescriptor(project, containingFile.getVirtualFile(), anchorOffset);
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(openDescriptor, true);
            TemplateManager templateManager = TemplateManager.getInstance(project);
            Template t = templateManager.createTemplate("", "");
            if (prefixToInsert.length() > 0) {
                t.addTextSegment(prefixToInsert);
            }
            t.addTextSegment("<!" + this.myElementDeclarationName + " " + this.myReference.getCanonicalText() + " ");
            t.addEndVariable();
            t.addTextSegment(">\n");
            if (suffixToInsert.length() > 0) {
                t.addTextSegment(suffixToInsert);
            }
            templateManager.startTemplate(editor, t);
        }
    }
}

