/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.DataExternalizer;
import com.intellij.xml.index.XmlIndex;
import com.intellij.xml.index.XsdTagNameBuilder;
import java.io.ByteArrayInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class XmlTagNamesIndex
extends XmlIndex<Void> {
    private static final ID<String, Void> NAME = ID.create((String)"XmlTagNames");

    public static Collection<VirtualFile> getFilesByTagName(String tagName, Project project) {
        return FileBasedIndex.getInstance().getContainingFiles(NAME, tagName, XmlTagNamesIndex.createFilter(project));
    }

    public static Collection<String> getAllTagNames(Project project) {
        return FileBasedIndex.getInstance().getAllKeys(NAME, project);
    }

    static void requestRebuild() {
        FileBasedIndex.getInstance();
        FileBasedIndex.requestRebuild(NAME);
    }

    @Override
    public ID<String, Void> getName() {
        return NAME;
    }

    @Override
    public DataIndexer<String, Void, FileContent> getIndexer() {
        return new DataIndexer<String, Void, FileContent>(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            @NotNull
            public Map<String, Void> map(FileContent inputData) {
                HashMap hashMap;
                Collection<String> tags = XsdTagNameBuilder.computeTagNames(new ByteArrayInputStream(inputData.getContent()));
                if (tags != null && !tags.isEmpty()) {
                    HashMap map = new HashMap(tags.size());
                    for (String tag : tags) {
                        map.put((Object)tag, null);
                    }
                    hashMap = map;
                    if (hashMap == null) throw new IllegalStateException("@NotNull method com/intellij/xml/index/XmlTagNamesIndex$1.map must not return null");
                    return hashMap;
                }
                hashMap = Collections.emptyMap();
                if (hashMap != null) return hashMap;
                throw new IllegalStateException("@NotNull method com/intellij/xml/index/XmlTagNamesIndex$1.map must not return null");
            }
        };
    }

    @Override
    public DataExternalizer<Void> getValueExternalizer() {
        return ScalarIndexExtension.VOID_DATA_EXTERNALIZER;
    }
}

