/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomParentStrategy;
import com.intellij.util.xml.impl.PhysicalDomParentStrategy;
import org.jetbrains.annotations.NotNull;

public class VirtualDomParentStrategy
implements DomParentStrategy {
    private final DomInvocationHandler myParentHandler;
    private long myModCount;
    private final PsiFile myModificationTracker;

    public VirtualDomParentStrategy(@NotNull DomInvocationHandler parentHandler) {
        if (parentHandler == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/VirtualDomParentStrategy.<init> must not be null");
        }
        this.myParentHandler = parentHandler;
        this.myModificationTracker = parentHandler.getFile();
        this.myModCount = this.getModCount();
    }

    private long getModCount() {
        return this.myModificationTracker.getModificationStamp();
    }

    @Override
    @NotNull
    public DomInvocationHandler getParentHandler() {
        DomInvocationHandler domInvocationHandler = this.myParentHandler;
        if (domInvocationHandler == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/VirtualDomParentStrategy.getParentHandler must not return null");
        }
        return domInvocationHandler;
    }

    @Override
    public XmlElement getXmlElement() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public synchronized DomParentStrategy refreshStrategy(DomInvocationHandler handler) {
        DomParentStrategy domParentStrategy;
        if (!this.myParentHandler.isValid()) {
            domParentStrategy = this;
            if (domParentStrategy == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/VirtualDomParentStrategy.refreshStrategy must not return null");
            return domParentStrategy;
        }
        long modCount = this.getModCount();
        if (modCount != this.myModCount) {
            XmlElement xmlElement = handler.recomputeXmlElement(this.myParentHandler);
            if (xmlElement != null) {
                domParentStrategy = new PhysicalDomParentStrategy(xmlElement, DomManagerImpl.getDomManager(xmlElement.getProject()));
                if (domParentStrategy == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/VirtualDomParentStrategy.refreshStrategy must not return null");
                return domParentStrategy;
            }
            this.myModCount = modCount;
        }
        if ((domParentStrategy = this) != null) return domParentStrategy;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/VirtualDomParentStrategy.refreshStrategy must not return null");
    }

    @Override
    @NotNull
    public DomParentStrategy setXmlElement(@NotNull XmlElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/VirtualDomParentStrategy.setXmlElement must not be null");
        }
        PhysicalDomParentStrategy physicalDomParentStrategy = new PhysicalDomParentStrategy(element, DomManagerImpl.getDomManager(element.getProject()));
        if (physicalDomParentStrategy == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/VirtualDomParentStrategy.setXmlElement must not return null");
        }
        return physicalDomParentStrategy;
    }

    @Override
    @NotNull
    public synchronized DomParentStrategy clearXmlElement() {
        this.myModCount = this.getModCount();
        VirtualDomParentStrategy virtualDomParentStrategy = this;
        if (virtualDomParentStrategy == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/VirtualDomParentStrategy.clearXmlElement must not return null");
        }
        return virtualDomParentStrategy;
    }

    @Override
    public synchronized boolean isValid() {
        return this.getModCount() == this.myModCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualDomParentStrategy)) {
            return false;
        }
        VirtualDomParentStrategy that = (VirtualDomParentStrategy)o;
        return this.myParentHandler.equals((Object)that.myParentHandler);
    }

    public int hashCode() {
        return this.myParentHandler.hashCode();
    }
}

