/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.ByteBufferMapWriteHandler;
import com.intellij.util.io.ByteBufferRADataInput;
import com.intellij.util.io.MappedBufferWrapper;
import com.intellij.util.io.RandomAccessDataInput;
import com.intellij.util.io.WriteableMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ByteBufferMap<K, V> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.io.ByteBufferMap");
    private final RandomAccessDataInput myBuffer;
    private final int myStartOffset;
    private final KeyProvider<K> myKeyProvider;
    private final ValueProvider<V> myValueProvider;
    private int myMod;
    private final int myEndOffset;

    public static <V> void writeMap(DataOutput stream, ValueProvider<V> valueProvider, WriteableMap<V> map, double searchFactor) throws IOException {
        new ByteBufferMapWriteHandler<V>(stream, valueProvider, map, searchFactor).execute();
    }

    public static <V> int calcMapLength(ValueProvider<V> valueProvider, WriteableMap<V> map, double searchFactor) throws IOException {
        return new ByteBufferMapWriteHandler<V>(null, valueProvider, map, searchFactor).calcLength();
    }

    public ByteBufferMap(@NotNull MappedBufferWrapper holder, int startOffset, int endOffset, @NotNull KeyProvider<K> keyProvider, @NotNull ValueProvider<V> valueProvider) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/io/ByteBufferMap.<init> must not be null");
        }
        if (keyProvider == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/util/io/ByteBufferMap.<init> must not be null");
        }
        if (valueProvider == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/util/io/ByteBufferMap.<init> must not be null");
        }
        this(new ByteBufferRADataInput(holder), startOffset, endOffset, keyProvider, valueProvider);
    }

    public ByteBufferMap(@NotNull RandomAccessDataInput buffer, int startOffset, int endOffset, @NotNull KeyProvider<K> keyProvider, @NotNull ValueProvider<V> valueProvider) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/io/ByteBufferMap.<init> must not be null");
        }
        if (keyProvider == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/util/io/ByteBufferMap.<init> must not be null");
        }
        if (valueProvider == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/util/io/ByteBufferMap.<init> must not be null");
        }
        assert (startOffset < endOffset);
        this.myBuffer = buffer;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myKeyProvider = keyProvider;
        this.myValueProvider = valueProvider;
        buffer.setPosition(startOffset);
        try {
            this.myMod = buffer.readInt();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public V get(K key) {
        int hash = this.hash(this.myKeyProvider.hashCode(key));
        int keyGroupOffset = this.readKeyGroupOffset(hash);
        if (keyGroupOffset == -1) {
            return null;
        }
        if (this.myStartOffset >= keyGroupOffset || keyGroupOffset >= this.myEndOffset) {
            LOG.error("keyGroupOffset = " + keyGroupOffset + " myStartOffset = " + this.myStartOffset + " myEndOffset = " + this.myEndOffset);
        }
        try {
            this.myBuffer.setPosition(keyGroupOffset);
            int keyGroupSize = this.myBuffer.readInt();
            assert (keyGroupSize > 0);
            for (int i = 0; i < keyGroupSize; ++i) {
                if (this.myKeyProvider.equals((DataInput)this.myBuffer, key)) {
                    int valueOffset = this.myBuffer.readInt();
                    assert (valueOffset > 0);
                    this.myBuffer.setPosition(this.myStartOffset + valueOffset);
                    return this.myValueProvider.get((DataInput)this.myBuffer);
                }
                this.myBuffer.readInt();
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    public K[] getKeys(Class<K> keyClass) {
        ArrayList result = new ArrayList();
        this.getKeys(keyClass, result);
        return result.toArray((Object[])Array.newInstance(keyClass, result.size()));
    }

    public void getKeys(Class<K> keyClass, Collection<K> dst) {
        try {
            this.myBuffer.setPosition(this.myStartOffset + 4);
            int firstKeyGroupOffset = -1;
            int lastKeyGroupOffset = -1;
            for (int i = 0; i < this.myMod; ++i) {
                int value = this.myBuffer.readInt();
                if (value == -1) continue;
                int offset = value + this.myStartOffset;
                if (firstKeyGroupOffset == -1) {
                    firstKeyGroupOffset = offset;
                }
                lastKeyGroupOffset = offset;
            }
            if (firstKeyGroupOffset == -1) {
                return;
            }
            assert (firstKeyGroupOffset > this.myStartOffset);
            assert (lastKeyGroupOffset > this.myStartOffset);
            assert (lastKeyGroupOffset >= firstKeyGroupOffset);
            int firstValueOffset = -1;
            this.myBuffer.setPosition(firstKeyGroupOffset);
            while (this.myBuffer.getPosition() <= lastKeyGroupOffset) {
                int groupSize = this.myBuffer.readInt();
                for (int i = 0; i < groupSize; ++i) {
                    dst.add(this.myKeyProvider.get((DataInput)this.myBuffer));
                    int valueOffset = this.myBuffer.readInt();
                    if (firstValueOffset != -1) continue;
                    firstValueOffset = valueOffset + this.myStartOffset;
                }
            }
            assert (this.myBuffer.getPosition() == firstValueOffset);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private int readKeyGroupOffset(int hash) {
        this.myBuffer.setPosition(this.myStartOffset + 4 + 4 * hash);
        int offset = -1;
        try {
            offset = this.myBuffer.readInt();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        if (offset == -1) {
            return -1;
        }
        return offset + this.myStartOffset;
    }

    private int hash(int hashCode) {
        return Math.abs(hashCode) % this.myMod;
    }

    public static interface ValueProvider<V> {
        public void write(DataOutput var1, V var2) throws IOException;

        public int length(V var1);

        public V get(DataInput var1) throws IOException;
    }

    public static interface KeyProvider<K> {
        public int hashCode(K var1);

        public void write(DataOutput var1, K var2) throws IOException;

        public int length(K var1);

        public K get(DataInput var1) throws IOException;

        public boolean equals(DataInput var1, K var2) throws IOException;
    }
}

