/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SingleEntryIndexer<V>
implements DataIndexer<Integer, V, FileContent> {
    private boolean myAcceptNullValues;

    protected SingleEntryIndexer(boolean acceptNullValues) {
        this.myAcceptNullValues = acceptNullValues;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public final Map<Integer, V> map(FileContent inputData) {
        Map map;
        if (inputData == null) {
            map = Collections.emptyMap();
            if (map == null) throw new IllegalStateException("@NotNull method com/intellij/util/indexing/SingleEntryIndexer.map must not return null");
            return map;
        }
        V value = this.computeValue(inputData);
        if (value == null && !this.myAcceptNullValues) {
            map = Collections.emptyMap();
            if (map == null) throw new IllegalStateException("@NotNull method com/intellij/util/indexing/SingleEntryIndexer.map must not return null");
            return map;
        }
        int key = Math.abs(FileBasedIndex.getFileId(inputData.getFile()));
        map = Collections.singletonMap(key, value);
        if (map != null) return map;
        throw new IllegalStateException("@NotNull method com/intellij/util/indexing/SingleEntryIndexer.map must not return null");
    }

    @Nullable
    protected abstract V computeValue(@NotNull FileContent var1);
}

