/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.containers.SLRUCache;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.TObjectLongHashMap;
import gnu.trove.TObjectLongProcedure;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexingStamp {
    private static final SLRUCache<VirtualFile, Timestamps> myTimestampsCache = new SLRUCache<VirtualFile, Timestamps>(5, 5){

        @NotNull
        public Timestamps createValue(VirtualFile key) {
            try {
                DataInputStream stream = Timestamps.PERSISTENCE.readAttribute(key);
                Timestamps timestamps = new Timestamps(stream);
                if (timestamps == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/util/indexing/IndexingStamp$1.createValue must not return null");
                }
                return timestamps;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        protected void onDropFromCache(VirtualFile key, Timestamps value) {
            try {
                if (value.isDirty()) {
                    DataOutputStream sink = Timestamps.PERSISTENCE.writeAttribute(key);
                    value.writeToStream(sink);
                    sink.close();
                }
            }
            catch (InvalidVirtualFileAccessException ignored) {
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    };

    private IndexingStamp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFileIndexed(VirtualFile file, ID<?, ?> indexName, long indexCreationStamp) {
        block6: {
            try {
                if (file instanceof NewVirtualFile && file.isValid()) {
                    SLRUCache<VirtualFile, Timestamps> sLRUCache = myTimestampsCache;
                    synchronized (sLRUCache) {
                        return ((Timestamps)myTimestampsCache.get((Object)file)).get(indexName) == indexCreationStamp;
                    }
                }
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof IOException)) break block6;
                FileBasedIndex.getInstance();
                FileBasedIndex.requestRebuild(indexName, cause);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(VirtualFile file, ID<?, ?> indexName, long indexCreationStamp) {
        block5: {
            try {
                if (!(file instanceof NewVirtualFile) || !file.isValid()) break block5;
                SLRUCache<VirtualFile, Timestamps> sLRUCache = myTimestampsCache;
                synchronized (sLRUCache) {
                    ((Timestamps)myTimestampsCache.get((Object)file)).set(indexName, indexCreationStamp);
                }
            }
            catch (InvalidVirtualFileAccessException ignored) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushCache() {
        SLRUCache<VirtualFile, Timestamps> sLRUCache = myTimestampsCache;
        synchronized (sLRUCache) {
            myTimestampsCache.clear();
        }
    }

    private static class Timestamps {
        private static final FileAttribute PERSISTENCE = new FileAttribute("__index_stamps__", 1);
        private TObjectLongHashMap<ID<?, ?>> myIndexStamps;
        private boolean myIsDirty = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Timestamps(@Nullable DataInputStream stream) throws IOException {
            if (stream != null) {
                try {
                    int count = DataInputOutputUtil.readINT((DataInput)stream);
                    if (count > 0) {
                        this.myIndexStamps = new TObjectLongHashMap(20);
                        for (int i = 0; i < count; ++i) {
                            ID id = ID.findById((int)DataInputOutputUtil.readINT((DataInput)stream));
                            long timestamp = DataInputOutputUtil.readTIME((DataInput)stream);
                            if (id == null) continue;
                            this.myIndexStamps.put((Object)id, timestamp);
                        }
                    }
                }
                finally {
                    stream.close();
                }
            }
        }

        public void writeToStream(final DataOutputStream stream) throws IOException {
            if (this.myIndexStamps != null) {
                int size = this.myIndexStamps.size();
                final int[] count = new int[]{0};
                DataInputOutputUtil.writeINT((DataOutput)stream, (int)size);
                this.myIndexStamps.forEachEntry(new TObjectLongProcedure<ID<?, ?>>(){

                    public boolean execute(ID<?, ?> id, long timestamp) {
                        try {
                            DataInputOutputUtil.writeINT((DataOutput)stream, (int)((int)id.getUniqueId()));
                            DataInputOutputUtil.writeTIME((DataOutput)stream, (long)timestamp);
                            count[0] = count[0] + 1;
                            return true;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                assert (count[0] == size);
            }
        }

        public long get(ID<?, ?> id) {
            return this.myIndexStamps != null ? this.myIndexStamps.get(id) : 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(ID<?, ?> id, long tmst) {
            try {
                if (this.myIndexStamps == null) {
                    this.myIndexStamps = new TObjectLongHashMap(20);
                }
                this.myIndexStamps.put(id, tmst);
            }
            finally {
                this.myIsDirty = true;
            }
        }

        public boolean isDirty() {
            return this.myIsDirty;
        }
    }
}

