/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.rules.FileGroupingRule;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageGroupingRule;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ClassGroupingRule
implements UsageGroupingRule {
    public UsageGroup groupUsage(Usage usage) {
        if (!(usage instanceof PsiElementUsage)) {
            return null;
        }
        PsiElement psiElement = ((PsiElementUsage)usage).getElement();
        PsiFile containingFile = psiElement.getContainingFile();
        if (!(containingFile instanceof PsiJavaFile) || containingFile instanceof JspFile) {
            return null;
        }
        PsiElement containingClass = psiElement;
        while ((containingClass = PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiClass.class, (boolean)true)) != null && ((PsiClass)containingClass).getQualifiedName() == null) {
        }
        if (containingClass == null) {
            PsiImportList importList = (PsiImportList)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiImportList.class, (boolean)true);
            if (importList != null) {
                PsiClass[] classes;
                String fileName = ClassGroupingRule.getFileNameWithoutExtension(containingFile);
                for (PsiClass aClass : classes = ((PsiJavaFile)containingFile).getClasses()) {
                    if (!fileName.equals(aClass.getName())) continue;
                    containingClass = aClass;
                    break;
                }
            }
        } else if (containingClass.getParent() instanceof PsiFile && JspPsiUtil.isInJspFile((PsiElement)containingClass)) {
            containingClass = null;
        }
        if (containingClass != null) {
            return new ClassUsageGroup((PsiClass)containingClass);
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile != null) {
            return new FileGroupingRule.FileUsageGroup(containingFile.getProject(), virtualFile);
        }
        return null;
    }

    private static String getFileNameWithoutExtension(PsiFile file) {
        String name = file.getName();
        int index = name.lastIndexOf(46);
        return index < 0 ? name : name.substring(0, index);
    }

    private static class ClassUsageGroup
    implements UsageGroup,
    TypeSafeDataProvider {
        private final SmartPsiElementPointer myClassPointer;
        private final String myText;
        private final String myQName;
        private Icon myIcon;

        public ClassUsageGroup(PsiClass aClass) {
            this.myQName = aClass.getQualifiedName();
            this.myText = ClassUsageGroup.createText(aClass);
            this.myClassPointer = SmartPointerManager.getInstance((Project)aClass.getProject()).createLazyPointer((PsiElement)aClass);
            this.update();
        }

        public void update() {
            if (this.isValid()) {
                this.myIcon = this.getPsiClass().getIcon(3);
            }
        }

        private static String createText(PsiClass aClass) {
            String text = aClass.getName();
            for (PsiClass containingClass = aClass.getContainingClass(); containingClass != null; containingClass = containingClass.getContainingClass()) {
                text = containingClass.getName() + '.' + text;
            }
            return text;
        }

        public Icon getIcon(boolean isOpen) {
            return this.myIcon;
        }

        @NotNull
        public String getText(UsageView view) {
            String string = this.myText;
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/usages/impl/rules/ClassGroupingRule$ClassUsageGroup.getText must not return null");
            }
            return string;
        }

        public FileStatus getFileStatus() {
            return this.isValid() ? this.getPsiClass().getFileStatus() : null;
        }

        private PsiClass getPsiClass() {
            return (PsiClass)this.myClassPointer.getElement();
        }

        public boolean isValid() {
            PsiClass psiClass = this.getPsiClass();
            return psiClass != null && psiClass.isValid();
        }

        public int hashCode() {
            return this.myQName.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof ClassUsageGroup && this.myQName.equals(((ClassUsageGroup)object).myQName);
        }

        public void navigate(boolean focus) throws UnsupportedOperationException {
            if (this.canNavigate()) {
                this.getPsiClass().navigate(focus);
            }
        }

        public boolean canNavigate() {
            return this.isValid();
        }

        public boolean canNavigateToSource() {
            return this.canNavigate();
        }

        public int compareTo(UsageGroup usageGroup) {
            return this.getText(null).compareTo(usageGroup.getText(null));
        }

        public void calcData(DataKey key, DataSink sink) {
            PsiClass psiClass;
            if (!this.isValid()) {
                return;
            }
            if (LangDataKeys.PSI_ELEMENT == key) {
                sink.put(LangDataKeys.PSI_ELEMENT, (Object)this.getPsiClass());
            }
            if (UsageView.USAGE_INFO_KEY == key && (psiClass = this.getPsiClass()) != null) {
                sink.put(UsageView.USAGE_INFO_KEY, (Object)new UsageInfo((PsiElement)psiClass));
            }
        }
    }
}

