/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.ui.content.ContentManager;

public class ContentManagerUtil {
    private ContentManagerUtil() {
    }

    public static ContentManager getContentManagerFromContext(DataContext dataContext, boolean requiresVisibleToolWindow) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        ToolWindowManagerEx mgr = ToolWindowManagerEx.getInstanceEx(project);
        String id = mgr.getActiveToolWindowId();
        if (id == null && mgr.isEditorComponentActive()) {
            id = mgr.getLastActiveToolWindowId();
        }
        if (id == null) {
            return null;
        }
        ToolWindowEx toolWindow = (ToolWindowEx)mgr.getToolWindow(id);
        if (requiresVisibleToolWindow && !toolWindow.isVisible()) {
            return null;
        }
        ContentManager fromContext = (ContentManager)PlatformDataKeys.CONTENT_MANAGER.getData(dataContext);
        if (fromContext != null) {
            return fromContext;
        }
        return toolWindow != null ? toolWindow.getContentManager() : null;
    }
}

