/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FocusTrackback {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.FocusTrackback");
    private Window myParentWindow;
    private Window myRoot;
    private Component myFocusOwner;
    private Component myLocalFocusOwner;
    private static final Map<Window, List<FocusTrackback>> ourRootWindowToParentsStack = new WeakHashMap<Window, List<FocusTrackback>>();
    private static final Map<Window, WeakReference<Component>> ourRootWindowToFocusedMap = new WeakHashMap<Window, WeakReference<Component>>();
    private String myRequestorName;
    private ComponentQuery myFocusedComponentQuery;
    private boolean myMustBeShown;
    private boolean myConsumed;
    private WeakReference myRequestor;
    private boolean mySheduledForRestore;
    private boolean myWillBeSheduledForRestore;

    public FocusTrackback(@NotNull Object requestor, Component parent, boolean mustBeShown) {
        if (requestor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/FocusTrackback.<init> must not be null");
        }
        this(requestor, SwingUtilities.getWindowAncestor(parent), mustBeShown);
    }

    public FocusTrackback(@NotNull Object requestor, Window parent, boolean mustBeShown) {
        if (requestor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/FocusTrackback.<init> must not be null");
        }
        this.myRequestor = new WeakReference<Object>(requestor);
        this.myRequestorName = requestor.toString();
        this.myParentWindow = parent;
        this.myMustBeShown = mustBeShown;
        Application app = ApplicationManager.getApplication();
        if (app == null || app.isUnitTestMode() || FocusTrackback.wrongOS()) {
            return;
        }
        this.register(parent);
        List<FocusTrackback> stack = FocusTrackback.getStackForRoot(this.myRoot);
        int index = stack.indexOf(this);
        assert (index >= 0) : this.myRequestorName;
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.setLocalFocusOwner(manager.getPermanentFocusOwner());
        if (index == 0) {
            FocusTrackback other;
            Window window;
            this.setFocusOwner(manager.getPermanentFocusOwner());
            if (this.getFocusOwner() == null && (window = manager.getActiveWindow()) instanceof Provider && (other = ((Provider)((Object)window)).getFocusTrackback()) != null) {
                this.setFocusOwner(other.getFocusOwner());
            }
        } else {
            this.setFocusOwner(stack.get(0).getFocusOwner());
        }
        if (stack.size() == 1 && this.getFocusOwner() == null) {
            this.setFocusOwner(FocusTrackback.getFocusFor(this.myRoot));
        } else if (index == 0 && this.getFocusOwner() != null) {
            FocusTrackback.setFocusFor(this.myRoot, this.getFocusOwner());
        }
    }

    private void setLocalFocusOwner(Component component) {
        this.myLocalFocusOwner = component;
    }

    private static Component getFocusFor(Window parent) {
        WeakReference<Component> ref = ourRootWindowToFocusedMap.get(parent);
        return ref != null ? (Component)ref.get() : null;
    }

    private static void setFocusFor(Window parent, Component focus) {
        ourRootWindowToFocusedMap.put(parent, new WeakReference<Component>(focus));
    }

    private static boolean wrongOS() {
        return false;
    }

    public void registerFocusComponent(final @NotNull Component focusedComponent) {
        if (focusedComponent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/FocusTrackback.registerFocusComponent must not be null");
        }
        this.registerFocusComponent(new ComponentQuery(){

            @Override
            public Component getComponent() {
                return focusedComponent;
            }
        });
    }

    public void registerFocusComponent(@NotNull ComponentQuery query) {
        if (query == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/FocusTrackback.registerFocusComponent must not be null");
        }
        this.myFocusedComponentQuery = query;
    }

    private void register(Window parent) {
        this.myRoot = FocusTrackback.findUtlimateParent(parent);
        List<FocusTrackback> stack = this.getCleanStackForRoot();
        stack.remove(this);
        stack.add(this);
    }

    private List<FocusTrackback> getCleanStackForRoot() {
        return FocusTrackback.getCleanStackForRoot(this.myRoot);
    }

    private static List<FocusTrackback> getCleanStackForRoot(Window root) {
        FocusTrackback[] stackArray;
        List<FocusTrackback> stack = FocusTrackback.getStackForRoot(root);
        for (FocusTrackback eachExisting : stackArray = stack.toArray(new FocusTrackback[stack.size()])) {
            if (eachExisting != null && eachExisting.isConsumed()) {
                eachExisting.dispose();
                continue;
            }
            if (eachExisting != null) continue;
            stack.remove(eachExisting);
        }
        return stack;
    }

    public void restoreFocus() {
        DataContext context;
        Application app = ApplicationManager.getApplication();
        if (app == null || FocusTrackback.wrongOS() || this.myConsumed || this.isSheduledForRestore()) {
            return;
        }
        Project project = null;
        DataContext dataContext = context = this.myParentWindow == null ? DataManager.getInstance().getDataContext() : DataManager.getInstance().getDataContext((Component)this.myParentWindow);
        if (context != null) {
            project = (Project)PlatformDataKeys.PROJECT.getData(context);
        }
        this.mySheduledForRestore = true;
        List<FocusTrackback> stack = this.getCleanStackForRoot();
        int index = stack.indexOf(this);
        for (int i = index - 1; i >= 0; --i) {
            if (!stack.get(i).isSheduledForRestore()) continue;
            this.dispose();
            return;
        }
        if (project != null && !project.isDisposed()) {
            IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)project);
            focusManager.requestFocus((FocusCommand)new MyFocusCommand(), false).doWhenProcessed(new Runnable(){

                @Override
                public void run() {
                    FocusTrackback.this.dispose();
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FocusTrackback.this._restoreFocus();
                    FocusTrackback.this.dispose();
                }
            });
        }
    }

    private void _restoreFocus() {
        List<FocusTrackback> stack = this.getCleanStack();
        if (!stack.contains(this)) {
            return;
        }
        Component toFocus = FocusTrackback.queryToFocus(stack, this, true);
        if (toFocus != null) {
            Window ownerBySwingWindow;
            Component ownerBySwing = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (ownerBySwing != null && (ownerBySwingWindow = SwingUtilities.getWindowAncestor(ownerBySwing)) != null && ownerBySwingWindow == SwingUtilities.getWindowAncestor(toFocus)) {
                toFocus = ownerBySwing;
            }
            if (this.myParentWindow != null) {
                Window to;
                Window window = to = toFocus instanceof Window ? (Window)toFocus : SwingUtilities.getWindowAncestor(toFocus);
                if (to != null && UIUtil.findUltimateParent((Component)to) == UIUtil.findUltimateParent((Component)this.myParentWindow)) {
                    toFocus.requestFocus();
                }
            } else {
                toFocus.requestFocus();
            }
        }
        stack.remove(this);
        this.dispose();
    }

    private static Component queryToFocus(List<FocusTrackback> stack, FocusTrackback trackback, boolean mustBeLastInStack) {
        int index = stack.indexOf(trackback);
        Component toFocus = null;
        if (trackback.myLocalFocusOwner != null && !(toFocus = trackback.myLocalFocusOwner).isShowing()) {
            toFocus = null;
        }
        if (toFocus == null) {
            ComponentQuery query;
            toFocus = index > 0 ? ((query = stack.get((int)(index - 1)).myFocusedComponentQuery) != null ? query.getComponent() : null) : trackback.getFocusOwner();
        }
        if (mustBeLastInStack) {
            for (int i = index + 1; i < stack.size(); ++i) {
                if (stack.get(i).isConsumed()) continue;
                toFocus = null;
                break;
            }
        }
        return toFocus;
    }

    private List<FocusTrackback> getCleanStack() {
        FocusTrackback[] all;
        List<FocusTrackback> stack = FocusTrackback.getStackForRoot(this.myRoot);
        for (FocusTrackback each : all = stack.toArray(new FocusTrackback[stack.size()])) {
            if (each != null && (each == this || !each.isConsumed())) continue;
            stack.remove(each);
        }
        return stack;
    }

    private static List<FocusTrackback> getStackForRoot(Window root) {
        List<FocusTrackback> stack = ourRootWindowToParentsStack.get(root);
        if (stack == null) {
            stack = new ArrayList<FocusTrackback>();
            ourRootWindowToParentsStack.put(root, stack);
        }
        return stack;
    }

    @Nullable
    private static Window findUtlimateParent(Window parent) {
        Container next;
        Window root;
        Window window = root = parent == null ? JOptionPane.getRootFrame() : parent;
        while (root != null && (next = root.getParent()) != null) {
            Window nextWindow;
            if (next instanceof Window) {
                root = (Window)next;
            }
            if ((nextWindow = SwingUtilities.getWindowAncestor(next)) == null) break;
            root = nextWindow;
        }
        return root;
    }

    @Nullable
    public Component getFocusOwner() {
        return this.myFocusOwner;
    }

    public String toString() {
        return this.getClass().getName() + " requestor: " + this.myRequestorName + " parent=" + this.myParentWindow;
    }

    public void dispose() {
        this.consume();
        FocusTrackback.getStackForRoot(this.myRoot).remove(this);
        this.mySheduledForRestore = false;
        this.myParentWindow = null;
        this.myRoot = null;
        this.myFocusOwner = null;
        this.myLocalFocusOwner = null;
    }

    private boolean isConsumed() {
        if (this.myConsumed) {
            return true;
        }
        if (this.myMustBeShown) {
            return !this.isSheduledForRestore() && this.myFocusedComponentQuery != null && this.myFocusedComponentQuery.getComponent() != null && !this.myFocusedComponentQuery.getComponent().isShowing();
        }
        return this.myParentWindow == null || !this.myParentWindow.isShowing();
    }

    public void consume() {
        this.myConsumed = true;
    }

    private void setFocusOwner(Component focusOwner) {
        this.myFocusOwner = focusOwner;
    }

    public void setMustBeShown(boolean mustBeShown) {
        this.myMustBeShown = mustBeShown;
    }

    public boolean isMustBeShown() {
        return this.myMustBeShown;
    }

    public static void release(@NotNull JFrame frame) {
        Window[] all;
        if (frame == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/FocusTrackback.release must not be null");
        }
        for (Window each : all = ourRootWindowToParentsStack.keySet().toArray(new Window[ourRootWindowToParentsStack.size()])) {
            if (each == null || each != frame && !SwingUtilities.isDescendingFrom(each, frame)) continue;
            ourRootWindowToParentsStack.remove(each);
        }
    }

    public Object getRequestor() {
        return this.myRequestor.get();
    }

    public void setWillBeSheduledForRestore() {
        this.myWillBeSheduledForRestore = true;
    }

    public boolean isSheduledForRestore() {
        return this.mySheduledForRestore;
    }

    public boolean isWillBeSheduledForRestore() {
        return this.myWillBeSheduledForRestore;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<JBPopup> getChildPopups(@NotNull Component component) {
        ArrayList<JBPopup> arrayList;
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/FocusTrackback.getChildPopups must not be null");
        }
        ArrayList<JBPopup> result = new ArrayList<JBPopup>();
        Window window = SwingUtilities.windowForComponent(component);
        if (window == null) {
            arrayList = result;
            if (arrayList == null) throw new IllegalStateException("@NotNull method com/intellij/ui/FocusTrackback.getChildPopups must not return null");
            return arrayList;
        }
        List<FocusTrackback> stack = FocusTrackback.getCleanStackForRoot(FocusTrackback.findUtlimateParent(window));
        for (FocusTrackback each : stack) {
            if (!each.isChildFor(component) || !(each.getRequestor() instanceof JBPopup)) continue;
            result.add((JBPopup)each.getRequestor());
        }
        arrayList = result;
        if (arrayList != null) return arrayList;
        throw new IllegalStateException("@NotNull method com/intellij/ui/FocusTrackback.getChildPopups must not return null");
    }

    private boolean isChildFor(Component parent) {
        Component toFocus = FocusTrackback.queryToFocus(this.getCleanStack(), this, false);
        if (toFocus == null) {
            return false;
        }
        if (parent == toFocus) {
            return true;
        }
        return SwingUtilities.isDescendingFrom(toFocus, parent);
    }

    private class MyFocusCommand
    extends FocusCommand {
        private MyFocusCommand() {
        }

        public ActionCallback run() {
            FocusTrackback.this._restoreFocus();
            return new ActionCallback.Done();
        }

        public boolean isExpired() {
            return FocusTrackback.this.isConsumed();
        }

        public String toString() {
            return "focus trackback";
        }
    }

    public static interface ComponentQuery {
        public Component getComponent();
    }

    public static interface Provider {
        public FocusTrackback getFocusTrackback();
    }
}

