/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.util.ImageLoader;
import com.intellij.util.ui.UIUtil;
import java.awt.Frame;
import java.awt.Image;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;

public class AppUIUtil {
    private AppUIUtil() {
    }

    public static void updateFrameIcon(Frame frame) {
        try {
            Method method = frame.getClass().getMethod("setIconImages", List.class);
            method.invoke((Object)frame, AppUIUtil.getAppIconImages());
        }
        catch (Exception e) {
            Image image = ImageLoader.loadFromResource((String)ApplicationInfoImpl.getShadowInstance().getOpaqueIconUrl());
            frame.setIconImage(image);
        }
    }

    public static List<Image> getAppIconImages() {
        ArrayList<Image> images = new ArrayList<Image>();
        images.add(ImageLoader.loadFromResource((String)ApplicationInfoImpl.getShadowInstance().getIconUrl()));
        images.add(ImageLoader.loadFromResource((String)ApplicationInfoImpl.getShadowInstance().getSmallIconUrl()));
        return images;
    }

    public static void updateDialogIcon(JDialog dialog) {
        UIUtil.updateDialogIcon((JDialog)dialog, AppUIUtil.getAppIconImages());
    }
}

