/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.SafeDeleteDialog;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegate;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.HashSet;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SafeDeleteHandler
implements RefactoringActionHandler {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"safe.delete.title");

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/safeDelete/SafeDeleteHandler.invoke must not be null");
        }
        PsiElement element = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (element == null || !SafeDeleteProcessor.validElement(element)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"is.not.supported.in.the.current.context", (Object[])new Object[]{REFACTORING_NAME}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.safeDelete");
            return;
        }
        this.invoke(project, new PsiElement[]{element}, dataContext);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/safeDelete/SafeDeleteHandler.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/safeDelete/SafeDeleteHandler.invoke must not be null");
        }
        SafeDeleteHandler.invoke(project, elements, true);
    }

    public static void invoke(Project project, PsiElement[] elements, boolean checkSuperMethods) {
        SafeDeleteHandler.invoke(project, elements, checkSuperMethods, null);
    }

    public static void invoke(final Project project, PsiElement[] elements, boolean checkSuperMethods, final @Nullable Runnable successRunnable) {
        for (PsiElement element : elements) {
            if (SafeDeleteProcessor.validElement(element)) continue;
            return;
        }
        PsiElement[] temptoDelete = PsiTreeUtil.filterAncestors((PsiElement[])elements);
        HashSet elementsSet = new HashSet(Arrays.asList(temptoDelete));
        HashSet fullElementsSet = new HashSet();
        if (checkSuperMethods) {
            for (PsiElement element : temptoDelete) {
                boolean found = false;
                for (SafeDeleteProcessorDelegate delegate : (SafeDeleteProcessorDelegate[])Extensions.getExtensions(SafeDeleteProcessorDelegate.EP_NAME)) {
                    if (!delegate.handlesElement(element)) continue;
                    found = true;
                    Collection<? extends PsiElement> addElements = delegate.getElementsToSearch(element, (Collection<PsiElement>)elementsSet);
                    if (addElements == null) {
                        return;
                    }
                    fullElementsSet.addAll(addElements);
                    break;
                }
                if (found) continue;
                fullElementsSet.add(element);
            }
        } else {
            fullElementsSet.addAll(Arrays.asList(temptoDelete));
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, (Collection)fullElementsSet)) {
            return;
        }
        final PsiElement[] elementsToDelete = fullElementsSet.toArray(new PsiElement[fullElementsSet.size()]);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            RefactoringSettings settings = RefactoringSettings.getInstance();
            SafeDeleteProcessor.createInstance(project, null, elementsToDelete, settings.SAFE_DELETE_SEARCH_IN_COMMENTS, settings.SAFE_DELETE_SEARCH_IN_NON_JAVA, true).run();
        } else {
            SafeDeleteDialog.Callback callback = new SafeDeleteDialog.Callback(){

                @Override
                public void run(final SafeDeleteDialog dialog) {
                    SafeDeleteProcessor.createInstance(project, new Runnable(){

                        @Override
                        public void run() {
                            if (successRunnable != null) {
                                successRunnable.run();
                            }
                            dialog.close(1);
                        }
                    }, elementsToDelete, dialog.isSearchInComments(), dialog.isSearchForTextOccurences(), true).run();
                }
            };
            SafeDeleteDialog dialog = new SafeDeleteDialog(project, elementsToDelete, callback);
            dialog.show();
        }
    }
}

