/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.ui.EnableDisableAction;
import com.intellij.refactoring.ui.StringTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.TableUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.util.ui.Table;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class AutomaticRenamingDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.AutomaticRenamingDialog");
    private static final int CHECK_COLUMN = 0;
    private static final int OLD_NAME_COLUMN = 1;
    private static final int NEW_NAME_COLUMN = 2;
    private final AutomaticRenamer myRenamer;
    private boolean[] myShouldRename;
    private String[] myNewNames;
    private PsiNamedElement[] myRenames;
    private MyTableModel myTableModel;
    private Table myTable;
    private JPanel myPanelForPreview;
    private JButton mySelectAllButton;
    private JButton myUnselectAllButton;
    private JPanel myPanel;
    private JSplitPane mySplitPane;
    private final Project myProject;
    private final UsagePreviewPanel myUsagePreviewPanel;
    private ListSelectionListener myListSelectionListener;

    public AutomaticRenamingDialog(Project project, AutomaticRenamer renamer) {
        super(project, true);
        this.myProject = project;
        this.myRenamer = renamer;
        this.$$$setupUI$$$();
        this.myUsagePreviewPanel = new UsagePreviewPanel(this.myProject);
        this.populateData();
        this.setTitle(this.myRenamer.getDialogTitle());
        this.init();
    }

    private void populateData() {
        int i;
        Map<PsiNamedElement, String> renames = this.myRenamer.getRenames();
        ArrayList<PsiNamedElement> temp = new ArrayList<PsiNamedElement>();
        for (PsiNamedElement namedElement : renames.keySet()) {
            String newName = renames.get(namedElement);
            if (newName == null) continue;
            temp.add(namedElement);
        }
        this.myRenames = temp.toArray(new PsiNamedElement[temp.size()]);
        Arrays.sort(this.myRenames, new Comparator<PsiNamedElement>(){

            @Override
            public int compare(PsiNamedElement e1, PsiNamedElement e2) {
                return Comparing.compare((Comparable)((Object)e1.getName()), (Comparable)((Object)e2.getName()));
            }
        });
        this.myNewNames = new String[this.myRenames.length];
        for (i = 0; i < this.myNewNames.length; ++i) {
            this.myNewNames[i] = renames.get(this.myRenames[i]);
        }
        this.myShouldRename = new boolean[this.myRenames.length];
        if (this.myRenamer.isSelectedByDefault()) {
            for (i = 0; i < this.myShouldRename.length; ++i) {
                this.myShouldRename[i] = true;
            }
        }
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.refactoring.rename.AutomaticRenamingDialog";
    }

    protected JComponent createNorthPanel() {
        Box box = Box.createHorizontalBox();
        box.add(new JLabel(this.myRenamer.getDialogDescription()));
        box.add(Box.createHorizontalGlue());
        return box;
    }

    public void show() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        super.show();
    }

    protected void handleChanges() {
    }

    protected JComponent createCenterPanel() {
        this.myTableModel = new MyTableModel();
        this.myTable.setModel((TableModel)this.myTableModel);
        this.myTableModel.getSpaceAction().register();
        this.myTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                AutomaticRenamingDialog.this.handleChanges();
            }
        });
        TableColumnModel columnModel = this.myTable.getColumnModel();
        columnModel.getColumn(0).setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        int checkBoxWidth = new JCheckBox().getPreferredSize().width;
        columnModel.getColumn(0).setMaxWidth(checkBoxWidth);
        columnModel.getColumn(0).setMinWidth(checkBoxWidth);
        columnModel.getColumn(2).setCellEditor(new StringTableCellEditor(this.myProject));
        this.mySelectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < AutomaticRenamingDialog.this.myShouldRename.length; ++i) {
                    ((AutomaticRenamingDialog)AutomaticRenamingDialog.this).myShouldRename[i] = true;
                }
                AutomaticRenamingDialog.this.fireDataChanged();
            }
        });
        this.myUnselectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < AutomaticRenamingDialog.this.myShouldRename.length; ++i) {
                    ((AutomaticRenamingDialog)AutomaticRenamingDialog.this).myShouldRename[i] = false;
                }
                AutomaticRenamingDialog.this.fireDataChanged();
            }
        });
        this.myListSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = AutomaticRenamingDialog.this.myTable.getSelectionModel().getLeadSelectionIndex();
                if (index != -1) {
                    PsiNamedElement element = AutomaticRenamingDialog.this.myRenames[index];
                    UsageInfo usageInfo = new UsageInfo((PsiElement)element);
                    AutomaticRenamingDialog.this.myUsagePreviewPanel.updateLayout(Collections.singletonList(usageInfo));
                } else {
                    AutomaticRenamingDialog.this.myUsagePreviewPanel.updateLayout(null);
                }
            }
        };
        this.myTable.getSelectionModel().addListSelectionListener(this.myListSelectionListener);
        this.myPanelForPreview.add((Component)this.myUsagePreviewPanel, "Center");
        this.myUsagePreviewPanel.updateLayout(null);
        this.mySplitPane.setDividerLocation(0.5);
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.myPanel);
        if (this.myTableModel.getRowCount() != 0) {
            this.myTable.getSelectionModel().addSelectionInterval(0, 0);
        }
        return this.myPanel;
    }

    private void fireDataChanged() {
        int[] selectedRows = this.myTable.getSelectedRows();
        this.myTable.getSelectionModel().removeListSelectionListener(this.myListSelectionListener);
        this.myTableModel.fireTableDataChanged();
        for (int selectedRow : selectedRows) {
            this.myTable.addRowSelectionInterval(selectedRow, selectedRow);
        }
        this.myTable.getSelectionModel().addListSelectionListener(this.myListSelectionListener);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    protected void doOKAction() {
        TableUtil.stopEditing((JTable)this.myTable);
        this.updateRenamer();
        super.doOKAction();
    }

    protected void dispose() {
        Disposer.dispose((Disposable)this.myUsagePreviewPanel);
        super.dispose();
    }

    private void updateRenamer() {
        for (int i = 0; i < this.myRenames.length; ++i) {
            PsiNamedElement element = this.myRenames[i];
            if (this.myShouldRename[i]) {
                this.myRenamer.setRename(element, this.myNewNames[i]);
                continue;
            }
            this.myRenamer.doNotRename(element);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        Table table;
        JPanel jPanel;
        JSplitPane jSplitPane;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySplitPane = jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(300);
        jSplitPane.setOrientation(0);
        jPanel2.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        this.myPanelForPreview = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jSplitPane.setRightComponent(jPanel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setLeftComponent(jPanel3);
        JScrollPane jScrollPane = new JScrollPane();
        jPanel3.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 3, 0, 1, 7, 3, null, null, null));
        this.myTable = table = new Table();
        jScrollPane.setViewportView((Component)table);
        this.mySelectAllButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/RefactoringBundle").getString("select.all.button"));
        jPanel3.add((Component)jButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myUnselectAllButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/RefactoringBundle").getString("unselect.all.button"));
        jPanel3.add((Component)jButton, new GridConstraints(1, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return AutomaticRenamingDialog.this.myShouldRename.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return AutomaticRenamingDialog.this.myShouldRename[rowIndex];
                }
                case 1: {
                    ItemPresentation presentation;
                    PsiNamedElement namedElement = AutomaticRenamingDialog.this.myRenames[rowIndex];
                    String location = null;
                    if (namedElement instanceof NavigationItem && (presentation = ((NavigationItem)namedElement).getPresentation()) != null) {
                        location = presentation.getLocationString();
                    }
                    return namedElement.getName() + (location != null ? " " + location : "");
                }
                case 2: {
                    return AutomaticRenamingDialog.this.myNewNames[rowIndex];
                }
            }
            LOG.assertTrue(false);
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    ((AutomaticRenamingDialog)AutomaticRenamingDialog.this).myShouldRename[rowIndex] = (Boolean)aValue;
                    break;
                }
                case 2: {
                    ((AutomaticRenamingDialog)AutomaticRenamingDialog.this).myNewNames[rowIndex] = (String)aValue;
                    break;
                }
                default: {
                    LOG.assertTrue(false);
                }
            }
            AutomaticRenamingDialog.this.handleChanges();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 1;
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 1: {
                    return RefactoringBundle.message((String)"automatic.renamer.enity.name.column", (Object[])new Object[]{AutomaticRenamingDialog.this.myRenamer.entityName()});
                }
                case 2: {
                    return RefactoringBundle.message((String)"automatic.renamer.rename.to.column");
                }
            }
            return " ";
        }

        private MyEnableDisable getSpaceAction() {
            return new MyEnableDisable();
        }

        private class MyEnableDisable
        extends EnableDisableAction {
            private MyEnableDisable() {
            }

            @Override
            protected JTable getTable() {
                return AutomaticRenamingDialog.this.myTable;
            }

            @Override
            protected boolean isRowChecked(int row) {
                return AutomaticRenamingDialog.this.myShouldRename[row];
            }

            @Override
            protected void applyValue(int[] rows, boolean valueToBeSet) {
                for (int row : rows) {
                    ((AutomaticRenamingDialog)AutomaticRenamingDialog.this).myShouldRename[row] = valueToBeSet;
                }
                AutomaticRenamingDialog.this.fireDataChanged();
            }
        }
    }
}

