/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveInner;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveInner.MoveInnerViewDescriptor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveInnerProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveInner.MoveInnerProcessor");
    private MoveCallback myMoveCallback;
    private PsiClass myInnerClass;
    private PsiClass myOuterClass;
    private PsiElement myTargetContainer;
    private String myParameterNameOuterClass;
    private String myFieldNameOuterClass;
    private String myDescriptiveName = "";
    private String myNewClassName;
    private boolean mySearchInComments;
    private boolean mySearchInNonJavaFiles;
    private NonCodeUsageInfo[] myNonCodeUsages;

    public MoveInnerProcessor(Project project, MoveCallback moveCallback) {
        super(project);
        this.myMoveCallback = moveCallback;
    }

    public MoveInnerProcessor(Project project, PsiClass innerClass, String name, boolean passOuterClass, String parameterName, PsiElement targetContainer) {
        super(project);
        this.setup(innerClass, name, passOuterClass, parameterName, true, true, targetContainer);
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"move.inner.class.command", (Object[])new Object[]{this.myDescriptiveName});
    }

    @Override
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        return new MoveInnerViewDescriptor(this.myInnerClass);
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        String newQName;
        LOG.assertTrue(this.myTargetContainer != null);
        Collection innerClassRefs = ReferencesSearch.search((PsiElement)this.myInnerClass).findAll();
        ArrayList<UsageInfo> usageInfos = new ArrayList<UsageInfo>(innerClassRefs.size());
        for (PsiReference innerClassRef : innerClassRefs) {
            PsiElement ref = innerClassRef.getElement();
            if (PsiTreeUtil.isAncestor((PsiElement)this.myInnerClass, (PsiElement)ref, (boolean)true)) continue;
            usageInfos.add(new UsageInfo(ref));
        }
        if (this.myTargetContainer instanceof PsiDirectory) {
            PsiDirectory targetDirectory = (PsiDirectory)this.myTargetContainer;
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(targetDirectory);
            LOG.assertTrue(aPackage != null);
            newQName = aPackage.getQualifiedName() + "." + this.myNewClassName;
        } else {
            String qName;
            newQName = this.myTargetContainer instanceof PsiClass ? ((qName = ((PsiClass)this.myTargetContainer).getQualifiedName()) != null ? qName + "." + this.myNewClassName : this.myNewClassName) : this.myNewClassName;
        }
        MoveClassesOrPackagesUtil.findNonCodeUsages(this.mySearchInComments, this.mySearchInNonJavaFiles, (PsiElement)this.myInnerClass, newQName, usageInfos);
        UsageInfo[] usageInfoArray = usageInfos.toArray(new UsageInfo[usageInfos.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/move/moveInner/MoveInnerProcessor.findUsages must not return null");
        }
        return usageInfoArray;
    }

    @Override
    protected void refreshElements(PsiElement[] elements) {
        boolean condition = elements.length == 1 && elements[0] instanceof PsiClass;
        LOG.assertTrue(condition);
        this.myInnerClass = (PsiClass)elements[0];
    }

    public boolean isSearchInComments() {
        return this.mySearchInComments;
    }

    public void setSearchInComments(boolean searchInComments) {
        this.mySearchInComments = searchInComments;
    }

    public boolean isSearchInNonJavaFiles() {
        return this.mySearchInNonJavaFiles;
    }

    public void setSearchInNonJavaFiles(boolean searchInNonJavaFiles) {
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
    }

    @Override
    protected void performRefactoring(UsageInfo[] usages) {
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        RefactoringElementListener elementListener = this.getTransaction().getElementListener((PsiElement)this.myInnerClass);
        String newClassName = this.myNewClassName;
        try {
            PsiClass newClass;
            PsiField field = null;
            if (this.myParameterNameOuterClass != null) {
                field = factory.createField(this.myFieldNameOuterClass, (PsiType)factory.createType(this.myOuterClass));
                field = (PsiField)this.myInnerClass.add((PsiElement)field);
                this.myInnerClass = field.getContainingClass();
                this.addFieldInitializationToConstructors(this.myInnerClass, field, this.myParameterNameOuterClass);
            }
            ChangeContextUtil.encodeContextInfo((PsiElement)this.myInnerClass, false);
            if (this.myTargetContainer instanceof PsiDirectory) {
                PsiMethod[] constructors;
                this.myInnerClass = CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement(this.myInnerClass);
                newClass = JavaDirectoryService.getInstance().createClass((PsiDirectory)this.myTargetContainer, newClassName);
                PsiDocComment defaultDocComment = newClass.getDocComment();
                if (defaultDocComment != null && this.myInnerClass.getDocComment() == null) {
                    this.myInnerClass = (PsiClass)this.myInnerClass.addAfter((PsiElement)defaultDocComment, null).getParent();
                }
                newClass = (PsiClass)newClass.replace((PsiElement)this.myInnerClass);
                PsiUtil.setModifierProperty((PsiModifierListOwner)newClass, (String)"static", (boolean)false);
                PsiUtil.setModifierProperty((PsiModifierListOwner)newClass, (String)"private", (boolean)false);
                PsiUtil.setModifierProperty((PsiModifierListOwner)newClass, (String)"protected", (boolean)false);
                boolean makePublic = this.needPublicAccess();
                if (makePublic) {
                    PsiUtil.setModifierProperty((PsiModifierListOwner)newClass, (String)"public", (boolean)true);
                }
                for (PsiMethod constructor : constructors = newClass.getConstructors()) {
                    PsiModifierList modifierList = constructor.getModifierList();
                    modifierList.setModifierProperty("private", false);
                    modifierList.setModifierProperty("protected", false);
                    if (!makePublic) continue;
                    modifierList.setModifierProperty("public", true);
                }
            } else {
                newClass = (PsiClass)this.myTargetContainer.add((PsiElement)this.myInnerClass);
            }
            newClass.setName(newClassName);
            for (PsiReference ref : ReferencesSearch.search((PsiElement)this.myInnerClass, (SearchScope)new LocalSearchScope((PsiElement)newClass), (boolean)true)) {
                PsiJavaCodeReferenceElement parentRef;
                PsiElement parentRefElement;
                PsiElement element = ref.getElement();
                if (element.getParent() instanceof PsiJavaCodeReferenceElement && (parentRefElement = (parentRef = (PsiJavaCodeReferenceElement)element.getParent()).resolve()) instanceof PsiClass) {
                    parentRef.getQualifier().delete();
                    continue;
                }
                ref.bindToElement((PsiElement)newClass);
            }
            ArrayList<PsiReference> referencesToRebind = new ArrayList<PsiReference>();
            for (UsageInfo usage : usages) {
                PsiReference[] references;
                if (usage.isNonCodeUsage) continue;
                PsiElement refElement = usage.getElement();
                for (PsiReference reference : references = refElement.getReferences()) {
                    if (!reference.isReferenceTo((PsiElement)this.myInnerClass)) continue;
                    referencesToRebind.add(reference);
                }
            }
            this.myInnerClass.delete();
            for (UsageInfo usage : usages) {
                PsiNewExpression newExpr;
                PsiExpressionList argList;
                PsiElement refParent;
                if (usage.isNonCodeUsage) continue;
                PsiElement refElement = usage.getElement();
                if (this.myParameterNameOuterClass == null || !((refParent = refElement.getParent()) instanceof PsiNewExpression) && !(refParent instanceof PsiAnonymousClass) || (argList = (newExpr = refParent instanceof PsiNewExpression ? (PsiNewExpression)refParent : (PsiNewExpression)refParent.getParent()).getArgumentList()) == null) continue;
                if (newExpr.getQualifier() == null) {
                    PsiClass parentClass = RefactoringUtil.getThisClass((PsiElement)newExpr);
                    PsiThisExpression thisExpr = this.myOuterClass.equals(parentClass) ? RefactoringUtil.createThisExpression(manager, null) : RefactoringUtil.createThisExpression(manager, this.myOuterClass);
                    argList.addAfter((PsiElement)thisExpr, null);
                    continue;
                }
                argList.addAfter((PsiElement)newExpr.getQualifier(), null);
                newExpr.getQualifier().delete();
            }
            for (PsiReference reference : referencesToRebind) {
                reference.bindToElement((PsiElement)newClass);
            }
            if (field != null) {
                PsiExpression paramAccessExpression = factory.createExpressionFromText(this.myParameterNameOuterClass, null);
                for (PsiMethod constructor : newClass.getConstructors()) {
                    String text;
                    PsiExpression expression;
                    PsiStatement[] statements = constructor.getBody().getStatements();
                    if (statements.length <= 0 || !(statements[0] instanceof PsiExpressionStatement) || !((expression = ((PsiExpressionStatement)statements[0]).getExpression()) instanceof PsiMethodCallExpression) || !"this".equals(text = ((PsiMethodCallExpression)expression).getMethodExpression().getText()) && !"super".equals(text)) continue;
                    ChangeContextUtil.decodeContextInfo((PsiElement)expression, this.myOuterClass, paramAccessExpression);
                }
                PsiExpression accessExpression = factory.createExpressionFromText(this.myFieldNameOuterClass, null);
                ChangeContextUtil.decodeContextInfo((PsiElement)newClass, this.myOuterClass, accessExpression);
            } else {
                ChangeContextUtil.decodeContextInfo((PsiElement)newClass, null, null);
            }
            PsiFile targetFile = newClass.getContainingFile();
            OpenFileDescriptor descriptor = new OpenFileDescriptor(this.myProject, targetFile.getVirtualFile(), newClass.getTextOffset());
            FileEditorManager.getInstance((Project)this.myProject).openTextEditor(descriptor, true);
            if (this.myMoveCallback != null) {
                this.myMoveCallback.refactoringCompleted();
            }
            elementListener.elementMoved((PsiElement)newClass);
            ArrayList<NonCodeUsageInfo> nonCodeUsages = new ArrayList<NonCodeUsageInfo>();
            for (UsageInfo usage : usages) {
                if (!(usage instanceof NonCodeUsageInfo)) continue;
                nonCodeUsages.add((NonCodeUsageInfo)usage);
            }
            this.myNonCodeUsages = nonCodeUsages.toArray(new NonCodeUsageInfo[nonCodeUsages.size()]);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private boolean needPublicAccess() {
        PsiPackage targetPackage;
        if (this.myOuterClass.isInterface()) {
            return true;
        }
        return this.myTargetContainer instanceof PsiDirectory && (targetPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)this.myTargetContainer)) != null && !MoveInnerProcessor.isInPackage(this.myOuterClass.getContainingFile(), targetPackage);
    }

    @Override
    protected void performPsiSpoilingRefactoring() {
        if (this.myNonCodeUsages != null) {
            RenameUtil.renameNonCodeUsages(this.myProject, this.myNonCodeUsages);
        }
    }

    @Override
    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        final MultiMap conflicts = new MultiMap();
        class Visitor
        extends JavaRecursiveElementWalkingVisitor {
            private final HashMap<PsiElement, HashSet<PsiElement>> reported = new HashMap();

            Visitor() {
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                PsiElement resolved = reference.resolve();
                if (resolved instanceof PsiMember && PsiTreeUtil.isAncestor((PsiElement)MoveInnerProcessor.this.myInnerClass, (PsiElement)resolved, (boolean)true) && this.becomesInaccessible((PsiMember)resolved)) {
                    PsiElement container = ConflictsUtil.getContainer((PsiElement)reference);
                    HashSet<PsiElement> containerSet = (HashSet<PsiElement>)this.reported.get((Object)resolved);
                    if (containerSet == null) {
                        containerSet = new HashSet<PsiElement>();
                        this.reported.put((Object)resolved, containerSet);
                    }
                    if (!containerSet.contains(container)) {
                        containerSet.add(container);
                        String message = RefactoringBundle.message((String)"0.will.become.inaccessible.from.1", (Object[])new Object[]{RefactoringUIUtil.getDescription(resolved, true), RefactoringUIUtil.getDescription(container, true)});
                        conflicts.putValue((Object)resolved, (Object)message);
                    }
                }
            }

            private boolean becomesInaccessible(PsiMember element) {
                PsiDirectory containingDirectory;
                String visibilityModifier = VisibilityUtil.getVisibilityModifier((PsiModifierList)element.getModifierList());
                if ("private".equals(visibilityModifier)) {
                    return true;
                }
                if ("public".equals(visibilityModifier)) {
                    return false;
                }
                PsiFile containingFile = MoveInnerProcessor.this.myOuterClass.getContainingFile();
                if (MoveInnerProcessor.this.myTargetContainer instanceof PsiDirectory) {
                    PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)MoveInnerProcessor.this.myTargetContainer);
                    return !MoveInnerProcessor.isInPackage(containingFile, aPackage);
                }
                PsiFile targetFile = MoveInnerProcessor.this.myTargetContainer.getContainingFile();
                if (targetFile != null && (containingDirectory = targetFile.getContainingDirectory()) != null) {
                    PsiPackage targetPackage = JavaDirectoryService.getInstance().getPackage(containingDirectory);
                    return MoveInnerProcessor.isInPackage(containingFile, targetPackage);
                }
                return false;
            }

            public void visitClass(PsiClass aClass) {
                if (aClass == MoveInnerProcessor.this.myInnerClass) {
                    return;
                }
                super.visitClass(aClass);
            }
        }
        this.myOuterClass.accept((PsiElementVisitor)new Visitor());
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts);
    }

    private static boolean isInPackage(PsiFile containingFile, PsiPackage aPackage) {
        PsiPackage filePackage;
        PsiDirectory containingDirectory;
        return containingFile == null || (containingDirectory = containingFile.getContainingDirectory()) == null || (filePackage = JavaDirectoryService.getInstance().getPackage(containingDirectory)) == null || filePackage.getQualifiedName().equals(aPackage.getQualifiedName());
    }

    public void setup(PsiClass innerClass, String className, boolean passOuterClass, String parameterName, boolean searchInComments, boolean searchInNonJava, @NotNull PsiElement targetContainer) {
        if (targetContainer == null) {
            throw new IllegalArgumentException("Argument 6 for @NotNull parameter of com/intellij/refactoring/move/moveInner/MoveInnerProcessor.setup must not be null");
        }
        this.myNewClassName = className;
        this.myInnerClass = innerClass;
        this.myDescriptiveName = UsageViewUtil.getDescriptiveName((PsiElement)this.myInnerClass);
        this.myOuterClass = this.myInnerClass.getContainingClass();
        this.myTargetContainer = targetContainer;
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
        String string = this.myParameterNameOuterClass = passOuterClass ? parameterName : null;
        if (this.myParameterNameOuterClass != null) {
            this.myFieldNameOuterClass = codeStyleManager.variableNameToPropertyName(this.myParameterNameOuterClass, VariableKind.PARAMETER);
            this.myFieldNameOuterClass = codeStyleManager.propertyNameToVariableName(this.myFieldNameOuterClass, VariableKind.FIELD);
        }
        this.mySearchInComments = searchInComments;
        this.mySearchInNonJavaFiles = searchInNonJava;
    }

    private void addFieldInitializationToConstructors(PsiClass aClass, PsiField field, String parameterName) throws IncorrectOperationException {
        PsiMethod[] constructors = aClass.getConstructors();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
        if (constructors.length > 0) {
            for (PsiMethod constructor : constructors) {
                String text;
                PsiExpression expression;
                PsiStatement first;
                PsiStatement[] statements;
                PsiCodeBlock body;
                if (parameterName != null) {
                    PsiParameterList parameterList = constructor.getParameterList();
                    PsiParameter parameter = factory.createParameter(parameterName, field.getType());
                    parameterList.addAfter((PsiElement)parameter, null);
                }
                if ((body = constructor.getBody()) == null || (statements = body.getStatements()).length > 0 && (first = statements[0]) instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)first).getExpression()) instanceof PsiMethodCallExpression && "this".equals(text = ((PsiMethodCallExpression)expression).getMethodExpression().getText())) continue;
                this.createAssignmentStatement(constructor, field.getName(), parameterName);
            }
        } else {
            PsiMethod constructor = factory.createConstructor();
            if (parameterName != null) {
                PsiParameterList parameterList = constructor.getParameterList();
                PsiParameter parameter = factory.createParameter(parameterName, field.getType());
                parameterList.add((PsiElement)parameter);
            }
            this.createAssignmentStatement(constructor, field.getName(), parameterName);
            aClass.add((PsiElement)constructor);
        }
    }

    private PsiStatement createAssignmentStatement(PsiMethod constructor, String fieldname, String parameterName) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
        String pattern = fieldname + "=a;";
        if (fieldname.equals(parameterName)) {
            pattern = "this." + pattern;
        }
        PsiExpressionStatement statement = (PsiExpressionStatement)factory.createStatementFromText(pattern, null);
        statement = (PsiExpressionStatement)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)statement);
        PsiCodeBlock body = constructor.getBody();
        statement = (PsiExpressionStatement)body.addAfter((PsiElement)statement, MoveInnerProcessor.getAnchorElement(body));
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)statement.getExpression();
        PsiReferenceExpression rExpr = (PsiReferenceExpression)assignment.getRExpression();
        PsiIdentifier identifier = (PsiIdentifier)rExpr.getReferenceNameElement();
        identifier.replace((PsiElement)factory.createIdentifier(parameterName));
        return statement;
    }

    @Nullable
    private static PsiElement getAnchorElement(PsiCodeBlock body) {
        PsiReferenceExpression methodCall;
        String text;
        PsiExpression expression;
        PsiStatement first;
        PsiStatement[] statements = body.getStatements();
        if (statements.length > 0 && (first = statements[0]) instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)first).getExpression()) instanceof PsiMethodCallExpression && "super".equals(text = (methodCall = ((PsiMethodCallExpression)expression).getMethodExpression()).getText())) {
            return first;
        }
        return null;
    }

    public PsiClass getInnerClass() {
        return this.myInnerClass;
    }

    public String getNewClassName() {
        return this.myNewClassName;
    }

    public boolean shouldPassParameter() {
        return this.myParameterNameOuterClass != null;
    }

    public String getParameterName() {
        return this.myParameterNameOuterClass;
    }
}

