/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.util.Function;

public class PsiExpressionTrimRenderer
extends JavaRecursiveElementWalkingVisitor {
    private final StringBuilder myBuf;

    public PsiExpressionTrimRenderer(StringBuilder buf) {
        this.myBuf = buf;
    }

    public void visitExpression(PsiExpression expression) {
        this.myBuf.append(expression.getText());
    }

    public void visitInstanceOfExpression(PsiInstanceOfExpression expression) {
        expression.getOperand().accept((PsiElementVisitor)this);
        this.myBuf.append(" ").append("instanceof").append(" ");
        PsiTypeElement checkType = expression.getCheckType();
        if (checkType != null) {
            this.myBuf.append(checkType.getText());
        }
    }

    public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
        this.myBuf.append("(");
        PsiExpression expr = expression.getExpression();
        if (expr != null) {
            expr.accept((PsiElementVisitor)this);
        }
        this.myBuf.append(")");
    }

    public void visitTypeCastExpression(PsiTypeCastExpression expression) {
        PsiExpression operand;
        PsiTypeElement castType = expression.getCastType();
        if (castType != null) {
            this.myBuf.append("(").append(castType.getText()).append(")");
        }
        if ((operand = expression.getOperand()) != null) {
            operand.accept((PsiElementVisitor)this);
        }
    }

    public void visitArrayAccessExpression(PsiArrayAccessExpression expression) {
        expression.getArrayExpression().accept((PsiElementVisitor)this);
        this.myBuf.append("[");
        PsiExpression indexExpression = expression.getIndexExpression();
        if (indexExpression != null) {
            indexExpression.accept((PsiElementVisitor)this);
        }
        this.myBuf.append("]");
    }

    public void visitPrefixExpression(PsiPrefixExpression expression) {
        this.myBuf.append(expression.getOperationSign().getText());
        PsiExpression operand = expression.getOperand();
        if (operand != null) {
            operand.accept((PsiElementVisitor)this);
        }
    }

    public void visitPostfixExpression(PsiPostfixExpression expression) {
        expression.getOperand().accept((PsiElementVisitor)this);
        this.myBuf.append(expression.getOperationSign().getText());
    }

    public void visitBinaryExpression(PsiBinaryExpression expression) {
        expression.getLOperand().accept((PsiElementVisitor)this);
        this.myBuf.append(" ").append(expression.getOperationSign().getText()).append(" ");
        PsiExpression rOperand = expression.getROperand();
        if (rOperand != null) {
            rOperand.accept((PsiElementVisitor)this);
        }
    }

    public void visitConditionalExpression(PsiConditionalExpression expression) {
        expression.getCondition().accept((PsiElementVisitor)this);
        this.myBuf.append(" ? ");
        PsiExpression thenExpression = expression.getThenExpression();
        if (thenExpression != null) {
            thenExpression.accept((PsiElementVisitor)this);
        }
        this.myBuf.append(" : ");
        PsiExpression elseExpression = expression.getElseExpression();
        if (elseExpression != null) {
            elseExpression.accept((PsiElementVisitor)this);
        }
    }

    public void visitAssignmentExpression(PsiAssignmentExpression expression) {
        expression.getLExpression().accept((PsiElementVisitor)this);
        this.myBuf.append(expression.getOperationSign().getText());
        PsiExpression rExpression = expression.getRExpression();
        if (rExpression != null) {
            rExpression.accept((PsiElementVisitor)this);
        }
    }

    public void visitReferenceExpression(PsiReferenceExpression expr) {
        PsiExpression qualifierExpression = expr.getQualifierExpression();
        if (qualifierExpression != null) {
            qualifierExpression.accept((PsiElementVisitor)this);
            this.myBuf.append(".");
        }
        this.myBuf.append(expr.getReferenceName());
    }

    public void visitMethodCallExpression(PsiMethodCallExpression expr) {
        expr.getMethodExpression().accept((PsiElementVisitor)this);
        expr.getArgumentList().accept((PsiElementVisitor)this);
    }

    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
        this.myBuf.append("{");
        boolean first = true;
        for (PsiExpression expr : expression.getInitializers()) {
            if (!first) {
                this.myBuf.append(", ");
            }
            first = false;
            expr.accept((PsiElementVisitor)this);
        }
        this.myBuf.append("}");
    }

    public void visitExpressionList(PsiExpressionList list) {
        PsiExpression[] args = list.getExpressions();
        if (args.length > 0) {
            this.myBuf.append("(...)");
        } else {
            this.myBuf.append("()");
        }
    }

    public void visitNewExpression(PsiNewExpression expr) {
        PsiAnonymousClass anonymousClass = expr.getAnonymousClass();
        PsiExpressionList argumentList = expr.getArgumentList();
        if (anonymousClass != null) {
            this.myBuf.append("new").append(" ").append(anonymousClass.getBaseClassType().getPresentableText());
            if (argumentList != null) {
                argumentList.accept((PsiElementVisitor)this);
            }
            this.myBuf.append(" {...}");
        } else {
            PsiJavaCodeReferenceElement reference = expr.getClassReference();
            if (reference != null) {
                PsiArrayInitializerExpression arrayInitializer;
                this.myBuf.append("new").append(" ").append(reference.getText());
                PsiExpression[] arrayDimensions = expr.getArrayDimensions();
                if (arrayDimensions.length > 0) {
                    this.myBuf.append("[");
                }
                boolean first = true;
                for (PsiExpression dimension : arrayDimensions) {
                    if (!first) {
                        this.myBuf.append(", ");
                    }
                    first = false;
                    dimension.accept((PsiElementVisitor)this);
                }
                if (arrayDimensions.length > 0) {
                    this.myBuf.append("]");
                }
                if (argumentList != null) {
                    argumentList.accept((PsiElementVisitor)this);
                }
                if ((arrayInitializer = expr.getArrayInitializer()) != null) {
                    arrayInitializer.accept((PsiElementVisitor)this);
                }
            } else {
                this.myBuf.append(expr.getText());
            }
        }
    }

    public static class RenderFunction
    implements Function<PsiExpression, String> {
        public String fun(PsiExpression psiExpression) {
            StringBuilder buf = new StringBuilder();
            psiExpression.accept((PsiElementVisitor)new PsiExpressionTrimRenderer(buf));
            return buf.toString();
        }
    }
}

