/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.extractMethod.ParametersFolder;
import com.intellij.refactoring.util.ParameterTablePanel;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class InputVariables {
    private final List<ParameterTablePanel.VariableData> myInputVariables;
    private List<? extends PsiVariable> myInitialParameters;
    private final Project myProject;
    private final LocalSearchScope myScope;
    private ParametersFolder myFolding;
    private boolean myFoldingAvailable;

    public InputVariables(List<? extends PsiVariable> inputVariables, Project project, LocalSearchScope scope, boolean foldingAvailable) {
        this.myInitialParameters = inputVariables;
        this.myProject = project;
        this.myScope = scope;
        this.myFoldingAvailable = foldingAvailable;
        this.myFolding = new ParametersFolder();
        this.myInputVariables = this.wrapInputVariables(inputVariables);
    }

    public InputVariables(List<ParameterTablePanel.VariableData> inputVariables, Project project, LocalSearchScope scope) {
        this.myProject = project;
        this.myScope = scope;
        this.myInputVariables = new ArrayList<ParameterTablePanel.VariableData>(inputVariables);
    }

    public boolean isFoldable() {
        return this.myFolding.isFoldable();
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<ParameterTablePanel.VariableData> wrapInputVariables(List<? extends PsiVariable> inputVariables) {
        ArrayList<ParameterTablePanel.VariableData> inputData = new ArrayList<ParameterTablePanel.VariableData>(inputVariables.size());
        for (PsiVariable psiVariable : inputVariables) {
            PsiType type;
            String name = psiVariable.getName();
            if (!(psiVariable instanceof PsiParameter)) {
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
                VariableKind kind = codeStyleManager.getVariableKind(psiVariable);
                name = codeStyleManager.variableNameToPropertyName(name, kind);
                name = codeStyleManager.propertyNameToVariableName(name, VariableKind.PARAMETER);
            }
            if ((type = psiVariable.getType()) instanceof PsiEllipsisType) {
                type = ((PsiEllipsisType)type).toArrayType();
            }
            ParameterTablePanel.VariableData data = new ParameterTablePanel.VariableData(psiVariable, type);
            data.name = name;
            data.passAsParameter = true;
            inputData.add(data);
            if (!this.myFoldingAvailable) continue;
            this.myFolding.isParameterFoldable(data, this.myScope, inputVariables);
        }
        if (this.myFoldingAvailable) {
            void var4_6;
            HashSet<ParameterTablePanel.VariableData> toDelete = new HashSet<ParameterTablePanel.VariableData>();
            int n = inputData.size() - 1;
            while (var4_6 >= 0) {
                ParameterTablePanel.VariableData data = inputData.get((int)var4_6);
                if (this.myFolding.isParameterSafeToDelete(data, this.myScope)) {
                    toDelete.add(data);
                }
                --var4_6;
            }
            inputData.removeAll(toDelete);
        }
        return inputData;
    }

    public List<ParameterTablePanel.VariableData> getInputVariables() {
        return this.myInputVariables;
    }

    public PsiExpression replaceWrappedReferences(PsiElement[] elements, PsiExpression expression) {
        if (!this.myFoldingAvailable) {
            return expression;
        }
        boolean update = elements[0] == expression;
        for (ParameterTablePanel.VariableData inputVariable : this.myInputVariables) {
            this.myFolding.foldParameterUsagesInBody(inputVariable, elements, (SearchScope)this.myScope);
        }
        return update ? (PsiExpression)elements[0] : expression;
    }

    public boolean toDeclareInsideBody(PsiVariable variable) {
        ArrayList<ParameterTablePanel.VariableData> knownVars = new ArrayList<ParameterTablePanel.VariableData>(this.myInputVariables);
        for (ParameterTablePanel.VariableData data : knownVars) {
            if (!data.variable.equals(variable)) continue;
            return false;
        }
        return !this.myFolding.wasExcluded(variable);
    }

    public boolean contains(PsiVariable variable) {
        for (ParameterTablePanel.VariableData data : this.myInputVariables) {
            if (!data.variable.equals(variable)) continue;
            return true;
        }
        return false;
    }

    public void removeParametersUsedInExitsOnly(PsiElement codeFragment, Collection<PsiStatement> exitStatements, ControlFlow controlFlow, int startOffset, int endOffset) {
        LocalSearchScope scope = new LocalSearchScope(codeFragment);
        Iterator<ParameterTablePanel.VariableData> iterator = this.myInputVariables.iterator();
        block0: while (iterator.hasNext()) {
            ParameterTablePanel.VariableData data = iterator.next();
            for (PsiReference ref : ReferencesSearch.search((PsiElement)data.variable, (SearchScope)scope)) {
                PsiElement element = ref.getElement();
                int elementOffset = controlFlow.getStartOffset(element);
                if (elementOffset < startOffset || elementOffset > endOffset || InputVariables.isInExitStatements(element, exitStatements)) continue;
                continue block0;
            }
            iterator.remove();
        }
    }

    private static boolean isInExitStatements(PsiElement element, Collection<PsiStatement> exitStatements) {
        for (PsiStatement exitStatement : exitStatements) {
            if (!PsiTreeUtil.isAncestor((PsiElement)exitStatement, (PsiElement)element, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public InputVariables copy() {
        InputVariables inputVariables = new InputVariables(this.myInputVariables, this.myProject, this.myScope);
        inputVariables.myFoldingAvailable = this.myFoldingAvailable;
        inputVariables.myFolding = this.myFolding;
        inputVariables.myInitialParameters = this.myInitialParameters;
        return inputVariables;
    }

    public void appendCallArguments(ParameterTablePanel.VariableData data, StringBuilder buffer) {
        if (this.myFoldingAvailable) {
            buffer.append(this.myFolding.getGeneratedCallArgument(data));
        } else {
            buffer.append(data.variable.getName());
        }
    }

    public void setFoldingAvailable(boolean foldingAvailable) {
        this.myFoldingAvailable = foldingAvailable;
        this.myFolding.clear();
        this.myInputVariables.clear();
        this.myInputVariables.addAll(this.wrapInputVariables(this.myInitialParameters));
    }

    public void annotateWithParameter(PsiJavaCodeReferenceElement reference) {
        for (ParameterTablePanel.VariableData data : this.myInputVariables) {
            PsiMethod psiMethod;
            int idx;
            PsiElement element = reference.resolve();
            if (!data.variable.equals(element)) continue;
            PsiType type = data.variable.getType();
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiMethodCallExpression.class);
            if (methodCallExpression != null && (idx = ArrayUtil.find((Object[])methodCallExpression.getArgumentList().getExpressions(), (Object)reference)) > -1 && (psiMethod = methodCallExpression.resolveMethod()) != null) {
                PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
                if (idx >= parameters.length && (idx = parameters.length - 1) >= 0) {
                    type = parameters[idx].getType();
                }
                if (type instanceof PsiEllipsisType) {
                    type = ((PsiEllipsisType)type).getComponentType();
                }
            }
            if (this.myFoldingAvailable && this.myFolding.annotateWithParameter(data, (PsiElement)reference)) continue;
            reference.putUserData(DuplicatesFinder.PARAMETER, (Object)Pair.create((Object)data.variable, (Object)type));
        }
    }

    public boolean isFoldingSelectedByDefault() {
        return this.myFolding.isFoldingSelectedByDefault();
    }
}

