/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature.inCallers;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nullable;

public class MethodNode
extends CheckedTreeNode {
    private final PsiMethod myMethod;
    private final Set<PsiMethod> myCalled;
    private final Runnable myCancelCallback;
    private boolean myOldChecked;

    public MethodNode(PsiMethod method, Set<PsiMethod> called, Runnable cancelCallback) {
        super((Object)method);
        this.myMethod = method;
        this.myCalled = called;
        this.myCancelCallback = cancelCallback;
        this.isChecked = false;
    }

    public PsiMethod getMethod() {
        return this.myMethod;
    }

    private void buildChildren() {
        if (this.children == null) {
            PsiMethod[] callers = this.findCallers();
            this.children = new Vector(callers.length);
            for (PsiMethod caller : callers) {
                HashSet<PsiMethod> called = new HashSet<PsiMethod>(this.myCalled);
                called.add(this.myMethod);
                MethodNode child = new MethodNode(caller, called, this.myCancelCallback);
                this.children.add(child);
                child.parent = this;
            }
        }
    }

    public TreeNode getChildAt(int index) {
        this.buildChildren();
        return super.getChildAt(index);
    }

    public int getChildCount() {
        this.buildChildren();
        return super.getChildCount();
    }

    public int getIndex(TreeNode aChild) {
        this.buildChildren();
        return super.getIndex(aChild);
    }

    private PsiMethod[] findCallers() {
        if (this.myMethod == null) {
            return PsiMethod.EMPTY_ARRAY;
        }
        final Project project = this.myMethod.getProject();
        final ArrayList callers = new ArrayList();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                PsiReference[] refs;
                for (PsiReference ref : refs = (PsiReference[])MethodReferencesSearch.search((PsiMethod)MethodNode.this.myMethod, (SearchScope)GlobalSearchScope.allScope((Project)project), (boolean)true).toArray((Object[])PsiReference.EMPTY_ARRAY)) {
                    PsiElement element = ref.getElement();
                    if (element instanceof PsiReferenceExpression && ((PsiReferenceExpression)element).getQualifierExpression() instanceof PsiSuperExpression) continue;
                    PsiElement enclosingContext = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiClass.class});
                    if (enclosingContext instanceof PsiMethod && !MethodNode.this.myMethod.equals(enclosingContext) && !MethodNode.this.myCalled.contains(MethodNode.this.myMethod)) {
                        callers.add((PsiMethod)enclosingContext);
                        continue;
                    }
                    if (!(element instanceof PsiClass)) continue;
                    PsiClass aClass = (PsiClass)element;
                    callers.add(JavaPsiFacade.getElementFactory((Project)project).createMethodFromText(aClass.getName() + "(){}", (PsiElement)aClass));
                }
            }
        }, RefactoringBundle.message((String)"caller.chooser.looking.for.callers"), true, project)) {
            this.myCancelCallback.run();
            return PsiMethod.EMPTY_ARRAY;
        }
        return callers.toArray(new PsiMethod[callers.size()]);
    }

    public void customizeRenderer(ColoredTreeCellRenderer renderer) {
        if (this.myMethod == null) {
            return;
        }
        int flags = 3;
        renderer.setIcon(this.myMethod.getIcon(flags));
        StringBuffer buffer = new StringBuffer(128);
        PsiClass containingClass = this.myMethod.getContainingClass();
        if (containingClass != null) {
            buffer.append(ClassPresentationUtil.getNameForClass(containingClass, false));
            buffer.append('.');
        }
        String methodText = PsiFormatUtil.formatMethod((PsiMethod)this.myMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
        buffer.append(methodText);
        SimpleTextAttributes attributes = this.isEnabled() ? new SimpleTextAttributes(0, UIUtil.getTreeForeground()) : SimpleTextAttributes.EXCLUDED_ATTRIBUTES;
        renderer.append(buffer.toString(), attributes);
        if (containingClass != null) {
            String packageName = MethodNode.getPackageName(containingClass);
            renderer.append("  (" + packageName + ")", new SimpleTextAttributes(2, Color.GRAY));
        }
    }

    @Nullable
    private static String getPackageName(PsiClass aClass) {
        PsiFile file = aClass.getContainingFile();
        if (file instanceof PsiJavaFile) {
            return ((PsiJavaFile)file).getPackageName();
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.myOldChecked = this.isChecked();
            this.setChecked(false);
        } else {
            this.setChecked(this.myOldChecked);
        }
    }
}

