/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeClassSignature;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeClassSignature.ChangeClassSignatureDialog;
import com.intellij.refactoring.changeClassSignature.ChangeClassSigntaureViewDescriptor;
import com.intellij.refactoring.changeClassSignature.TypeParameterInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChangeClassSignatureProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.changeClassSignature.ChangeClassSignatureProcessor");
    private PsiClass myClass;
    private final TypeParameterInfo[] myNewSignature;

    public ChangeClassSignatureProcessor(Project project, PsiClass aClass, TypeParameterInfo[] newSignature) {
        super(project);
        this.myClass = aClass;
        this.myNewSignature = newSignature;
    }

    @Override
    protected void refreshElements(PsiElement[] elements) {
        LOG.assertTrue(elements.length == 1);
        LOG.assertTrue(elements[0] instanceof PsiClass);
        this.myClass = (PsiClass)elements[0];
    }

    @Override
    protected String getCommandName() {
        return ChangeClassSignatureDialog.REFACTORING_NAME;
    }

    @Override
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        return new ChangeClassSigntaureViewDescriptor(this.myClass);
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)this.myProject);
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        boolean hadTypeParameters = this.myClass.hasTypeParameters();
        for (PsiReference reference : ReferencesSearch.search((PsiElement)this.myClass, (SearchScope)projectScope, (boolean)false)) {
            PsiJavaCodeReferenceElement referenceElement;
            PsiElement parent;
            if (!(reference.getElement() instanceof PsiJavaCodeReferenceElement) || !((parent = (referenceElement = (PsiJavaCodeReferenceElement)reference.getElement()).getParent()) instanceof PsiTypeElement) && !(parent instanceof PsiNewExpression) && !(parent instanceof PsiAnonymousClass) && !(parent instanceof PsiReferenceList) || hadTypeParameters && referenceElement.getTypeParameters().length <= 0) continue;
            result.add(new UsageInfo((PsiQualifiedReference)referenceElement));
        }
        UsageInfo[] usageInfoArray = result.toArray(new UsageInfo[result.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/changeClassSignature/ChangeClassSignatureProcessor.findUsages must not return null");
        }
        return usageInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performRefactoring(UsageInfo[] usages) {
        LocalHistoryAction a = LocalHistory.startAction((Project)this.myProject, (String)this.getCommandName());
        try {
            this.doRefactoring(usages);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        finally {
            a.finish();
        }
    }

    private void doRefactoring(UsageInfo[] usages) throws IncorrectOperationException {
        PsiTypeParameter[] typeParameters = this.myClass.getTypeParameters();
        boolean[] toRemoveParms = this.detectRemovedParameters(typeParameters);
        for (UsageInfo usage : usages) {
            LOG.assertTrue(usage.getElement() instanceof PsiJavaCodeReferenceElement);
            this.processUsage(usage, typeParameters, toRemoveParms);
        }
        this.changeClassSignature(typeParameters, toRemoveParms);
    }

    private void changeClassSignature(PsiTypeParameter[] originalTypeParameters, boolean[] toRemoveParms) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myClass.getProject()).getElementFactory();
        ArrayList<PsiTypeParameter> newTypeParameters = new ArrayList<PsiTypeParameter>();
        for (TypeParameterInfo info : this.myNewSignature) {
            int oldIndex = info.getOldParameterIndex();
            if (oldIndex >= 0) {
                newTypeParameters.add(originalTypeParameters[oldIndex]);
                continue;
            }
            newTypeParameters.add(factory.createTypeParameterFromText(info.getNewName(), null));
        }
        ChangeSignatureUtil.synchronizeList(this.myClass.getTypeParameterList(), newTypeParameters, TypeParameterList.INSTANCE, toRemoveParms);
    }

    private boolean[] detectRemovedParameters(PsiTypeParameter[] originaltypeParameters) {
        boolean[] toRemoveParms = new boolean[originaltypeParameters.length];
        Arrays.fill(toRemoveParms, true);
        for (TypeParameterInfo info : this.myNewSignature) {
            int oldParameterIndex = info.getOldParameterIndex();
            if (oldParameterIndex < 0) continue;
            toRemoveParms[oldParameterIndex] = false;
        }
        return toRemoveParms;
    }

    private void processUsage(UsageInfo usage, PsiTypeParameter[] originalTypeParameters, boolean[] toRemoveParms) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myClass.getProject()).getElementFactory();
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)usage.getElement();
        PsiSubstitutor usageSubstitutor = this.determineUsageSubstitutor(referenceElement);
        PsiReferenceParameterList referenceParameterList = referenceElement.getParameterList();
        PsiTypeElement[] oldValues = referenceParameterList.getTypeParameterElements();
        if (oldValues.length != originalTypeParameters.length) {
            return;
        }
        ArrayList<PsiTypeElement> newValues = new ArrayList<PsiTypeElement>();
        for (TypeParameterInfo info : this.myNewSignature) {
            int oldIndex = info.getOldParameterIndex();
            if (oldIndex >= 0) {
                newValues.add(oldValues[oldIndex]);
                continue;
            }
            PsiType type = info.getDefaultValue().getType((PsiElement)this.myClass.getLBrace(), PsiManager.getInstance((Project)this.myProject));
            PsiTypeElement newValue = factory.createTypeElement(usageSubstitutor.substitute(type));
            newValues.add(newValue);
        }
        ChangeSignatureUtil.synchronizeList(referenceParameterList, newValues, ReferenceParameterList.INSTANCE, toRemoveParms);
    }

    private PsiSubstitutor determineUsageSubstitutor(PsiJavaCodeReferenceElement referenceElement) {
        PsiType[] typeArguments = referenceElement.getTypeParameters();
        PsiSubstitutor usageSubstitutor = PsiSubstitutor.EMPTY;
        PsiTypeParameter[] typeParameters = this.myClass.getTypeParameters();
        if (typeParameters.length == typeArguments.length) {
            for (int i = 0; i < typeParameters.length; ++i) {
                usageSubstitutor = usageSubstitutor.put(typeParameters[i], typeArguments[i]);
            }
        }
        return usageSubstitutor;
    }

    private static class TypeParameterList
    implements ChangeSignatureUtil.ChildrenGenerator<PsiTypeParameterList, PsiTypeParameter> {
        private static final TypeParameterList INSTANCE = new TypeParameterList();

        private TypeParameterList() {
        }

        @Override
        public List<PsiTypeParameter> getChildren(PsiTypeParameterList psiTypeParameterList) {
            return Arrays.asList(psiTypeParameterList.getTypeParameters());
        }
    }

    private static class ReferenceParameterList
    implements ChangeSignatureUtil.ChildrenGenerator<PsiReferenceParameterList, PsiTypeElement> {
        private static final ReferenceParameterList INSTANCE = new ReferenceParameterList();

        private ReferenceParameterList() {
        }

        @Override
        public List<PsiTypeElement> getChildren(PsiReferenceParameterList list) {
            return Arrays.asList(list.getTypeParameterElements());
        }
    }
}

