/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.psi.templateLanguages.ConfigurableTemplateLanguageFileViewProvider;
import com.intellij.psi.templateLanguages.TemplateDataLanguageConfigurable;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;

public class ChangeTemplateDataLanguageAction
extends AnAction {
    public void update(AnActionEvent e) {
        e.getPresentation().setVisible(false);
        VirtualFile virtualFile = (VirtualFile)e.getData(PlatformDataKeys.VIRTUAL_FILE);
        VirtualFile[] files = (VirtualFile[])e.getData(PlatformDataKeys.VIRTUAL_FILE_ARRAY);
        if (files != null && files.length > 1) {
            virtualFile = null;
        }
        if (virtualFile == null) {
            return;
        }
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        FileViewProvider provider = PsiManager.getInstance((Project)project).findViewProvider(virtualFile);
        if (provider instanceof ConfigurableTemplateLanguageFileViewProvider) {
            TemplateLanguageFileViewProvider viewProvider = (TemplateLanguageFileViewProvider)provider;
            e.getPresentation().setText(LangBundle.message("quickfix.change.template.data.language.text", viewProvider.getTemplateDataLanguage().getDisplayName()));
            e.getPresentation().setEnabled(true);
            e.getPresentation().setVisible(true);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        final VirtualFile virtualFile = (VirtualFile)e.getData(PlatformDataKeys.VIRTUAL_FILE);
        final TemplateDataLanguageConfigurable configurable = TemplateDataLanguageConfigurable.getInstance(project);
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, new Runnable(){

            @Override
            public void run() {
                if (virtualFile != null) {
                    configurable.selectFile(virtualFile);
                }
            }
        });
    }
}

