/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.jsp;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JspSpiUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.jsp.tagLibrary.JspTagInfoImpl");
    @NonNls
    private static final String JAR_EXTENSION = "jar";

    @Nullable
    private static JspSpiUtil getJspSpiUtil() {
        return (JspSpiUtil)ServiceManager.getService(JspSpiUtil.class);
    }

    public static int escapeCharsInJspContext(JspFile file, int offset, String toEscape) throws IncorrectOperationException {
        JspSpiUtil util = JspSpiUtil.getJspSpiUtil();
        return util != null ? util._escapeCharsInJspContext(file, offset, toEscape) : 0;
    }

    protected abstract int _escapeCharsInJspContext(JspFile var1, int var2, String var3) throws IncorrectOperationException;

    public static void visitAllIncludedFilesRecursively(JspFile jspFile, Processor<JspFile> visitor) {
        JspSpiUtil util = JspSpiUtil.getJspSpiUtil();
        if (util != null) {
            util._visitAllIncludedFilesRecursively(jspFile, visitor);
        }
    }

    protected abstract void _visitAllIncludedFilesRecursively(JspFile var1, Processor<JspFile> var2);

    @Nullable
    public static PsiElement resolveMethodPropertyReference(@NotNull PsiReference reference, @Nullable PsiClass resolvedClass, boolean readable) {
        if (reference == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/jsp/JspSpiUtil.resolveMethodPropertyReference must not be null");
        }
        JspSpiUtil util = JspSpiUtil.getJspSpiUtil();
        return util == null ? null : util._resolveMethodPropertyReference(reference, resolvedClass, readable);
    }

    @Nullable
    protected abstract PsiElement _resolveMethodPropertyReference(@NotNull PsiReference var1, @Nullable PsiClass var2, boolean var3);

    @NotNull
    public static Object[] getMethodPropertyReferenceVariants(@NotNull PsiReference reference, @Nullable PsiClass resolvedClass, boolean readable) {
        if (reference == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/jsp/JspSpiUtil.getMethodPropertyReferenceVariants must not be null");
        }
        JspSpiUtil util = JspSpiUtil.getJspSpiUtil();
        Object[] objectArray = util == null ? ArrayUtil.EMPTY_OBJECT_ARRAY : util._getMethodPropertyReferenceVariants(reference, resolvedClass, readable);
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/jsp/JspSpiUtil.getMethodPropertyReferenceVariants must not return null");
        }
        return objectArray;
    }

    protected abstract Object[] _getMethodPropertyReferenceVariants(@NotNull PsiReference var1, @Nullable PsiClass var2, boolean var3);

    public static boolean isIncludedOrIncludesSomething(@NotNull JspFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/jsp/JspSpiUtil.isIncludedOrIncludesSomething must not be null");
        }
        return JspSpiUtil.isIncludingAnything(file) || JspSpiUtil.isIncluded(file);
    }

    public static boolean isIncluded(@NotNull JspFile jspFile) {
        if (jspFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/jsp/JspSpiUtil.isIncluded must not be null");
        }
        JspSpiUtil util = JspSpiUtil.getJspSpiUtil();
        return util != null && util._isIncluded(jspFile);
    }

    public abstract boolean _isIncluded(@NotNull JspFile var1);

    public static boolean isIncludingAnything(@NotNull JspFile jspFile) {
        if (jspFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/jsp/JspSpiUtil.isIncludingAnything must not be null");
        }
        JspSpiUtil util = JspSpiUtil.getJspSpiUtil();
        return util != null && util._isIncludingAnything(jspFile);
    }

    protected abstract boolean _isIncludingAnything(@NotNull JspFile var1);

    public static PsiFile[] getIncludedFiles(@NotNull JspFile jspFile) {
        if (jspFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/jsp/JspSpiUtil.getIncludedFiles must not be null");
        }
        JspSpiUtil util = JspSpiUtil.getJspSpiUtil();
        return util == null ? PsiFile.EMPTY_ARRAY : util._getIncludedFiles(jspFile);
    }

    public static PsiFile[] getIncludingFiles(@NotNull JspFile jspFile) {
        if (jspFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/jsp/JspSpiUtil.getIncludingFiles must not be null");
        }
        JspSpiUtil util = JspSpiUtil.getJspSpiUtil();
        return util == null ? PsiFile.EMPTY_ARRAY : util._getIncludingFiles((PsiFile)jspFile);
    }

    protected abstract PsiFile[] _getIncludingFiles(@NotNull PsiFile var1);

    @NotNull
    protected abstract PsiFile[] _getIncludedFiles(@NotNull JspFile var1);

    public static boolean isJavaContext(PsiElement position) {
        return PsiTreeUtil.getContextOfType((PsiElement)position, JspClass.class, (boolean)false) != null;
    }

    public static boolean isJarFile(@Nullable VirtualFile file) {
        String ext;
        return file != null && (ext = file.getExtension()) != null && ext.equalsIgnoreCase(JAR_EXTENSION);
    }

    public static List<URL> buildUrls(@Nullable VirtualFile virtualFile, @Nullable Module module) {
        return JspSpiUtil.buildUrls(virtualFile, module, OrderRootType.CLASSES_AND_OUTPUT);
    }

    public static List<URL> buildUrls(@Nullable VirtualFile virtualFile, @Nullable Module module, OrderRootType rootType) {
        final ArrayList<URL> urls = new ArrayList<URL>();
        JspSpiUtil.processClassPathItems(virtualFile, module, new Consumer<VirtualFile>(){

            public void consume(VirtualFile file) {
                JspSpiUtil.addUrl(urls, file);
            }
        }, rootType);
        return urls;
    }

    public static void processClassPathItems(VirtualFile virtualFile, Module module, Consumer<VirtualFile> consumer) {
        JspSpiUtil.processClassPathItems(virtualFile, module, consumer, OrderRootType.CLASSES_AND_OUTPUT);
    }

    public static void processClassPathItems(VirtualFile virtualFile, Module module, Consumer<VirtualFile> consumer, OrderRootType rootType) {
        if (JspSpiUtil.isJarFile(virtualFile)) {
            consumer.consume((Object)virtualFile);
        }
        if (module != null) {
            for (VirtualFile file1 : ModuleRootManager.getInstance((Module)module).getFiles(rootType)) {
                VirtualFile file = file1.getFileSystem().getProtocol().equals(JAR_EXTENSION) ? JarFileSystem.getInstance().getVirtualFileForJar(file1) : file1;
                consumer.consume((Object)file);
            }
        }
    }

    private static void addUrl(List<URL> urls, VirtualFile file) {
        if (file == null || !file.isValid()) {
            return;
        }
        URL url = JspSpiUtil.getUrl(file);
        if (url != null) {
            urls.add(url);
        }
    }

    @Nullable
    private static URL getUrl(VirtualFile file) {
        if (file.getFileSystem() instanceof JarFileSystem && file.getParent() != null) {
            return null;
        }
        String path = file.getPath();
        if (path.endsWith("!/")) {
            path = path.substring(0, path.length() - 2);
        }
        String url = SystemInfo.isWindows ? "file:/" + path : "file://" + path;
        if (file.isDirectory() && !(file.getFileSystem() instanceof JarFileSystem)) {
            url = url + "/";
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static IElementType getJspScriptletType() {
        JspSpiUtil spiUtil = JspSpiUtil.getJspSpiUtil();
        return spiUtil != null ? spiUtil._getJspScriptletType() : null;
    }

    public static IElementType getJspExpressionType() {
        JspSpiUtil spiUtil = JspSpiUtil.getJspSpiUtil();
        return spiUtil != null ? spiUtil._getJspExpressionType() : null;
    }

    protected abstract IElementType _getJspExpressionType();

    protected abstract IElementType _getJspScriptletType();
}

