/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.intellij.AppTopics;
import com.intellij.ProjectTopics;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.java.stubs.index.JavaFullClassNameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFileManagerImpl
implements JavaFileManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.file.impl.JavaFileManagerImpl");
    private final ConcurrentHashMap<GlobalSearchScope, PsiClass> myCachedObjectClassMap = new ConcurrentHashMap();
    private final Map<String, PsiClass> myNameToClassMap = new ConcurrentHashMap();
    @NonNls
    private static final String JAVA_EXTENSION = ".java";
    @NonNls
    private static final String CLASS_EXTENSION = ".class";
    private final PsiManagerEx myManager;
    private final ProjectRootManager myProjectRootManager;
    private final FileManager myFileManager;
    private final boolean myUseRepository;
    private Set<String> myNontrivialPackagePrefixes = null;
    private boolean myInitialized = false;
    private boolean myDisposed = false;
    private final PackageIndex myPackageIndex;

    public JavaFileManagerImpl(PsiManagerEx manager, ProjectRootManager projectRootManager, FileManager fileManager, MessageBus bus) {
        this.myManager = manager;
        this.myProjectRootManager = projectRootManager;
        this.myFileManager = fileManager;
        this.myUseRepository = true;
        this.myManager.registerRunnableToRunOnChange(new Runnable(){

            @Override
            public void run() {
                JavaFileManagerImpl.this.myCachedObjectClassMap.clear();
            }
        });
        MessageBusConnection connection = bus.connect();
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void beforeRootsChange(ModuleRootEvent event) {
            }

            public void rootsChanged(ModuleRootEvent event) {
                JavaFileManagerImpl.this.myNontrivialPackagePrefixes = null;
                JavaFileManagerImpl.this.clearNonRepositoryMaps();
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void before(List<? extends VFileEvent> events) {
                JavaFileManagerImpl.this.clearNonRepositoryMaps();
            }

            public void after(List<? extends VFileEvent> events) {
                JavaFileManagerImpl.this.clearNonRepositoryMaps();
            }
        });
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerAdapter(){

            public void fileWithNoDocumentChanged(VirtualFile file) {
                JavaFileManagerImpl.this.clearNonRepositoryMaps();
            }
        });
        this.myPackageIndex = PackageIndex.getInstance((Project)this.myManager.getProject());
    }

    @Override
    public void initialize() {
        this.myInitialized = true;
    }

    @Override
    public void dispose() {
        this.myDisposed = true;
        this.myCachedObjectClassMap.clear();
    }

    private void clearNonRepositoryMaps() {
        if (!this.myUseRepository) {
            this.myNameToClassMap.clear();
        }
    }

    @Override
    @Nullable
    public PsiPackage findPackage(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/impl/JavaFileManagerImpl.findPackage must not be null");
        }
        Query dirs = this.myPackageIndex.getDirsByPackageName(packageName, false);
        if (dirs.findFirst() == null) {
            return null;
        }
        return new PsiPackageImpl(this.myManager, packageName);
    }

    @Override
    public PsiClass[] findClasses(@NotNull String qName, final @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/impl/JavaFileManagerImpl.findClasses must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/file/impl/JavaFileManagerImpl.findClasses must not be null");
        }
        Collection<PsiClass> classes = JavaFullClassNameIndex.getInstance().get(qName.hashCode(), this.myManager.getProject(), scope);
        if (classes.isEmpty()) {
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList<PsiClass> result = new ArrayList<PsiClass>(classes.size());
        int count = 0;
        PsiClass aClass = null;
        for (PsiElement psiElement : classes) {
            VirtualFile vFile;
            String qualifiedName;
            if (JavaFileManagerImpl.notClass(psiElement) || (qualifiedName = (aClass = (PsiClass)psiElement).getQualifiedName()) == null || !qualifiedName.equals(qName) || !this.fileIsInScope(scope, vFile = aClass.getContainingFile().getVirtualFile())) continue;
            result.add(aClass);
            ++count;
        }
        if (count == 0) {
            return PsiClass.EMPTY_ARRAY;
        }
        if (count == 1) {
            return new PsiClass[]{aClass};
        }
        ContainerUtil.quickSort(result, (Comparator)new Comparator<PsiClass>(){

            @Override
            public int compare(PsiClass o1, PsiClass o2) {
                return scope.compare(o2.getContainingFile().getVirtualFile(), o1.getContainingFile().getVirtualFile());
            }
        });
        return result.toArray(new PsiClass[count]);
    }

    public static boolean notClass(PsiElement found) {
        if (found instanceof PsiClass) {
            return false;
        }
        VirtualFile faultyContainer = PsiUtil.getVirtualFile((PsiElement)found);
        LOG.error("Non class in class list: " + faultyContainer + ". found: " + found);
        if (faultyContainer != null && faultyContainer.isValid()) {
            FileBasedIndex.getInstance().requestReindex(faultyContainer);
        }
        return true;
    }

    @Override
    @Nullable
    public PsiClass findClass(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/impl/JavaFileManagerImpl.findClass must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/file/impl/JavaFileManagerImpl.findClass must not be null");
        }
        if (!this.myUseRepository) {
            return this.findClassWithoutRepository(qName);
        }
        if (!this.myInitialized) {
            LOG.error("Access to psi files should be performed only after startup activity");
            return null;
        }
        LOG.assertTrue(!this.myDisposed);
        if ("java.lang.Object".equals(qName)) {
            PsiClass cached = (PsiClass)this.myCachedObjectClassMap.get((Object)scope);
            if (cached == null && (cached = this.findClassInIndex(qName, scope)) != null) {
                cached = (PsiClass)this.myCachedObjectClassMap.cacheOrGet((Object)scope, (Object)cached);
            }
            return cached;
        }
        return this.findClassInIndex(qName, scope);
    }

    @Nullable
    private PsiClass findClassWithoutRepository(String qName) {
        PsiClass aClass = this.myNameToClassMap.get(qName);
        if (aClass != null) {
            return aClass;
        }
        aClass = this._findClassWithoutRepository(qName);
        this.myNameToClassMap.put(qName, aClass);
        return aClass;
    }

    @Nullable
    private PsiClass _findClassWithoutRepository(String qName) {
        VirtualFile[] sourcePath = this.myProjectRootManager.getFilesFromAllModules(OrderRootType.SOURCES);
        VirtualFile[] classPath = this.myProjectRootManager.getFilesFromAllModules(OrderRootType.CLASSES);
        int index = 0;
        while (index < qName.length()) {
            int index1 = qName.indexOf(46, index);
            if (index1 < 0) {
                index1 = qName.length();
            }
            String name = qName.substring(index, index1);
            boolean sourceType = false;
            for (int type = 0; type < 2; ++type) {
                VirtualFile[] vDirs;
                for (VirtualFile vDir : vDirs = type == 0 ? sourcePath : classPath) {
                    PsiClass aClass;
                    PsiFile file;
                    VirtualFile vChild;
                    if (vDir == null) continue;
                    VirtualFile virtualFile = vChild = type == 0 ? vDir.findChild(name + JAVA_EXTENSION) : vDir.findChild(name + CLASS_EXTENSION);
                    if (vChild == null || !((file = this.myFileManager.findFile(vChild)) instanceof PsiJavaFile) || (aClass = JavaFileManagerImpl.findClassByName((PsiJavaFile)file, name)) == null) continue;
                    index = index1 + 1;
                    while (index < qName.length()) {
                        index1 = qName.indexOf(46, index);
                        if (index1 < 0) {
                            index1 = qName.length();
                        }
                        if ((aClass = JavaFileManagerImpl.findClassByName(aClass, name = qName.substring(index, index1))) == null) {
                            return null;
                        }
                        index = index1 + 1;
                    }
                    return aClass;
                }
            }
            boolean existsDir = false;
            for (int type = 0; type < 2; ++type) {
                VirtualFile[] vDirs = type == 0 ? sourcePath : classPath;
                for (int i = 0; i < vDirs.length; ++i) {
                    PsiDirectory dir;
                    if (vDirs[i] == null) continue;
                    VirtualFile vDirChild = vDirs[i].findChild(name);
                    if (vDirChild != null && (dir = this.myFileManager.findDirectory(vDirChild)) != null) {
                        vDirs[i] = vDirChild;
                        existsDir = true;
                        continue;
                    }
                    vDirs[i] = null;
                }
            }
            if (!existsDir) {
                return null;
            }
            index = index1 + 1;
        }
        return null;
    }

    @Nullable
    private static PsiClass findClassByName(PsiJavaFile scope, String name) {
        PsiClass[] classes;
        for (PsiClass aClass : classes = scope.getClasses()) {
            if (!name.equals(aClass.getName())) continue;
            return aClass;
        }
        return null;
    }

    @Nullable
    private static PsiClass findClassByName(PsiClass scope, String name) {
        PsiClass[] classes;
        for (PsiClass aClass : classes = scope.getInnerClasses()) {
            if (!name.equals(aClass.getName())) continue;
            return aClass;
        }
        return null;
    }

    @Nullable
    private PsiClass findClassInIndex(String qName, GlobalSearchScope scope) {
        VirtualFile bestFile = null;
        PsiClass bestClass = null;
        Collection<PsiClass> classes = JavaFullClassNameIndex.getInstance().get(qName.hashCode(), this.myManager.getProject(), scope);
        for (PsiElement psiElement : classes) {
            if (JavaFileManagerImpl.notClass(psiElement)) continue;
            PsiClass aClass = (PsiClass)psiElement;
            boolean valid = aClass.isValid();
            if (!valid) {
                LOG.error("Invalid class " + aClass + "; " + aClass.getContainingFile());
                continue;
            }
            String qualifiedName = aClass.getQualifiedName();
            if (qualifiedName == null || !qualifiedName.equals(qName)) continue;
            PsiFile file = aClass.getContainingFile();
            if (file == null) {
                LOG.error("aClass=" + aClass);
                continue;
            }
            VirtualFile vFile = file.getVirtualFile();
            if (!this.fileIsInScope(scope, vFile) || bestFile != null && scope.compare(vFile, bestFile) <= 0) continue;
            bestFile = vFile;
            bestClass = aClass;
        }
        return bestClass;
    }

    private boolean fileIsInScope(GlobalSearchScope scope, VirtualFile vFile) {
        if (!scope.contains(vFile)) {
            return false;
        }
        if (vFile.getFileType() == StdFileTypes.CLASS) {
            VirtualFile root = ProjectRootManager.getInstance((Project)this.myManager.getProject()).getFileIndex().getClassRootForFile(vFile);
            PsiNameHelper nameHelper = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getNameHelper();
            for (VirtualFile parent = vFile.getParent(); parent != null && parent != root; parent = parent.getParent()) {
                if (nameHelper.isIdentifier(parent.getName())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Collection<String> getNonTrivialPackagePrefixes() {
        if (this.myNontrivialPackagePrefixes == null) {
            HashSet<String> names = new HashSet<String>();
            ProjectRootManager rootManager = this.myProjectRootManager;
            VirtualFile[] sourceRoots = rootManager.getContentSourceRoots();
            ProjectFileIndex fileIndex = rootManager.getFileIndex();
            for (VirtualFile sourceRoot : sourceRoots) {
                String packageName = fileIndex.getPackageNameByDirectory(sourceRoot);
                if (packageName == null || packageName.length() <= 0) continue;
                names.add(packageName);
            }
            this.myNontrivialPackagePrefixes = names;
        }
        return this.myNontrivialPackagePrefixes;
    }
}

