/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.intellij.AppTopics;
import com.intellij.ProjectTopics;
import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileTypes.ContentBasedClassFileProcessor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.psi.FileResolveScopeProvider;
import com.intellij.psi.FileTypeFileViewProviders;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.FileViewProviderFactory;
import com.intellij.psi.LanguageFileViewProviders;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.ConcurrentWeakValueHashMap;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileManagerImpl
implements FileManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.file.impl.FileManagerImpl");
    private final PsiManagerImpl myManager;
    private final FileTypeManager myFileTypeManager;
    private final ProjectRootManager myProjectRootManager;
    private ProjectFileIndex myProjectFileIndex = null;
    private final ConcurrentMap<VirtualFile, PsiDirectory> myVFileToPsiDirMap = new ConcurrentHashMap();
    private final ConcurrentWeakValueHashMap<VirtualFile, FileViewProvider> myVFileToViewProviderMap = new ConcurrentWeakValueHashMap();
    private boolean myInitialized = false;
    private boolean myDisposed = false;
    private final FileDocumentManager myFileDocumentManager;
    private final MessageBusConnection myConnection;
    private boolean myProcessingFileTypesChange = false;

    public FileManagerImpl(PsiManagerImpl manager, FileTypeManager fileTypeManager, FileDocumentManager fileDocumentManager, ProjectRootManager projectRootManager) {
        this.myFileTypeManager = fileTypeManager;
        this.myManager = manager;
        this.myConnection = manager.getProject().getMessageBus().connect();
        this.myFileDocumentManager = fileDocumentManager;
        this.myProjectRootManager = projectRootManager;
        this.myConnection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                FileManagerImpl.this.recalcAllViewProviders();
            }

            public void exitDumbMode() {
                FileManagerImpl.this.recalcAllViewProviders();
            }
        });
    }

    public void processQueue() {
        this.myVFileToViewProviderMap.processQueue();
    }

    public ConcurrentWeakValueHashMap<VirtualFile, FileViewProvider> getVFileToViewProviderMap() {
        return this.myVFileToViewProviderMap;
    }

    private void recalcAllViewProviders() {
        this.handleFileTypesChange(new FileTypesChanged(){

            @Override
            protected void updateMaps() {
                for (FileViewProvider provider : FileManagerImpl.this.myVFileToViewProviderMap.values()) {
                    if (!provider.getVirtualFile().isValid()) continue;
                    for (Language language : provider.getLanguages()) {
                        PsiFile psi = provider.getPsi(language);
                        if (!(psi instanceof PsiFileImpl)) continue;
                        ((PsiFileImpl)psi).clearCaches();
                    }
                }
                FileManagerImpl.this.removeInvalidFilesAndDirs(false);
            }
        });
    }

    @Override
    public void dispose() {
        if (this.myInitialized) {
            this.myConnection.disconnect();
        }
        this.myDisposed = true;
    }

    @Override
    public void cleanupForNextTest() {
        this.myVFileToViewProviderMap.clear();
        this.myVFileToPsiDirMap.clear();
        this.processQueue();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public FileViewProvider findViewProvider(@NotNull VirtualFile file) {
        FileViewProvider fileViewProvider;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/impl/FileManagerImpl.findViewProvider must not be null");
        }
        FileViewProvider viewProvider = this.getFromInjected(file);
        if (viewProvider != null) {
            fileViewProvider = viewProvider;
            if (fileViewProvider == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/impl/FileManagerImpl.findViewProvider must not return null");
            return fileViewProvider;
        }
        viewProvider = (FileViewProvider)this.myVFileToViewProviderMap.get((Object)file);
        if (viewProvider == null) {
            viewProvider = (FileViewProvider)ConcurrencyUtil.cacheOrGet(this.myVFileToViewProviderMap, (Object)file, (Object)this.createFileViewProvider(file, true));
        }
        if ((fileViewProvider = viewProvider) != null) return fileViewProvider;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/impl/FileManagerImpl.findViewProvider must not return null");
    }

    @Override
    public FileViewProvider findCachedViewProvider(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/impl/FileManagerImpl.findCachedViewProvider must not be null");
        }
        FileViewProvider viewProvider = this.getFromInjected(file);
        if (viewProvider != null) {
            return viewProvider;
        }
        return (FileViewProvider)this.myVFileToViewProviderMap.get((Object)file);
    }

    private FileViewProvider getFromInjected(VirtualFile file) {
        if (file instanceof VirtualFileWindow) {
            DocumentWindow document = ((VirtualFileWindow)file).getDocumentWindow();
            PsiFile psiFile = PsiDocumentManagerImpl.getInstance((Project)this.myManager.getProject()).getCachedPsiFile((Document)document);
            if (psiFile == null) {
                return null;
            }
            return psiFile.getViewProvider();
        }
        return null;
    }

    @Override
    public void setViewProvider(@NotNull VirtualFile virtualFile, FileViewProvider fileViewProvider) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/impl/FileManagerImpl.setViewProvider must not be null");
        }
        if (!(virtualFile instanceof VirtualFileWindow)) {
            if (fileViewProvider == null) {
                this.myVFileToViewProviderMap.remove((Object)virtualFile);
            } else {
                this.myVFileToViewProviderMap.put((Object)virtualFile, (Object)fileViewProvider);
            }
        }
    }

    @Override
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file, boolean physical) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/impl/FileManagerImpl.createFileViewProvider must not be null");
        }
        Language language = this.getLanguage(file);
        FileViewProviderFactory factory = language == null ? (FileViewProviderFactory)FileTypeFileViewProviders.INSTANCE.forFileType(file.getFileType()) : (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
        SingleRootFileViewProvider viewProvider = factory == null ? null : factory.createFileViewProvider(file, language, (PsiManager)this.myManager, physical);
        SingleRootFileViewProvider singleRootFileViewProvider = viewProvider == null ? new SingleRootFileViewProvider(this.myManager, file, physical) : viewProvider;
        if (singleRootFileViewProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/impl/FileManagerImpl.createFileViewProvider must not return null");
        }
        return singleRootFileViewProvider;
    }

    @Nullable
    private Language getLanguage(VirtualFile file) {
        ContentBasedClassFileProcessor[] processors;
        FileType fileType = file.getFileType();
        Project project = this.myManager.getProject();
        if (fileType instanceof LanguageFileType) {
            return LanguageSubstitutors.INSTANCE.substituteLanguage(((LanguageFileType)fileType).getLanguage(), file, project);
        }
        for (ContentBasedClassFileProcessor processor : processors = (ContentBasedClassFileProcessor[])Extensions.getExtensions((ExtensionPointName)ContentBasedClassFileProcessor.EP_NAME)) {
            Language language = processor.obtainLanguageForFile(file);
            if (language == null) continue;
            return language;
        }
        return null;
    }

    @Override
    public void runStartupActivity() {
        LOG.assertTrue(!this.myInitialized);
        this.myDisposed = false;
        this.myInitialized = true;
        this.myProjectFileIndex = this.myProjectRootManager.getFileIndex();
        this.myConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter((VirtualFileListener)new MyVirtualFileListener()));
        this.myConnection.subscribe(AppTopics.FILE_TYPES, (Object)new FileTypeListener(){

            public void beforeFileTypesChanged(FileTypeEvent event) {
            }

            public void fileTypesChanged(FileTypeEvent e) {
                FileManagerImpl.this.handleFileTypesChange(new FileTypesChanged(){

                    @Override
                    protected void updateMaps() {
                        FileManagerImpl.this.removeInvalidFilesAndDirs(true);
                    }
                });
            }
        });
        this.myConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new MyModuleRootListener());
        this.myConnection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new MyFileDocumentManagerAdapter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFileTypesChange(FileTypesChanged runnable) {
        if (this.myProcessingFileTypesChange) {
            return;
        }
        this.myProcessingFileTypesChange = true;
        try {
            ApplicationManager.getApplication().runWriteAction((Runnable)runnable);
        }
        finally {
            this.myProcessingFileTypesChange = false;
        }
    }

    private void dispatchPendingEvents() {
        if (!this.myInitialized) {
            LOG.error("Project is not yet initialized");
        }
        if (this.myDisposed) {
            LOG.error("Project is already disposed");
        }
        this.myConnection.deliverImmediately();
    }

    public void checkConsistency() {
        HashMap<VirtualFile, FileViewProvider> fileToViewProvider = new HashMap<VirtualFile, FileViewProvider>((Map<VirtualFile, FileViewProvider>)this.myVFileToViewProviderMap);
        this.myVFileToViewProviderMap.clear();
        for (VirtualFile vFile : fileToViewProvider.keySet()) {
            FileViewProvider fileViewProvider = fileToViewProvider.get(vFile);
            LOG.assertTrue(vFile.isValid());
            PsiFile psiFile1 = this.findFile(vFile);
            if (psiFile1 != null && fileViewProvider != null && fileViewProvider.isPhysical()) assert (psiFile1.getClass().equals(fileViewProvider.getPsi(fileViewProvider.getBaseLanguage()).getClass()));
        }
        HashMap<VirtualFile, PsiDirectory> fileToPsiDirMap = new HashMap<VirtualFile, PsiDirectory>(this.myVFileToPsiDirMap);
        this.myVFileToPsiDirMap.clear();
        for (VirtualFile vFile : fileToPsiDirMap.keySet()) {
            LOG.assertTrue(vFile.isValid());
            PsiDirectory psiDir1 = this.findDirectory(vFile);
            LOG.assertTrue(psiDir1 != null);
            VirtualFile parent = vFile.getParent();
            if (parent == null) continue;
            LOG.assertTrue(this.myVFileToPsiDirMap.containsKey(parent));
        }
    }

    @Override
    @Nullable
    public PsiFile findFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/impl/FileManagerImpl.findFile must not be null");
        }
        if (vFile.isDirectory()) {
            return null;
        }
        ProjectEx project = (ProjectEx)this.myManager.getProject();
        if (project.isDefault()) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!vFile.isValid()) {
            LOG.error("Invalid file: " + vFile);
            return null;
        }
        this.dispatchPendingEvents();
        FileViewProvider viewProvider = this.findViewProvider(vFile);
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    @Override
    @Nullable
    public PsiFile getCachedPsiFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/impl/FileManagerImpl.getCachedPsiFile must not be null");
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LOG.assertTrue(vFile.isValid());
        LOG.assertTrue(!this.myDisposed);
        if (!this.myInitialized) {
            return null;
        }
        this.dispatchPendingEvents();
        return this.getCachedPsiFileInner(vFile);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public GlobalSearchScope getResolveScope(@NotNull PsiElement element) {
        GlobalSearchScope globalSearchScope;
        VirtualFile vFile;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/impl/FileManagerImpl.getResolveScope must not be null");
        }
        ProgressManager.checkCanceled();
        Project project = this.myManager.getProject();
        if (element instanceof PsiDirectory) {
            vFile = ((PsiDirectory)element).getVirtualFile();
        } else {
            PsiFile contextFile;
            PsiFile containingFile = element.getContainingFile();
            if (containingFile instanceof PsiCodeFragment) {
                PsiElement context;
                GlobalSearchScope forcedScope = ((PsiCodeFragment)containingFile).getForcedResolveScope();
                if (!(forcedScope != null ? (globalSearchScope = forcedScope) != null : ((context = containingFile.getContext()) == null ? (globalSearchScope = GlobalSearchScope.allScope((Project)project)) != null : (globalSearchScope = this.getResolveScope(context)) != null))) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/impl/FileManagerImpl.getResolveScope must not return null");
                return globalSearchScope;
            }
            PsiFile psiFile = contextFile = containingFile != null ? FileContextUtil.getContextFile((PsiElement)containingFile) : null;
            if (contextFile == null) {
                globalSearchScope = GlobalSearchScope.allScope((Project)project);
                if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/impl/FileManagerImpl.getResolveScope must not return null");
                return globalSearchScope;
            }
            if (contextFile instanceof FileResolveScopeProvider) {
                globalSearchScope = ((FileResolveScopeProvider)contextFile).getFileResolveScope();
                if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/impl/FileManagerImpl.getResolveScope must not return null");
                return globalSearchScope;
            }
            vFile = contextFile.getOriginalFile().getVirtualFile();
        }
        if (vFile == null) {
            globalSearchScope = GlobalSearchScope.allScope((Project)project);
            if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/impl/FileManagerImpl.getResolveScope must not return null");
            return globalSearchScope;
        }
        globalSearchScope = this.getDefaultResolveScope(vFile);
        if (globalSearchScope != null) return globalSearchScope;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/impl/FileManagerImpl.getResolveScope must not return null");
    }

    public GlobalSearchScope getDefaultResolveScope(VirtualFile vFile) {
        ProjectFileIndex projectFileIndex = this.myProjectRootManager.getFileIndex();
        Module module = projectFileIndex.getModuleForFile(vFile);
        if (module != null) {
            boolean includeTests = projectFileIndex.isInTestSourceContent(vFile) || !projectFileIndex.isContentJavaSourceFile(vFile);
            return GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)includeTests);
        }
        ArrayList<Module> modulesLibraryUsedIn = new ArrayList<Module>();
        List orderEntries = projectFileIndex.getOrderEntriesForFile(vFile);
        for (OrderEntry entry : orderEntries) {
            ProgressManager.checkCanceled();
            if (entry instanceof JdkOrderEntry) {
                return ((ProjectRootManagerEx)this.myProjectRootManager).getScopeForJdk((JdkOrderEntry)entry);
            }
            if (!(entry instanceof LibraryOrderEntry) && !(entry instanceof ModuleOrderEntry)) continue;
            modulesLibraryUsedIn.add(entry.getOwnerModule());
        }
        return ((ProjectRootManagerEx)this.myProjectRootManager).getScopeForLibraryUsedIn(modulesLibraryUsedIn);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public GlobalSearchScope getUseScope(@NotNull PsiElement element) {
        GlobalSearchScope globalSearchScope;
        VirtualFile vFile;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/impl/FileManagerImpl.getUseScope must not be null");
        }
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)this.myManager.getProject());
        if (element instanceof PsiDirectory) {
            vFile = ((PsiDirectory)element).getVirtualFile();
        } else {
            PsiFile containingFile = element.getContainingFile();
            if (containingFile == null) {
                globalSearchScope = allScope;
                if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/impl/FileManagerImpl.getUseScope must not return null");
                return globalSearchScope;
            }
            VirtualFile virtualFile = containingFile.getVirtualFile();
            if (virtualFile == null) {
                globalSearchScope = allScope;
                if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/impl/FileManagerImpl.getUseScope must not return null");
                return globalSearchScope;
            }
            vFile = virtualFile.getParent();
        }
        if (vFile == null) {
            globalSearchScope = allScope;
            if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/impl/FileManagerImpl.getUseScope must not return null");
            return globalSearchScope;
        }
        ProjectFileIndex projectFileIndex = this.myProjectRootManager.getFileIndex();
        Module module = projectFileIndex.getModuleForFile(vFile);
        if (module != null) {
            boolean isTest = projectFileIndex.isInTestSourceContent(vFile);
            globalSearchScope = isTest ? GlobalSearchScope.moduleTestsWithDependentsScope((Module)module) : GlobalSearchScope.moduleWithDependentsScope((Module)module);
            if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/impl/FileManagerImpl.getUseScope must not return null");
            return globalSearchScope;
        }
        PsiFile f = element.getContainingFile();
        VirtualFile vf = f == null ? null : f.getVirtualFile();
        globalSearchScope = f == null || vf == null || vf.isDirectory() || allScope.contains(vf) ? allScope : GlobalSearchScope.fileScope((PsiFile)f).uniteWith(allScope);
        if (globalSearchScope != null) return globalSearchScope;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/impl/FileManagerImpl.getUseScope must not return null");
    }

    @Nullable
    private PsiFile createFileCopyWithNewName(VirtualFile vFile, String name) {
        FileTypeManager instance = FileTypeManager.getInstance();
        if (instance.isFileIgnored(name)) {
            return null;
        }
        FileType fileTypeByFileName = instance.getFileTypeByFileName(name);
        Document document = FileDocumentManager.getInstance().getDocument(vFile);
        return PsiFileFactory.getInstance((Project)this.myManager.getProject()).createFileFromText(name, fileTypeByFileName, document != null ? document.getCharsSequence() : "", vFile.getModificationStamp(), true, false);
    }

    @Override
    @Nullable
    public PsiDirectory findDirectory(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/impl/FileManagerImpl.findDirectory must not be null");
        }
        LOG.assertTrue(this.myInitialized, (Object)"Access to psi files should be performed only after startup activity");
        LOG.assertTrue(!this.myDisposed, (Object)"Access to psi files should not be performed after disposal");
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!vFile.isValid()) {
            LOG.error("File is not valid:" + vFile.getName());
        }
        if (!vFile.isDirectory()) {
            return null;
        }
        this.dispatchPendingEvents();
        return this.findDirectoryImpl(vFile);
    }

    private PsiDirectory findDirectoryImpl(VirtualFile vFile) {
        PsiDirectory psiDir = (PsiDirectory)this.myVFileToPsiDirMap.get(vFile);
        if (psiDir != null) {
            return psiDir;
        }
        if (this.myProjectRootManager.getFileIndex().isIgnored(vFile)) {
            return null;
        }
        VirtualFile parent = vFile.getParent();
        if (parent != null) {
            this.findDirectoryImpl(parent);
        }
        psiDir = PsiDirectoryFactory.getInstance(this.myManager.getProject()).createDirectory(vFile);
        return (PsiDirectory)ConcurrencyUtil.cacheOrGet(this.myVFileToPsiDirMap, (Object)vFile, (Object)psiDir);
    }

    @Nullable
    private PsiFile getCachedPsiFileInner(VirtualFile file) {
        FileViewProvider fileViewProvider = (FileViewProvider)this.myVFileToViewProviderMap.get((Object)file);
        return fileViewProvider instanceof SingleRootFileViewProvider ? ((SingleRootFileViewProvider)fileViewProvider).getCachedPsi(fileViewProvider.getBaseLanguage()) : null;
    }

    @Override
    public List<PsiFile> getAllCachedFiles() {
        ArrayList<PsiFile> files = new ArrayList<PsiFile>();
        for (FileViewProvider provider : this.myVFileToViewProviderMap.values()) {
            if (!(provider instanceof SingleRootFileViewProvider)) continue;
            files.add(((SingleRootFileViewProvider)provider).getCachedPsi(provider.getBaseLanguage()));
        }
        return files;
    }

    private void removeInvalidFilesAndDirs(boolean useFind) {
        THashMap fileToPsiDirMap = new THashMap(this.myVFileToPsiDirMap);
        if (useFind) {
            this.myVFileToPsiDirMap.clear();
        }
        Iterator iterator = fileToPsiDirMap.keySet().iterator();
        while (iterator.hasNext()) {
            VirtualFile vFile = (VirtualFile)iterator.next();
            if (!vFile.isValid()) {
                iterator.remove();
                continue;
            }
            PsiDirectory psiDir = this.findDirectory(vFile);
            if (psiDir != null) continue;
            iterator.remove();
        }
        this.myVFileToPsiDirMap.clear();
        this.myVFileToPsiDirMap.putAll((Map<VirtualFile, PsiDirectory>)fileToPsiDirMap);
        THashMap fileToPsiFileMap = new THashMap(this.myVFileToViewProviderMap);
        if (useFind) {
            this.myVFileToViewProviderMap.clear();
        }
        Iterator iterator2 = fileToPsiFileMap.keySet().iterator();
        while (iterator2.hasNext()) {
            VirtualFile vFile = (VirtualFile)iterator2.next();
            if (!vFile.isValid()) {
                iterator2.remove();
                continue;
            }
            if (!useFind) continue;
            FileViewProvider view = (FileViewProvider)fileToPsiFileMap.get(vFile);
            if (view == null) {
                iterator2.remove();
                continue;
            }
            PsiFile psiFile1 = this.findFile(vFile);
            if (psiFile1 == null) {
                iterator2.remove();
                continue;
            }
            PsiFile psi = view.getPsi(view.getBaseLanguage());
            if (psi == null || !psiFile1.getClass().equals(psi.getClass()) || psiFile1.getViewProvider().getBaseLanguage() != view.getBaseLanguage()) {
                iterator2.remove();
                continue;
            }
            if (!(psi instanceof PsiFileImpl)) continue;
            ((PsiFileImpl)psi).clearCaches();
        }
        this.myVFileToViewProviderMap.clear();
        this.myVFileToViewProviderMap.putAll((Map)fileToPsiFileMap);
    }

    @Override
    public void reloadFromDisk(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/impl/FileManagerImpl.reloadFromDisk must not be null");
        }
        this.reloadFromDisk(file, false);
    }

    private void reloadFromDisk(PsiFile file, boolean ignoreDocument) {
        VirtualFile vFile = file.getVirtualFile();
        assert (vFile != null);
        if (!(file instanceof PsiBinaryFile)) {
            FileDocumentManager fileDocumentManager = this.myFileDocumentManager;
            Document document = fileDocumentManager.getCachedDocument(vFile);
            if (document != null && !ignoreDocument) {
                fileDocumentManager.reloadFromDisk(document);
            } else {
                PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
                event.setParent((PsiElement)file);
                event.setFile(file);
                if (file instanceof PsiFileImpl && ((PsiFileImpl)file).isContentsLoaded()) {
                    event.setOffset(0);
                    event.setOldLength(file.getTextLength());
                }
                this.myManager.beforeChildrenChange(event);
                if (file instanceof PsiFileEx) {
                    ((PsiFileEx)file).onContentReload();
                }
                this.myManager.childrenChanged(event);
            }
        }
    }

    private static boolean languageDialectChanged(PsiFile newPsiFile, String oldFileName) {
        return newPsiFile instanceof PsiFileBase && ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(newPsiFile.getLanguage())).getClass() == ((PsiFileBase)newPsiFile).getParserDefinition().getClass() && !FileUtil.getExtension((String)newPsiFile.getName()).equals(FileUtil.getExtension((String)oldFileName));
    }

    public void dumpFilesWithContentLoaded(Writer out) throws IOException {
        out.write("Files with content loaded cached in FileManagerImpl:\n");
        Set vFiles = this.myVFileToViewProviderMap.keySet();
        for (VirtualFile fileCacheEntry : vFiles) {
            FileViewProvider view = (FileViewProvider)this.myVFileToViewProviderMap.get((Object)fileCacheEntry);
            PsiFile psiFile = view.getPsi(view.getBaseLanguage());
            if (!(psiFile instanceof PsiFileImpl) || !((PsiFileImpl)psiFile).isContentsLoaded()) continue;
            out.write(fileCacheEntry.getPresentableUrl());
            out.write("\n");
        }
    }

    private class MyFileDocumentManagerAdapter
    extends FileDocumentManagerAdapter {
        private MyFileDocumentManagerAdapter() {
        }

        public void fileWithNoDocumentChanged(VirtualFile file) {
            final PsiFile psiFile = FileManagerImpl.this.getCachedPsiFileInner(file);
            if (psiFile != null) {
                ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

                    @Override
                    public void run() {
                        FileManagerImpl.this.reloadFromDisk(psiFile, true);
                    }
                });
            }
        }
    }

    private class MyModuleRootListener
    implements ModuleRootListener {
        private VirtualFile[] myOldContentRoots = null;
        private volatile int depthCounter = 0;

        private MyModuleRootListener() {
        }

        public void beforeRootsChange(ModuleRootEvent event) {
            if (!FileManagerImpl.this.myInitialized) {
                return;
            }
            if (event.isCausedByFileTypesChange()) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

                @Override
                public void run() {
                    MyModuleRootListener.this.depthCounter++;
                    if (MyModuleRootListener.this.depthCounter > 1) {
                        return;
                    }
                    PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(FileManagerImpl.this.myManager);
                    treeEvent.setPropertyName("roots");
                    VirtualFile[] contentRoots = FileManagerImpl.this.myProjectRootManager.getContentRoots();
                    LOG.assertTrue(MyModuleRootListener.this.myOldContentRoots == null);
                    MyModuleRootListener.access$2102(MyModuleRootListener.this, contentRoots);
                    treeEvent.setOldValue(contentRoots);
                    FileManagerImpl.this.myManager.beforePropertyChange(treeEvent);
                }
            });
        }

        public void rootsChanged(ModuleRootEvent event) {
            FileManagerImpl.this.dispatchPendingEvents();
            if (!FileManagerImpl.this.myInitialized) {
                return;
            }
            if (event.isCausedByFileTypesChange()) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

                @Override
                public void run() {
                    MyModuleRootListener.this.depthCounter--;
                    assert (MyModuleRootListener.this.depthCounter >= 0) : MyModuleRootListener.access$2000(MyModuleRootListener.this);
                    if (MyModuleRootListener.this.depthCounter > 0) {
                        return;
                    }
                    FileManagerImpl.this.removeInvalidFilesAndDirs(true);
                    PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(FileManagerImpl.this.myManager);
                    treeEvent.setPropertyName("roots");
                    VirtualFile[] contentRoots = FileManagerImpl.this.myProjectRootManager.getContentRoots();
                    treeEvent.setNewValue(contentRoots);
                    LOG.assertTrue(MyModuleRootListener.this.myOldContentRoots != null);
                    treeEvent.setOldValue(MyModuleRootListener.this.myOldContentRoots);
                    MyModuleRootListener.access$2102(MyModuleRootListener.this, null);
                    FileManagerImpl.this.myManager.propertyChanged(treeEvent);
                }
            });
        }

        static /* synthetic */ VirtualFile[] access$2102(MyModuleRootListener x0, VirtualFile[] x1) {
            x0.myOldContentRoots = x1;
            return x1;
        }
    }

    private class MyVirtualFileListener
    extends VirtualFileAdapter {
        private MyVirtualFileListener() {
        }

        public void contentsChanged(VirtualFileEvent event) {
        }

        public void fileCreated(VirtualFileEvent event) {
            final VirtualFile vFile = event.getFile();
            ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

                @Override
                public void run() {
                    PsiDirectory parentDir;
                    VirtualFile parent = vFile.getParent();
                    PsiDirectory psiDirectory = parentDir = parent == null ? null : (PsiDirectory)FileManagerImpl.this.myVFileToPsiDirMap.get(parent);
                    if (parentDir == null) {
                        return;
                    }
                    if (!vFile.isDirectory()) {
                        PsiFile psiFile = FileManagerImpl.this.findFile(vFile);
                        if (psiFile != null) {
                            PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(FileManagerImpl.this.myManager);
                            treeEvent.setParent((PsiElement)parentDir);
                            FileManagerImpl.this.myManager.beforeChildAddition(treeEvent);
                            treeEvent.setChild((PsiElement)psiFile);
                            FileManagerImpl.this.myManager.childAdded(treeEvent);
                        }
                    } else {
                        PsiDirectory psiDir = FileManagerImpl.this.findDirectory(vFile);
                        if (psiDir != null) {
                            PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(FileManagerImpl.this.myManager);
                            treeEvent.setParent((PsiElement)parentDir);
                            FileManagerImpl.this.myManager.beforeChildAddition(treeEvent);
                            treeEvent.setChild((PsiElement)psiDir);
                            FileManagerImpl.this.myManager.childAdded(treeEvent);
                        }
                    }
                }
            });
        }

        public void beforeFileDeletion(VirtualFileEvent event) {
            PsiDirectory parentDir;
            final VirtualFile vFile = event.getFile();
            VirtualFile parent = vFile.getParent();
            PsiDirectory psiDirectory = parentDir = parent == null ? null : (PsiDirectory)FileManagerImpl.this.myVFileToPsiDirMap.get(parent);
            if (parentDir == null) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

                @Override
                public void run() {
                    if (!vFile.isDirectory()) {
                        PsiFile psiFile = FileManagerImpl.this.getCachedPsiFile(vFile);
                        if (psiFile != null) {
                            PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(FileManagerImpl.this.myManager);
                            treeEvent.setParent((PsiElement)parentDir);
                            treeEvent.setChild((PsiElement)psiFile);
                            FileManagerImpl.this.myManager.beforeChildRemoval(treeEvent);
                        }
                    } else {
                        PsiDirectory psiDir = FileManagerImpl.this.findDirectory(vFile);
                        if (psiDir != null) {
                            PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(FileManagerImpl.this.myManager);
                            treeEvent.setParent((PsiElement)parentDir);
                            treeEvent.setChild((PsiElement)psiDir);
                            FileManagerImpl.this.myManager.beforeChildRemoval(treeEvent);
                        }
                    }
                }
            });
        }

        public void fileDeleted(VirtualFileEvent event) {
            VirtualFile vFile = event.getFile();
            VirtualFile parent = event.getParent();
            final PsiDirectory parentDir = parent == null ? null : (PsiDirectory)FileManagerImpl.this.myVFileToPsiDirMap.get(parent);
            final PsiFile psiFile = FileManagerImpl.this.getCachedPsiFileInner(vFile);
            if (psiFile != null) {
                FileManagerImpl.this.myVFileToViewProviderMap.remove((Object)vFile);
                if (parentDir != null) {
                    ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

                        @Override
                        public void run() {
                            PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(FileManagerImpl.this.myManager);
                            treeEvent.setParent((PsiElement)parentDir);
                            treeEvent.setChild((PsiElement)psiFile);
                            FileManagerImpl.this.myManager.childRemoved(treeEvent);
                        }
                    });
                }
            } else {
                final PsiDirectory psiDir = (PsiDirectory)FileManagerImpl.this.myVFileToPsiDirMap.get(vFile);
                if (psiDir != null) {
                    FileManagerImpl.this.removeInvalidFilesAndDirs(false);
                    if (parentDir != null) {
                        ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

                            @Override
                            public void run() {
                                PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(FileManagerImpl.this.myManager);
                                treeEvent.setParent((PsiElement)parentDir);
                                treeEvent.setChild((PsiElement)psiDir);
                                FileManagerImpl.this.myManager.childRemoved(treeEvent);
                            }
                        });
                    }
                }
            }
        }

        public void beforePropertyChange(final VirtualFilePropertyEvent event) {
            PsiDirectory parentDir;
            final VirtualFile vFile = event.getFile();
            final String propertyName = event.getPropertyName();
            VirtualFile parent = vFile.getParent();
            PsiDirectory psiDirectory = parentDir = parent == null ? null : (PsiDirectory)FileManagerImpl.this.myVFileToPsiDirMap.get(parent);
            if (parentDir == null) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

                @Override
                public void run() {
                    PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(FileManagerImpl.this.myManager);
                    treeEvent.setParent((PsiElement)parentDir);
                    if ("name".equals(propertyName)) {
                        String newName = (String)event.getNewValue();
                        if (vFile.isDirectory()) {
                            PsiDirectory psiDir = FileManagerImpl.this.findDirectory(vFile);
                            if (psiDir != null) {
                                if (!FileManagerImpl.this.myFileTypeManager.isFileIgnored(newName)) {
                                    treeEvent.setChild((PsiElement)psiDir);
                                    treeEvent.setPropertyName("directoryName");
                                    treeEvent.setOldValue(vFile.getName());
                                    treeEvent.setNewValue(newName);
                                    FileManagerImpl.this.myManager.beforePropertyChange(treeEvent);
                                } else {
                                    treeEvent.setChild((PsiElement)psiDir);
                                    FileManagerImpl.this.myManager.beforeChildRemoval(treeEvent);
                                }
                            } else if (!MyVirtualFileListener.this.isExcludeRoot(vFile) && !FileManagerImpl.this.myFileTypeManager.isFileIgnored(newName)) {
                                FileManagerImpl.this.myManager.beforeChildAddition(treeEvent);
                            }
                        } else {
                            FileViewProvider viewProvider = FileManagerImpl.this.findViewProvider(vFile);
                            PsiFile psiFile = viewProvider.getPsi(viewProvider.getBaseLanguage());
                            PsiFile psiFile1 = FileManagerImpl.this.createFileCopyWithNewName(vFile, newName);
                            if (psiFile != null) {
                                if (psiFile1 == null) {
                                    treeEvent.setChild((PsiElement)psiFile);
                                    FileManagerImpl.this.myManager.beforeChildRemoval(treeEvent);
                                } else if (!psiFile1.getClass().equals(psiFile.getClass())) {
                                    treeEvent.setOldChild((PsiElement)psiFile);
                                    FileManagerImpl.this.myManager.beforeChildReplacement(treeEvent);
                                } else {
                                    treeEvent.setChild((PsiElement)psiFile);
                                    treeEvent.setPropertyName("fileName");
                                    treeEvent.setOldValue(vFile.getName());
                                    treeEvent.setNewValue(newName);
                                    FileManagerImpl.this.myManager.beforePropertyChange(treeEvent);
                                }
                            } else if (psiFile1 != null) {
                                FileManagerImpl.this.myManager.beforeChildAddition(treeEvent);
                            }
                        }
                    } else if ("writable".equals(propertyName)) {
                        PsiFile psiFile = FileManagerImpl.this.getCachedPsiFileInner(vFile);
                        if (psiFile == null) {
                            return;
                        }
                        treeEvent.setElement((PsiElement)psiFile);
                        treeEvent.setPropertyName("writable");
                        treeEvent.setOldValue(event.getOldValue());
                        treeEvent.setNewValue(event.getNewValue());
                        FileManagerImpl.this.myManager.beforePropertyChange(treeEvent);
                    }
                }
            });
        }

        private boolean isExcludeRoot(VirtualFile file) {
            VirtualFile[] excludeRoots;
            VirtualFile parent = file.getParent();
            if (parent == null) {
                return false;
            }
            Module module = FileManagerImpl.this.myProjectRootManager.getFileIndex().getModuleForFile(parent);
            if (module == null) {
                return false;
            }
            for (VirtualFile root : excludeRoots = ModuleRootManager.getInstance((Module)module).getExcludeRoots()) {
                if (!root.equals(file)) continue;
                return true;
            }
            return false;
        }

        public void propertyChanged(final VirtualFilePropertyEvent event) {
            PsiDirectory parentDir;
            final String propertyName = event.getPropertyName();
            final VirtualFile vFile = event.getFile();
            final FileViewProvider oldFileViewProvider = FileManagerImpl.this.findViewProvider(vFile);
            final PsiFile oldPsiFile = oldFileViewProvider instanceof SingleRootFileViewProvider ? ((SingleRootFileViewProvider)oldFileViewProvider).getCachedPsi(oldFileViewProvider.getBaseLanguage()) : null;
            VirtualFile parent = vFile.getParent();
            PsiDirectory psiDirectory = parentDir = parent == null ? null : (PsiDirectory)FileManagerImpl.this.myVFileToPsiDirMap.get(parent);
            if (parentDir == null) {
                boolean fire;
                boolean bl = fire = "name".equals(propertyName) && vFile.isDirectory();
                if (fire) {
                    PsiDirectory psiDir = (PsiDirectory)FileManagerImpl.this.myVFileToPsiDirMap.get(vFile);
                    boolean bl2 = fire = psiDir != null;
                }
                if (!fire) {
                    return;
                }
            }
            if (oldPsiFile != null && oldPsiFile.isPhysical()) {
                SmartPointerManagerImpl.fastenBelts(oldPsiFile);
            }
            ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

                @Override
                public void run() {
                    PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(FileManagerImpl.this.myManager);
                    treeEvent.setParent((PsiElement)parentDir);
                    if ("name".equals(propertyName)) {
                        if (vFile.isDirectory()) {
                            PsiDirectory psiDir = (PsiDirectory)FileManagerImpl.this.myVFileToPsiDirMap.get(vFile);
                            if (psiDir != null) {
                                if (FileManagerImpl.this.myFileTypeManager.isFileIgnored(vFile.getName())) {
                                    MyVirtualFileListener.this.removeFilesAndDirsRecursively(vFile);
                                    treeEvent.setChild((PsiElement)psiDir);
                                    FileManagerImpl.this.myManager.childRemoved(treeEvent);
                                } else {
                                    treeEvent.setElement((PsiElement)psiDir);
                                    treeEvent.setPropertyName("directoryName");
                                    treeEvent.setOldValue(event.getOldValue());
                                    treeEvent.setNewValue(event.getNewValue());
                                    FileManagerImpl.this.myManager.propertyChanged(treeEvent);
                                }
                            } else {
                                PsiDirectory psiDir1 = FileManagerImpl.this.findDirectory(vFile);
                                if (psiDir1 != null) {
                                    treeEvent.setChild((PsiElement)psiDir1);
                                    FileManagerImpl.this.myManager.childAdded(treeEvent);
                                }
                            }
                        } else {
                            FileViewProvider fileViewProvider = FileManagerImpl.this.createFileViewProvider(vFile, true);
                            PsiFile newPsiFile = fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
                            if (oldPsiFile != null) {
                                if (newPsiFile == null) {
                                    FileManagerImpl.this.myVFileToViewProviderMap.remove((Object)vFile);
                                    treeEvent.setChild((PsiElement)oldPsiFile);
                                    FileManagerImpl.this.myManager.childRemoved(treeEvent);
                                } else if (!newPsiFile.getClass().equals(oldPsiFile.getClass()) || newPsiFile.getFileType() != FileManagerImpl.this.myFileTypeManager.getFileTypeByFileName((String)event.getOldValue()) || FileManagerImpl.languageDialectChanged(newPsiFile, (String)event.getOldValue()) || !((Object)oldFileViewProvider.getLanguages()).equals(fileViewProvider.getLanguages()) || "FileContentUtil.saveOrReload".equals(event.getRequestor())) {
                                    FileManagerImpl.this.myVFileToViewProviderMap.put((Object)vFile, (Object)fileViewProvider);
                                    treeEvent.setOldChild((PsiElement)oldPsiFile);
                                    treeEvent.setNewChild((PsiElement)newPsiFile);
                                    FileManagerImpl.this.myManager.childReplaced(treeEvent);
                                } else {
                                    treeEvent.setElement((PsiElement)oldPsiFile);
                                    treeEvent.setPropertyName("fileName");
                                    treeEvent.setOldValue(event.getOldValue());
                                    treeEvent.setNewValue(event.getNewValue());
                                    FileManagerImpl.this.myManager.propertyChanged(treeEvent);
                                }
                            } else if (newPsiFile != null) {
                                FileManagerImpl.this.myVFileToViewProviderMap.put((Object)vFile, (Object)fileViewProvider);
                                treeEvent.setChild((PsiElement)newPsiFile);
                                FileManagerImpl.this.myManager.childAdded(treeEvent);
                            }
                        }
                    } else if ("writable".equals(propertyName)) {
                        if (oldPsiFile == null) {
                            return;
                        }
                        treeEvent.setElement((PsiElement)oldPsiFile);
                        treeEvent.setPropertyName("writable");
                        treeEvent.setOldValue(event.getOldValue());
                        treeEvent.setNewValue(event.getNewValue());
                        FileManagerImpl.this.myManager.propertyChanged(treeEvent);
                    }
                }
            });
        }

        public void beforeFileMovement(VirtualFileMoveEvent event) {
            final VirtualFile vFile = event.getFile();
            final PsiDirectory oldParentDir = FileManagerImpl.this.findDirectory(event.getOldParent());
            final PsiDirectory newParentDir = FileManagerImpl.this.findDirectory(event.getNewParent());
            if (oldParentDir == null && newParentDir == null) {
                return;
            }
            if (FileManagerImpl.this.myFileTypeManager.isFileIgnored(vFile.getName())) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

                @Override
                public void run() {
                    boolean isExcluded;
                    PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(FileManagerImpl.this.myManager);
                    boolean bl = isExcluded = vFile.isDirectory() && FileManagerImpl.this.myProjectFileIndex.isIgnored(vFile);
                    if (oldParentDir != null && !isExcluded) {
                        if (newParentDir != null) {
                            treeEvent.setOldParent((PsiElement)oldParentDir);
                            treeEvent.setNewParent((PsiElement)newParentDir);
                            if (vFile.isDirectory()) {
                                PsiDirectory psiDir = FileManagerImpl.this.findDirectory(vFile);
                                treeEvent.setChild((PsiElement)psiDir);
                            } else {
                                PsiFile psiFile = FileManagerImpl.this.findFile(vFile);
                                treeEvent.setChild((PsiElement)psiFile);
                            }
                            FileManagerImpl.this.myManager.beforeChildMovement(treeEvent);
                        } else {
                            treeEvent.setParent((PsiElement)oldParentDir);
                            if (vFile.isDirectory()) {
                                PsiDirectory psiDir = FileManagerImpl.this.findDirectory(vFile);
                                treeEvent.setChild((PsiElement)psiDir);
                            } else {
                                PsiFile psiFile = FileManagerImpl.this.findFile(vFile);
                                treeEvent.setChild((PsiElement)psiFile);
                            }
                            FileManagerImpl.this.myManager.beforeChildRemoval(treeEvent);
                        }
                    } else {
                        LOG.assertTrue(newParentDir != null);
                        treeEvent.setParent((PsiElement)newParentDir);
                        FileManagerImpl.this.myManager.beforeChildAddition(treeEvent);
                    }
                }
            });
        }

        public void fileMoved(VirtualFileMoveEvent event) {
            PsiDirectory newElement;
            FileViewProvider newViewProvider;
            VirtualFile vFile = event.getFile();
            PsiDirectory oldParentDir = FileManagerImpl.this.findDirectory(event.getOldParent());
            PsiDirectory newParentDir = FileManagerImpl.this.findDirectory(event.getNewParent());
            if (oldParentDir == null && newParentDir == null) {
                return;
            }
            PsiFile oldElement = vFile.isDirectory() ? (PsiFileSystemItem)FileManagerImpl.this.myVFileToPsiDirMap.get(vFile) : FileManagerImpl.this.getCachedPsiFileInner(vFile);
            FileManagerImpl.this.removeInvalidFilesAndDirs(true);
            FileViewProvider viewProvider = FileManagerImpl.this.findViewProvider(vFile);
            if (!vFile.isDirectory()) {
                newViewProvider = FileManagerImpl.this.createFileViewProvider(vFile, true);
                newElement = newViewProvider.getPsi(viewProvider.getBaseLanguage());
            } else {
                newElement = FileManagerImpl.this.findDirectory(vFile);
                newViewProvider = null;
            }
            if (oldElement == null && newElement == null) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction((PsiElement)oldElement, (PsiElement)newElement, vFile, newViewProvider, oldParentDir, newParentDir){
                final /* synthetic */ PsiElement val$oldElement;
                final /* synthetic */ PsiElement val$newElement;
                final /* synthetic */ VirtualFile val$vFile;
                final /* synthetic */ FileViewProvider val$newViewProvider;
                final /* synthetic */ PsiDirectory val$oldParentDir;
                final /* synthetic */ PsiDirectory val$newParentDir;
                {
                    this.val$oldElement = psiElement;
                    this.val$newElement = psiElement2;
                    this.val$vFile = virtualFile;
                    this.val$newViewProvider = fileViewProvider;
                    this.val$oldParentDir = psiDirectory;
                    this.val$newParentDir = psiDirectory2;
                }

                @Override
                public void run() {
                    PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(FileManagerImpl.this.myManager);
                    if (this.val$oldElement != null) {
                        if (this.val$newElement != null) {
                            if (!this.val$oldElement.getClass().equals(this.val$oldElement.getClass())) {
                                FileManagerImpl.this.myVFileToViewProviderMap.put((Object)this.val$vFile, (Object)this.val$newViewProvider);
                                PsiTreeChangeEventImpl treeRemoveEvent = new PsiTreeChangeEventImpl(FileManagerImpl.this.myManager);
                                treeRemoveEvent.setParent((PsiElement)this.val$oldParentDir);
                                treeRemoveEvent.setChild(this.val$oldElement);
                                FileManagerImpl.this.myManager.childRemoved(treeRemoveEvent);
                                PsiTreeChangeEventImpl treeAddEvent = new PsiTreeChangeEventImpl(FileManagerImpl.this.myManager);
                                treeAddEvent.setParent((PsiElement)this.val$newParentDir);
                                treeAddEvent.setChild(this.val$newElement);
                                FileManagerImpl.this.myManager.childAdded(treeAddEvent);
                            } else {
                                treeEvent.setOldParent((PsiElement)this.val$oldParentDir);
                                treeEvent.setNewParent((PsiElement)this.val$newParentDir);
                                treeEvent.setChild(this.val$newElement);
                                FileManagerImpl.this.myManager.childMoved(treeEvent);
                            }
                        } else {
                            FileManagerImpl.this.myVFileToViewProviderMap.remove((Object)this.val$vFile);
                            treeEvent.setParent((PsiElement)this.val$oldParentDir);
                            treeEvent.setChild(this.val$oldElement);
                            FileManagerImpl.this.myManager.childRemoved(treeEvent);
                        }
                    } else {
                        FileManagerImpl.this.myVFileToViewProviderMap.put((Object)this.val$vFile, (Object)this.val$newViewProvider);
                        LOG.assertTrue(this.val$newElement != null);
                        treeEvent.setParent((PsiElement)this.val$newParentDir);
                        treeEvent.setChild(this.val$newElement);
                        FileManagerImpl.this.myManager.childAdded(treeEvent);
                    }
                }
            });
        }

        private void removeFilesAndDirsRecursively(VirtualFile vFile) {
            if (vFile.isDirectory()) {
                VirtualFile[] children;
                FileManagerImpl.this.myVFileToPsiDirMap.remove(vFile);
                for (VirtualFile child : children = vFile.getChildren()) {
                    this.removeFilesAndDirsRecursively(child);
                }
            } else {
                FileManagerImpl.this.myVFileToViewProviderMap.remove((Object)vFile);
            }
        }
    }

    private abstract class FileTypesChanged
    implements Runnable {
        private FileTypesChanged() {
        }

        protected abstract void updateMaps();

        @Override
        public void run() {
            PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(FileManagerImpl.this.myManager);
            event.setPropertyName("propFileTypes");
            FileManagerImpl.this.myManager.beforePropertyChange(event);
            this.updateMaps();
            event = new PsiTreeChangeEventImpl(FileManagerImpl.this.myManager);
            event.setPropertyName("propFileTypes");
            FileManagerImpl.this.myManager.propertyChanged(event);
        }
    }
}

