/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.ide.caches.CacheUpdater;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.cache.impl.CacheUtil;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.cache.impl.todo.TodoIndex;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class IndexCacheManagerImpl
implements CacheManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.cache.impl.IndexCacheManagerImpl");
    private final Project myProject;
    private final PsiManager myPsiManager;

    public IndexCacheManagerImpl(PsiManager psiManager) {
        this.myPsiManager = psiManager;
        this.myProject = psiManager.getProject();
    }

    @Override
    public void initialize() {
    }

    @Override
    public void dispose() {
    }

    @Override
    @NotNull
    public CacheUpdater[] getCacheUpdaters() {
        CacheUpdater[] cacheUpdaterArray = new CacheUpdater[]{};
        if (cacheUpdaterArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/impl/IndexCacheManagerImpl.getCacheUpdaters must not return null");
        }
        return cacheUpdaterArray;
    }

    @Override
    @NotNull
    public PsiFile[] getFilesWithWord(@NotNull String word, short occurenceMask, @NotNull GlobalSearchScope scope, boolean caseSensitively) {
        if (word == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/cache/impl/IndexCacheManagerImpl.getFilesWithWord must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/cache/impl/IndexCacheManagerImpl.getFilesWithWord must not be null");
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.processFilesWithWord((Processor<PsiFile>)processor, word, occurenceMask, scope, caseSensitively);
        PsiFile[] psiFileArray = processor.getResults().isEmpty() ? PsiFile.EMPTY_ARRAY : (PsiFile[])processor.toArray((Object[])PsiFile.EMPTY_ARRAY);
        if (psiFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/impl/IndexCacheManagerImpl.getFilesWithWord must not return null");
        }
        return psiFileArray;
    }

    @Override
    public boolean processFilesWithWord(final @NotNull Processor<PsiFile> psiFileProcessor, final @NotNull String word, final short occurrenceMask, final @NotNull GlobalSearchScope scope, final boolean caseSensitively) {
        if (psiFileProcessor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/cache/impl/IndexCacheManagerImpl.processFilesWithWord must not be null");
        }
        if (word == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/cache/impl/IndexCacheManagerImpl.processFilesWithWord must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/cache/impl/IndexCacheManagerImpl.processFilesWithWord must not be null");
        }
        THashSet vFiles = new THashSet();
        GlobalSearchScope projectScope = GlobalSearchScope.allScope((Project)this.myProject);
        ApplicationManager.getApplication().runReadAction(new Runnable((Set)vFiles, projectScope){
            final /* synthetic */ Set val$vFiles;
            final /* synthetic */ GlobalSearchScope val$projectScope;
            {
                this.val$vFiles = set;
                this.val$projectScope = globalSearchScope;
            }

            @Override
            public void run() {
                FileBasedIndex.getInstance().processValues(IdIndex.NAME, new IdIndexEntry(word, caseSensitively), null, new FileBasedIndex.ValueProcessor<Integer>(){

                    @Override
                    public boolean process(VirtualFile file, Integer value) {
                        ProgressManager.checkCanceled();
                        int mask = value;
                        if ((mask & occurrenceMask) != 0) {
                            val$vFiles.add(file);
                        }
                        return true;
                    }
                }, this.val$projectScope);
            }
        });
        if (vFiles.isEmpty()) {
            return true;
        }
        final ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        Processor<VirtualFile> virtualFileProcessor = new Processor<VirtualFile>(){

            public boolean process(final VirtualFile virtualFile) {
                LOG.assertTrue(virtualFile.isValid());
                return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        if (virtualFile.isValid() && scope.contains(virtualFile) && (index.isInContent(virtualFile) || index.isInLibrarySource(virtualFile))) {
                            if (virtualFile.getFileType().isBinary()) {
                                return Boolean.TRUE;
                            }
                            PsiFile psiFile = IndexCacheManagerImpl.this.myPsiManager.findFile(virtualFile);
                            return psiFile == null || psiFileProcessor.process((Object)psiFile);
                        }
                        return Boolean.TRUE;
                    }
                });
            }
        };
        for (VirtualFile vFile : vFiles) {
            ProgressManager.checkCanceled();
            if (virtualFileProcessor.process((Object)vFile)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public PsiFile[] getFilesWithTodoItems() {
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        final HashSet allFiles = new HashSet();
        final ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        for (IndexPattern indexPattern : CacheUtil.getIndexPatterns()) {
            final Collection<VirtualFile> files = fileBasedIndex.getContainingFiles(TodoIndex.NAME, new TodoIndexEntry(indexPattern.getPatternString(), indexPattern.isCaseSensitive()), GlobalSearchScope.allScope((Project)this.myProject));
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    for (VirtualFile file : files) {
                        PsiFile psiFile;
                        if (!projectFileIndex.isInContent(file) || (psiFile = IndexCacheManagerImpl.this.myPsiManager.findFile(file)) == null) continue;
                        allFiles.add(psiFile);
                    }
                }
            });
        }
        PsiFile[] psiFileArray = allFiles.isEmpty() ? PsiFile.EMPTY_ARRAY : allFiles.toArray(new PsiFile[allFiles.size()]);
        if (psiFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/impl/IndexCacheManagerImpl.getFilesWithTodoItems must not return null");
        }
        return psiFileArray;
    }

    @Override
    public int getTodoCount(@NotNull VirtualFile file, IndexPatternProvider patternProvider) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/cache/impl/IndexCacheManagerImpl.getTodoCount must not be null");
        }
        if (file instanceof VirtualFileWindow) {
            return -1;
        }
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        int count = 0;
        for (IndexPattern indexPattern : patternProvider.getIndexPatterns()) {
            count += this.fetchCount(fileBasedIndex, file, indexPattern);
        }
        return count;
    }

    @Override
    public int getTodoCount(@NotNull VirtualFile file, IndexPattern pattern) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/cache/impl/IndexCacheManagerImpl.getTodoCount must not be null");
        }
        if (file instanceof VirtualFileWindow) {
            return -1;
        }
        return this.fetchCount(FileBasedIndex.getInstance(), file, pattern);
    }

    private int fetchCount(FileBasedIndex fileBasedIndex, VirtualFile file, IndexPattern indexPattern) {
        final int[] count = new int[]{0};
        fileBasedIndex.processValues(TodoIndex.NAME, new TodoIndexEntry(indexPattern.getPatternString(), indexPattern.isCaseSensitive()), file, new FileBasedIndex.ValueProcessor<Integer>(){

            @Override
            public boolean process(VirtualFile file, Integer value) {
                count[0] = count[0] + value;
                return true;
            }
        }, GlobalSearchScope.fileScope((Project)this.myProject, (VirtualFile)file));
        return count[0];
    }

    @Override
    public void addOrInvalidateFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/cache/impl/IndexCacheManagerImpl.addOrInvalidateFile must not be null");
        }
    }
}

