/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.ide.util.EditSourceUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class PsiElementBase
extends ElementBase
implements PsiElement {
    public PsiElement getFirstChild() {
        PsiElement[] children = this.getChildren();
        if (children.length == 0) {
            return null;
        }
        return children[0];
    }

    public PsiElement getLastChild() {
        PsiElement[] children = this.getChildren();
        if (children.length == 0) {
            return null;
        }
        return children[children.length - 1];
    }

    public PsiElement getNextSibling() {
        return SharedPsiElementImplUtil.getNextSibling(this);
    }

    public PsiElement getPrevSibling() {
        return SharedPsiElementImplUtil.getPrevSibling(this);
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        PsiElement[] children;
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementBase.acceptChildren must not be null");
        }
        for (PsiElement child : children = this.getChildren()) {
            child.accept(visitor);
        }
    }

    public PsiReference getReference() {
        return null;
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences(this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementBase.getReferences must not return null");
        }
        return psiReferenceArray;
    }

    public PsiReference findReferenceAt(int offset) {
        return SharedPsiElementImplUtil.findReferenceAt(this, offset);
    }

    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException("Operation not supported in: " + ((Object)((Object)this)).getClass());
    }

    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementBase.addRangeBefore must not be null");
        }
        if (last == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementBase.addRangeBefore must not be null");
        }
        throw new IncorrectOperationException("Operation not supported in: " + ((Object)((Object)this)).getClass());
    }

    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        throw new IncorrectOperationException("Operation not supported in: " + ((Object)((Object)this)).getClass());
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException("Operation not supported in: " + ((Object)((Object)this)).getClass());
    }

    public boolean textContains(char c) {
        return this.getText().indexOf(c) >= 0;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementBase.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementBase.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/PsiElementBase.processDeclarations must not be null");
        }
        return true;
    }

    public PsiElement getContext() {
        return this.getParent();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElementBase psiElementBase = this;
        if (psiElementBase == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementBase.getNavigationElement must not return null");
        }
        return psiElementBase;
    }

    public PsiElement getOriginalElement() {
        return this;
    }

    @NotNull
    public final GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = ((PsiManagerEx)this.getManager()).getFileManager().getResolveScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementBase.getResolveScope must not return null");
        }
        return globalSearchScope;
    }

    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = ((PsiManagerEx)this.getManager()).getFileManager().getUseScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementBase.getUseScope must not return null");
        }
        return globalSearchScope;
    }

    public void navigate(boolean requestFocus) {
        EditSourceUtil.getDescriptor((PsiElement)this).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return EditSourceUtil.canNavigate((PsiElement)this);
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @NotNull
    public Project getProject() {
        PsiManager manager = this.getManager();
        if (manager == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        Project project = manager.getProject();
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementBase.getProject must not return null");
        }
        return project;
    }

    public ItemPresentation getPresentation() {
        return null;
    }

    public FileStatus getFileStatus() {
        return FileStatus.NOT_CHANGED;
    }

    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }
}

