/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.ide.IconProvider;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.IconSet;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.util.Icons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDirectoryIconProvider
extends IconProvider
implements DumbAware {
    @Nullable
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaDirectoryIconProvider.getIcon must not be null");
        }
        if (element instanceof PsiDirectory) {
            Module module;
            boolean isOpen;
            PsiDirectory psiDirectory = (PsiDirectory)element;
            VirtualFile vFile = psiDirectory.getVirtualFile();
            Project project = psiDirectory.getProject();
            boolean isJarRoot = vFile.getParent() == null && vFile.getFileSystem() instanceof JarFileSystem;
            boolean isContentRoot = ProjectRootsUtil.isModuleContentRoot(vFile, project);
            boolean inTestSource = ProjectRootsUtil.isInTestSource(vFile, project);
            boolean isSourceOrTestRoot = ProjectRootsUtil.isSourceOrTestRoot(vFile, project);
            boolean bl = isOpen = (flags & 4) != 0;
            Icon symbolIcon = isJarRoot ? Icons.JAR_ICON : (isContentRoot ? ((module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(vFile)) != null ? module.getModuleType().getNodeIcon(isOpen) : (isOpen ? Icons.CONTENT_ROOT_ICON_OPEN : Icons.CONTENT_ROOT_ICON_CLOSED)) : (isSourceOrTestRoot ? IconSet.getSourceRootIcon(inTestSource, isOpen) : (JavaDirectoryService.getInstance().getPackage(psiDirectory) != null ? (isOpen ? Icons.PACKAGE_OPEN_ICON : Icons.PACKAGE_ICON) : (isOpen ? Icons.DIRECTORY_OPEN_ICON : Icons.DIRECTORY_CLOSED_ICON))));
            boolean isExcluded = ElementPresentationUtil.isExcluded(vFile, project);
            return ElementBase.createLayeredIcon((Icon)symbolIcon, (int)(isExcluded ? 4096 : 0));
        }
        return null;
    }
}

