/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.util.ReflectionCache;
import org.jetbrains.annotations.NonNls;

public class AnnotationParameterFilter
implements ElementFilter {
    private final Class<? extends PsiElement> myClass;
    @NonNls
    private final String myParameterName;
    private final String myAnnotationQualifiedName;

    public AnnotationParameterFilter(Class<? extends PsiElement> elementClass, String annotationQualifiedName, @NonNls String parameterName) {
        this.myAnnotationQualifiedName = annotationQualifiedName;
        this.myClass = elementClass;
        this.myParameterName = parameterName;
    }

    public boolean isAcceptable(Object element, PsiElement context) {
        PsiElement grandParent;
        PsiElement psiElement;
        PsiNameValuePair pair;
        String name;
        PsiElement parent = ((PsiElement)element).getParent();
        return parent instanceof PsiNameValuePair && (this.myParameterName.equals(name = (pair = (PsiNameValuePair)parent).getName()) || name == null && "value".equals(this.myParameterName)) && (psiElement = pair.getParent()) instanceof PsiAnnotationParameterList && (grandParent = psiElement.getParent()) instanceof PsiAnnotation && this.myAnnotationQualifiedName.equals(((PsiAnnotation)grandParent).getQualifiedName());
    }

    public boolean isClassAcceptable(Class hintClass) {
        return ReflectionCache.isAssignable(this.myClass, (Class)hintClass);
    }
}

