/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlTagTextUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlElementFactoryImpl
extends XmlElementFactory {
    private final Project myProject;

    public XmlElementFactoryImpl(Project project) {
        this.myProject = project;
    }

    @NotNull
    public XmlTag createTagFromText(@NotNull @NonNls String text, @NotNull Language language) throws IncorrectOperationException {
        XmlDocument document;
        XmlTag tag;
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/XmlElementFactoryImpl.createTagFromText must not be null");
        }
        if (language == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/XmlElementFactoryImpl.createTagFromText must not be null");
        }
        assert (language instanceof XMLLanguage) : "Tag can be created only for xml language";
        FileType type = language.getAssociatedFileType();
        if (type == null) {
            type = StdFileTypes.XML;
        }
        if ((tag = (document = this.createXmlDocument(text, "dummy." + type.getDefaultExtension())).getRootTag()) == null) {
            throw new IncorrectOperationException("Incorrect tag text");
        }
        XmlTag xmlTag = tag;
        if (xmlTag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/XmlElementFactoryImpl.createTagFromText must not return null");
        }
        return xmlTag;
    }

    @NotNull
    public XmlTag createTagFromText(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/XmlElementFactoryImpl.createTagFromText must not be null");
        }
        XmlTag xmlTag = this.createTagFromText(text, StdFileTypes.XML.getLanguage());
        if (xmlTag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/XmlElementFactoryImpl.createTagFromText must not return null");
        }
        return xmlTag;
    }

    @NotNull
    public XmlAttribute createXmlAttribute(@NotNull String name, String value) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/XmlElementFactoryImpl.createXmlAttribute must not be null");
        }
        XmlDocument document = this.createXmlDocument("<tag " + name + "=\"" + value + "\"/>", "dummy.xml");
        XmlTag tag = document.getRootTag();
        assert (tag != null);
        XmlAttribute xmlAttribute = tag.getAttributes()[0];
        if (xmlAttribute == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/XmlElementFactoryImpl.createXmlAttribute must not return null");
        }
        return xmlAttribute;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public XmlText createDisplayText(@NotNull String s) throws IncorrectOperationException {
        XmlText xmlText;
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/XmlElementFactoryImpl.createDisplayText must not be null");
        }
        XmlTag tagFromText = this.createTagFromText("<a>" + XmlTagTextUtil.getCDATAQuote((String)s) + "</a>");
        XmlText[] textElements = tagFromText.getValue().getTextElements();
        if (textElements.length == 0) {
            xmlText = (XmlText)ASTFactory.composite(XmlElementType.XML_TEXT);
            if (xmlText == null) throw new IllegalStateException("@NotNull method com/intellij/psi/XmlElementFactoryImpl.createDisplayText must not return null");
            return xmlText;
        }
        xmlText = textElements[0];
        if (xmlText != null) return xmlText;
        throw new IllegalStateException("@NotNull method com/intellij/psi/XmlElementFactoryImpl.createDisplayText must not return null");
    }

    @NotNull
    public XmlTag createXHTMLTagFromText(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/XmlElementFactoryImpl.createXHTMLTagFromText must not be null");
        }
        XmlDocument document = this.createXmlDocument(text, "dummy.xhtml");
        XmlTag tag = document.getRootTag();
        assert (tag != null);
        XmlTag xmlTag = tag;
        if (xmlTag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/XmlElementFactoryImpl.createXHTMLTagFromText must not return null");
        }
        return xmlTag;
    }

    private XmlDocument createXmlDocument(@NonNls String text, @NonNls String fileName) {
        XmlDocument document = ((XmlFile)PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(fileName, text)).getDocument();
        assert (document != null);
        return document;
    }
}

