/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ui.ErrorsConfigurable;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.HashMap;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public abstract class InspectionToolsConfigurable
extends BaseConfigurable
implements ErrorsConfigurable,
SearchableConfigurable {
    private CardLayout myLayout;
    private JPanel myPanel;
    public static final String ID = "Errors";
    public static final String DISPLAY_NAME = "Inspections";
    protected JComboBox myProfiles;
    private Map<String, SingleInspectionProfilePanel> myPanels;
    private JPanel myWholePanel;
    private JButton myAddButton;
    private JButton myDeleteButton;
    private JButton myImportButton;
    private JButton myExportButton;
    private JCheckBox myShareProfileCheckBox;
    private JButton myCopyButton;
    private ArrayList<String> myDeletedProfiles;
    protected final InspectionProfileManager myProfileManager;
    protected final InspectionProjectProfileManager myProjectProfileManager;
    private static final Logger LOG = Logger.getInstance((String)("#" + InspectionToolsConfigurable.class.getName()));

    public InspectionToolsConfigurable(InspectionProjectProfileManager projectProfileManager, InspectionProfileManager profileManager) {
        this.$$$setupUI$$$();
        this.myLayout = new CardLayout();
        this.myPanels = new HashMap();
        this.myDeletedProfiles = new ArrayList();
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifiableModel model = SingleInspectionProfilePanel.createNewProfile(-1, InspectionToolsConfigurable.this.getSelectedObject(), InspectionToolsConfigurable.this.myWholePanel, "");
                if (model != null) {
                    InspectionToolsConfigurable.this.addProfile((InspectionProfileImpl)model);
                    InspectionToolsConfigurable.this.myDeletedProfiles.remove(model.getName());
                    InspectionToolsConfigurable.this.myDeleteButton.setEnabled(true);
                }
            }
        });
        this.myDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InspectionProfileImpl selectedProfile = (InspectionProfileImpl)((Object)InspectionToolsConfigurable.this.myProfiles.getSelectedItem());
                ((DefaultComboBoxModel)InspectionToolsConfigurable.this.myProfiles.getModel()).removeElement((Object)selectedProfile);
                InspectionToolsConfigurable.this.myDeletedProfiles.add(selectedProfile.getName());
                InspectionToolsConfigurable.this.myDeleteButton.setEnabled(InspectionToolsConfigurable.this.myProfiles.getModel().getSize() > 1);
            }
        });
        this.myImportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){

                    public boolean isFileSelectable(VirtualFile file) {
                        return file.getFileType().equals(StdFileTypes.XML);
                    }
                };
                descriptor.setDescription("Choose profile file");
                VirtualFile[] files = FileChooser.chooseFiles((Component)InspectionToolsConfigurable.this.myWholePanel, (FileChooserDescriptor)descriptor);
                if (files.length == 0) {
                    return;
                }
                InspectionProfileImpl profile = new InspectionProfileImpl("TempProfile", InspectionToolRegistrar.getInstance(), (ProfileManager)InspectionToolsConfigurable.this.myProfileManager);
                try {
                    Element rootElement = JDOMUtil.loadDocument((File)VfsUtil.virtualToIoFile((VirtualFile)files[0])).getRootElement();
                    HashSet<String> levels = new HashSet<String>();
                    for (Object o : rootElement.getChildren("inspection_tool")) {
                        Element inspectElement = (Element)o;
                        levels.add(inspectElement.getAttributeValue("level"));
                        for (Object s : inspectElement.getChildren("scope")) {
                            levels.add(((Element)s).getAttributeValue("level"));
                        }
                    }
                    Iterator iterator = levels.iterator();
                    while (iterator.hasNext()) {
                        String level = (String)iterator.next();
                        if (InspectionToolsConfigurable.this.myProfileManager.getOwnSeverityRegistrar().getSeverity(level) == null) continue;
                        iterator.remove();
                    }
                    if (!levels.isEmpty() && Messages.showYesNoDialog((Component)InspectionToolsConfigurable.this.myWholePanel, (String)("Undefined severities detected: " + StringUtil.join(levels, (String)", ") + ". Do you want to create them?"), (String)"Warning", (Icon)Messages.getWarningIcon()) == 0) {
                        for (String level : levels) {
                            TextAttributes textAttributes = CodeInsightColors.WARNINGS_ATTRIBUTES.getDefaultAttributes();
                            HighlightInfoType.HighlightInfoTypeImpl info = new HighlightInfoType.HighlightInfoTypeImpl(new HighlightSeverity(level, 50), TextAttributesKey.createTextAttributesKey((String)level));
                            InspectionToolsConfigurable.this.myProfileManager.getOwnSeverityRegistrar().registerSeverity(new SeverityRegistrar.SeverityBasedTextAttributes(textAttributes.clone(), info), textAttributes.getErrorStripeColor());
                        }
                    }
                    profile.readExternal(rootElement);
                    profile.initInspectionTools();
                    if (InspectionToolsConfigurable.this.myProfileManager.getProfile(profile.getName(), false) != null && Messages.showOkCancelDialog((Component)InspectionToolsConfigurable.this.myWholePanel, (String)("Profile with name '" + profile.getName() + "' already exists. Do you want to overwrite it?"), (String)"Warning", (Icon)Messages.getInformationIcon()) != 0) {
                        return;
                    }
                    InspectionToolsConfigurable.this.addProfile((InspectionProfileImpl)profile.getModifiableModel());
                    InspectionToolsConfigurable.this.myDeletedProfiles.remove(profile.getName());
                    InspectionToolsConfigurable.this.myDeleteButton.setEnabled(true);
                }
                catch (InvalidDataException e1) {
                    LOG.error((Throwable)e1);
                }
                catch (JDOMException e1) {
                    LOG.error((Throwable)e1);
                }
                catch (IOException e1) {
                    LOG.error((Throwable)e1);
                }
            }
        });
        this.myExportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                descriptor.setDescription("Choose directory to store profile file");
                VirtualFile[] files = FileChooser.chooseFiles((Component)InspectionToolsConfigurable.this.myWholePanel, (FileChooserDescriptor)descriptor);
                if (files.length == 0) {
                    return;
                }
                Element element = new Element("inspections");
                try {
                    InspectionProfileImpl profile = (InspectionProfileImpl)((Object)InspectionToolsConfigurable.this.myProfiles.getSelectedItem());
                    profile.writeExternal(element);
                    String filePath = files[0].getPath() + File.separator + FileUtil.sanitizeFileName((String)profile.getName()) + ".xml";
                    if (new File(filePath).isFile() && Messages.showOkCancelDialog((Component)InspectionToolsConfigurable.this.myWholePanel, (String)("File '" + filePath + "' already exist. Do you want to override it?"), (String)"Warning", (Icon)Messages.getQuestionIcon()) != 0) {
                        return;
                    }
                    JDOMUtil.writeDocument((Document)new Document(element), (String)filePath, (String)SystemProperties.getLineSeparator());
                }
                catch (WriteExternalException e1) {
                    LOG.error((Throwable)e1);
                }
                catch (IOException e1) {
                    LOG.error((Throwable)e1);
                }
            }
        });
        this.myCopyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InspectionProfileImpl model = (InspectionProfileImpl)SingleInspectionProfilePanel.createNewProfile(0, InspectionToolsConfigurable.this.getSelectedObject(), InspectionToolsConfigurable.this.myWholePanel, "");
                if (model != null) {
                    InspectionToolsConfigurable.this.addProfile((InspectionProfileImpl)model.getModifiableModel());
                    InspectionToolsConfigurable.this.myDeletedProfiles.remove(model.getName());
                    InspectionToolsConfigurable.this.myDeleteButton.setEnabled(true);
                }
            }
        });
        this.myProjectProfileManager = projectProfileManager;
        this.myProfileManager = profileManager;
    }

    private void addProfile(InspectionProfileImpl model) {
        String modelName = model.getName();
        SingleInspectionProfilePanel panel = new SingleInspectionProfilePanel(this.myProjectProfileManager, modelName, model);
        panel.reset();
        this.myPanel.add(modelName, panel);
        if (!this.myPanels.containsKey(modelName)) {
            ((DefaultComboBoxModel)this.myProfiles.getModel()).addElement(model);
        }
        this.myPanels.put(modelName, panel);
        this.myProfiles.setSelectedItem((Object)model);
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public Icon getIcon() {
        return IconLoader.getIcon((String)"/general/configurableErrorHighlighting.png");
    }

    public String getHelpTopic() {
        return "preferences.inspections";
    }

    public String getId() {
        return ID;
    }

    public Runnable enableSearch(final String option) {
        return new Runnable(){

            @Override
            public void run() {
                InspectionToolsConfigurable.this.getSelectedPanel().filterTree(option);
            }
        };
    }

    public JComponent createComponent() {
        this.myProfiles.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                String profileName = ((Profile)value).getName();
                this.setText(profileName);
                SingleInspectionProfilePanel panel = (SingleInspectionProfilePanel)InspectionToolsConfigurable.this.myPanels.get(profileName);
                if (panel != null && panel.isProfileShared()) {
                    this.setIcon(Profile.PROJECT_PROFILE);
                } else {
                    this.setIcon(Profile.LOCAL_PROFILE);
                }
                return rendererComponent;
            }
        });
        this.myProfiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InspectionProfileImpl profile = (InspectionProfileImpl)((Object)InspectionToolsConfigurable.this.myProfiles.getSelectedItem());
                InspectionToolsConfigurable.this.myDeleteButton.setEnabled(InspectionToolsConfigurable.this.myProfiles.getModel().getSize() > 1);
                InspectionToolsConfigurable.this.myLayout.show(InspectionToolsConfigurable.this.myPanel, profile.getName());
                SingleInspectionProfilePanel panel = InspectionToolsConfigurable.this.getSelectedPanel();
                if (panel != null) {
                    InspectionToolsConfigurable.this.myShareProfileCheckBox.setSelected(panel.isProfileShared());
                }
            }
        });
        this.myShareProfileCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleInspectionProfilePanel panel = InspectionToolsConfigurable.this.getSelectedPanel();
                LOG.assertTrue(panel != null, (Object)("No settings panel for: " + (Object)((Object)InspectionToolsConfigurable.this.getSelectedObject())));
                panel.setProfileShared(InspectionToolsConfigurable.this.myShareProfileCheckBox.isSelected());
                InspectionToolsConfigurable.this.myProfiles.repaint();
            }
        });
        this.myPanel.setLayout(this.myLayout);
        return this.myWholePanel;
    }

    protected abstract InspectionProfileImpl getCurrentProfile();

    public boolean isModified() {
        for (SingleInspectionProfilePanel panel : this.myPanels.values()) {
            if (!panel.isModified()) continue;
            return true;
        }
        if (this.getProfiles().size() != this.myPanels.size()) {
            return true;
        }
        return !this.myDeletedProfiles.isEmpty();
    }

    public void apply() throws ConfigurationException {
        Iterator<String> it = this.myPanels.keySet().iterator();
        while (it.hasNext()) {
            String name = it.next();
            if (this.myDeletedProfiles.remove(name)) {
                this.deleteProfile(name);
                it.remove();
                continue;
            }
            this.myPanels.get(name).apply();
        }
    }

    protected void deleteProfile(String name) {
        if (this.myProfileManager.getProfile(name, false) != null) {
            this.myProfileManager.deleteProfile(name);
        }
        if (this.myProjectProfileManager.getProfile(name, false) != null) {
            this.myProjectProfileManager.deleteProfile(name);
        }
    }

    public void reset() {
        this.myDeletedProfiles.clear();
        this.myPanels.clear();
        DefaultComboBoxModel<Profile> model = new DefaultComboBoxModel<Profile>();
        this.myProfiles.setModel(model);
        for (Profile profile : this.getProfiles()) {
            model.addElement(profile);
            String profileName = profile.getName();
            SingleInspectionProfilePanel panel = new SingleInspectionProfilePanel(this.myProjectProfileManager, profileName, ((InspectionProfileImpl)profile).getModifiableModel());
            this.myPanels.put(profileName, panel);
            panel.reset();
            this.myPanel.add(profileName, panel);
        }
        InspectionProfileImpl inspectionProfile = this.getCurrentProfile();
        this.myProfiles.setSelectedItem((Object)inspectionProfile);
        this.myLayout.show(this.myPanel, inspectionProfile.getName());
        this.myDeleteButton.setEnabled(this.getProfiles().size() > 1 && inspectionProfile.getProfileManager() == this.myProfileManager);
        SingleInspectionProfilePanel panel = this.getSelectedPanel();
        if (panel != null) {
            this.myShareProfileCheckBox.setSelected(panel.isProfileShared());
        }
    }

    protected Collection<Profile> getProfiles() {
        ArrayList<Profile> result = new ArrayList<Profile>();
        result.addAll(this.myProfileManager.getProfiles());
        result.addAll(this.myProjectProfileManager.getProfiles());
        return result;
    }

    public void disposeUIResources() {
        for (SingleInspectionProfilePanel panel : this.myPanels.values()) {
            panel.disposeUI();
        }
        this.myPanels.clear();
    }

    @Override
    public void selectProfile(String name) {
        for (int i = 0; i < this.myProfiles.getItemCount(); ++i) {
            if (!Comparing.strEqual((String)((InspectionProfileImpl)((Object)this.myProfiles.getItemAt(i))).getName(), (String)name)) continue;
            this.myProfiles.setSelectedIndex(i);
            break;
        }
    }

    @Override
    public void selectInspectionTool(String selectedToolShortName) {
        SingleInspectionProfilePanel panel = this.getSelectedPanel();
        LOG.assertTrue(panel != null, (Object)("No settings panel for: " + (Object)((Object)this.getSelectedObject())));
        panel.selectInspectionTool(selectedToolShortName);
    }

    protected SingleInspectionProfilePanel getSelectedPanel() {
        InspectionProfileImpl inspectionProfile = this.getSelectedObject();
        assert (inspectionProfile != null);
        return this.myPanels.get(inspectionProfile.getName());
    }

    public InspectionProfileImpl getSelectedObject() {
        return (InspectionProfileImpl)((Object)this.myProfiles.getSelectedItem());
    }

    public JComponent getPreferredFocusedComponent() {
        InspectionProfileImpl inspectionProfile = this.getSelectedObject();
        assert (inspectionProfile != null);
        return this.myPanels.get(inspectionProfile.getName()).getTree();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        JComboBox jComboBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.myWholePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 1, null, null, null));
        this.myProfiles = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), 5, -1, true, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAddButton = jButton5 = new JButton();
        jButton5.setText("Add");
        jButton5.setMnemonic('A');
        jButton5.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jButton5, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myDeleteButton = jButton4 = new JButton();
        jButton4.setText("Delete");
        jButton4.setMnemonic('D');
        jButton4.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jButton4, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myImportButton = jButton3 = new JButton();
        jButton3.setText("Import");
        jButton3.setMnemonic('I');
        jButton3.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jButton3, new GridConstraints(0, 3, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myExportButton = jButton2 = new JButton();
        jButton2.setText("Export");
        jButton2.setMnemonic('E');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jButton2, new GridConstraints(0, 4, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myCopyButton = jButton = new JButton();
        jButton.setText("Copy");
        jButton.setMnemonic('C');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myShareProfileCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Share profile");
        jCheckBox.setMnemonic('S');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }
}

