/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.ui;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.impl.elements.FileCopyElementType;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NotNull;

public class FileCopyPresentation
extends PackagingElementPresentation {
    private final String mySourcePath;
    private final String myOutputFileName;
    private final ArtifactEditorContext myContext;
    private final VirtualFile myFile;

    public FileCopyPresentation(String filePath, String outputFileName, ArtifactEditorContext context) {
        VirtualFile parent;
        this.myOutputFileName = outputFileName;
        this.myContext = context;
        this.myFile = LocalFileSystem.getInstance().findFileByPath(filePath);
        String parentPath = this.myFile != null ? ((parent = this.myFile.getParent()) != null ? FileUtil.toSystemDependentName((String)parent.getPath()) : "") : FileUtil.toSystemDependentName((String)PathUtil.getParentPath((String)filePath));
        String sourceFileName = PathUtil.getFileName((String)filePath);
        this.mySourcePath = !sourceFileName.equals(this.myOutputFileName) ? parentPath + "/" + sourceFileName : parentPath;
    }

    public String getPresentableName() {
        return this.myOutputFileName;
    }

    public void render(@NotNull PresentationData presentationData, SimpleTextAttributes mainAttributes, SimpleTextAttributes commentAttributes) {
        if (presentationData == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/ui/FileCopyPresentation.render must not be null");
        }
        if (this.myFile != null && !this.myFile.isDirectory()) {
            presentationData.setIcons(this.myFile != null ? this.myFile.getIcon() : FileCopyElementType.ICON);
            presentationData.addText(this.myOutputFileName, mainAttributes);
            presentationData.addText(" (" + this.mySourcePath + ")", commentAttributes);
        } else {
            presentationData.setIcons(FileCopyElementType.ICON);
            presentationData.addText(this.myOutputFileName, SimpleTextAttributes.ERROR_ATTRIBUTES);
            VirtualFile parentFile = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)this.mySourcePath));
            presentationData.addText("(" + this.mySourcePath + ")", parentFile != null ? commentAttributes : SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
    }

    public int getWeight() {
        return 0;
    }
}

