/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ComboContentLayout;
import com.intellij.openapi.wm.impl.content.ComboIcon;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class ContentComboLabel
extends BaseLabel {
    private ComboIcon myComboIcon = new ComboIcon(){

        @Override
        public Rectangle getIconRec() {
            return new Rectangle(ContentComboLabel.this.getWidth() - this.getIconWidth(), 0, this.getIconWidth(), ContentComboLabel.this.getHeight());
        }

        @Override
        public boolean isActive() {
            return ContentComboLabel.this.myUi.myWindow.isActive();
        }
    };
    private ComboContentLayout myLayout;

    public ContentComboLabel(ComboContentLayout layout) {
        super(layout.myUi, true);
        this.myLayout = layout;
        this.addMouseListener(new MouseAdapter(){});
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (UIUtil.isActionClick((MouseEvent)e)) {
            this.myUi.showContentPopup(e);
        }
    }

    void update() {
        if (this.isToDrawCombo()) {
            this.setBorder(new EmptyBorder(0, 8, 0, 8));
        } else {
            this.setBorder(null);
        }
        this.updateTextAndIcon(this.myUi.myManager.getSelectedContent(), true);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isToDrawCombo()) {
            g.translate(0, -2);
            super.paintComponent(g);
            g.translate(0, 2);
        } else {
            super.paintComponent(g);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.isToDrawCombo()) {
            return super.getPreferredSize();
        }
        int width = 0;
        for (int i = 0; i < this.myUi.myManager.getContentCount(); ++i) {
            String text = this.myUi.myManager.getContent(i).getDisplayName();
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            int eachTextWidth = metrics.stringWidth(text != null ? text : "");
            width = Math.max(eachTextWidth, width);
        }
        Border border = this.getBorder();
        if (border != null) {
            Insets insets = border.getBorderInsets(this);
            width += insets.left + insets.right;
        }
        return new Dimension(width += this.myComboIcon.getIconWidth(), super.getPreferredSize().height);
    }

    private boolean isToDrawCombo() {
        return this.myLayout.isToDrawCombo();
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.isToDrawCombo()) {
            this.myComboIcon.paintIcon(this, g);
            g.setColor(new Color(255, 255, 255, 100));
            int x = this.myComboIcon.getIconRec().x - 3;
            int yTop = this.myComboIcon.getIconRec().y;
            int yBottom = yTop + this.myComboIcon.getIconHeight();
            g.drawLine(x, yTop + 1, x, yBottom - 3);
        }
    }

    @Override
    public Content getContent() {
        return this.myUi.myManager.getSelectedContent();
    }
}

