/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FakeVirtualFile
extends StubVirtualFile {
    private final VirtualFile myParent;
    private final String myName;

    public FakeVirtualFile(@NotNull VirtualFile parent, @NotNull String name) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/newvfs/impl/FakeVirtualFile.<init> must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/newvfs/impl/FakeVirtualFile.<init> must not be null");
        }
        this.myName = name;
        this.myParent = parent;
    }

    @Nullable
    public VirtualFile getParent() {
        return this.myParent;
    }

    public String getPath() {
        String basePath = this.myParent.getPath();
        if (basePath.endsWith("/")) {
            return basePath + this.myName;
        }
        return basePath + '/' + this.myName;
    }

    @NotNull
    @NonNls
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/impl/FakeVirtualFile.getName must not return null");
        }
        return string;
    }

    public String toString() {
        return this.getPath();
    }
}

