/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.ModificationAttemptEvent;
import com.intellij.openapi.vfs.ModificationAttemptListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VirtualFileManagerImpl
extends VirtualFileManagerEx
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.impl.VirtualFileManagerImpl");
    private final ArrayList<VirtualFileSystem> myFileSystems = new ArrayList();
    private final Map<String, VirtualFileSystem> myProtocolToSystemMap = new HashMap();
    private final EventDispatcher<VirtualFileListener> myVirtualFileListenerMulticaster = EventDispatcher.create(VirtualFileListener.class);
    private final List<VirtualFileManagerListener> myVirtualFileManagerListeners = ContainerUtil.createEmptyCOWList();
    private final EventDispatcher<ModificationAttemptListener> myModificationAttemptListenerMulticaster = EventDispatcher.create(ModificationAttemptListener.class);
    @NonNls
    private static final String USER_HOME = "user.home";
    private int myRefreshCount = 0;
    private final ManagingFS myPersistence;

    public VirtualFileManagerImpl(VirtualFileSystem[] fileSystems, MessageBus bus, ManagingFS persistence) {
        this.myPersistence = persistence;
        for (VirtualFileSystem fileSystem : fileSystems) {
            this.registerFileSystem(fileSystem);
        }
        if (LOG.isDebugEnabled()) {
            this.addVirtualFileListener(new LoggingListener());
        }
        bus.connect().subscribe(VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter((VirtualFileListener)this.myVirtualFileListenerMulticaster.getMulticaster()));
    }

    @NotNull
    public String getComponentName() {
        if ("VirtualFileManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/VirtualFileManagerImpl.getComponentName must not return null");
        }
        return "VirtualFileManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @Override
    public void registerFileSystem(VirtualFileSystem fileSystem) {
        this.myFileSystems.add(fileSystem);
        if (!(fileSystem instanceof NewVirtualFileSystem)) {
            fileSystem.addVirtualFileListener((VirtualFileListener)this.myVirtualFileListenerMulticaster.getMulticaster());
        }
        this.myProtocolToSystemMap.put(fileSystem.getProtocol(), fileSystem);
    }

    @Override
    public void unregisterFileSystem(VirtualFileSystem fileSystem) {
        this.myFileSystems.remove(fileSystem);
        fileSystem.removeVirtualFileListener((VirtualFileListener)this.myVirtualFileListenerMulticaster.getMulticaster());
        this.myProtocolToSystemMap.remove(fileSystem.getProtocol());
    }

    public VirtualFileSystem[] getFileSystems() {
        return this.myFileSystems.toArray(new VirtualFileSystem[this.myFileSystems.size()]);
    }

    public VirtualFileSystem getFileSystem(String protocol) {
        return this.myProtocolToSystemMap.get(protocol);
    }

    public void refresh(boolean asynchronous) {
        this.refresh(asynchronous, null);
    }

    public void refreshWithoutFileWatcher(boolean asynchronous) {
        if (!asynchronous) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        for (VirtualFileSystem fileSystem : this.myFileSystems) {
            if (fileSystem instanceof NewVirtualFileSystem) {
                ((NewVirtualFileSystem)fileSystem).refreshWithoutFileWatcher(asynchronous);
                continue;
            }
            fileSystem.refresh(asynchronous);
        }
    }

    public void refresh(boolean asynchronous, Runnable postAction) {
        if (!asynchronous) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        RefreshQueue.getInstance().refresh(asynchronous, true, postAction, this.myPersistence.getLocalRoots());
        for (VirtualFileSystem fileSystem : this.myFileSystems) {
            if (fileSystem instanceof NewVirtualFileSystem) continue;
            fileSystem.refresh(asynchronous);
        }
    }

    public VirtualFile findFileByUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFileManagerImpl.findFileByUrl must not be null");
        }
        String protocol = VirtualFileManagerImpl.extractProtocol((String)url);
        if (protocol == null) {
            return null;
        }
        VirtualFileSystem fileSystem = this.myProtocolToSystemMap.get(protocol);
        if (fileSystem == null) {
            return null;
        }
        return fileSystem.findFileByPath(VirtualFileManagerImpl.extractPath((String)url));
    }

    public VirtualFile refreshAndFindFileByUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFileManagerImpl.refreshAndFindFileByUrl must not be null");
        }
        String protocol = VirtualFileManagerImpl.extractProtocol((String)url);
        if (protocol == null) {
            return null;
        }
        VirtualFileSystem fileSystem = this.myProtocolToSystemMap.get(protocol);
        if (fileSystem == null) {
            return null;
        }
        String path = VirtualFileManagerImpl.extractPath((String)url);
        return fileSystem.refreshAndFindFileByPath(path);
    }

    public void addVirtualFileListener(@NotNull VirtualFileListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFileManagerImpl.addVirtualFileListener must not be null");
        }
        this.myVirtualFileListenerMulticaster.addListener((EventListener)listener);
    }

    public void addVirtualFileListener(@NotNull VirtualFileListener listener, Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFileManagerImpl.addVirtualFileListener must not be null");
        }
        this.myVirtualFileListenerMulticaster.addListener((EventListener)listener, parentDisposable);
    }

    public void removeVirtualFileListener(@NotNull VirtualFileListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFileManagerImpl.removeVirtualFileListener must not be null");
        }
        this.myVirtualFileListenerMulticaster.removeListener((EventListener)listener);
    }

    public void addModificationAttemptListener(@NotNull ModificationAttemptListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFileManagerImpl.addModificationAttemptListener must not be null");
        }
        this.myModificationAttemptListenerMulticaster.addListener((EventListener)listener);
    }

    public void removeModificationAttemptListener(@NotNull ModificationAttemptListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFileManagerImpl.removeModificationAttemptListener must not be null");
        }
        this.myModificationAttemptListenerMulticaster.removeListener((EventListener)listener);
    }

    public void fireReadOnlyModificationAttempt(VirtualFile ... files) {
        if (files == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFileManagerImpl.fireReadOnlyModificationAttempt must not be null");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ModificationAttemptEvent event = new ModificationAttemptEvent((VirtualFileManager)this, files);
        ((ModificationAttemptListener)this.myModificationAttemptListenerMulticaster.getMulticaster()).readOnlyModificationAttempt(event);
    }

    public void addVirtualFileManagerListener(VirtualFileManagerListener listener) {
        this.myVirtualFileManagerListeners.add(listener);
    }

    public void removeVirtualFileManagerListener(VirtualFileManagerListener listener) {
        this.myVirtualFileManagerListeners.remove(listener);
    }

    @Override
    public void fireBeforeRefreshStart(boolean asynchronous) {
        if (this.myRefreshCount++ == 0) {
            for (VirtualFileManagerListener listener : this.myVirtualFileManagerListeners) {
                listener.beforeRefreshStart(asynchronous);
            }
        }
    }

    @Override
    public void fireAfterRefreshFinish(boolean asynchronous) {
        if (--this.myRefreshCount == 0) {
            for (VirtualFileManagerListener listener : this.myVirtualFileManagerListeners) {
                listener.afterRefreshFinish(asynchronous);
            }
        }
    }

    private static String convertLocalPathToUrl(@NonNls @NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFileManagerImpl.convertLocalPathToUrl must not be null");
        }
        if (path.startsWith("~")) {
            path = System.getProperty(USER_HOME) + path.substring(1);
        }
        if ((SystemInfo.isWindows || SystemInfo.isOS2) && path.endsWith(":/")) {
            path = Character.toUpperCase(path.charAt(0)) + path.substring(1);
        }
        if (path.length() == 0) {
            try {
                path = new File("").getCanonicalPath();
            }
            catch (IOException e) {
                return null;
            }
        }
        if (SystemInfo.isWindows) {
            if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
            if (path.contains("~")) {
                try {
                    path = new File(path.replace('/', File.separatorChar)).getCanonicalPath().replace(File.separatorChar, '/');
                }
                catch (IOException e) {
                    return null;
                }
            }
        }
        return "file://" + path.replace(File.separatorChar, '/');
    }

    public long getModificationCount() {
        return this.myPersistence.getCheapFileSystemModificationCount();
    }

    private static class LoggingListener
    implements VirtualFileListener {
        private LoggingListener() {
        }

        public void propertyChanged(VirtualFilePropertyEvent event) {
            LOG.debug("propertyChanged: file = " + event.getFile().getUrl() + ", propertyName = " + event.getPropertyName() + ", oldValue = " + event.getOldValue() + ", newValue = " + event.getNewValue() + ", requestor = " + event.getRequestor());
        }

        public void contentsChanged(VirtualFileEvent event) {
            LOG.debug("contentsChanged: file = " + event.getFile().getUrl() + ", requestor = " + event.getRequestor());
        }

        public void fileCreated(VirtualFileEvent event) {
            LOG.debug("fileCreated: file = " + event.getFile().getUrl() + ", requestor = " + event.getRequestor());
        }

        public void fileDeleted(VirtualFileEvent event) {
            VirtualFile parent = event.getParent();
            LOG.debug("fileDeleted: file = " + event.getFile().getName() + ", parent = " + (parent != null ? parent.getUrl() : null) + ", requestor = " + event.getRequestor());
        }

        public void fileMoved(VirtualFileMoveEvent event) {
            LOG.debug("fileMoved: file = " + event.getFile().getUrl() + ", oldParent = " + event.getOldParent() + ", newParent = " + event.getNewParent() + ", requestor = " + event.getRequestor());
        }

        public void fileCopied(VirtualFileCopyEvent event) {
            LOG.debug("fileCopied: file = " + event.getFile().getUrl() + "originalFile = " + event.getOriginalFile().getUrl() + ", requestor = " + event.getRequestor());
        }

        public void beforeContentsChange(VirtualFileEvent event) {
            LOG.debug("beforeContentsChange: file = " + event.getFile().getUrl() + ", requestor = " + event.getRequestor());
        }

        public void beforePropertyChange(VirtualFilePropertyEvent event) {
            LOG.debug("beforePropertyChange: file = " + event.getFile().getUrl() + ", propertyName = " + event.getPropertyName() + ", oldValue = " + event.getOldValue() + ", newValue = " + event.getNewValue() + ", requestor = " + event.getRequestor());
        }

        public void beforeFileDeletion(VirtualFileEvent event) {
            LOG.debug("beforeFileDeletion: file = " + event.getFile().getUrl() + ", requestor = " + event.getRequestor());
            LOG.assertTrue(event.getFile().isValid());
        }

        public void beforeFileMovement(VirtualFileMoveEvent event) {
            LOG.debug("beforeFileMovement: file = " + event.getFile().getUrl() + ", oldParent = " + event.getOldParent() + ", newParent = " + event.getNewParent() + ", requestor = " + event.getRequestor());
        }
    }
}

