/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.impl.ExcludedFileIndex;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectBaseDirectory;

public class DefaultExcludedFileIndex
extends ExcludedFileIndex {
    private final Project myProject;
    private final VirtualFile myBaseDir;

    public DefaultExcludedFileIndex(Project project) {
        super(project);
        this.myProject = project;
        this.myBaseDir = project.getBaseDir();
    }

    public boolean isInContent(VirtualFile file) {
        return VfsUtil.isAncestor((VirtualFile)this.getBaseDir(), (VirtualFile)file, (boolean)false);
    }

    public boolean isExcludedFile(VirtualFile file) {
        return false;
    }

    public boolean isValidAncestor(VirtualFile baseDir, VirtualFile childDir) {
        return VfsUtil.isAncestor((VirtualFile)baseDir, (VirtualFile)childDir, (boolean)false);
    }

    private VirtualFile getBaseDir() {
        return ProjectBaseDirectory.getInstance(this.myProject).getBaseDir(this.myBaseDir);
    }
}

