/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class SessionDialog
extends DialogWrapper {
    private final CommitSession mySession;
    private final List<Change> myChanges;
    private final Alarm myOKButtonUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private final String myCommitMessage;
    private final JPanel myCenterPanel = new JPanel(new BorderLayout());
    private final JComponent myConfigurationComponent;

    public SessionDialog(String title, Project project, CommitSession session, List<Change> changes, String commitMessage) {
        super(project, true);
        this.mySession = session;
        this.myChanges = changes;
        this.myCommitMessage = commitMessage;
        this.myConfigurationComponent = SessionDialog.createConfigurationUI(this.mySession, this.myChanges, this.myCommitMessage);
        this.setTitle(CommitChangeListDialog.trimEllipsis(title));
        this.init();
        this.updateButtons();
    }

    public static JComponent createConfigurationUI(CommitSession session, List<Change> changes, String commitMessage) {
        try {
            return session.getAdditionalConfigurationUI(changes, commitMessage);
        }
        catch (AbstractMethodError e) {
            return session.getAdditionalConfigurationUI();
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myCenterPanel.add((Component)this.myConfigurationComponent, "Center");
        return this.myCenterPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myConfigurationComponent;
    }

    private void updateButtons() {
        this.setOKActionEnabled(this.mySession.canExecute(this.myChanges, this.myCommitMessage));
        this.myOKButtonUpdateAlarm.cancelAllRequests();
        this.myOKButtonUpdateAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                SessionDialog.this.updateButtons();
            }
        }, 300, ModalityState.stateForComponent((Component)this.myCenterPanel));
    }

    protected void dispose() {
        super.dispose();
        this.myOKButtonUpdateAlarm.cancelAllRequests();
    }
}

