/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.projectRoots.ui.NotifiableSdkModel;
import com.intellij.openapi.projectRoots.ui.SdkEditor;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class ProjectJdksModel
implements NotifiableSdkModel {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectJdksModel");
    private final HashMap<Sdk, Sdk> myProjectJdks = new HashMap();
    private final EventDispatcher<SdkModel.Listener> mySdkEventsDispatcher = EventDispatcher.create(SdkModel.Listener.class);
    private boolean myModified = false;
    private Sdk myProjectJdk;
    private boolean myInitialized = false;

    public static ProjectJdksModel getInstance(Project project) {
        return ProjectStructureConfigurable.getInstance(project).getProjectJdksModel();
    }

    @Override
    public SdkModel.Listener getMulticaster() {
        return (SdkModel.Listener)this.mySdkEventsDispatcher.getMulticaster();
    }

    public Sdk[] getSdks() {
        return this.myProjectJdks.values().toArray(new Sdk[this.myProjectJdks.size()]);
    }

    @Nullable
    public Sdk findSdk(String sdkName) {
        for (Sdk projectJdk : this.myProjectJdks.values()) {
            if (!Comparing.strEqual((String)projectJdk.getName(), (String)sdkName)) continue;
            return projectJdk;
        }
        return null;
    }

    public void addListener(SdkModel.Listener listener) {
        this.mySdkEventsDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(SdkModel.Listener listener) {
        this.mySdkEventsDispatcher.removeListener((EventListener)listener);
    }

    public void reset(Project project) {
        Sdk[] projectJdks;
        this.myProjectJdks.clear();
        for (Sdk jdk : projectJdks = ProjectJdkTable.getInstance().getAllJdks()) {
            try {
                this.myProjectJdks.put(jdk, (Sdk)jdk.clone());
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
        }
        this.myProjectJdk = this.findSdk(ProjectRootManager.getInstance((Project)project).getProjectJdkName());
        this.myModified = false;
        this.myInitialized = true;
    }

    public void disposeUIResources() {
        this.myProjectJdks.clear();
        this.myInitialized = false;
    }

    public HashMap<Sdk, Sdk> getProjectJdks() {
        return this.myProjectJdks;
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void apply(MasterDetailsComponent configurable) throws ConfigurationException {
        String[] errorString = new String[1];
        if (!this.canApply(errorString, configurable)) {
            throw new ConfigurationException(errorString[0]);
        }
        final Sdk[] allFromTable = ProjectJdkTable.getInstance().getAllJdks();
        final ArrayList itemsInTable = new ArrayList();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
                for (Sdk tableItem : allFromTable) {
                    if (ProjectJdksModel.this.myProjectJdks.containsKey(tableItem)) {
                        itemsInTable.add(tableItem);
                        continue;
                    }
                    jdkTable.removeJdk(tableItem);
                }
            }
        });
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
                for (Sdk originalJdk : itemsInTable) {
                    Sdk modifiedJdk = (Sdk)ProjectJdksModel.this.myProjectJdks.get(originalJdk);
                    LOG.assertTrue(modifiedJdk != null);
                    jdkTable.updateJdk(originalJdk, modifiedJdk);
                }
                Object[] allJdks = jdkTable.getAllJdks();
                for (Sdk projectJdk : ProjectJdksModel.this.myProjectJdks.keySet()) {
                    LOG.assertTrue(projectJdk != null);
                    if (ArrayUtil.find((Object[])allJdks, (Object)projectJdk) != -1) continue;
                    jdkTable.addJdk(projectJdk);
                }
            }
        });
        this.myModified = false;
    }

    private boolean canApply(String[] errorString, MasterDetailsComponent rootConfigurable) throws ConfigurationException {
        ArrayList<String> allNames = new ArrayList<String>();
        Sdk itemWithError = null;
        for (Sdk currItem : this.myProjectJdks.values()) {
            String currName = currItem.getName();
            if (currName.length() == 0) {
                itemWithError = currItem;
                errorString[0] = ProjectBundle.message((String)"sdk.list.name.required.error", (Object[])new Object[0]);
                break;
            }
            if (allNames.contains(currName)) {
                itemWithError = currItem;
                errorString[0] = ProjectBundle.message((String)"sdk.list.unique.name.required.error", (Object[])new Object[0]);
                break;
            }
            SdkAdditionalData sdkAdditionalData = currItem.getSdkAdditionalData();
            if (sdkAdditionalData != null) {
                try {
                    sdkAdditionalData.checkValid((SdkModel)this);
                }
                catch (ConfigurationException e) {
                    Object projectJdk = rootConfigurable.getSelectedObject();
                    if (!(projectJdk instanceof Sdk) || !Comparing.strEqual((String)((Sdk)projectJdk).getName(), (String)currName)) {
                        rootConfigurable.selectNodeInTree(currName);
                    }
                    throw new ConfigurationException(ProjectBundle.message((String)"sdk.configuration.exception", (Object[])new Object[]{currName}) + " " + e.getMessage());
                }
            }
            allNames.add(currName);
        }
        if (itemWithError == null) {
            return true;
        }
        rootConfigurable.selectNodeInTree(itemWithError.getName());
        return false;
    }

    public void removeJdk(Sdk editableObject) {
        Sdk projectJdk = null;
        for (Sdk jdk : this.myProjectJdks.keySet()) {
            if (this.myProjectJdks.get(jdk) != editableObject) continue;
            projectJdk = jdk;
            break;
        }
        if (projectJdk != null) {
            this.myProjectJdks.remove(projectJdk);
            ((SdkModel.Listener)this.mySdkEventsDispatcher.getMulticaster()).beforeSdkRemove(projectJdk);
            this.myModified = true;
        }
    }

    public void createAddActions(DefaultActionGroup group, final JComponent parent, final Consumer<Sdk> updateTree) {
        SdkType[] types;
        for (final SdkType type : types = SdkType.getAllTypes()) {
            DumbAwareAction addAction = new DumbAwareAction(type.getPresentableName(), null, type.getIconForAddAction()){

                public void actionPerformed(AnActionEvent e) {
                    ProjectJdksModel.this.doAdd(type, parent, (Consumer<Sdk>)updateTree);
                }
            };
            group.add((AnAction)addAction);
        }
    }

    public void doAdd(SdkType type, JComponent parent, Consumer<Sdk> updateTree) {
        this.myModified = true;
        String home = SdkEditor.selectSdkHome(parent, type);
        if (home == null) {
            return;
        }
        String newSdkName = SdkConfigurationUtil.createUniqueSdkName(type, home, this.myProjectJdks.values());
        ProjectJdkImpl newJdk = new ProjectJdkImpl(newSdkName, type);
        newJdk.setHomePath(home);
        if (!type.setupSdkPaths((Sdk)newJdk, (SdkModel)this)) {
            return;
        }
        if (newJdk.getVersionString() == null) {
            Messages.showMessageDialog((String)ProjectBundle.message((String)"sdk.java.corrupt.error", (Object[])new Object[]{home}), (String)ProjectBundle.message((String)"sdk.java.corrupt.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }
        this.myProjectJdks.put(newJdk, newJdk);
        updateTree.consume((Object)newJdk);
        ((SdkModel.Listener)this.mySdkEventsDispatcher.getMulticaster()).sdkAdded((Sdk)newJdk);
    }

    @Nullable
    public Sdk findSdk(@Nullable Sdk modelJdk) {
        for (Sdk jdk : this.myProjectJdks.keySet()) {
            if (!Comparing.equal((Object)this.myProjectJdks.get(jdk), (Object)modelJdk)) continue;
            return jdk;
        }
        return null;
    }

    @Nullable
    public Sdk getProjectJdk() {
        if (!this.myProjectJdks.containsValue(this.myProjectJdk)) {
            return null;
        }
        return this.myProjectJdk;
    }

    public void setProjectJdk(Sdk projectJdk) {
        this.myProjectJdk = projectJdk;
    }

    public boolean isInitialized() {
        return this.myInitialized;
    }
}

