/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.ui.configuration.LibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ChooseModulesDialog;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryFileChooser;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FindUsagesInProjectStructureActionBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.SdkProjectStructureElement;
import com.intellij.openapi.roots.ui.util.CellAppearance;
import com.intellij.openapi.roots.ui.util.OrderEntryCellAppearanceUtils;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.OrderPanelListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TableUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Icons;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.Table;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClasspathPanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.ClasspathPanel");
    private final Table myEntryTable;
    private final MyTableModel myModel;
    private final EventDispatcher<OrderPanelListener> myListeners = EventDispatcher.create(OrderPanelListener.class);
    private PopupAction[] myPopupActions = null;
    private Icon[] myIcons = null;
    private JButton myEditButton;
    private final ModuleConfigurationState myState;
    private int myInsideChange = 0;

    protected ClasspathPanel(ModuleConfigurationState state) {
        super(new BorderLayout());
        this.myState = state;
        this.myModel = new MyTableModel(state);
        this.myEntryTable = new Table((TableModel)this.myModel);
        this.myEntryTable.setShowGrid(false);
        this.myEntryTable.setDragEnabled(false);
        this.myEntryTable.setShowHorizontalLines(false);
        this.myEntryTable.setShowVerticalLines(false);
        this.myEntryTable.setIntercellSpacing(new Dimension(0, 0));
        this.myEntryTable.setDefaultRenderer(TableItem.class, (TableCellRenderer)((Object)new TableItemRenderer()));
        this.myEntryTable.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ExportFlagRenderer(this.myEntryTable.getDefaultRenderer(Boolean.class)));
        JComboBox scopeEditor = new JComboBox(new EnumComboBoxModel(DependencyScope.class));
        this.myEntryTable.setDefaultEditor(DependencyScope.class, (TableCellEditor)new DefaultCellEditor(scopeEditor));
        this.myEntryTable.getSelectionModel().setSelectionMode(2);
        new SpeedSearchBase<Table>(this.myEntryTable){

            @Override
            public int getSelectedIndex() {
                return ClasspathPanel.this.myEntryTable.getSelectedRow();
            }

            @Override
            public Object[] getAllElements() {
                int count = ClasspathPanel.this.myModel.getRowCount();
                Object[] elements = new Object[count];
                for (int idx = 0; idx < count; ++idx) {
                    elements[idx] = ClasspathPanel.this.myModel.getItemAt(idx);
                }
                return elements;
            }

            @Override
            public String getElementText(Object element) {
                return ClasspathPanel.getCellAppearance((TableItem)element, false).getText();
            }

            @Override
            public void selectElement(Object element, String selectedText) {
                int count = ClasspathPanel.this.myModel.getRowCount();
                for (int row = 0; row < count; ++row) {
                    if (!element.equals(ClasspathPanel.this.myModel.getItemAt(row))) continue;
                    ClasspathPanel.this.myEntryTable.getSelectionModel().setSelectionInterval(row, row);
                    TableUtil.scrollSelectionToVisible((JTable)ClasspathPanel.this.myEntryTable);
                    break;
                }
            }
        };
        this.setFixedColumnWidth(0, MyTableModel.EXPORT_COLUMN_NAME);
        this.setFixedColumnWidth(2, DependencyScope.COMPILE.toString() + "     ");
        this.myEntryTable.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = ClasspathPanel.this.myEntryTable.getSelectedRows();
                boolean currentlyMarked = true;
                for (int selectedRow : selectedRows) {
                    TableItem item = ClasspathPanel.this.myModel.getItemAt(selectedRow);
                    if (selectedRow < 0 || !item.isExportable()) {
                        return;
                    }
                    currentlyMarked &= item.isExported();
                }
                for (int selectedRow : selectedRows) {
                    ClasspathPanel.this.myModel.getItemAt(selectedRow).setExported(!currentlyMarked);
                }
                ClasspathPanel.this.myModel.fireTableDataChanged();
                TableUtil.selectRows((JTable)ClasspathPanel.this.myEntryTable, (int[])selectedRows);
            }
        }, KeyStroke.getKeyStroke(32, 0), 0);
        this.add((Component)ScrollPaneFactory.createScrollPane((JComponent)this.myEntryTable), "Center");
        this.add((Component)this.createButtonsBlock(), "East");
        if (this.myEntryTable.getRowCount() > 0) {
            this.myEntryTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.myEntryTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ClasspathPanel.this.navigate(true);
                }
            }
        });
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        AnAction navigateAction = new AnAction(ProjectBundle.message((String)"classpath.panel.navigate.action.text", (Object[])new Object[0])){

            public void actionPerformed(AnActionEvent e) {
                ClasspathPanel.this.navigate(false);
            }

            public void update(AnActionEvent e) {
                Presentation presentation = e.getPresentation();
                presentation.setEnabled(false);
                if (ClasspathPanel.this.myEntryTable.getSelectedRowCount() != 1) {
                    return;
                }
                Object entry = ClasspathPanel.this.myModel.getItemAt(ClasspathPanel.this.myEntryTable.getSelectedRow()).getEntry();
                if (entry != null && entry.isValid() && !(entry instanceof ModuleSourceOrderEntry)) {
                    presentation.setEnabled(true);
                }
            }
        };
        navigateAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("EditSource").getShortcutSet(), (JComponent)this.myEntryTable);
        actionGroup.add(navigateAction);
        actionGroup.add((AnAction)new MyFindUsagesAction());
        PopupHandler.installPopupHandler((JComponent)this.myEntryTable, (ActionGroup)actionGroup, (String)"unknown", (ActionManager)ActionManager.getInstance());
    }

    private void setFixedColumnWidth(int columnIndex, String textToMeasure) {
        FontMetrics fontMetrics = this.myEntryTable.getFontMetrics(this.myEntryTable.getFont());
        int width = fontMetrics.stringWidth(" " + textToMeasure + " ") + 4;
        TableColumn checkboxColumn = this.myEntryTable.getTableHeader().getColumnModel().getColumn(columnIndex);
        checkboxColumn.setWidth(width);
        checkboxColumn.setPreferredWidth(width);
        checkboxColumn.setMaxWidth(width);
        checkboxColumn.setMinWidth(width);
    }

    private void navigate(boolean openLibraryEditor) {
        Sdk jdk;
        int selectedRow = this.myEntryTable.getSelectedRow();
        Object entry = this.myModel.getItemAt(selectedRow).getEntry();
        ProjectStructureConfigurable rootConfigurable = ProjectStructureConfigurable.getInstance(this.myState.getProject());
        if (entry instanceof ModuleOrderEntry) {
            Module module = ((ModuleOrderEntry)entry).getModule();
            if (module != null) {
                rootConfigurable.select(module.getName(), null, true);
            }
        } else if (entry instanceof LibraryOrderEntry) {
            if (!openLibraryEditor) {
                rootConfigurable.select((LibraryOrderEntry)entry, true);
            } else {
                this.myEditButton.doClick();
            }
        } else if (entry instanceof JdkOrderEntry && (jdk = ((JdkOrderEntry)entry).getJdk()) != null) {
            rootConfigurable.select(jdk, true);
        }
    }

    private JComponent createButtonsBlock() {
        final JButton addButton = new JButton(ProjectBundle.message((String)"button.add", (Object[])new Object[0]));
        final JButton removeButton = new JButton(ProjectBundle.message((String)"button.remove", (Object[])new Object[0]));
        this.myEditButton = new JButton(ProjectBundle.message((String)"button.edit", (Object[])new Object[0]));
        final JButton upButton = new JButton(ProjectBundle.message((String)"button.move.up", (Object[])new Object[0]));
        final JButton downButton = new JButton(ProjectBundle.message((String)"button.move.down", (Object[])new Object[0]));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)addButton, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(2, 2, 0, 0), 0, 0));
        panel.add((Component)removeButton, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(2, 2, 0, 0), 0, 0));
        panel.add((Component)this.myEditButton, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(2, 2, 0, 0), 0, 0));
        panel.add((Component)upButton, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(2, 2, 0, 0), 0, 0));
        panel.add((Component)downButton, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 2, new Insets(2, 2, 0, 0), 0, 0));
        this.myEntryTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int[] selectedRows = ClasspathPanel.this.myEntryTable.getSelectedRows();
                boolean removeButtonEnabled = true;
                int minRow = ClasspathPanel.this.myEntryTable.getRowCount() + 1;
                int maxRow = -1;
                for (int selectedRow : selectedRows) {
                    minRow = Math.min(minRow, selectedRow);
                    maxRow = Math.max(maxRow, selectedRow);
                    TableItem item = ClasspathPanel.this.myModel.getItemAt(selectedRow);
                    if (item.isRemovable()) continue;
                    removeButtonEnabled = false;
                }
                upButton.setEnabled(minRow > 0 && minRow < ClasspathPanel.this.myEntryTable.getRowCount());
                downButton.setEnabled(maxRow >= 0 && maxRow < ClasspathPanel.this.myEntryTable.getRowCount() - 1);
                removeButton.setEnabled(removeButtonEnabled);
                TableItem selectedItem = selectedRows.length == 1 ? ClasspathPanel.this.myModel.getItemAt(selectedRows[0]) : null;
                ClasspathPanel.this.myEditButton.setEnabled(selectedItem instanceof LibItem && selectedItem.isEditable());
            }
        });
        upButton.addActionListener(new ButtonAction(){

            @Override
            protected void executeImpl() {
                ClasspathPanel.this.moveSelectedRows(-1);
            }
        });
        downButton.addActionListener(new ButtonAction(){

            @Override
            protected void executeImpl() {
                ClasspathPanel.this.moveSelectedRows(1);
            }
        });
        ClasspathPanel.addKeyboardShortcut((JComponent)this.myEntryTable, removeButton, 127, 0);
        ClasspathPanel.addKeyboardShortcut((JComponent)this.myEntryTable, addButton, 155, 0);
        ClasspathPanel.addKeyboardShortcut((JComponent)this.myEntryTable, upButton, 38, 128);
        ClasspathPanel.addKeyboardShortcut((JComponent)this.myEntryTable, downButton, 40, 128);
        addButton.addActionListener(new ButtonAction(){

            @Override
            protected void executeImpl() {
                ClasspathPanel.this.initPopupActions();
                ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<PopupAction>(null, ClasspathPanel.this.myPopupActions, ClasspathPanel.this.myIcons){

                    public boolean isMnemonicsNavigationEnabled() {
                        return true;
                    }

                    public boolean isSelectable(PopupAction value) {
                        return value.isSelectable();
                    }

                    public PopupStep onChosen(final PopupAction selectedValue, boolean finalChoice) {
                        return this.doFinalStep(new Runnable(){

                            @Override
                            public void run() {
                                selectedValue.execute();
                            }
                        });
                    }

                    @NotNull
                    public String getTextFor(PopupAction value) {
                        String string = "&" + value.getIndex() + "  " + value.getTitle();
                        if (string == null) {
                            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/ClasspathPanel$8$1.getTextFor must not return null");
                        }
                        return string;
                    }
                });
                popup.showUnderneathOf((Component)addButton);
            }
        });
        removeButton.addActionListener(new ButtonAction(){

            @Override
            protected void executeImpl() {
                List removedRows = TableUtil.removeSelectedItems((JTable)ClasspathPanel.this.myEntryTable);
                if (removedRows.isEmpty()) {
                    return;
                }
                for (Object removedRow : removedRows) {
                    TableItem item = (TableItem)((Object[])removedRow)[1];
                    Object orderEntry = item.getEntry();
                    if (orderEntry == null) continue;
                    ClasspathPanel.this.getRootModel().removeOrderEntry(orderEntry);
                }
                int[] selectedRows = ClasspathPanel.this.myEntryTable.getSelectedRows();
                ClasspathPanel.this.myModel.fireTableDataChanged();
                TableUtil.selectRows((JTable)ClasspathPanel.this.myEntryTable, (int[])selectedRows);
                StructureConfigurableContext context = ModuleStructureConfigurable.getInstance(ClasspathPanel.this.myState.getProject()).getContext();
                context.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(context, ClasspathPanel.this.getRootModel().getModule()));
            }
        });
        this.myEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryTableModifiableModelProvider provider;
                int row = ClasspathPanel.this.myEntryTable.getSelectedRow();
                TableItem item = ClasspathPanel.this.myModel.getItemAt(row);
                if (!(item instanceof LibItem)) {
                    return;
                }
                LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)((LibItem)item).getEntry();
                if (libraryOrderEntry == null) {
                    return;
                }
                Library library = libraryOrderEntry.getLibrary();
                if (library == null) {
                    return;
                }
                LibraryTable table = library.getTable();
                if (table == null) {
                    final LibraryTable moduleLibraryTable = ClasspathPanel.this.getRootModel().getModuleLibraryTable();
                    provider = new LibraryTableModifiableModelProvider(){

                        @Override
                        public LibraryTable.ModifiableModel getModifiableModel() {
                            return moduleLibraryTable.getModifiableModel();
                        }

                        @Override
                        public String getTableLevel() {
                            return moduleLibraryTable.getTableLevel();
                        }

                        @Override
                        public LibraryTablePresentation getLibraryTablePresentation() {
                            return moduleLibraryTable.getPresentation();
                        }

                        @Override
                        public boolean isLibraryTableEditable() {
                            return false;
                        }
                    };
                } else {
                    provider = ProjectStructureConfigurable.getInstance(ClasspathPanel.this.myState.getProject()).getContext().createModifiableModelProvider(table.getTableLevel(), false);
                }
                LibraryTableEditor editor = LibraryTableEditor.editLibrary(provider, library);
                editor.addFileChooserContext(LangDataKeys.MODULE_CONTEXT, ClasspathPanel.this.getRootModel().getModule());
                editor.openDialog(ClasspathPanel.this, Collections.singletonList(library), true);
                ClasspathPanel.this.myEntryTable.repaint();
                ModuleStructureConfigurable.getInstance(ClasspathPanel.this.myState.getProject()).getTree().repaint();
            }
        });
        return panel;
    }

    private static void addKeyboardShortcut(JComponent target, final JButton button, int keyEvent, int modifiers) {
        target.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (button.isEnabled()) {
                    button.doClick();
                }
            }
        }, KeyStroke.getKeyStroke(keyEvent, modifiers), 0);
    }

    private ModifiableRootModel getRootModel() {
        return this.myState.getRootModel();
    }

    public void rootsChanged() {
        this.forceInitFromModel();
    }

    private void initPopupActions() {
        if (this.myPopupActions == null) {
            StructureConfigurableContext context = ProjectStructureConfigurable.getInstance(this.myState.getProject()).getContext();
            int actionIndex = 1;
            ArrayList<PopupAction> actions = new ArrayList<PopupAction>(Arrays.asList(new ChooseAndAddAction<Library>(actionIndex++, ProjectBundle.message((String)"classpath.add.simple.module.library.action", (Object[])new Object[0]), Icons.JAR_ICON){

                @Override
                protected TableItem createTableItem(Library item) {
                    OrderEntry[] entries;
                    for (OrderEntry entry : entries = ClasspathPanel.this.getRootModel().getOrderEntries()) {
                        LibraryOrderEntry libraryOrderEntry;
                        if (!(entry instanceof LibraryOrderEntry) || !item.equals((libraryOrderEntry = (LibraryOrderEntry)entry).getLibrary())) continue;
                        return new LibItem(libraryOrderEntry);
                    }
                    LOG.error("Unknown library " + item);
                    return null;
                }

                @Override
                protected ChooserDialog<Library> createChooserDialog() {
                    return new ChooseModuleLibrariesDialog(ClasspathPanel.this, ClasspathPanel.this.getRootModel().getModuleLibraryTable(), null);
                }
            }, new ChooseAndAddAction<Library>(actionIndex++, ProjectBundle.message((String)"classpath.add.module.library.action", (Object[])new Object[0]), Icons.JAR_ICON){

                @Override
                protected TableItem createTableItem(Library item) {
                    OrderEntry[] entries;
                    for (OrderEntry entry : entries = ClasspathPanel.this.getRootModel().getOrderEntries()) {
                        LibraryOrderEntry libraryOrderEntry;
                        if (!(entry instanceof LibraryOrderEntry) || !item.equals((libraryOrderEntry = (LibraryOrderEntry)entry).getLibrary())) continue;
                        return new LibItem(libraryOrderEntry);
                    }
                    LOG.error("Unknown library " + item);
                    return null;
                }

                @Override
                protected ChooserDialog<Library> createChooserDialog() {
                    return new CreateModuleLibraryDialog(ClasspathPanel.this, ClasspathPanel.this.getRootModel().getModuleLibraryTable());
                }
            }, new ChooseNamedLibraryAction(actionIndex++, ProjectBundle.message((String)"classpath.add.project.library.action", (Object[])new Object[0]), context.getProjectLibrariesProvider(true)), new ChooseNamedLibraryAction(actionIndex++, ProjectBundle.message((String)"classpath.add.global.library.action", (Object[])new Object[0]), context.getGlobalLibrariesProvider(true))));
            for (LibraryTableModifiableModelProvider provider : context.getCustomLibrariesProviders(true)) {
                actions.add(new ChooseNamedLibraryAction(actionIndex++, provider.getLibraryTablePresentation().getDisplayName(false) + "...", provider));
            }
            actions.add(new ChooseAndAddAction<Module>(actionIndex, ProjectBundle.message((String)"classpath.add.module.dependency.action", (Object[])new Object[0]), StdModuleTypes.JAVA.getNodeIcon(false)){

                @Override
                protected TableItem createTableItem(Module item) {
                    return new ModuleItem(ClasspathPanel.this.getRootModel().addModuleOrderEntry(item));
                }

                @Override
                protected ChooserDialog<Module> createChooserDialog() {
                    List chooseItems = ClasspathPanel.this.getDependencyModules();
                    if (chooseItems.isEmpty()) {
                        Messages.showMessageDialog((Component)ClasspathPanel.this, (String)ProjectBundle.message((String)"message.no.module.dependency.candidates", (Object[])new Object[0]), (String)this.getTitle(), (Icon)Messages.getInformationIcon());
                        return null;
                    }
                    return new ChooseModulesToAddDialog((List<Module>)chooseItems, ProjectBundle.message((String)"classpath.chooser.title.add.module.dependency", (Object[])new Object[0]));
                }
            });
            this.myPopupActions = actions.toArray(new PopupAction[actions.size()]);
            this.myIcons = new Icon[this.myPopupActions.length];
            for (int idx = 0; idx < this.myPopupActions.length; ++idx) {
                this.myIcons[idx] = this.myPopupActions[idx].getIcon();
            }
        }
    }

    private void enableModelUpdate() {
        --this.myInsideChange;
    }

    private void disableModelUpdate() {
        ++this.myInsideChange;
    }

    public void addListener(OrderPanelListener listener) {
        this.myListeners.addListener((EventListener)listener);
    }

    public void removeListener(OrderPanelListener listener) {
        this.myListeners.removeListener((EventListener)listener);
    }

    private void moveSelectedRows(int increment) {
        int row;
        if (increment == 0) {
            return;
        }
        if (this.myEntryTable.isEditing()) {
            this.myEntryTable.getCellEditor().stopCellEditing();
        }
        ListSelectionModel selectionModel = this.myEntryTable.getSelectionModel();
        int n = row = increment < 0 ? 0 : this.myModel.getRowCount() - 1;
        while (increment < 0 ? row < this.myModel.getRowCount() : row >= 0) {
            if (selectionModel.isSelectedIndex(row)) {
                int newRow = this.moveRow(row, increment);
                selectionModel.removeSelectionInterval(row, row);
                selectionModel.addSelectionInterval(newRow, newRow);
            }
            row += increment < 0 ? 1 : -1;
        }
        this.myModel.fireTableRowsUpdated(0, this.myModel.getRowCount() - 1);
        Rectangle cellRect = this.myEntryTable.getCellRect(selectionModel.getMinSelectionIndex(), 0, true);
        if (cellRect != null) {
            this.myEntryTable.scrollRectToVisible(cellRect);
        }
        this.myEntryTable.repaint();
        ((OrderPanelListener)this.myListeners.getMulticaster()).entryMoved();
    }

    public void selectOrderEntry(@NotNull OrderEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/ClasspathPanel.selectOrderEntry must not be null");
        }
        for (int row = 0; row < this.myModel.getRowCount(); ++row) {
            if (!entry.equals(this.myModel.getItemAt(row).getEntry())) continue;
            this.myEntryTable.getSelectionModel().setSelectionInterval(row, row);
            TableUtil.scrollSelectionToVisible((JTable)this.myEntryTable);
        }
        IdeFocusManager.getInstance((Project)this.myState.getProject()).requestFocus((Component)this.myEntryTable, true);
    }

    private int moveRow(int row, int increment) {
        int newIndex = Math.abs(row + increment) % this.myModel.getRowCount();
        TableItem item = this.myModel.removeDataRow(row);
        this.myModel.addItemAt(item, newIndex);
        return newIndex;
    }

    public void stopEditing() {
        TableUtil.stopEditing((JTable)this.myEntryTable);
    }

    public List<OrderEntry> getEntries() {
        int count = this.myModel.getRowCount();
        ArrayList<OrderEntry> entries = new ArrayList<OrderEntry>(count);
        for (int row = 0; row < count; ++row) {
            Object entry = this.myModel.getItemAt(row).getEntry();
            if (entry == null) continue;
            entries.add((OrderEntry)entry);
        }
        return entries;
    }

    public void initFromModel() {
        if (this.myInsideChange == 0) {
            this.forceInitFromModel();
        }
    }

    void forceInitFromModel() {
        int[] selection = this.myEntryTable.getSelectedRows();
        this.myModel.clear();
        this.myModel.init();
        this.myModel.fireTableDataChanged();
        TableUtil.selectRows((JTable)this.myEntryTable, (int[])selection);
    }

    private List<Module> getDependencyModules() {
        int rowCount = this.myModel.getRowCount();
        HashSet<String> filtered = new HashSet<String>(rowCount);
        for (int row = 0; row < rowCount; ++row) {
            Object entry = this.myModel.getItemAt(row).getEntry();
            if (!(entry instanceof ModuleOrderEntry)) continue;
            filtered.add(((ModuleOrderEntry)entry).getModuleName());
        }
        ModulesProvider modulesProvider = this.myState.getModulesProvider();
        Module self = modulesProvider.getModule(this.getRootModel().getModule().getName());
        filtered.add(self.getName());
        Module[] modules = modulesProvider.getModules();
        ArrayList<Module> elements = new ArrayList<Module>(modules.length);
        for (Module module : modules) {
            if (filtered.contains(module.getName())) continue;
            elements.add(module);
        }
        return elements;
    }

    private static CellAppearance getCellAppearance(TableItem item, boolean selected) {
        if (item instanceof JdkItem && item.getEntry() == null) {
            return OrderEntryCellAppearanceUtils.forJdk(null, (boolean)false, (boolean)selected);
        }
        return OrderEntryCellAppearanceUtils.forOrderEntry(item.getEntry(), (boolean)selected);
    }

    private class MyFindUsagesAction
    extends FindUsagesInProjectStructureActionBase {
        private MyFindUsagesAction() {
            super((JComponent)ClasspathPanel.this.myEntryTable, ClasspathPanel.this.myState.getProject());
        }

        @Override
        protected boolean isEnabled() {
            return this.getSelectedElement() != null;
        }

        @Override
        protected ProjectStructureElement getSelectedElement() {
            int row = ClasspathPanel.this.myEntryTable.getSelectedRow();
            if (0 <= row && row < ClasspathPanel.this.myModel.getRowCount()) {
                Sdk jdk;
                JdkOrderEntry orderEntry;
                TableItem item = ClasspathPanel.this.myModel.getItemAt(row);
                if (item instanceof LibItem) {
                    Library library;
                    LibraryOrderEntry orderEntry2 = (LibraryOrderEntry)((LibItem)item).getEntry();
                    if (orderEntry2 != null && (library = orderEntry2.getLibrary()) != null) {
                        return new LibraryProjectStructureElement(this.getContext(), library);
                    }
                } else if (item instanceof ModuleItem) {
                    Module module;
                    ModuleOrderEntry orderEntry3 = (ModuleOrderEntry)((ModuleItem)item).getEntry();
                    if (orderEntry3 != null && (module = orderEntry3.getModule()) != null) {
                        return new ModuleProjectStructureElement(this.getContext(), module);
                    }
                } else if (item instanceof JdkItem && (orderEntry = (JdkOrderEntry)((JdkItem)item).getEntry()) != null && (jdk = orderEntry.getJdk()) != null) {
                    return new SdkProjectStructureElement(this.getContext(), jdk);
                }
            }
            return null;
        }

        @Override
        protected RelativePoint getPointToShowResults() {
            Rectangle rect = ClasspathPanel.this.myEntryTable.getCellRect(ClasspathPanel.this.myEntryTable.getSelectedRow(), 1, false);
            Point location = rect.getLocation();
            location.y += rect.height;
            return new RelativePoint((Component)ClasspathPanel.this.myEntryTable, location);
        }
    }

    private class ChooseNamedLibraryAction
    extends ChooseAndAddAction<Library> {
        private final LibraryTableModifiableModelProvider myLibraryTableModelProvider;

        public ChooseNamedLibraryAction(int index, String title, LibraryTableModifiableModelProvider libraryTable) {
            super(index, title, Icons.LIBRARY_ICON);
            this.myLibraryTableModelProvider = libraryTable;
        }

        @Override
        @Nullable
        protected TableItem createTableItem(Library item) {
            OrderEntry[] orderEntries;
            for (OrderEntry orderEntry : orderEntries = ClasspathPanel.this.getRootModel().getOrderEntries()) {
                if (!(orderEntry instanceof LibraryOrderEntry) || !item.getName().equals(((LibraryOrderEntry)orderEntry).getLibraryName())) continue;
                if (orderEntry.isValid()) {
                    Messages.showErrorDialog((String)ProjectBundle.message((String)"classpath.message.library.already.added", (Object[])new Object[]{item.getName()}), (String)ProjectBundle.message((String)"classpath.title.adding.dependency", (Object[])new Object[0]));
                    return null;
                }
                ClasspathPanel.this.getRootModel().removeOrderEntry(orderEntry);
            }
            return new LibItem(ClasspathPanel.this.getRootModel().addLibraryEntry(item));
        }

        @Override
        protected ChooserDialog<Library> createChooserDialog() {
            return new MyChooserDialog();
        }

        private Collection<Library> getAlreadyAddedLibraries() {
            OrderEntry[] orderEntries = ClasspathPanel.this.getRootModel().getOrderEntries();
            HashSet<Library> result = new HashSet<Library>(orderEntries.length);
            for (OrderEntry orderEntry : orderEntries) {
                LibraryImpl library;
                if (!(orderEntry instanceof LibraryOrderEntry) || !orderEntry.isValid() || (library = (LibraryImpl)((LibraryOrderEntry)orderEntry).getLibrary()) == null) continue;
                result.add(library.getSource());
            }
            return result;
        }

        private class MyChooserDialog
        implements ChooserDialog<Library> {
            private final LibraryTableEditor myEditor;
            private Library[] myLibraries;

            MyChooserDialog() {
                this.myEditor = LibraryTableEditor.editLibraryTable(ChooseNamedLibraryAction.this.myLibraryTableModelProvider, ClasspathPanel.this.myState.getProject());
                Disposer.register((Disposable)this, (Disposable)this.myEditor);
            }

            @Override
            public List<Library> getChosenElements() {
                ArrayList<Library> chosen = new ArrayList<Library>(Arrays.asList(this.myLibraries));
                chosen.removeAll(ChooseNamedLibraryAction.this.getAlreadyAddedLibraries());
                return chosen;
            }

            @Override
            public void doChoose() {
                Iterator iter = ChooseNamedLibraryAction.this.myLibraryTableModelProvider.getModifiableModel().getLibraryIterator();
                this.myLibraries = this.myEditor.openDialog(ClasspathPanel.this, iter.hasNext() ? Collections.singleton((Library)iter.next()) : Collections.emptyList(), false);
            }

            @Override
            public boolean isOK() {
                return this.myLibraries != null;
            }

            public void dispose() {
            }
        }
    }

    private static class ChooseModuleLibrariesDialog
    extends LibraryFileChooser
    implements ChooserDialog<Library> {
        private Pair<String, VirtualFile[]> myLastChosen;
        private final LibraryTable myLibraryTable;
        @Nullable
        private final VirtualFile myFileToSelect;

        public ChooseModuleLibrariesDialog(Component parent, LibraryTable libraryTable, VirtualFile fileToSelect) {
            super(ChooseModuleLibrariesDialog.createFileChooserDescriptor(parent), parent, false, null);
            this.myLibraryTable = libraryTable;
            this.myFileToSelect = fileToSelect;
        }

        private static FileChooserDescriptor createFileChooserDescriptor(Component parent) {
            FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, true, false, false, true);
            Module contextModule = (Module)LangDataKeys.MODULE_CONTEXT.getData(DataManager.getInstance().getDataContext(parent));
            descriptor.putUserData(LangDataKeys.MODULE_CONTEXT, (Object)contextModule);
            return descriptor;
        }

        @Override
        public List<Library> getChosenElements() {
            if (this.myLastChosen == null) {
                return Collections.emptyList();
            }
            VirtualFile[] files = this.filterAlreadyAdded((VirtualFile[])this.myLastChosen.getSecond());
            if (files.length == 0) {
                return Collections.emptyList();
            }
            LibraryTable.ModifiableModel modifiableModel = this.myLibraryTable.getModifiableModel();
            ArrayList<Library> addedLibraries = new ArrayList<Library>(files.length);
            for (VirtualFile file : files) {
                Library library = modifiableModel.createLibrary(null);
                Library.ModifiableModel libModel = library.getModifiableModel();
                libModel.addRoot(file, OrderRootType.CLASSES);
                libModel.commit();
                addedLibraries.add(library);
            }
            return addedLibraries;
        }

        private VirtualFile[] filterAlreadyAdded(VirtualFile[] files) {
            Library[] libraries;
            if (files == null || files.length == 0) {
                return VirtualFile.EMPTY_ARRAY;
            }
            HashSet<VirtualFile> chosenFilesSet = new HashSet<VirtualFile>(Arrays.asList(files));
            HashSet<VirtualFile> alreadyAdded = new HashSet<VirtualFile>();
            for (Library library : libraries = this.myLibraryTable.getLibraries()) {
                alreadyAdded.addAll(Arrays.asList(library.getFiles(OrderRootType.CLASSES)));
            }
            chosenFilesSet.removeAll(alreadyAdded);
            return VfsUtil.toVirtualFileArray(chosenFilesSet);
        }

        @Override
        public void doChoose() {
            this.myLastChosen = this.chooseNameAndFiles(this.myFileToSelect);
        }
    }

    private static class CreateModuleLibraryDialog
    implements ChooserDialog<Library> {
        private boolean myIsOk;
        private final Component myParent;
        private final LibraryTable myLibraryTable;
        private Library myChosenLibrary;

        public CreateModuleLibraryDialog(Component parent, LibraryTable libraryTable) {
            this.myParent = parent;
            this.myLibraryTable = libraryTable;
        }

        @Override
        public List<Library> getChosenElements() {
            return this.myChosenLibrary == null ? Collections.emptyList() : Collections.singletonList(this.myChosenLibrary);
        }

        @Override
        public void doChoose() {
            final LibraryTable.ModifiableModel libraryModifiableModel = this.myLibraryTable.getModifiableModel();
            LibraryTableModifiableModelProvider provider = new LibraryTableModifiableModelProvider(){

                @Override
                public LibraryTable.ModifiableModel getModifiableModel() {
                    return libraryModifiableModel;
                }

                @Override
                public String getTableLevel() {
                    return CreateModuleLibraryDialog.this.myLibraryTable.getTableLevel();
                }

                @Override
                public LibraryTablePresentation getLibraryTablePresentation() {
                    return CreateModuleLibraryDialog.this.myLibraryTable.getPresentation();
                }

                @Override
                public boolean isLibraryTableEditable() {
                    return false;
                }
            };
            Library library = this.myLibraryTable.createLibrary();
            LibraryTableEditor editor = LibraryTableEditor.editLibrary(provider, library);
            Module contextModule = (Module)DataKeys.MODULE_CONTEXT.getData(DataManager.getInstance().getDataContext(this.myParent));
            editor.addFileChooserContext(LangDataKeys.MODULE_CONTEXT, contextModule);
            boolean bl = this.myIsOk = editor.openDialog(this.myParent, Collections.singletonList(library), true) != null;
            if (this.myIsOk && library.getUrls(OrderRootType.CLASSES).length > 0) {
                this.myChosenLibrary = library;
            } else {
                this.myChosenLibrary = null;
                libraryModifiableModel.removeLibrary(library);
            }
        }

        @Override
        public boolean isOK() {
            return this.myIsOk;
        }

        public void dispose() {
        }
    }

    private class ChooseModulesToAddDialog
    extends ChooseModulesDialog
    implements ChooserDialog<Module> {
        public ChooseModulesToAddDialog(List<Module> items, String title) {
            super((Component)ClasspathPanel.this, items, title);
        }

        @Override
        public void doChoose() {
            this.show();
        }

        public void dispose() {
            super.dispose();
        }
    }

    private static interface ChooserDialog<T>
    extends Disposable {
        public List<T> getChosenElements();

        public void doChoose();

        public boolean isOK();
    }

    private static class ExportFlagRenderer
    implements TableCellRenderer {
        private final TableCellRenderer myDelegate;
        private final JPanel myBlankPanel;

        public ExportFlagRenderer(TableCellRenderer delegate) {
            this.myDelegate = delegate;
            this.myBlankPanel = new JPanel();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (!table.isCellEditable(row, column)) {
                this.myBlankPanel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                return this.myBlankPanel;
            }
            return this.myDelegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private static class TableItemRenderer
    extends ColoredTableCellRenderer {
        private final Border NO_FOCUS_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);

        private TableItemRenderer() {
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            this.setPaintFocusBorder(false);
            this.setFocusBorderAroundIcon(true);
            this.setBorder(this.NO_FOCUS_BORDER);
            if (value instanceof TableItem) {
                ClasspathPanel.getCellAppearance((TableItem)value, selected).customize((SimpleColoredComponent)this);
            }
        }
    }

    private static class MyTableModel
    extends AbstractTableModel
    implements ItemRemovable {
        private static final String EXPORT_COLUMN_NAME = ProjectBundle.message((String)"modules.order.export.export.column", (Object[])new Object[0]);
        private static final String SCOPE_COLUMN_NAME = ProjectBundle.message((String)"modules.order.export.scope.column", (Object[])new Object[0]);
        public static final int EXPORT_COLUMN = 0;
        public static final int ITEM_COLUMN = 1;
        public static final int SCOPE_COLUMN = 2;
        private final List<TableItem> myItems = new ArrayList<TableItem>();
        private final ModuleConfigurationState myState;

        public MyTableModel(ModuleConfigurationState state) {
            this.myState = state;
            this.init();
        }

        private ModifiableRootModel getModel() {
            return this.myState.getRootModel();
        }

        public void init() {
            OrderEntry[] orderEntries = this.getModel().getOrderEntries();
            boolean hasJdkOrderEntry = false;
            for (OrderEntry orderEntry : orderEntries) {
                if (orderEntry instanceof JdkOrderEntry) {
                    hasJdkOrderEntry = true;
                }
                this.addOrderEntry(orderEntry);
            }
            if (!hasJdkOrderEntry) {
                this.addItemAt(new JdkItem(null), 0);
            }
        }

        private void addOrderEntry(OrderEntry orderEntry) {
            if (orderEntry instanceof JdkOrderEntry) {
                this.addItem(new JdkItem((JdkOrderEntry)orderEntry));
            } else if (orderEntry instanceof LibraryOrderEntry) {
                this.addItem(new LibItem((LibraryOrderEntry)orderEntry));
            } else if (orderEntry instanceof ModuleOrderEntry) {
                this.addItem(new ModuleItem((ModuleOrderEntry)orderEntry));
            } else if (orderEntry instanceof ModuleSourceOrderEntry) {
                this.addItem(new SelfModuleItem((ModuleSourceOrderEntry)orderEntry));
            }
        }

        public TableItem getItemAt(int row) {
            return this.myItems.get(row);
        }

        public void addItem(TableItem item) {
            this.myItems.add(item);
        }

        public void addItemAt(TableItem item, int row) {
            this.myItems.add(row, item);
        }

        public TableItem removeDataRow(int row) {
            return this.myItems.remove(row);
        }

        public void removeRow(int row) {
            this.removeDataRow(row);
        }

        public void clear() {
            this.myItems.clear();
        }

        @Override
        public int getRowCount() {
            return this.myItems.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            TableItem item = this.myItems.get(rowIndex);
            if (columnIndex == 0) {
                return item.isExported();
            }
            if (columnIndex == 2) {
                return item.getScope();
            }
            if (columnIndex == 1) {
                return item;
            }
            LOG.error("Incorrect column index: " + columnIndex);
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            TableItem item = this.myItems.get(rowIndex);
            if (columnIndex == 0) {
                item.setExported((Boolean)aValue);
            } else if (columnIndex == 2 && aValue instanceof DependencyScope) {
                item.setScope((DependencyScope)aValue);
            }
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return EXPORT_COLUMN_NAME;
            }
            if (column == 2) {
                return SCOPE_COLUMN_NAME;
            }
            return "";
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return Boolean.class;
            }
            if (column == 2) {
                return DependencyScope.class;
            }
            if (column == 1) {
                return TableItem.class;
            }
            return super.getColumnClass(column);
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (column == 0 || column == 2) {
                TableItem item = this.myItems.get(row);
                return item != null && item.isExportable();
            }
            return false;
        }
    }

    private static class SelfModuleItem
    extends TableItem<ModuleSourceOrderEntry> {
        public SelfModuleItem(ModuleSourceOrderEntry entry) {
            super(entry);
        }

        @Override
        public boolean isRemovable() {
            return false;
        }

        @Override
        public boolean isEditable() {
            return false;
        }
    }

    private static class JdkItem
    extends TableItem<JdkOrderEntry> {
        public JdkItem(JdkOrderEntry entry) {
            super(entry);
        }

        @Override
        public boolean isRemovable() {
            return false;
        }

        @Override
        public boolean isEditable() {
            return true;
        }
    }

    private static class ModuleItem
    extends TableItem<ModuleOrderEntry> {
        public ModuleItem(ModuleOrderEntry entry) {
            super(entry);
        }

        @Override
        public boolean isRemovable() {
            return true;
        }

        @Override
        public boolean isEditable() {
            return true;
        }
    }

    private static class LibItem
    extends TableItem<LibraryOrderEntry> {
        public LibItem(LibraryOrderEntry entry) {
            super(entry);
        }

        @Override
        public boolean isRemovable() {
            return true;
        }

        @Override
        public boolean isEditable() {
            LibraryOrderEntry orderEntry = (LibraryOrderEntry)this.getEntry();
            return orderEntry != null && orderEntry.isValid();
        }
    }

    private static abstract class TableItem<T extends OrderEntry> {
        @Nullable
        protected final T myEntry;

        protected TableItem(@Nullable T entry) {
            this.myEntry = entry;
        }

        public final boolean isExportable() {
            return this.myEntry instanceof ExportableOrderEntry;
        }

        public final boolean isExported() {
            return this.isExportable() && ((ExportableOrderEntry)this.getEntry()).isExported();
        }

        public final void setExported(boolean isExported) {
            if (this.isExportable()) {
                ((ExportableOrderEntry)this.getEntry()).setExported(isExported);
            }
        }

        @Nullable
        public final DependencyScope getScope() {
            return this.myEntry instanceof ExportableOrderEntry ? ((ExportableOrderEntry)this.myEntry).getScope() : null;
        }

        public final void setScope(DependencyScope scope) {
            if (this.myEntry instanceof ExportableOrderEntry) {
                ((ExportableOrderEntry)this.myEntry).setScope(scope);
            }
        }

        public final T getEntry() {
            return this.myEntry;
        }

        public abstract boolean isRemovable();

        public abstract boolean isEditable();
    }

    private abstract class ChooseAndAddAction<ItemType>
    extends PopupAction {
        public ChooseAndAddAction(int index, String title, Icon icon) {
            super(title, icon, index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final void executeImpl() {
            ChooserDialog<ItemType> dialog = this.createChooserDialog();
            if (dialog == null) {
                return;
            }
            try {
                dialog.doChoose();
                if (!dialog.isOK()) {
                    return;
                }
                List<ItemType> chosen = dialog.getChosenElements();
                if (chosen.isEmpty()) {
                    return;
                }
                ModuleStructureConfigurable rootConfigurable = ModuleStructureConfigurable.getInstance(ClasspathPanel.this.myState.getProject());
                for (ItemType item : chosen) {
                    TableItem tableItem = this.createTableItem(item);
                    if (tableItem == null) continue;
                    ClasspathPanel.this.myModel.addItem(tableItem);
                }
                ClasspathPanel.this.myModel.fireTableDataChanged();
                ListSelectionModel selectionModel = ClasspathPanel.this.myEntryTable.getSelectionModel();
                selectionModel.setSelectionInterval(ClasspathPanel.this.myModel.getRowCount() - chosen.size(), ClasspathPanel.this.myModel.getRowCount() - 1);
                TableUtil.scrollSelectionToVisible((JTable)ClasspathPanel.this.myEntryTable);
                StructureConfigurableContext context = rootConfigurable.getContext();
                context.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(context, ClasspathPanel.this.getRootModel().getModule()));
            }
            finally {
                if (dialog instanceof ChooseNamedLibraryAction.MyChooserDialog) {
                    Disposer.dispose(dialog);
                }
            }
        }

        @Nullable
        protected abstract TableItem createTableItem(ItemType var1);

        @Nullable
        protected abstract ChooserDialog<ItemType> createChooserDialog();
    }

    private class PopupAction
    extends ButtonAction {
        private final String myTitle;
        private final Icon myIcon;
        private final int myIndex;

        protected PopupAction(String title, Icon icon, int index) {
            this.myTitle = title;
            this.myIcon = icon;
            this.myIndex = index;
        }

        public String getTitle() {
            return this.myTitle;
        }

        public Icon getIcon() {
            return this.myIcon;
        }

        public int getIndex() {
            return this.myIndex;
        }

        public boolean isSelectable() {
            return true;
        }

        @Override
        protected void executeImpl() {
        }
    }

    private abstract class ButtonAction
    implements ActionListener {
        private ButtonAction() {
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            this.execute();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void execute() {
            try {
                ClasspathPanel.this.disableModelUpdate();
                this.executeImpl();
            }
            finally {
                ClasspathPanel.this.enableModelUpdate();
                ClasspathPanel.this.myEntryTable.requestFocus();
            }
        }

        protected abstract void executeImpl();
    }
}

