/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorageChooser;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleComponent;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.ModuleFileIndexImpl;
import com.intellij.openapi.roots.impl.ModuleOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleSourceOrderEntryImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootConfigurationAccessor;
import com.intellij.openapi.roots.impl.RootModelComponentBase;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="NewModuleRootManager", storages={@Storage(id="default", file="$MODULE_FILE$"), @Storage(id="special", storageClass=ClasspathStorage.class)}, storageChooser=StorageChooser.class)
public class ModuleRootManagerImpl
extends ModuleRootManager
implements ModuleComponent,
PersistentStateComponent<ModuleRootManagerState> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.ModuleRootManagerImpl");
    private final Module myModule;
    private final ProjectRootManagerImpl myProjectRootManager;
    private final VirtualFilePointerManager myFilePointerManager;
    private RootModelImpl myRootModel;
    private final ModuleFileIndexImpl myFileIndex;
    private boolean myIsDisposed = false;
    private boolean isModuleAdded = false;
    private final Map<OrderRootType, Set<VirtualFilePointer>> myCachedFiles = new THashMap();
    private final Map<OrderRootType, Set<VirtualFilePointer>> myCachedExportedFiles = new THashMap();
    private final Map<RootModelImpl, Throwable> myModelCreations = new THashMap();

    public ModuleRootManagerImpl(Module module, DirectoryIndex directoryIndex, ProjectRootManagerImpl projectRootManager, VirtualFilePointerManager filePointerManager) {
        this.myModule = module;
        this.myProjectRootManager = projectRootManager;
        this.myFilePointerManager = filePointerManager;
        this.myFileIndex = new ModuleFileIndexImpl(this.myModule, directoryIndex);
        this.myRootModel = new RootModelImpl(this, this.myProjectRootManager, this.myFilePointerManager);
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleRootManagerImpl.getModule must not return null");
        }
        return module;
    }

    @NotNull
    public ModuleFileIndex getFileIndex() {
        ModuleFileIndexImpl moduleFileIndexImpl = this.myFileIndex;
        if (moduleFileIndexImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleRootManagerImpl.getFileIndex must not return null");
        }
        return moduleFileIndexImpl;
    }

    @NotNull
    public String getComponentName() {
        if ("NewModuleRootManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleRootManagerImpl.getComponentName must not return null");
        }
        return "NewModuleRootManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        this.myRootModel.dispose();
        this.myIsDisposed = true;
        if (Disposer.isDebugMode()) {
            Set<Map.Entry<RootModelImpl, Throwable>> entries = this.myModelCreations.entrySet();
            for (Map.Entry<RootModelImpl, Throwable> entry : new ArrayList<Map.Entry<RootModelImpl, Throwable>>(entries)) {
                System.err.println("***********************************************************************************************");
                System.err.println("***                        R O O T   M O D E L   N O T   D I S P O S E D                    ***");
                System.err.println("***********************************************************************************************");
                System.err.println("Created at:");
                entry.getValue().printStackTrace(System.err);
                entry.getKey().dispose();
            }
        }
    }

    public VirtualFile getExplodedDirectory() {
        return this.myRootModel.getExplodedDirectory();
    }

    public String getExplodedDirectoryUrl() {
        return this.myRootModel.getExplodedDirectoryUrl();
    }

    @NotNull
    public ModifiableRootModel getModifiableModel() {
        ModifiableRootModel modifiableRootModel = this.getModifiableModel(new RootConfigurationAccessor());
        if (modifiableRootModel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleRootManagerImpl.getModifiableModel must not return null");
        }
        return modifiableRootModel;
    }

    @NotNull
    public ModifiableRootModel getModifiableModel(RootConfigurationAccessor accessor) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        RootModelImpl model = new RootModelImpl(this.myRootModel, this, true, accessor, null, this.myFilePointerManager, this.myProjectRootManager){

            @Override
            public void dispose() {
                super.dispose();
                if (Disposer.isDebugMode()) {
                    ModuleRootManagerImpl.this.myModelCreations.remove(this);
                }
                for (OrderEntry entry : ModuleRootManagerImpl.this.getOrderEntries()) {
                    assert (!((RootModelComponentBase)entry).isDisposed());
                }
            }
        };
        if (Disposer.isDebugMode()) {
            this.myModelCreations.put(model, new Throwable());
        }
        RootModelImpl rootModelImpl = model;
        if (rootModelImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleRootManagerImpl.getModifiableModel must not return null");
        }
        return rootModelImpl;
    }

    void makeRootsChange(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ModuleRootManagerImpl.makeRootsChange must not be null");
        }
        ProjectRootManagerEx projectRootManagerEx = (ProjectRootManagerEx)ProjectRootManager.getInstance((Project)this.myModule.getProject());
        projectRootManagerEx.makeRootsChange(runnable, false, this.isModuleAdded);
    }

    RootModelImpl getRootModel() {
        return this.myRootModel;
    }

    public ContentEntry[] getContentEntries() {
        return this.myRootModel.getContentEntries();
    }

    @NotNull
    public OrderEntry[] getOrderEntries() {
        OrderEntry[] orderEntryArray = this.myRootModel.getOrderEntries();
        if (orderEntryArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleRootManagerImpl.getOrderEntries must not return null");
        }
        return orderEntryArray;
    }

    public Sdk getSdk() {
        return this.myRootModel.getSdk();
    }

    public boolean isSdkInherited() {
        return this.myRootModel.isSdkInherited();
    }

    @NotNull
    public VirtualFile[] getFiles(OrderRootType type) {
        VirtualFile[] virtualFileArray = this.getFiles(type, (Set<Module>)new HashSet());
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleRootManagerImpl.getFiles must not return null");
        }
        return virtualFileArray;
    }

    @NotNull
    private VirtualFile[] getFiles(OrderRootType type, Set<Module> processed) {
        Set<VirtualFilePointer> cachedFiles = this.myCachedFiles.get(type);
        if (cachedFiles == null) {
            cachedFiles = new LinkedHashSet<VirtualFilePointer>();
            Iterator<OrderEntry> orderIterator = this.myRootModel.getOrderIterator();
            while (orderIterator.hasNext()) {
                String[] urls;
                OrderEntry entry = orderIterator.next();
                if (entry instanceof ModuleOrderEntryImpl) {
                    List<String> list = ((ModuleOrderEntryImpl)entry).getUrls(type, processed);
                    urls = ArrayUtil.toStringArray(list);
                } else {
                    urls = entry.getUrls(type);
                }
                VirtualFilePointerManager virtualFilePointerManager = VirtualFilePointerManager.getInstance();
                for (String url : urls) {
                    if (url == null) continue;
                    cachedFiles.add(virtualFilePointerManager.create(url, (Disposable)this.getModule(), null));
                }
            }
            this.myCachedFiles.put(type, cachedFiles);
        }
        VirtualFile[] virtualFileArray = ModuleRootManagerImpl.convertPointers(cachedFiles);
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleRootManagerImpl.getFiles must not return null");
        }
        return virtualFileArray;
    }

    private static VirtualFile[] convertPointers(Set<VirtualFilePointer> cachedFiles) {
        LinkedHashSet<VirtualFile> result = new LinkedHashSet<VirtualFile>();
        for (VirtualFilePointer cachedFile : cachedFiles) {
            VirtualFile virtualFile = cachedFile.getFile();
            if (virtualFile == null) continue;
            result.add(virtualFile);
        }
        return VfsUtil.toVirtualFileArray(result);
    }

    @NotNull
    public String[] getUrls(OrderRootType type) {
        List<String> urls = this.getUrls(type, null);
        String[] stringArray = ArrayUtil.toStringArray(urls);
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleRootManagerImpl.getUrls must not return null");
        }
        return stringArray;
    }

    @NotNull
    private List<String> getUrls(OrderRootType type, @Nullable Set<Module> processed) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator<OrderEntry> orderIterator = this.myRootModel.getOrderIterator();
        while (orderIterator.hasNext()) {
            OrderEntry entry = orderIterator.next();
            if (entry instanceof ModuleOrderEntryImpl) {
                result.addAll(((ModuleOrderEntryImpl)entry).getUrls(type, processed));
                continue;
            }
            String[] urls = entry.getUrls(type);
            result.addAll(Arrays.asList(urls));
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleRootManagerImpl.getUrls must not return null");
        }
        return arrayList;
    }

    void commitModel(RootModelImpl rootModel) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LOG.assertTrue(rootModel.myModuleRootManager == this);
        Project project = this.myModule.getProject();
        ModifiableModuleModel moduleModel = ModuleManager.getInstance((Project)project).getModifiableModel();
        ModuleRootManagerImpl.multiCommit(new ModifiableRootModel[]{rootModel}, moduleModel);
    }

    private static void commitModelWithoutEvents(RootModelImpl rootModel) {
        ModuleRootManagerImpl.doCommit(rootModel);
    }

    private static void doCommit(RootModelImpl rootModel) {
        rootModel.docommit();
        rootModel.dispose();
    }

    static void multiCommit(ModifiableRootModel[] rootModels, ModifiableModuleModel moduleModel) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        final List<RootModelImpl> modelsToCommit = ModuleRootManagerImpl.getSortedChangedModels(rootModels, moduleModel);
        final ArrayList<ModifiableRootModel> modelsToDispose = new ArrayList<ModifiableRootModel>(Arrays.asList(rootModels));
        modelsToDispose.removeAll(modelsToCommit);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (RootModelImpl rootModel : modelsToCommit) {
                    ModuleRootManagerImpl.commitModelWithoutEvents(rootModel);
                }
                for (ModifiableRootModel model : modelsToDispose) {
                    model.dispose();
                }
            }
        };
        ModuleManagerImpl.commitModelWithRunnable(moduleModel, runnable);
    }

    private static List<RootModelImpl> getSortedChangedModels(ModifiableRootModel[] _rootModels, ModifiableModuleModel moduleModel) {
        ArrayList<RootModelImpl> rootModels = new ArrayList<RootModelImpl>();
        for (ModifiableRootModel _rootModel : _rootModels) {
            RootModelImpl rootModel = (RootModelImpl)_rootModel;
            if (!rootModel.isChanged()) continue;
            rootModels.add(rootModel);
        }
        ModuleRootManagerImpl.sortRootModels(rootModels, moduleModel);
        return rootModels;
    }

    @NotNull
    public Module[] getDependencies() {
        Module[] moduleArray = this.myRootModel.getModuleDependencies();
        if (moduleArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleRootManagerImpl.getDependencies must not return null");
        }
        return moduleArray;
    }

    @NotNull
    public Module[] getDependencies(boolean includeTests) {
        Module[] moduleArray = this.myRootModel.getModuleDependencies(includeTests);
        if (moduleArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleRootManagerImpl.getDependencies must not return null");
        }
        return moduleArray;
    }

    public boolean isDependsOn(Module module) {
        return this.myRootModel.isDependsOn(module);
    }

    @NotNull
    public String[] getDependencyModuleNames() {
        String[] stringArray = this.myRootModel.getDependencyModuleNames();
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleRootManagerImpl.getDependencyModuleNames must not return null");
        }
        return stringArray;
    }

    @NotNull
    public VirtualFile[] getRootPaths(OrderRootType rootType) {
        VirtualFile[] virtualFileArray = this.myRootModel.getRootPaths(rootType);
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleRootManagerImpl.getRootPaths must not return null");
        }
        return virtualFileArray;
    }

    @NotNull
    public String[] getRootUrls(OrderRootType rootType) {
        String[] stringArray = this.myRootModel.getRootUrls(rootType);
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleRootManagerImpl.getRootUrls must not return null");
        }
        return stringArray;
    }

    public <T> T getModuleExtension(Class<T> klass) {
        return this.myRootModel.getModuleExtension(klass);
    }

    public <R> R processOrder(RootPolicy<R> policy, R initialValue) {
        LOG.assertTrue(!this.myIsDisposed);
        return this.myRootModel.processOrder(policy, initialValue);
    }

    List<String> getUrlsForOtherModules(OrderRootType rootType, Set<Module> processed) {
        ArrayList<String> result = new ArrayList<String>();
        if (OrderRootType.SOURCES.equals((Object)rootType) || OrderRootType.COMPILATION_CLASSES.equals((Object)rootType) || OrderRootType.PRODUCTION_COMPILATION_CLASSES.equals((Object)rootType)) {
            ModuleRootManagerImpl.addExportedUrls(this.myRootModel, rootType, result, processed);
            return result;
        }
        if (OrderRootType.CLASSES.equals((Object)rootType)) {
            ModuleRootManagerImpl.addExportedUrls(this.myRootModel, rootType, result, processed);
            return result;
        }
        if (OrderRootType.CLASSES_AND_OUTPUT.equals((Object)rootType)) {
            return this.getUrls(OrderRootType.CLASSES_AND_OUTPUT, processed);
        }
        return Collections.emptyList();
    }

    private static void addExportedUrls(RootModelImpl model, OrderRootType type, List<String> result, Set<Module> processed) {
        for (OrderEntry orderEntry : model.getOrderEntries()) {
            if (orderEntry instanceof ModuleSourceOrderEntryImpl) {
                ((ModuleSourceOrderEntryImpl)orderEntry).addExportedUrls(type, result);
                continue;
            }
            if (!(orderEntry instanceof ExportableOrderEntry) || !((ExportableOrderEntry)orderEntry).isExported()) continue;
            if (orderEntry instanceof ModuleOrderEntryImpl) {
                result.addAll(((ModuleOrderEntryImpl)orderEntry).getUrls(type, processed));
                continue;
            }
            result.addAll(Arrays.asList(orderEntry.getUrls(type)));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    VirtualFile[] getFilesForOtherModules(OrderRootType rootType, Set<Module> processed) {
        VirtualFile[] virtualFileArray;
        Set<VirtualFilePointer> filePointers = this.myCachedExportedFiles.get(rootType);
        if (filePointers == null) {
            filePointers = new LinkedHashSet<VirtualFilePointer>();
            ArrayList<String> result = new ArrayList<String>();
            if (OrderRootType.SOURCES.equals((Object)rootType) || OrderRootType.COMPILATION_CLASSES.equals((Object)rootType) || OrderRootType.PRODUCTION_COMPILATION_CLASSES.equals((Object)rootType)) {
                ModuleRootManagerImpl.addExportedUrls(this.myRootModel, rootType, result, processed);
            } else {
                if (!OrderRootType.CLASSES.equals((Object)rootType)) {
                    if (OrderRootType.CLASSES_AND_OUTPUT.equals((Object)rootType)) {
                        virtualFileArray = this.getFiles(OrderRootType.CLASSES_AND_OUTPUT, processed);
                        if (virtualFileArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleRootManagerImpl.getFilesForOtherModules must not return null");
                        return virtualFileArray;
                    }
                    if (rootType.collectFromDependentModules()) {
                        virtualFileArray = this.getFiles(rootType, processed);
                        if (virtualFileArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleRootManagerImpl.getFilesForOtherModules must not return null");
                        return virtualFileArray;
                    } else {
                        virtualFileArray = VirtualFile.EMPTY_ARRAY;
                        if (VirtualFile.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleRootManagerImpl.getFilesForOtherModules must not return null");
                        return virtualFileArray;
                    }
                }
                ModuleRootManagerImpl.addExportedUrls(this.myRootModel, rootType, result, processed);
            }
            VirtualFilePointerManager pointerManager = VirtualFilePointerManager.getInstance();
            for (String url : result) {
                if (url == null) continue;
                filePointers.add(pointerManager.create(url, (Disposable)this.getModule(), null));
            }
            this.myCachedExportedFiles.put(rootType, filePointers);
        }
        if ((virtualFileArray = ModuleRootManagerImpl.convertPointers(filePointers)) != null) return virtualFileArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleRootManagerImpl.getFilesForOtherModules must not return null");
    }

    @NotNull
    public VirtualFile[] getContentRoots() {
        LOG.assertTrue(!this.myIsDisposed);
        VirtualFile[] virtualFileArray = this.myRootModel.getContentRoots();
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleRootManagerImpl.getContentRoots must not return null");
        }
        return virtualFileArray;
    }

    @NotNull
    public String[] getContentRootUrls() {
        LOG.assertTrue(!this.myIsDisposed);
        String[] stringArray = this.myRootModel.getContentRootUrls();
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleRootManagerImpl.getContentRootUrls must not return null");
        }
        return stringArray;
    }

    @NotNull
    public String[] getExcludeRootUrls() {
        LOG.assertTrue(!this.myIsDisposed);
        String[] stringArray = this.myRootModel.getExcludeRootUrls();
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleRootManagerImpl.getExcludeRootUrls must not return null");
        }
        return stringArray;
    }

    @NotNull
    public VirtualFile[] getExcludeRoots() {
        LOG.assertTrue(!this.myIsDisposed);
        VirtualFile[] virtualFileArray = this.myRootModel.getExcludeRoots();
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleRootManagerImpl.getExcludeRoots must not return null");
        }
        return virtualFileArray;
    }

    @NotNull
    public String[] getSourceRootUrls() {
        LOG.assertTrue(!this.myIsDisposed);
        String[] stringArray = this.myRootModel.getSourceRootUrls();
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleRootManagerImpl.getSourceRootUrls must not return null");
        }
        return stringArray;
    }

    @NotNull
    public VirtualFile[] getSourceRoots() {
        LOG.assertTrue(!this.myIsDisposed);
        VirtualFile[] virtualFileArray = this.myRootModel.getSourceRoots();
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleRootManagerImpl.getSourceRoots must not return null");
        }
        return virtualFileArray;
    }

    public void projectOpened() {
        this.myRootModel.projectOpened();
    }

    public void projectClosed() {
        this.myRootModel.projectClosed();
    }

    public void moduleAdded() {
        this.isModuleAdded = true;
    }

    private static void sortRootModels(List<RootModelImpl> rootModels, ModifiableModuleModel moduleModel) {
        DFSTBuilder<RootModelImpl> builder = ModuleRootManagerImpl.createDFSTBuilder(rootModels, moduleModel);
        Comparator comparator = builder.comparator();
        Collections.sort(rootModels, comparator);
    }

    private static DFSTBuilder<RootModelImpl> createDFSTBuilder(List<RootModelImpl> rootModels, final ModifiableModuleModel moduleModel) {
        Module[] modules;
        HashMap nameToModel = new HashMap();
        for (RootModelImpl rootModel : rootModels) {
            String name = rootModel.getModule().getName();
            LOG.assertTrue(!nameToModel.containsKey(name));
            nameToModel.put(name, rootModel);
        }
        for (Module module : modules = moduleModel.getModules()) {
            String name = module.getName();
            if (nameToModel.containsKey(name)) continue;
            RootModelImpl rootModel = ((ModuleRootManagerImpl)ModuleRootManager.getInstance((Module)module)).myRootModel;
            nameToModel.put(name, rootModel);
        }
        final Collection allRootModels = nameToModel.values();
        return new DFSTBuilder((Graph)new GraphGenerator((GraphGenerator.SemiGraph)new CachingSemiGraph((GraphGenerator.SemiGraph)new GraphGenerator.SemiGraph<RootModelImpl>((Map)nameToModel){
            final /* synthetic */ Map val$nameToModel;
            {
                this.val$nameToModel = map;
            }

            public Collection<RootModelImpl> getNodes() {
                return allRootModels;
            }

            public Iterator<RootModelImpl> getIn(RootModelImpl rootModel) {
                ArrayList names1 = rootModel.processOrder(new RootPolicy<ArrayList<String>>(){

                    public ArrayList<String> visitModuleOrderEntry(ModuleOrderEntry moduleOrderEntry, ArrayList<String> strings) {
                        Module module = moduleOrderEntry.getModule();
                        if (module != null && !module.isDisposed()) {
                            strings.add(module.getName());
                        } else {
                            Module moduleToBeRenamed = moduleModel.getModuleToBeRenamed(moduleOrderEntry.getModuleName());
                            if (moduleToBeRenamed != null && !moduleToBeRenamed.isDisposed()) {
                                strings.add(moduleToBeRenamed.getName());
                            }
                        }
                        return strings;
                    }
                }, new ArrayList());
                String[] names = ArrayUtil.toStringArray(names1);
                ArrayList<RootModelImpl> result = new ArrayList<RootModelImpl>();
                for (String name : names) {
                    RootModelImpl depRootModel = (RootModelImpl)this.val$nameToModel.get(name);
                    if (depRootModel == null) continue;
                    result.add(depRootModel);
                }
                return result.iterator();
            }
        })));
    }

    public void dropCaches() {
        this.myCachedFiles.clear();
        this.myCachedExportedFiles.clear();
    }

    public ModuleRootManagerState getState() {
        return new ModuleRootManagerState(this.myRootModel);
    }

    public void loadState(ModuleRootManagerState object) {
        try {
            boolean throwEvent;
            final RootModelImpl newModel = new RootModelImpl(object.getRootModelElement(), this, this.myProjectRootManager, this.myFilePointerManager);
            boolean bl = throwEvent = this.myRootModel != null;
            if (throwEvent) {
                this.makeRootsChange(new Runnable(){

                    @Override
                    public void run() {
                        ModuleRootManagerImpl.doCommit(newModel);
                    }
                });
            } else {
                this.myRootModel = newModel;
            }
            assert (!this.myRootModel.isOrderEntryDisposed());
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public static class StorageChooser
    implements StateStorageChooser<ModuleRootManagerImpl> {
        public Storage[] selectStorages(Storage[] storages, ModuleRootManagerImpl moduleRootManager, StateStorageOperation operation) {
            String storageType = ClasspathStorage.getStorageType(moduleRootManager.getModule());
            String id = storageType.equals("default") ? "default" : "special";
            for (Storage storage : storages) {
                if (!storage.id().equals(id)) continue;
                return new Storage[]{storage};
            }
            throw new IllegalArgumentException();
        }
    }

    public static class ModuleRootManagerState
    implements JDOMExternalizable {
        private RootModelImpl myRootModel;
        private Element myRootModelElement = null;

        public ModuleRootManagerState() {
        }

        public ModuleRootManagerState(RootModelImpl rootModel) {
            this.myRootModel = rootModel;
        }

        public void readExternal(Element element) throws InvalidDataException {
            this.myRootModelElement = element;
        }

        public void writeExternal(Element element) throws WriteExternalException {
            this.myRootModel.writeExternal(element);
        }

        public Element getRootModelElement() {
            return this.myRootModelElement;
        }
    }
}

