/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.components.impl.ProjectPathMacroManager;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.components.impl.stores.UnknownMacroNotification;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.project.impl.ProjectMacrosUtil;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.project.impl.ProjectStoreClassProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.CachingComponentAdapter;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapter;

public class ProjectImpl
extends ComponentManagerImpl
implements ProjectEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.project.impl.ProjectImpl");
    private static final String PLUGIN_SETTINGS_ERROR = "Plugin Settings Error";
    private ProjectManagerImpl myManager;
    private MyProjectManagerListener myProjectManagerListener;
    private AtomicBoolean mySavingInProgress = new AtomicBoolean(false);
    @NonNls
    private static final String PROJECT_LAYER = "project-components";
    public boolean myOptimiseTestLoadSpeed;
    @NonNls
    public static final String TEMPLATE_PROJECT_NAME = "Default (Template) Project";
    @NonNls
    private static final String DEPRECATED_MESSAGE = "Deprecated method usage: {0}.\nThis method will cease to exist in IDEA 7.0 final release.\nPlease contact plugin developers for plugin update.";
    private final Condition myDisposedCondition = new Condition(){

        public boolean value(Object o) {
            return ProjectImpl.this.isDisposed();
        }
    };
    private final String myName;
    public static Key<Long> CREATION_TIME = Key.create((String)"ProjectImpl.CREATION_TIME");

    protected ProjectImpl(ProjectManagerImpl manager, String filePath, boolean isOptimiseTestLoadSpeed, String projectName) {
        super((ComponentManager)ApplicationManager.getApplication());
        this.putUserData(CREATION_TIME, System.nanoTime());
        this.getPicoContainer().registerComponentInstance(Project.class, (Object)this);
        this.getStateStore().setProjectFilePath(filePath);
        this.myOptimiseTestLoadSpeed = isOptimiseTestLoadSpeed;
        this.myManager = manager;
        this.myName = this.isDefault() ? TEMPLATE_PROJECT_NAME : (projectName == null ? this.getStateStore().getProjectName() : projectName);
    }

    @Override
    protected void boostrapPicoContainer() {
        Extensions.instantiateArea((String)"IDEA_PROJECT", (AreaInstance)this, null);
        super.boostrapPicoContainer();
        MutablePicoContainer picoContainer = this.getPicoContainer();
        final ProjectStoreClassProvider projectStoreClassProvider = (ProjectStoreClassProvider)picoContainer.getComponentInstanceOfType(ProjectStoreClassProvider.class);
        picoContainer.registerComponentImplementation(ProjectPathMacroManager.class);
        picoContainer.registerComponent(new ComponentAdapter(){
            ComponentAdapter myDelegate;

            public ComponentAdapter getDelegate() {
                if (this.myDelegate == null) {
                    Class<? extends IComponentStore> storeClass = projectStoreClassProvider.getProjectStoreClass(ProjectImpl.this.isDefault());
                    this.myDelegate = new CachingComponentAdapter((ComponentAdapter)new ConstructorInjectionComponentAdapter(storeClass, storeClass, null, true));
                }
                return this.myDelegate;
            }

            public Object getComponentKey() {
                return IComponentStore.class;
            }

            public Class getComponentImplementation() {
                return this.getDelegate().getComponentImplementation();
            }

            public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException {
                return this.getDelegate().getComponentInstance(container);
            }

            public void verify(PicoContainer container) throws PicoIntrospectionException {
                this.getDelegate().verify(container);
            }

            public void accept(PicoVisitor visitor) {
                visitor.visitComponentAdapter((ComponentAdapter)this);
                this.getDelegate().accept(visitor);
            }
        });
    }

    @Override
    @NotNull
    public IProjectStore getStateStore() {
        IProjectStore iProjectStore = (IProjectStore)super.getStateStore();
        if (iProjectStore == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/project/impl/ProjectImpl.getStateStore must not return null");
        }
        return iProjectStore;
    }

    public boolean isOpen() {
        return ProjectManagerEx.getInstanceEx().isProjectOpened(this);
    }

    public Condition getDisposed() {
        return this.myDisposedCondition;
    }

    public boolean isInitialized() {
        return this.isOpen() && !this.isDisposed() && StartupManagerEx.getInstanceEx(this).startupActivityPassed();
    }

    public void loadProjectComponents() {
        IdeaPluginDescriptor[] plugins;
        Application app = ApplicationManager.getApplication();
        for (IdeaPluginDescriptor plugin : plugins = app.getPlugins()) {
            if (PluginManager.shouldSkipPlugin((IdeaPluginDescriptor)plugin)) continue;
            this.loadComponentsConfiguration(plugin.getProjectComponents(), plugin, this.isDefault());
        }
    }

    @Deprecated
    @NotNull
    public String getProjectFilePath() {
        LOG.warn(MessageFormat.format(DEPRECATED_MESSAGE, "ProjectImpl.getProjectFilePath()"), new Throwable());
        String string = this.getStateStore().getProjectFilePath();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/project/impl/ProjectImpl.getProjectFilePath must not return null");
        }
        return string;
    }

    @Deprecated
    @Nullable
    public VirtualFile getProjectFile() {
        LOG.warn(MessageFormat.format(DEPRECATED_MESSAGE, "ProjectImpl.getProjectFile()"), new Throwable());
        return this.getStateStore().getProjectFile();
    }

    @Nullable
    public VirtualFile getBaseDir() {
        return this.getStateStore().getProjectBaseDir();
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/project/impl/ProjectImpl.getName must not return null");
        }
        return string;
    }

    @Nullable
    @NonNls
    public String getPresentableUrl() {
        return this.getStateStore().getPresentableUrl();
    }

    @NotNull
    @NonNls
    public String getLocationHash() {
        String str = this.getPresentableUrl();
        if (str == null) {
            str = this.getName();
        }
        String string = this.getName() + Integer.toHexString(str.hashCode());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/project/impl/ProjectImpl.getLocationHash must not return null");
        }
        return string;
    }

    @Nullable
    @NonNls
    public String getLocation() {
        return this.isDisposed() ? null : this.getStateStore().getLocation();
    }

    @Deprecated
    @Nullable
    public VirtualFile getWorkspaceFile() {
        LOG.warn(MessageFormat.format(DEPRECATED_MESSAGE, "ProjectImpl.getWorkspaceFile()"), new Throwable());
        return this.getStateStore().getWorkspaceFile();
    }

    @Override
    public boolean isOptimiseTestLoadSpeed() {
        return this.myOptimiseTestLoadSpeed;
    }

    @Override
    public void setOptimiseTestLoadSpeed(boolean optimiseTestLoadSpeed) {
        this.myOptimiseTestLoadSpeed = optimiseTestLoadSpeed;
    }

    @Override
    public void init() {
        super.init();
        ((ProjectLifecycleListener)this.getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).projectComponentsInitialized(this);
        this.myProjectManagerListener = new MyProjectManagerListener();
        this.myManager.addProjectManagerListener(this, (ProjectManagerListener)this.myProjectManagerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (ApplicationManagerEx.getApplicationEx().isDoNotSave()) {
            return;
        }
        if (this.mySavingInProgress.compareAndSet(false, true)) {
            try {
                this.doSave();
            }
            catch (IComponentStore.SaveCancelledException e) {
                LOG.info((Throwable)e);
            }
            catch (PluginException e) {
                PluginManager.disablePlugin((String)e.getPluginId().getIdString());
                Notifications.Bus.notify((Notification)new Notification(PLUGIN_SETTINGS_ERROR, "Unable to save plugin settings!", "<p>The plugin <i>" + e.getPluginId() + "</i> failed to save settings and has been disabled. Please restart" + ApplicationNamesInfo.getInstance().getFullProductName() + "</p>" + (ApplicationManagerEx.getApplicationEx().isInternal() ? "<p>" + StringUtil.getThrowableText((Throwable)e) + "</p>" : ""), NotificationType.ERROR), (NotificationDisplayType)NotificationDisplayType.BALLOON, (Project)this);
                LOG.info("Unable to save plugin settings", (Throwable)e);
            }
            catch (IOException e) {
                MessagesEx.error(this, ProjectBundle.message((String)"project.save.error", (Object[])new Object[]{ApplicationManagerEx.getApplicationEx().isInternal() ? StringUtil.getThrowableText((Throwable)e) : e.getMessage()})).showLater();
                LOG.info("Error saving project", (Throwable)e);
            }
            finally {
                this.mySavingInProgress.set(false);
            }
        }
    }

    @Override
    public synchronized void dispose() {
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        assert (application.isHeadlessEnvironment() || application.isUnitTestMode() || application.isDispatchThread() || application.isInModalProgressThread());
        LOG.assertTrue(!this.isDisposed());
        if (this.myProjectManagerListener != null) {
            this.myManager.removeProjectManagerListener(this, (ProjectManagerListener)this.myProjectManagerListener);
        }
        this.disposeComponents();
        Extensions.disposeArea((AreaInstance)this);
        this.myManager = null;
        this.myProjectManagerListener = null;
        super.dispose();
        if (!application.isDisposed()) {
            ((ProjectLifecycleListener)application.getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).afterProjectClosed(this);
        }
    }

    private void projectOpened() {
        ProjectComponent[] components;
        for (ProjectComponent component : components = this.getComponents(ProjectComponent.class)) {
            try {
                component.projectOpened();
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    private void projectClosed() {
        ArrayList<ProjectComponent> components = new ArrayList<ProjectComponent>(Arrays.asList(this.getComponents(ProjectComponent.class)));
        Collections.reverse(components);
        for (ProjectComponent component : components) {
            try {
                component.projectClosed();
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    public <T> T[] getExtensions(ExtensionPointName<T> extensionPointName) {
        return Extensions.getArea((AreaInstance)this).getExtensionPoint(extensionPointName).getExtensions();
    }

    public String getDefaultName() {
        if (this.isDefault()) {
            return TEMPLATE_PROJECT_NAME;
        }
        return this.getStateStore().getProjectName();
    }

    @Override
    protected MutablePicoContainer createPicoContainer() {
        return Extensions.getArea((AreaInstance)this).getPicoContainer();
    }

    public boolean isDefault() {
        return false;
    }

    @Override
    public void checkUnknownMacros(boolean showDialog) {
        final IProjectStore stateStore = this.getStateStore();
        TrackingPathMacroSubstitutor[] substitutors = stateStore.getSubstitutors();
        HashSet<String> unknownMacros = new HashSet<String>();
        for (TrackingPathMacroSubstitutor substitutor : substitutors) {
            unknownMacros.addAll(substitutor.getUnknownMacros(null));
        }
        if (!(unknownMacros.isEmpty() || showDialog && !ProjectMacrosUtil.checkMacros(this, new HashSet<String>(unknownMacros)))) {
            PathMacros pathMacros = PathMacros.getInstance();
            HashSet<String> macros2invalidate = new HashSet<String>(unknownMacros);
            Iterator it = macros2invalidate.iterator();
            while (it.hasNext()) {
                String macro = (String)it.next();
                String value = pathMacros.getValue(macro);
                if (null != value && value.trim().length() != 0 || pathMacros.isIgnoredMacroName(macro)) continue;
                it.remove();
            }
            if (!macros2invalidate.isEmpty()) {
                final HashSet<String> components = new HashSet<String>();
                for (TrackingPathMacroSubstitutor substitutor : substitutors) {
                    components.addAll(substitutor.getComponents(macros2invalidate));
                }
                if (stateStore.isReloadPossible(components)) {
                    UnknownMacroNotification[] notifications;
                    for (TrackingPathMacroSubstitutor substitutor : substitutors) {
                        substitutor.invalidateUnknownMacros(macros2invalidate);
                    }
                    for (UnknownMacroNotification notification : notifications = (UnknownMacroNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(UnknownMacroNotification.class, (Project)this)) {
                        if (!macros2invalidate.containsAll(notification.getMacros())) continue;
                        notification.expire();
                    }
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            stateStore.reinitComponents(components, true);
                        }
                    });
                } else if (Messages.showYesNoDialog((Project)this, (String)"Component could not be reloaded. Reload project?", (String)"Configuration changed", (Icon)Messages.getQuestionIcon()) == 0) {
                    ProjectManagerEx.getInstanceEx().reloadProject(this);
                }
            }
        }
    }

    public String toString() {
        return "Project " + (this.isDisposed() ? "(Disposed) " : "") + (this.isDefault() ? "(Default) " : "'" + this.getLocation() + "'");
    }

    private class MyProjectManagerListener
    extends ProjectManagerAdapter {
        private MyProjectManagerListener() {
        }

        public void projectOpened(Project project) {
            LOG.assertTrue(project == ProjectImpl.this);
            ProjectImpl.this.projectOpened();
        }

        public void projectClosed(Project project) {
            LOG.assertTrue(project == ProjectImpl.this);
            ProjectImpl.this.projectClosed();
        }
    }
}

